/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.search.AuditSearchRequest;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.EntityAudit;
import com.atlan.model.search.IndexSearchDSL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class AuditSearch
extends CompoundQuery {
    List<SortOptions> sorts;
    Map<String, Aggregation> aggregations;
    Integer pageSize;
    List<AtlanField> includesOnResults;
    List<String> _includesOnResults;

    public static AuditSearchBuilder<?, ?> builder(AtlanClient client) {
        return (AuditSearchBuilder)AuditSearch._internal().client(client);
    }

    public AuditSearchRequest toRequest() {
        return this._requestBuilder().build();
    }

    public long count() throws AtlanException {
        if (this.client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        AtlanObject request = ((AuditSearchRequest.AuditSearchRequestBuilder)AuditSearchRequest.builder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)this._dsl().size(1)).clearAggregations()).build())).build();
        return ((AuditSearchRequest)request).search(this.client).getTotalCount();
    }

    public Stream<EntityAudit> stream() throws AtlanException {
        return this.stream(false);
    }

    public Stream<EntityAudit> stream(boolean parallel) throws AtlanException {
        if (this.client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        if (parallel) {
            return this.toRequest().search(this.client).parallelStream();
        }
        return this.toRequest().search(this.client).stream();
    }

    public Stream<EntityAudit> parallelStream() throws AtlanException {
        return this.stream(true);
    }

    protected IndexSearchDSL.IndexSearchDSLBuilder<?, ?> _dsl() {
        return IndexSearchDSL.builder(this.toQuery());
    }

    protected AuditSearchRequest.AuditSearchRequestBuilder<?, ?> _requestBuilder() {
        IndexSearchDSL.IndexSearchDSLBuilder<?, ?> dsl = this._dsl();
        if (this.pageSize != null) {
            dsl.size(this.pageSize);
        }
        if (this.sorts != null) {
            dsl.sort(this.sorts);
        }
        if (this.aggregations != null) {
            dsl.aggregations(this.aggregations);
        }
        Object request = AuditSearchRequest.builder().dsl((IndexSearchDSL)dsl.build());
        if (this._includesOnResults != null) {
            ((AuditSearchRequest.AuditSearchRequestBuilder)request).attributes(this._includesOnResults);
        }
        if (this.includesOnResults != null) {
            ((AuditSearchRequest.AuditSearchRequestBuilder)request).attributes(this.includesOnResults.stream().map(AtlanField::getAtlanFieldName).collect(Collectors.toList()));
        }
        return request;
    }

    @Generated
    protected AuditSearch(AuditSearchBuilder<?, ?> b) {
        super(b);
        Map<Object, Object> aggregations;
        this.sorts = switch (b.sorts == null ? 0 : b.sorts.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.sorts.get(0));
            default -> Collections.unmodifiableList(new ArrayList<SortOptions>(b.sorts));
        };
        switch (b.aggregations$key == null ? 0 : b.aggregations$key.size()) {
            case 0: {
                aggregations = Collections.emptyMap();
                break;
            }
            case 1: {
                aggregations = Collections.singletonMap(b.aggregations$key.get(0), b.aggregations$value.get(0));
                break;
            }
            default: {
                aggregations = new LinkedHashMap(b.aggregations$key.size() < 0x40000000 ? 1 + b.aggregations$key.size() + (b.aggregations$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.aggregations$key.size(); ++$i) {
                    aggregations.put(b.aggregations$key.get($i), b.aggregations$value.get($i));
                }
                aggregations = Collections.unmodifiableMap(aggregations);
            }
        }
        this.aggregations = aggregations;
        this.pageSize = b.pageSize;
        this.includesOnResults = switch (b.includesOnResults == null ? 0 : b.includesOnResults.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.includesOnResults.get(0));
            default -> Collections.unmodifiableList(new ArrayList<AtlanField>(b.includesOnResults));
        };
        this._includesOnResults = switch (b._includesOnResults == null ? 0 : b._includesOnResults.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b._includesOnResults.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b._includesOnResults));
        };
    }

    @Generated
    public static AuditSearchBuilder<?, ?> _internal() {
        return new AuditSearchBuilderImpl();
    }

    public static abstract class AuditSearchBuilder<C extends AuditSearch, B extends AuditSearchBuilder<C, B>>
    extends CompoundQuery.CompoundQueryBuilder<C, B> {
        @Generated
        private ArrayList<SortOptions> sorts;
        @Generated
        private ArrayList<String> aggregations$key;
        @Generated
        private ArrayList<Aggregation> aggregations$value;
        @Generated
        private Integer pageSize;
        @Generated
        private ArrayList<AtlanField> includesOnResults;
        @Generated
        private ArrayList<String> _includesOnResults;

        public AuditSearchRequest.AuditSearchRequestBuilder<?, ?> toRequestBuilder() {
            return ((AuditSearch)this.build())._requestBuilder();
        }

        public AuditSearchRequest toRequest() {
            return ((AuditSearch)this.build()).toRequest();
        }

        public long count() throws AtlanException {
            return ((AuditSearch)this.build()).count();
        }

        public Stream<EntityAudit> stream() throws AtlanException {
            return ((AuditSearch)this.build()).stream();
        }

        public Stream<EntityAudit> stream(boolean parallel) throws AtlanException {
            return ((AuditSearch)this.build()).stream(parallel);
        }

        @Generated
        public B sort(SortOptions sort) {
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.add(sort);
            return (B)this.self();
        }

        @Generated
        public B sorts(Collection<? extends SortOptions> sorts) {
            if (sorts == null) {
                throw new NullPointerException("sorts cannot be null");
            }
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.addAll(sorts);
            return (B)this.self();
        }

        @Generated
        public B clearSorts() {
            if (this.sorts != null) {
                this.sorts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B aggregate(String aggregateKey, Aggregation aggregateValue) {
            if (this.aggregations$key == null) {
                this.aggregations$key = new ArrayList();
                this.aggregations$value = new ArrayList();
            }
            this.aggregations$key.add(aggregateKey);
            this.aggregations$value.add(aggregateValue);
            return (B)this.self();
        }

        @Generated
        public B aggregations(Map<? extends String, ? extends Aggregation> aggregations) {
            if (aggregations == null) {
                throw new NullPointerException("aggregations cannot be null");
            }
            if (this.aggregations$key == null) {
                this.aggregations$key = new ArrayList();
                this.aggregations$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Aggregation> $lombokEntry : aggregations.entrySet()) {
                this.aggregations$key.add($lombokEntry.getKey());
                this.aggregations$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearAggregations() {
            if (this.aggregations$key != null) {
                this.aggregations$key.clear();
                this.aggregations$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return (B)this.self();
        }

        @Generated
        public B includeOnResults(AtlanField includeOnResults) {
            if (this.includesOnResults == null) {
                this.includesOnResults = new ArrayList();
            }
            this.includesOnResults.add(includeOnResults);
            return (B)this.self();
        }

        @Generated
        public B includesOnResults(Collection<? extends AtlanField> includesOnResults) {
            if (includesOnResults == null) {
                throw new NullPointerException("includesOnResults cannot be null");
            }
            if (this.includesOnResults == null) {
                this.includesOnResults = new ArrayList();
            }
            this.includesOnResults.addAll(includesOnResults);
            return (B)this.self();
        }

        @Generated
        public B clearIncludesOnResults() {
            if (this.includesOnResults != null) {
                this.includesOnResults.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B _includeOnResults(String _includeOnResults) {
            if (this._includesOnResults == null) {
                this._includesOnResults = new ArrayList();
            }
            this._includesOnResults.add(_includeOnResults);
            return (B)this.self();
        }

        @Generated
        public B _includesOnResults(Collection<? extends String> _includesOnResults) {
            if (_includesOnResults == null) {
                throw new NullPointerException("_includesOnResults cannot be null");
            }
            if (this._includesOnResults == null) {
                this._includesOnResults = new ArrayList();
            }
            this._includesOnResults.addAll(_includesOnResults);
            return (B)this.self();
        }

        @Generated
        public B clear_includesOnResults() {
            if (this._includesOnResults != null) {
                this._includesOnResults.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AuditSearch.AuditSearchBuilder(super=" + super.toString() + ", sorts=" + this.sorts + ", aggregations$key=" + this.aggregations$key + ", aggregations$value=" + this.aggregations$value + ", pageSize=" + this.pageSize + ", includesOnResults=" + this.includesOnResults + ", _includesOnResults=" + this._includesOnResults + ")";
        }
    }

    @Generated
    private static final class AuditSearchBuilderImpl
    extends AuditSearchBuilder<AuditSearch, AuditSearchBuilderImpl> {
        @Generated
        private AuditSearchBuilderImpl() {
        }

        @Override
        @Generated
        protected AuditSearchBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AuditSearch build() {
            return new AuditSearch(this);
        }
    }
}

