/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.search.AggregationResult;
import com.atlan.model.search.AuditSearchRequest;
import com.atlan.model.search.EntityAudit;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditSearchResponse
extends ApiResource
implements Iterable<EntityAudit> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditSearchResponse.class);
    private static final long serialVersionUID = 2L;
    private static final int CHARACTERISTICS = 17744;
    @JsonIgnore
    AtlanClient client;
    @JsonIgnore
    AuditSearchRequest request;
    List<EntityAudit> entityAudits;
    Map<String, AggregationResult> aggregations;
    Long count;
    Long totalCount;

    @JsonIgnore
    public AuditSearchResponse getNextPage() throws AtlanException {
        AtlanObject dsl = this.getRequest().getDsl();
        int from = dsl.getFrom() == null ? 0 : dsl.getFrom();
        int page = dsl.getSize() == null ? 10 : dsl.getSize();
        dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(from + page)).build();
        Object next = AuditSearchRequest.builder().dsl((IndexSearchDSL)dsl);
        if (this.getRequest().getAttributes() != null) {
            next = ((AuditSearchRequest.AuditSearchRequestBuilder)next).attributes(this.getRequest().getAttributes());
        }
        return ((AuditSearchRequest)((AuditSearchRequest.AuditSearchRequestBuilder)next).build()).search(this.client);
    }

    @JsonIgnore
    public List<EntityAudit> getSpecificPage(int offset, int pageSize) throws AtlanException {
        AuditSearchResponse response;
        AtlanObject dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)this.getRequest().getDsl().toBuilder().from(offset)).size(pageSize)).build();
        Object next = AuditSearchRequest.builder().dsl((IndexSearchDSL)dsl);
        if (this.getRequest().getAttributes() != null) {
            next = ((AuditSearchRequest.AuditSearchRequestBuilder)next).attributes(this.getRequest().getAttributes());
        }
        if ((response = ((AuditSearchRequest)((AuditSearchRequest.AuditSearchRequestBuilder)next).build()).search(this.client)) != null && response.getEntityAudits() != null) {
            return response.getEntityAudits();
        }
        return Collections.emptyList();
    }

    @Override
    public Iterator<EntityAudit> iterator() {
        return new AuditSearchResponseIterator(this);
    }

    @Override
    public Spliterator<EntityAudit> spliterator() {
        long pageSize = this.getRequest().getDsl().getSize().intValue();
        AuditSearchResponseSpliterator spliterator = new AuditSearchResponseSpliterator(this, 0L, this.getTotalCount(), pageSize);
        List<Object> audits = this.getEntityAudits() == null ? Collections.emptyList() : this.getEntityAudits();
        spliterator.firstPage = audits.spliterator();
        return spliterator;
    }

    public Stream<EntityAudit> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.totalCount, 17744), false);
    }

    public Stream<EntityAudit> parallelStream() {
        return StreamSupport.stream(this::spliterator, 17744, true);
    }

    @Generated
    public AtlanClient getClient() {
        return this.client;
    }

    @Generated
    public AuditSearchRequest getRequest() {
        return this.request;
    }

    @Generated
    public List<EntityAudit> getEntityAudits() {
        return this.entityAudits;
    }

    @Generated
    public Map<String, AggregationResult> getAggregations() {
        return this.aggregations;
    }

    @Generated
    public Long getCount() {
        return this.count;
    }

    @Generated
    public Long getTotalCount() {
        return this.totalCount;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditSearchResponse)) {
            return false;
        }
        AuditSearchResponse other = (AuditSearchResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$count = this.getCount();
        Long other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        AtlanClient this$client = this.getClient();
        AtlanClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        AuditSearchRequest this$request = this.getRequest();
        AuditSearchRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        List<EntityAudit> this$entityAudits = this.getEntityAudits();
        List<EntityAudit> other$entityAudits = other.getEntityAudits();
        if (this$entityAudits == null ? other$entityAudits != null : !((Object)this$entityAudits).equals(other$entityAudits)) {
            return false;
        }
        Map<String, AggregationResult> this$aggregations = this.getAggregations();
        Map<String, AggregationResult> other$aggregations = other.getAggregations();
        return !(this$aggregations == null ? other$aggregations != null : !((Object)this$aggregations).equals(other$aggregations));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuditSearchResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        AtlanClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        AuditSearchRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        List<EntityAudit> $entityAudits = this.getEntityAudits();
        result = result * 59 + ($entityAudits == null ? 43 : ((Object)$entityAudits).hashCode());
        Map<String, AggregationResult> $aggregations = this.getAggregations();
        result = result * 59 + ($aggregations == null ? 43 : ((Object)$aggregations).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AuditSearchResponse(super=" + super.toString() + ", client=" + this.getClient() + ", request=" + this.getRequest() + ", entityAudits=" + this.getEntityAudits() + ", aggregations=" + this.getAggregations() + ", count=" + this.getCount() + ", totalCount=" + this.getTotalCount() + ")";
    }

    @JsonIgnore
    @Generated
    public void setClient(AtlanClient client) {
        this.client = client;
    }

    @JsonIgnore
    @Generated
    public void setRequest(AuditSearchRequest request) {
        this.request = request;
    }

    private static class AuditSearchResponseIterator
    implements Iterator<EntityAudit> {
        private AuditSearchResponse response;
        private int i;

        public AuditSearchResponseIterator(AuditSearchResponse response) {
            this.response = response;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.response.getEntityAudits() != null && this.response.getEntityAudits().size() > this.i) {
                return true;
            }
            try {
                this.response = this.response.getNextPage();
                this.i = 0;
                return this.response.getEntityAudits() != null && this.response.getEntityAudits().size() > this.i;
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to iterate through all pages of search results.", e);
            }
        }

        @Override
        public EntityAudit next() {
            return this.response.getEntityAudits().get(this.i++);
        }
    }

    private static class AuditSearchResponseSpliterator
    implements Spliterator<EntityAudit> {
        private final AuditSearchResponse response;
        private long start;
        private final long end;
        private final long pageSize;
        private Spliterator<EntityAudit> firstPage;
        private Spliterator<EntityAudit> currentPage;

        AuditSearchResponseSpliterator(AuditSearchResponse response, long start, long end, long pageSize) {
            this.response = response;
            this.start = start;
            this.end = end;
            this.pageSize = pageSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super EntityAudit> action) {
            while (!this.ensurePage().tryAdvance(action)) {
                if (this.start >= this.end) {
                    return false;
                }
                this.currentPage = null;
            }
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super EntityAudit> action) {
            do {
                this.ensurePage().forEachRemaining(action);
                this.currentPage = null;
            } while (this.start < this.end);
        }

        @Override
        public Spliterator<EntityAudit> trySplit() {
            if (this.firstPage != null) {
                Spliterator<EntityAudit> fp = this.firstPage;
                this.firstPage = null;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            if (this.currentPage != null) {
                return this.currentPage.trySplit();
            }
            if (this.end - this.start > this.pageSize) {
                long mid = this.start + this.end >>> 1;
                if ((mid = mid / this.pageSize * this.pageSize) == this.start) {
                    mid += this.pageSize;
                }
                this.start = mid;
                return new AuditSearchResponseSpliterator(this.response, this.start, this.start, this.pageSize);
            }
            return this.ensurePage().trySplit();
        }

        private Spliterator<EntityAudit> ensurePage() {
            if (this.firstPage != null) {
                Spliterator<EntityAudit> fp = this.firstPage;
                this.firstPage = null;
                this.currentPage = fp;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            Spliterator<EntityAudit> sp = this.currentPage;
            if (sp == null) {
                List<EntityAudit> audits;
                if (this.start >= this.end) {
                    return Spliterators.emptySpliterator();
                }
                try {
                    audits = this.response.getSpecificPage((int)this.start, (int)Math.min(this.end - this.start, this.pageSize));
                }
                catch (AtlanException e) {
                    log.warn("Unable to fetch the specific page from {} to {}", new Object[]{this.start, Math.min(this.end - this.start, this.pageSize), e});
                    audits = Collections.emptyList();
                }
                sp = audits.spliterator();
                this.start = sp.getExactSizeIfKnown() > 0L ? (this.start += sp.getExactSizeIfKnown()) : (this.start += this.pageSize);
                this.currentPage = sp;
            }
            return sp;
        }

        @Override
        public long estimateSize() {
            if (this.currentPage != null) {
                return this.currentPage.estimateSize();
            }
            return this.end - this.start;
        }

        @Override
        public int characteristics() {
            return 17744;
        }
    }
}

