/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.util.NamedValue;
import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.UTMTags;
import com.atlan.model.search.AggregationBucketDetails;
import com.atlan.model.search.AggregationBucketResult;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.SearchLogEntry;
import com.atlan.model.search.SearchLogResponse;
import com.atlan.model.search.aggregates.AssetViews;
import com.atlan.model.search.aggregates.UserViews;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;

@JsonDeserialize(builder=SearchLogRequestBuilderImpl.class)
public class SearchLogRequest
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    public static final List<String> EXCLUDE_USERS = List.of("support", "atlansupport");
    public static final Query VIEWED = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FluentSearch._internal().whereSome(SearchLogEntry.UTM_TAGS.eq(UTMTags.UI_PROFILE))).whereSome(SearchLogEntry.UTM_TAGS.eq(UTMTags.UI_SIDEBAR))).minSomes(1)).build().toQuery();
    IndexSearchDSL dsl;

    public static SearchLogRequestBuilder<?, ?> builder(Query query) {
        return SearchLogRequest.builder(IndexSearchDSL.of(query));
    }

    public static SearchLogRequestBuilder<?, ?> builder(IndexSearchDSL dsl) {
        return SearchLogRequest._internal().dsl(dsl);
    }

    public static SearchLogRequestBuilder<?, ?> views() {
        return SearchLogRequest.views(null);
    }

    public static SearchLogRequestBuilder<?, ?> views(List<String> excludeUsers) {
        ArrayList<String> exclusion = new ArrayList<String>(EXCLUDE_USERS);
        if (excludeUsers != null) {
            exclusion.addAll(excludeUsers);
        }
        Query viewedByGuid = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FluentSearch._internal().where(SearchLogEntry.UTM_TAGS.eq(UTMTags.ACTION_ASSET_VIEWED))).where(VIEWED)).whereNot(SearchLogEntry.USER.in(exclusion))).build().toQuery();
        return SearchLogRequest.builder(viewedByGuid);
    }

    public static SearchLogRequestBuilder<?, ?> viewsByGuid(String guid) {
        return SearchLogRequest.viewsByGuid(guid, null);
    }

    public static SearchLogRequestBuilder<?, ?> viewsByGuid(String guid, List<String> excludeUsers) {
        ArrayList<String> exclusion = new ArrayList<String>(EXCLUDE_USERS);
        if (excludeUsers != null) {
            exclusion.addAll(excludeUsers);
        }
        Query viewedByGuid = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FluentSearch._internal().where(SearchLogEntry.UTM_TAGS.eq(UTMTags.ACTION_ASSET_VIEWED))).where(SearchLogEntry.ENTITY_ID.eq(guid))).where(VIEWED)).whereNot(SearchLogEntry.USER.in(exclusion))).build().toQuery();
        return SearchLogRequest.builder(viewedByGuid);
    }

    public static List<UserViews> mostRecentViewers(String guid, int maxUsers) throws AtlanException {
        return SearchLogRequest.mostRecentViewers(guid, maxUsers, null);
    }

    public static List<UserViews> mostRecentViewers(String guid, int maxUsers, List<String> excludeUsers) throws AtlanException {
        return SearchLogRequest.mostRecentViewers(Atlan.getDefaultClient(), guid, maxUsers, excludeUsers);
    }

    public static List<UserViews> mostRecentViewers(AtlanClient client, String guid, int maxUsers) throws AtlanException {
        return SearchLogRequest.mostRecentViewers(client, guid, maxUsers, null);
    }

    public static List<UserViews> mostRecentViewers(AtlanClient client, String guid, int maxUsers, List<String> excludeUsers) throws AtlanException {
        ArrayList<UserViews> list = new ArrayList<UserViews>();
        Aggregation byUser = SearchLogEntry.USER.bucketBy(maxUsers, Map.of("latestTimestamp", SearchLogEntry.SEARCHED_AT.max()), List.of(NamedValue.of((String)"latestTimestamp", (Object)SortOrder.Desc)));
        AtlanObject request = ((SearchLogRequestBuilder)((SearchLogRequestBuilder)((SearchLogRequestBuilder)SearchLogRequest.viewsByGuid(guid, excludeUsers).aggregation("uniqueUsers", byUser)).aggregation("totalDistinctUsers", SearchLogEntry.USER.distinct(1000))).pageSize(0)).build();
        SearchLogResponse response = ((SearchLogRequest)request).search(client);
        AggregationBucketResult uniqueUsers = (AggregationBucketResult)response.getAggregations().get("uniqueUsers");
        for (AggregationBucketDetails details : uniqueUsers.getBuckets()) {
            list.add(UserViews.builder().username(details.key.toString()).viewCount(details.docCount).mostRecentView(details.getNestedResults().get("latestTimestamp").getMetric().longValue()).build());
        }
        return list;
    }

    public static List<AssetViews> mostViewedAssets(int maxAssets, boolean byDifferentUsers) throws AtlanException {
        return SearchLogRequest.mostViewedAssets(maxAssets, byDifferentUsers, null);
    }

    public static List<AssetViews> mostViewedAssets(int maxAssets, boolean byDifferentUsers, List<String> excludeUsers) throws AtlanException {
        return SearchLogRequest.mostViewedAssets(Atlan.getDefaultClient(), maxAssets, byDifferentUsers, excludeUsers);
    }

    public static List<AssetViews> mostViewedAssets(AtlanClient client, int maxAssets, boolean byDifferentUsers) throws AtlanException {
        return SearchLogRequest.mostViewedAssets(client, maxAssets, byDifferentUsers, null);
    }

    public static List<AssetViews> mostViewedAssets(AtlanClient client, int maxAssets, boolean byDifferentUsers, List<String> excludeUsers) throws AtlanException {
        ArrayList<AssetViews> list = new ArrayList<AssetViews>();
        List<NamedValue<SortOrder>> sort = null;
        if (byDifferentUsers) {
            sort = List.of(NamedValue.of((String)"uniqueUsers", (Object)SortOrder.Desc));
        }
        Aggregation byGuid = SearchLogEntry.ENTITY_ID.bucketBy(maxAssets, Map.of("uniqueUsers", SearchLogEntry.USER.distinct(1000)), sort);
        AtlanObject request = ((SearchLogRequestBuilder)((SearchLogRequestBuilder)((SearchLogRequestBuilder)SearchLogRequest.views(excludeUsers).aggregation("uniqueAssets", byGuid)).aggregation("totalDistinctUsers", SearchLogEntry.USER.distinct(1000))).pageSize(1)).build();
        SearchLogResponse response = ((SearchLogRequest)request).search(client);
        AggregationBucketResult uniqueAssets = (AggregationBucketResult)response.getAggregations().get("uniqueAssets");
        for (AggregationBucketDetails details : uniqueAssets.getBuckets()) {
            list.add(AssetViews.builder().guid(details.key.toString()).totalViews(details.docCount).distinctUsers(details.getNestedResults().get("uniqueUsers").getMetric().longValue()).build());
        }
        return list;
    }

    public SearchLogResponse search() throws AtlanException {
        return this.search(Atlan.getDefaultClient());
    }

    public SearchLogResponse search(AtlanClient client) throws AtlanException {
        return client.searchLog.search(this);
    }

    public long count() throws AtlanException {
        return this.count(Atlan.getDefaultClient());
    }

    public long count(AtlanClient client) throws AtlanException {
        if (client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        AtlanObject request = SearchLogRequest.builder((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)this.getDsl().toBuilder().size(1)).clearAggregations()).build()).build();
        return ((SearchLogRequest)request).search(client).getApproximateCount();
    }

    public Stream<SearchLogEntry> stream() throws AtlanException {
        return this.stream(Atlan.getDefaultClient());
    }

    public Stream<SearchLogEntry> stream(AtlanClient client) throws AtlanException {
        return this.stream(client, false);
    }

    public Stream<SearchLogEntry> stream(boolean parallel) throws AtlanException {
        return this.stream(Atlan.getDefaultClient(), parallel);
    }

    public Stream<SearchLogEntry> stream(AtlanClient client, boolean parallel) throws AtlanException {
        if (parallel) {
            return this.search(client).parallelStream();
        }
        return this.search(client).stream();
    }

    @Generated
    protected SearchLogRequest(SearchLogRequestBuilder<?, ?> b) {
        super(b);
        this.dsl = b.dsl;
    }

    @Generated
    public static SearchLogRequestBuilder<?, ?> _internal() {
        return new SearchLogRequestBuilderImpl();
    }

    @Generated
    public SearchLogRequestBuilder<?, ?> toBuilder() {
        return new SearchLogRequestBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public IndexSearchDSL getDsl() {
        return this.dsl;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchLogRequest)) {
            return false;
        }
        SearchLogRequest other = (SearchLogRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexSearchDSL this$dsl = this.getDsl();
        IndexSearchDSL other$dsl = other.getDsl();
        return !(this$dsl == null ? other$dsl != null : !((Object)this$dsl).equals(other$dsl));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SearchLogRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IndexSearchDSL $dsl = this.getDsl();
        result = result * 59 + ($dsl == null ? 43 : ((Object)$dsl).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SearchLogRequest(super=" + super.toString() + ", dsl=" + this.getDsl() + ")";
    }

    public static abstract class SearchLogRequestBuilder<C extends SearchLogRequest, B extends SearchLogRequestBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private IndexSearchDSL dsl;

        public B pageSize(int size) {
            return this.dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)this.dsl.toBuilder().size(size)).build());
        }

        public B sortBy(SortOptions option) {
            return this.dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)this.dsl.toBuilder().sortOption(option)).build());
        }

        public B aggregation(String key, Aggregation aggregation) {
            return this.dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)this.dsl.toBuilder().aggregation(key, aggregation)).build());
        }

        public long count() throws AtlanException {
            return ((SearchLogRequest)this.build()).count();
        }

        public Stream<SearchLogEntry> stream() throws AtlanException {
            return ((SearchLogRequest)this.build()).stream();
        }

        public Stream<SearchLogEntry> stream(boolean parallel) throws AtlanException {
            return ((SearchLogRequest)this.build()).stream(parallel);
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SearchLogRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SearchLogRequest instance, SearchLogRequestBuilder<?, ?> b) {
            b.dsl(instance.dsl);
        }

        @Generated
        public B dsl(IndexSearchDSL dsl) {
            this.dsl = dsl;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SearchLogRequest.SearchLogRequestBuilder(super=" + super.toString() + ", dsl=" + this.dsl + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SearchLogRequestBuilderImpl
    extends SearchLogRequestBuilder<SearchLogRequest, SearchLogRequestBuilderImpl> {
        @Generated
        private SearchLogRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected SearchLogRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SearchLogRequest build() {
            return new SearchLogRequest(this);
        }
    }
}

