/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.typedefs;

import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.Glossary;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanCustomAttributePrimitiveType;
import com.atlan.serde.SetToStringSerializer;
import com.atlan.serde.StringToSetDeserializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;

@JsonDeserialize(builder=AttributeDefOptionsBuilderImpl.class)
public class AttributeDefOptions
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    public static final Set<String> ALL_ASSET_TYPES = Set.of("ADLSAccount", "ADLSContainer", "ADLSObject", "APIPath", "APISpec", "AirflowDag", "AirflowTask", "AnomaloCheck", "Collection", "Query", "AuthPolicy", "AuthService", "AzureEventHub", "AzureEventHubConsumerGroup", "AzureServiceBusNamespace", "AzureServiceBusTopic", "BIProcess", "Badge", "BusinessPolicy", "BusinessPolicyException", "BusinessPolicyIncident", "BusinessPolicyLog", "CalculationView", "Cognite3DModel", "CogniteAsset", "CogniteEvent", "CogniteFile", "CogniteSequence", "CogniteTimeSeries", "CognosDashboard", "CognosDatasource", "CognosExploration", "CognosFile", "CognosFolder", "CognosModule", "CognosPackage", "CognosReport", "Column", "ColumnProcess", "Connection", "CosmosMongoDBAccount", "CosmosMongoDBCollection", "CosmosMongoDBDatabase", "Cube", "CubeDimension", "CubeField", "CubeHierarchy", "DMAttribute", "DMAttributeAssociation", "DMDataModel", "DMEntity", "DMEntityAssociation", "DMVersion", "DataContract", "DataStudioAsset", "Database", "DatabricksUnityCatalogTag", "DbtColumnProcess", "DbtMetric", "DbtModel", "DbtModelColumn", "DbtProcess", "DbtSource", "DbtTag", "DbtTest", "DomoCard", "DomoDashboard", "DomoDataset", "DomoDatasetColumn", "DynamoDBGlobalSecondaryIndex", "DynamoDBLocalSecondaryIndex", "DynamoDBTable", "Folder", "Function", "GCSBucket", "GCSObject", "Insight", "KafkaConsumerGroup", "KafkaTopic", "Process", "Link", "LookerDashboard", "LookerExplore", "LookerField", "LookerFolder", "LookerLook", "LookerModel", "LookerProject", "LookerQuery", "LookerTile", "LookerView", "MCIncident", "MCMonitor", "MaterialisedView", "MatillionComponent", "MatillionGroup", "MatillionJob", "MatillionProject", "MetabaseCollection", "MetabaseDashboard", "MetabaseQuestion", "MicroStrategyAttribute", "MicroStrategyCube", "MicroStrategyDocument", "MicroStrategyDossier", "MicroStrategyFact", "MicroStrategyMetric", "MicroStrategyProject", "MicroStrategyReport", "MicroStrategyVisualization", "ModeChart", "ModeCollection", "ModeQuery", "ModeReport", "ModeWorkspace", "ModelAttribute", "ModelAttributeAssociation", "ModelDataModel", "ModelEntity", "ModelEntityAssociation", "ModelVersion", "MongoDBCollection", "MongoDBDatabase", "Persona", "PowerBIColumn", "PowerBIDashboard", "PowerBIDataflow", "PowerBIDataset", "PowerBIDatasource", "PowerBIMeasure", "PowerBIPage", "PowerBIReport", "PowerBITable", "PowerBITile", "PowerBIWorkspace", "PresetChart", "PresetDashboard", "PresetDataset", "PresetWorkspace", "Procedure", "Purpose", "QlikApp", "QlikChart", "QlikDataset", "QlikSheet", "QlikSpace", "QlikStream", "QuickSightAnalysis", "QuickSightAnalysisVisual", "QuickSightDashboard", "QuickSightDashboardVisual", "QuickSightDataset", "QuickSightDatasetField", "QuickSightFolder", "Readme", "ReadmeTemplate", "RedashDashboard", "RedashQuery", "RedashVisualization", "S3Bucket", "S3Object", "SalesforceDashboard", "SalesforceField", "SalesforceObject", "SalesforceOrganization", "SalesforceReport", "Schema", "SchemaRegistrySubject", "SigmaDataElement", "SigmaDataElementField", "SigmaDataset", "SigmaDatasetColumn", "SigmaPage", "SigmaWorkbook", "SisenseDashboard", "SisenseDatamodel", "SisenseDatamodelTable", "SisenseFolder", "SisenseWidget", "SnowflakeDynamicTable", "SnowflakePipe", "SnowflakeStream", "SnowflakeTag", "SodaCheck", "SparkJob", "Stakeholder", "StakeholderTitle", "SupersetChart", "SupersetDashboard", "SupersetDataset", "Table", "TablePartition", "TableauCalculatedField", "TableauDashboard", "TableauDatasource", "TableauDatasourceField", "TableauFlow", "TableauMetric", "TableauProject", "TableauSite", "TableauWorkbook", "TableauWorksheet", "TagAttachment", "Task", "ThoughtspotAnswer", "ThoughtspotColumn", "ThoughtspotDashlet", "ThoughtspotLiveboard", "ThoughtspotTable", "ThoughtspotView", "ThoughtspotWorksheet", "View", "Workflow", "WorkflowRun");
    public static final Set<String> ALL_GLOSSARY_TYPES = Set.of("AtlasGlossary", "AtlasGlossaryTerm", "AtlasGlossaryCategory");
    public static final Set<String> ALL_DOMAIN_TYPES = Set.of("DataDomain", "DataProduct");
    public static final Set<String> ALL_OTHER_TYPES = Set.of("File");
    public static final Set<String> ALL_DOMAINS = Set.of("*/super");
    String customMetadataVersion;
    String description;
    @JsonSerialize(using=SetToStringSerializer.class)
    @JsonDeserialize(using=StringToSetDeserializer.class)
    Set<String> applicableEntityTypes;
    @JsonSerialize(using=SetToStringSerializer.class)
    @JsonDeserialize(using=StringToSetDeserializer.class)
    @Deprecated
    Set<String> customApplicableEntityTypes;
    @JsonSerialize(using=SetToStringSerializer.class)
    @JsonDeserialize(using=StringToSetDeserializer.class)
    Set<String> applicableConnections;
    @JsonSerialize(using=SetToStringSerializer.class)
    @JsonDeserialize(using=StringToSetDeserializer.class)
    Set<String> applicableGlossaries;
    @JsonSerialize(using=SetToStringSerializer.class)
    @JsonDeserialize(using=StringToSetDeserializer.class)
    Set<String> applicableDomains;
    @JsonSerialize(using=SetToStringSerializer.class)
    @JsonDeserialize(using=StringToSetDeserializer.class)
    @JsonProperty(value="assetTypesList")
    Set<String> applicableAssetTypes;
    @JsonSerialize(using=SetToStringSerializer.class)
    @JsonDeserialize(using=StringToSetDeserializer.class)
    @JsonProperty(value="glossaryTypeList")
    Set<String> applicableGlossaryTypes;
    @JsonSerialize(using=SetToStringSerializer.class)
    @JsonDeserialize(using=StringToSetDeserializer.class)
    @JsonProperty(value="domainTypesList")
    Set<String> applicableDomainTypes;
    @JsonSerialize(using=SetToStringSerializer.class)
    @JsonDeserialize(using=StringToSetDeserializer.class)
    @JsonProperty(value="otherAssetTypeList")
    Set<String> applicableOtherAssetTypes;
    Boolean allowSearch;
    String maxStrLength;
    Boolean allowFiltering;
    Boolean multiValueSelect;
    Boolean showInOverview;
    String isDeprecated;
    AtlanCustomAttributePrimitiveType primitiveType;
    Boolean isEnum;
    String enumType;
    String customType;
    Boolean hasTimePrecision;
    Boolean isArchived;
    Long archivedAt;
    String archivedBy;
    String isSoftReference;
    String isAppendOnPartialUpdate;

    public static AttributeDefOptions of(AtlanCustomAttributePrimitiveType type, String optionsName) throws AtlanException {
        return AttributeDefOptions.of(type, optionsName, null);
    }

    public static AttributeDefOptions of(AtlanCustomAttributePrimitiveType type, String optionsName, AttributeDefOptions options) throws AtlanException {
        AttributeDefOptionsBuilder<Object, Object> builder = options != null ? options.toBuilder() : ((AttributeDefOptionsBuilder)((AttributeDefOptionsBuilder)((AttributeDefOptionsBuilder)((AttributeDefOptionsBuilder)((AttributeDefOptionsBuilder)((AttributeDefOptionsBuilder)AttributeDefOptions.builder().applicableConnections(Connection.getAllQualifiedNames())).applicableAssetTypes(ALL_ASSET_TYPES)).applicableGlossaries(Glossary.getAllQualifiedNames())).applicableGlossaryTypes(ALL_GLOSSARY_TYPES)).applicableDomains(ALL_DOMAINS)).applicableDomainTypes(ALL_DOMAIN_TYPES)).applicableOtherAssetTypes(ALL_OTHER_TYPES);
        builder.primitiveType(type);
        switch (type) {
            case USERS: 
            case GROUPS: 
            case URL: 
            case SQL: {
                builder.customType(type.getValue());
                break;
            }
            case OPTIONS: {
                ((AttributeDefOptionsBuilder)builder.isEnum(true)).enumType(optionsName);
                break;
            }
        }
        return builder.build();
    }

    public AttributeDefOptions append(AttributeDefOptions options) {
        if (options == null) {
            return this;
        }
        if (options.description != null) {
            this.description = options.description;
        }
        if (options.applicableEntityTypes != null) {
            this.applicableEntityTypes = options.applicableEntityTypes;
        }
        if (options.customApplicableEntityTypes != null) {
            this.customApplicableEntityTypes = options.customApplicableEntityTypes;
        }
        if (options.applicableConnections != null) {
            this.applicableConnections = options.applicableConnections;
        }
        if (options.applicableGlossaries != null) {
            this.applicableGlossaries = options.applicableGlossaries;
        }
        if (options.applicableDomains != null) {
            this.applicableDomains = options.applicableDomains;
        }
        if (options.applicableAssetTypes != null) {
            this.applicableAssetTypes = options.applicableAssetTypes;
        }
        if (options.applicableGlossaryTypes != null) {
            this.applicableGlossaryTypes = options.applicableGlossaryTypes;
        }
        if (options.applicableDomainTypes != null) {
            this.applicableDomainTypes = options.applicableDomainTypes;
        }
        if (options.applicableOtherAssetTypes != null) {
            this.applicableOtherAssetTypes = options.applicableOtherAssetTypes;
        }
        if (options.allowSearch != null) {
            this.allowSearch = options.allowSearch;
        }
        if (options.maxStrLength != null) {
            this.maxStrLength = options.maxStrLength;
        }
        if (options.allowFiltering != null) {
            this.allowFiltering = options.allowFiltering;
        }
        if (options.showInOverview != null) {
            this.showInOverview = options.showInOverview;
        }
        if (options.isDeprecated != null) {
            this.isDeprecated = options.isDeprecated;
        }
        if (options.hasTimePrecision != null) {
            this.hasTimePrecision = options.hasTimePrecision;
        }
        return this;
    }

    @Generated
    private static String $default$customMetadataVersion() {
        return "v2";
    }

    @Generated
    private static Set<String> $default$applicableEntityTypes() {
        return Set.of("Asset");
    }

    @Generated
    private static Boolean $default$allowSearch() {
        return false;
    }

    @Generated
    private static String $default$maxStrLength() {
        return "100000000";
    }

    @Generated
    private static Boolean $default$allowFiltering() {
        return true;
    }

    @Generated
    private static Boolean $default$multiValueSelect() {
        return false;
    }

    @Generated
    private static Boolean $default$showInOverview() {
        return false;
    }

    @Generated
    private static Boolean $default$isEnum() {
        return false;
    }

    @Generated
    protected AttributeDefOptions(AttributeDefOptionsBuilder<?, ?> b) {
        super(b);
        Set<Object> applicableOtherAssetTypes;
        Set<Object> applicableDomainTypes;
        Set<Object> applicableGlossaryTypes;
        Set<Object> applicableAssetTypes;
        Set<Object> applicableDomains;
        Set<Object> applicableGlossaries;
        Set<Object> applicableConnections;
        this.customMetadataVersion = b.customMetadataVersion$set ? b.customMetadataVersion$value : AttributeDefOptions.$default$customMetadataVersion();
        this.description = b.description;
        this.applicableEntityTypes = b.applicableEntityTypes$set ? b.applicableEntityTypes$value : AttributeDefOptions.$default$applicableEntityTypes();
        this.customApplicableEntityTypes = b.customApplicableEntityTypes;
        switch (b.applicableConnections == null ? 0 : b.applicableConnections.size()) {
            case 0: {
                applicableConnections = Collections.emptySet();
                break;
            }
            case 1: {
                applicableConnections = Collections.singleton(b.applicableConnections.get(0));
                break;
            }
            default: {
                applicableConnections = new LinkedHashSet(b.applicableConnections.size() < 0x40000000 ? 1 + b.applicableConnections.size() + (b.applicableConnections.size() - 3) / 3 : Integer.MAX_VALUE);
                applicableConnections.addAll(b.applicableConnections);
                applicableConnections = Collections.unmodifiableSet(applicableConnections);
            }
        }
        this.applicableConnections = applicableConnections;
        switch (b.applicableGlossaries == null ? 0 : b.applicableGlossaries.size()) {
            case 0: {
                applicableGlossaries = Collections.emptySet();
                break;
            }
            case 1: {
                applicableGlossaries = Collections.singleton(b.applicableGlossaries.get(0));
                break;
            }
            default: {
                applicableGlossaries = new LinkedHashSet(b.applicableGlossaries.size() < 0x40000000 ? 1 + b.applicableGlossaries.size() + (b.applicableGlossaries.size() - 3) / 3 : Integer.MAX_VALUE);
                applicableGlossaries.addAll(b.applicableGlossaries);
                applicableGlossaries = Collections.unmodifiableSet(applicableGlossaries);
            }
        }
        this.applicableGlossaries = applicableGlossaries;
        switch (b.applicableDomains == null ? 0 : b.applicableDomains.size()) {
            case 0: {
                applicableDomains = Collections.emptySet();
                break;
            }
            case 1: {
                applicableDomains = Collections.singleton(b.applicableDomains.get(0));
                break;
            }
            default: {
                applicableDomains = new LinkedHashSet(b.applicableDomains.size() < 0x40000000 ? 1 + b.applicableDomains.size() + (b.applicableDomains.size() - 3) / 3 : Integer.MAX_VALUE);
                applicableDomains.addAll(b.applicableDomains);
                applicableDomains = Collections.unmodifiableSet(applicableDomains);
            }
        }
        this.applicableDomains = applicableDomains;
        switch (b.applicableAssetTypes == null ? 0 : b.applicableAssetTypes.size()) {
            case 0: {
                applicableAssetTypes = Collections.emptySet();
                break;
            }
            case 1: {
                applicableAssetTypes = Collections.singleton(b.applicableAssetTypes.get(0));
                break;
            }
            default: {
                applicableAssetTypes = new LinkedHashSet(b.applicableAssetTypes.size() < 0x40000000 ? 1 + b.applicableAssetTypes.size() + (b.applicableAssetTypes.size() - 3) / 3 : Integer.MAX_VALUE);
                applicableAssetTypes.addAll(b.applicableAssetTypes);
                applicableAssetTypes = Collections.unmodifiableSet(applicableAssetTypes);
            }
        }
        this.applicableAssetTypes = applicableAssetTypes;
        switch (b.applicableGlossaryTypes == null ? 0 : b.applicableGlossaryTypes.size()) {
            case 0: {
                applicableGlossaryTypes = Collections.emptySet();
                break;
            }
            case 1: {
                applicableGlossaryTypes = Collections.singleton(b.applicableGlossaryTypes.get(0));
                break;
            }
            default: {
                applicableGlossaryTypes = new LinkedHashSet(b.applicableGlossaryTypes.size() < 0x40000000 ? 1 + b.applicableGlossaryTypes.size() + (b.applicableGlossaryTypes.size() - 3) / 3 : Integer.MAX_VALUE);
                applicableGlossaryTypes.addAll(b.applicableGlossaryTypes);
                applicableGlossaryTypes = Collections.unmodifiableSet(applicableGlossaryTypes);
            }
        }
        this.applicableGlossaryTypes = applicableGlossaryTypes;
        switch (b.applicableDomainTypes == null ? 0 : b.applicableDomainTypes.size()) {
            case 0: {
                applicableDomainTypes = Collections.emptySet();
                break;
            }
            case 1: {
                applicableDomainTypes = Collections.singleton(b.applicableDomainTypes.get(0));
                break;
            }
            default: {
                applicableDomainTypes = new LinkedHashSet(b.applicableDomainTypes.size() < 0x40000000 ? 1 + b.applicableDomainTypes.size() + (b.applicableDomainTypes.size() - 3) / 3 : Integer.MAX_VALUE);
                applicableDomainTypes.addAll(b.applicableDomainTypes);
                applicableDomainTypes = Collections.unmodifiableSet(applicableDomainTypes);
            }
        }
        this.applicableDomainTypes = applicableDomainTypes;
        switch (b.applicableOtherAssetTypes == null ? 0 : b.applicableOtherAssetTypes.size()) {
            case 0: {
                applicableOtherAssetTypes = Collections.emptySet();
                break;
            }
            case 1: {
                applicableOtherAssetTypes = Collections.singleton(b.applicableOtherAssetTypes.get(0));
                break;
            }
            default: {
                applicableOtherAssetTypes = new LinkedHashSet(b.applicableOtherAssetTypes.size() < 0x40000000 ? 1 + b.applicableOtherAssetTypes.size() + (b.applicableOtherAssetTypes.size() - 3) / 3 : Integer.MAX_VALUE);
                applicableOtherAssetTypes.addAll(b.applicableOtherAssetTypes);
                applicableOtherAssetTypes = Collections.unmodifiableSet(applicableOtherAssetTypes);
            }
        }
        this.applicableOtherAssetTypes = applicableOtherAssetTypes;
        this.allowSearch = b.allowSearch$set ? b.allowSearch$value : AttributeDefOptions.$default$allowSearch();
        this.maxStrLength = b.maxStrLength$set ? b.maxStrLength$value : AttributeDefOptions.$default$maxStrLength();
        this.allowFiltering = b.allowFiltering$set ? b.allowFiltering$value : AttributeDefOptions.$default$allowFiltering();
        this.multiValueSelect = b.multiValueSelect$set ? b.multiValueSelect$value : AttributeDefOptions.$default$multiValueSelect();
        this.showInOverview = b.showInOverview$set ? b.showInOverview$value : AttributeDefOptions.$default$showInOverview();
        this.isDeprecated = b.isDeprecated;
        this.primitiveType = b.primitiveType;
        this.isEnum = b.isEnum$set ? b.isEnum$value : AttributeDefOptions.$default$isEnum();
        this.enumType = b.enumType;
        this.customType = b.customType;
        this.hasTimePrecision = b.hasTimePrecision;
        this.isArchived = b.isArchived;
        this.archivedAt = b.archivedAt;
        this.archivedBy = b.archivedBy;
        this.isSoftReference = b.isSoftReference;
        this.isAppendOnPartialUpdate = b.isAppendOnPartialUpdate;
    }

    @Generated
    public static AttributeDefOptionsBuilder<?, ?> builder() {
        return new AttributeDefOptionsBuilderImpl();
    }

    @Generated
    public AttributeDefOptionsBuilder<?, ?> toBuilder() {
        return new AttributeDefOptionsBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getCustomMetadataVersion() {
        return this.customMetadataVersion;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getApplicableEntityTypes() {
        return this.applicableEntityTypes;
    }

    @Deprecated
    @Generated
    public Set<String> getCustomApplicableEntityTypes() {
        return this.customApplicableEntityTypes;
    }

    @Generated
    public Set<String> getApplicableConnections() {
        return this.applicableConnections;
    }

    @Generated
    public Set<String> getApplicableGlossaries() {
        return this.applicableGlossaries;
    }

    @Generated
    public Set<String> getApplicableDomains() {
        return this.applicableDomains;
    }

    @Generated
    public Set<String> getApplicableAssetTypes() {
        return this.applicableAssetTypes;
    }

    @Generated
    public Set<String> getApplicableGlossaryTypes() {
        return this.applicableGlossaryTypes;
    }

    @Generated
    public Set<String> getApplicableDomainTypes() {
        return this.applicableDomainTypes;
    }

    @Generated
    public Set<String> getApplicableOtherAssetTypes() {
        return this.applicableOtherAssetTypes;
    }

    @Generated
    public Boolean getAllowSearch() {
        return this.allowSearch;
    }

    @Generated
    public String getMaxStrLength() {
        return this.maxStrLength;
    }

    @Generated
    public Boolean getAllowFiltering() {
        return this.allowFiltering;
    }

    @Generated
    public Boolean getMultiValueSelect() {
        return this.multiValueSelect;
    }

    @Generated
    public Boolean getShowInOverview() {
        return this.showInOverview;
    }

    @Generated
    public String getIsDeprecated() {
        return this.isDeprecated;
    }

    @Generated
    public AtlanCustomAttributePrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    @Generated
    public Boolean getIsEnum() {
        return this.isEnum;
    }

    @Generated
    public String getEnumType() {
        return this.enumType;
    }

    @Generated
    public String getCustomType() {
        return this.customType;
    }

    @Generated
    public Boolean getHasTimePrecision() {
        return this.hasTimePrecision;
    }

    @Generated
    public Boolean getIsArchived() {
        return this.isArchived;
    }

    @Generated
    public Long getArchivedAt() {
        return this.archivedAt;
    }

    @Generated
    public String getArchivedBy() {
        return this.archivedBy;
    }

    @Generated
    public String getIsSoftReference() {
        return this.isSoftReference;
    }

    @Generated
    public String getIsAppendOnPartialUpdate() {
        return this.isAppendOnPartialUpdate;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeDefOptions)) {
            return false;
        }
        AttributeDefOptions other = (AttributeDefOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$allowSearch = this.getAllowSearch();
        Boolean other$allowSearch = other.getAllowSearch();
        if (this$allowSearch == null ? other$allowSearch != null : !((Object)this$allowSearch).equals(other$allowSearch)) {
            return false;
        }
        Boolean this$allowFiltering = this.getAllowFiltering();
        Boolean other$allowFiltering = other.getAllowFiltering();
        if (this$allowFiltering == null ? other$allowFiltering != null : !((Object)this$allowFiltering).equals(other$allowFiltering)) {
            return false;
        }
        Boolean this$multiValueSelect = this.getMultiValueSelect();
        Boolean other$multiValueSelect = other.getMultiValueSelect();
        if (this$multiValueSelect == null ? other$multiValueSelect != null : !((Object)this$multiValueSelect).equals(other$multiValueSelect)) {
            return false;
        }
        Boolean this$showInOverview = this.getShowInOverview();
        Boolean other$showInOverview = other.getShowInOverview();
        if (this$showInOverview == null ? other$showInOverview != null : !((Object)this$showInOverview).equals(other$showInOverview)) {
            return false;
        }
        Boolean this$isEnum = this.getIsEnum();
        Boolean other$isEnum = other.getIsEnum();
        if (this$isEnum == null ? other$isEnum != null : !((Object)this$isEnum).equals(other$isEnum)) {
            return false;
        }
        Boolean this$hasTimePrecision = this.getHasTimePrecision();
        Boolean other$hasTimePrecision = other.getHasTimePrecision();
        if (this$hasTimePrecision == null ? other$hasTimePrecision != null : !((Object)this$hasTimePrecision).equals(other$hasTimePrecision)) {
            return false;
        }
        Boolean this$isArchived = this.getIsArchived();
        Boolean other$isArchived = other.getIsArchived();
        if (this$isArchived == null ? other$isArchived != null : !((Object)this$isArchived).equals(other$isArchived)) {
            return false;
        }
        Long this$archivedAt = this.getArchivedAt();
        Long other$archivedAt = other.getArchivedAt();
        if (this$archivedAt == null ? other$archivedAt != null : !((Object)this$archivedAt).equals(other$archivedAt)) {
            return false;
        }
        String this$customMetadataVersion = this.getCustomMetadataVersion();
        String other$customMetadataVersion = other.getCustomMetadataVersion();
        if (this$customMetadataVersion == null ? other$customMetadataVersion != null : !this$customMetadataVersion.equals(other$customMetadataVersion)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$applicableEntityTypes = this.getApplicableEntityTypes();
        Set<String> other$applicableEntityTypes = other.getApplicableEntityTypes();
        if (this$applicableEntityTypes == null ? other$applicableEntityTypes != null : !((Object)this$applicableEntityTypes).equals(other$applicableEntityTypes)) {
            return false;
        }
        Set<String> this$customApplicableEntityTypes = this.getCustomApplicableEntityTypes();
        Set<String> other$customApplicableEntityTypes = other.getCustomApplicableEntityTypes();
        if (this$customApplicableEntityTypes == null ? other$customApplicableEntityTypes != null : !((Object)this$customApplicableEntityTypes).equals(other$customApplicableEntityTypes)) {
            return false;
        }
        Set<String> this$applicableConnections = this.getApplicableConnections();
        Set<String> other$applicableConnections = other.getApplicableConnections();
        if (this$applicableConnections == null ? other$applicableConnections != null : !((Object)this$applicableConnections).equals(other$applicableConnections)) {
            return false;
        }
        Set<String> this$applicableGlossaries = this.getApplicableGlossaries();
        Set<String> other$applicableGlossaries = other.getApplicableGlossaries();
        if (this$applicableGlossaries == null ? other$applicableGlossaries != null : !((Object)this$applicableGlossaries).equals(other$applicableGlossaries)) {
            return false;
        }
        Set<String> this$applicableDomains = this.getApplicableDomains();
        Set<String> other$applicableDomains = other.getApplicableDomains();
        if (this$applicableDomains == null ? other$applicableDomains != null : !((Object)this$applicableDomains).equals(other$applicableDomains)) {
            return false;
        }
        Set<String> this$applicableAssetTypes = this.getApplicableAssetTypes();
        Set<String> other$applicableAssetTypes = other.getApplicableAssetTypes();
        if (this$applicableAssetTypes == null ? other$applicableAssetTypes != null : !((Object)this$applicableAssetTypes).equals(other$applicableAssetTypes)) {
            return false;
        }
        Set<String> this$applicableGlossaryTypes = this.getApplicableGlossaryTypes();
        Set<String> other$applicableGlossaryTypes = other.getApplicableGlossaryTypes();
        if (this$applicableGlossaryTypes == null ? other$applicableGlossaryTypes != null : !((Object)this$applicableGlossaryTypes).equals(other$applicableGlossaryTypes)) {
            return false;
        }
        Set<String> this$applicableDomainTypes = this.getApplicableDomainTypes();
        Set<String> other$applicableDomainTypes = other.getApplicableDomainTypes();
        if (this$applicableDomainTypes == null ? other$applicableDomainTypes != null : !((Object)this$applicableDomainTypes).equals(other$applicableDomainTypes)) {
            return false;
        }
        Set<String> this$applicableOtherAssetTypes = this.getApplicableOtherAssetTypes();
        Set<String> other$applicableOtherAssetTypes = other.getApplicableOtherAssetTypes();
        if (this$applicableOtherAssetTypes == null ? other$applicableOtherAssetTypes != null : !((Object)this$applicableOtherAssetTypes).equals(other$applicableOtherAssetTypes)) {
            return false;
        }
        String this$maxStrLength = this.getMaxStrLength();
        String other$maxStrLength = other.getMaxStrLength();
        if (this$maxStrLength == null ? other$maxStrLength != null : !this$maxStrLength.equals(other$maxStrLength)) {
            return false;
        }
        String this$isDeprecated = this.getIsDeprecated();
        String other$isDeprecated = other.getIsDeprecated();
        if (this$isDeprecated == null ? other$isDeprecated != null : !this$isDeprecated.equals(other$isDeprecated)) {
            return false;
        }
        AtlanCustomAttributePrimitiveType this$primitiveType = this.getPrimitiveType();
        AtlanCustomAttributePrimitiveType other$primitiveType = other.getPrimitiveType();
        if (this$primitiveType == null ? other$primitiveType != null : !this$primitiveType.equals(other$primitiveType)) {
            return false;
        }
        String this$enumType = this.getEnumType();
        String other$enumType = other.getEnumType();
        if (this$enumType == null ? other$enumType != null : !this$enumType.equals(other$enumType)) {
            return false;
        }
        String this$customType = this.getCustomType();
        String other$customType = other.getCustomType();
        if (this$customType == null ? other$customType != null : !this$customType.equals(other$customType)) {
            return false;
        }
        String this$archivedBy = this.getArchivedBy();
        String other$archivedBy = other.getArchivedBy();
        if (this$archivedBy == null ? other$archivedBy != null : !this$archivedBy.equals(other$archivedBy)) {
            return false;
        }
        String this$isSoftReference = this.getIsSoftReference();
        String other$isSoftReference = other.getIsSoftReference();
        if (this$isSoftReference == null ? other$isSoftReference != null : !this$isSoftReference.equals(other$isSoftReference)) {
            return false;
        }
        String this$isAppendOnPartialUpdate = this.getIsAppendOnPartialUpdate();
        String other$isAppendOnPartialUpdate = other.getIsAppendOnPartialUpdate();
        return !(this$isAppendOnPartialUpdate == null ? other$isAppendOnPartialUpdate != null : !this$isAppendOnPartialUpdate.equals(other$isAppendOnPartialUpdate));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AttributeDefOptions;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowSearch = this.getAllowSearch();
        result = result * 59 + ($allowSearch == null ? 43 : ((Object)$allowSearch).hashCode());
        Boolean $allowFiltering = this.getAllowFiltering();
        result = result * 59 + ($allowFiltering == null ? 43 : ((Object)$allowFiltering).hashCode());
        Boolean $multiValueSelect = this.getMultiValueSelect();
        result = result * 59 + ($multiValueSelect == null ? 43 : ((Object)$multiValueSelect).hashCode());
        Boolean $showInOverview = this.getShowInOverview();
        result = result * 59 + ($showInOverview == null ? 43 : ((Object)$showInOverview).hashCode());
        Boolean $isEnum = this.getIsEnum();
        result = result * 59 + ($isEnum == null ? 43 : ((Object)$isEnum).hashCode());
        Boolean $hasTimePrecision = this.getHasTimePrecision();
        result = result * 59 + ($hasTimePrecision == null ? 43 : ((Object)$hasTimePrecision).hashCode());
        Boolean $isArchived = this.getIsArchived();
        result = result * 59 + ($isArchived == null ? 43 : ((Object)$isArchived).hashCode());
        Long $archivedAt = this.getArchivedAt();
        result = result * 59 + ($archivedAt == null ? 43 : ((Object)$archivedAt).hashCode());
        String $customMetadataVersion = this.getCustomMetadataVersion();
        result = result * 59 + ($customMetadataVersion == null ? 43 : $customMetadataVersion.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $applicableEntityTypes = this.getApplicableEntityTypes();
        result = result * 59 + ($applicableEntityTypes == null ? 43 : ((Object)$applicableEntityTypes).hashCode());
        Set<String> $customApplicableEntityTypes = this.getCustomApplicableEntityTypes();
        result = result * 59 + ($customApplicableEntityTypes == null ? 43 : ((Object)$customApplicableEntityTypes).hashCode());
        Set<String> $applicableConnections = this.getApplicableConnections();
        result = result * 59 + ($applicableConnections == null ? 43 : ((Object)$applicableConnections).hashCode());
        Set<String> $applicableGlossaries = this.getApplicableGlossaries();
        result = result * 59 + ($applicableGlossaries == null ? 43 : ((Object)$applicableGlossaries).hashCode());
        Set<String> $applicableDomains = this.getApplicableDomains();
        result = result * 59 + ($applicableDomains == null ? 43 : ((Object)$applicableDomains).hashCode());
        Set<String> $applicableAssetTypes = this.getApplicableAssetTypes();
        result = result * 59 + ($applicableAssetTypes == null ? 43 : ((Object)$applicableAssetTypes).hashCode());
        Set<String> $applicableGlossaryTypes = this.getApplicableGlossaryTypes();
        result = result * 59 + ($applicableGlossaryTypes == null ? 43 : ((Object)$applicableGlossaryTypes).hashCode());
        Set<String> $applicableDomainTypes = this.getApplicableDomainTypes();
        result = result * 59 + ($applicableDomainTypes == null ? 43 : ((Object)$applicableDomainTypes).hashCode());
        Set<String> $applicableOtherAssetTypes = this.getApplicableOtherAssetTypes();
        result = result * 59 + ($applicableOtherAssetTypes == null ? 43 : ((Object)$applicableOtherAssetTypes).hashCode());
        String $maxStrLength = this.getMaxStrLength();
        result = result * 59 + ($maxStrLength == null ? 43 : $maxStrLength.hashCode());
        String $isDeprecated = this.getIsDeprecated();
        result = result * 59 + ($isDeprecated == null ? 43 : $isDeprecated.hashCode());
        AtlanCustomAttributePrimitiveType $primitiveType = this.getPrimitiveType();
        result = result * 59 + ($primitiveType == null ? 43 : $primitiveType.hashCode());
        String $enumType = this.getEnumType();
        result = result * 59 + ($enumType == null ? 43 : $enumType.hashCode());
        String $customType = this.getCustomType();
        result = result * 59 + ($customType == null ? 43 : $customType.hashCode());
        String $archivedBy = this.getArchivedBy();
        result = result * 59 + ($archivedBy == null ? 43 : $archivedBy.hashCode());
        String $isSoftReference = this.getIsSoftReference();
        result = result * 59 + ($isSoftReference == null ? 43 : $isSoftReference.hashCode());
        String $isAppendOnPartialUpdate = this.getIsAppendOnPartialUpdate();
        result = result * 59 + ($isAppendOnPartialUpdate == null ? 43 : $isAppendOnPartialUpdate.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AttributeDefOptions(super=" + super.toString() + ", customMetadataVersion=" + this.getCustomMetadataVersion() + ", description=" + this.getDescription() + ", applicableEntityTypes=" + this.getApplicableEntityTypes() + ", customApplicableEntityTypes=" + this.getCustomApplicableEntityTypes() + ", applicableConnections=" + this.getApplicableConnections() + ", applicableGlossaries=" + this.getApplicableGlossaries() + ", applicableDomains=" + this.getApplicableDomains() + ", applicableAssetTypes=" + this.getApplicableAssetTypes() + ", applicableGlossaryTypes=" + this.getApplicableGlossaryTypes() + ", applicableDomainTypes=" + this.getApplicableDomainTypes() + ", applicableOtherAssetTypes=" + this.getApplicableOtherAssetTypes() + ", allowSearch=" + this.getAllowSearch() + ", maxStrLength=" + this.getMaxStrLength() + ", allowFiltering=" + this.getAllowFiltering() + ", multiValueSelect=" + this.getMultiValueSelect() + ", showInOverview=" + this.getShowInOverview() + ", isDeprecated=" + this.getIsDeprecated() + ", primitiveType=" + this.getPrimitiveType() + ", isEnum=" + this.getIsEnum() + ", enumType=" + this.getEnumType() + ", customType=" + this.getCustomType() + ", hasTimePrecision=" + this.getHasTimePrecision() + ", isArchived=" + this.getIsArchived() + ", archivedAt=" + this.getArchivedAt() + ", archivedBy=" + this.getArchivedBy() + ", isSoftReference=" + this.getIsSoftReference() + ", isAppendOnPartialUpdate=" + this.getIsAppendOnPartialUpdate() + ")";
    }

    @Generated
    public static abstract class AttributeDefOptionsBuilder<C extends AttributeDefOptions, B extends AttributeDefOptionsBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private boolean customMetadataVersion$set;
        @Generated
        private String customMetadataVersion$value;
        @Generated
        private String description;
        @Generated
        private boolean applicableEntityTypes$set;
        @Generated
        private Set<String> applicableEntityTypes$value;
        @Generated
        private Set<String> customApplicableEntityTypes;
        @Generated
        private ArrayList<String> applicableConnections;
        @Generated
        private ArrayList<String> applicableGlossaries;
        @Generated
        private ArrayList<String> applicableDomains;
        @Generated
        private ArrayList<String> applicableAssetTypes;
        @Generated
        private ArrayList<String> applicableGlossaryTypes;
        @Generated
        private ArrayList<String> applicableDomainTypes;
        @Generated
        private ArrayList<String> applicableOtherAssetTypes;
        @Generated
        private boolean allowSearch$set;
        @Generated
        private Boolean allowSearch$value;
        @Generated
        private boolean maxStrLength$set;
        @Generated
        private String maxStrLength$value;
        @Generated
        private boolean allowFiltering$set;
        @Generated
        private Boolean allowFiltering$value;
        @Generated
        private boolean multiValueSelect$set;
        @Generated
        private Boolean multiValueSelect$value;
        @Generated
        private boolean showInOverview$set;
        @Generated
        private Boolean showInOverview$value;
        @Generated
        private String isDeprecated;
        @Generated
        private AtlanCustomAttributePrimitiveType primitiveType;
        @Generated
        private boolean isEnum$set;
        @Generated
        private Boolean isEnum$value;
        @Generated
        private String enumType;
        @Generated
        private String customType;
        @Generated
        private Boolean hasTimePrecision;
        @Generated
        private Boolean isArchived;
        @Generated
        private Long archivedAt;
        @Generated
        private String archivedBy;
        @Generated
        private String isSoftReference;
        @Generated
        private String isAppendOnPartialUpdate;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AttributeDefOptionsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AttributeDefOptions instance, AttributeDefOptionsBuilder<?, ?> b) {
            b.customMetadataVersion(instance.customMetadataVersion);
            b.description(instance.description);
            b.applicableEntityTypes(instance.applicableEntityTypes);
            b.customApplicableEntityTypes(instance.customApplicableEntityTypes);
            b.applicableConnections(instance.applicableConnections == null ? Collections.emptySet() : instance.applicableConnections);
            b.applicableGlossaries(instance.applicableGlossaries == null ? Collections.emptySet() : instance.applicableGlossaries);
            b.applicableDomains(instance.applicableDomains == null ? Collections.emptySet() : instance.applicableDomains);
            b.applicableAssetTypes(instance.applicableAssetTypes == null ? Collections.emptySet() : instance.applicableAssetTypes);
            b.applicableGlossaryTypes(instance.applicableGlossaryTypes == null ? Collections.emptySet() : instance.applicableGlossaryTypes);
            b.applicableDomainTypes(instance.applicableDomainTypes == null ? Collections.emptySet() : instance.applicableDomainTypes);
            b.applicableOtherAssetTypes(instance.applicableOtherAssetTypes == null ? Collections.emptySet() : instance.applicableOtherAssetTypes);
            b.allowSearch(instance.allowSearch);
            b.maxStrLength(instance.maxStrLength);
            b.allowFiltering(instance.allowFiltering);
            b.multiValueSelect(instance.multiValueSelect);
            b.showInOverview(instance.showInOverview);
            b.isDeprecated(instance.isDeprecated);
            b.primitiveType(instance.primitiveType);
            b.isEnum(instance.isEnum);
            b.enumType(instance.enumType);
            b.customType(instance.customType);
            b.hasTimePrecision(instance.hasTimePrecision);
            b.isArchived(instance.isArchived);
            b.archivedAt(instance.archivedAt);
            b.archivedBy(instance.archivedBy);
            b.isSoftReference(instance.isSoftReference);
            b.isAppendOnPartialUpdate(instance.isAppendOnPartialUpdate);
        }

        @Generated
        public B customMetadataVersion(String customMetadataVersion) {
            this.customMetadataVersion$value = customMetadataVersion;
            this.customMetadataVersion$set = true;
            return (B)this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        @JsonDeserialize(using=StringToSetDeserializer.class)
        @Generated
        public B applicableEntityTypes(Set<String> applicableEntityTypes) {
            this.applicableEntityTypes$value = applicableEntityTypes;
            this.applicableEntityTypes$set = true;
            return (B)this.self();
        }

        @Deprecated
        @JsonDeserialize(using=StringToSetDeserializer.class)
        @Generated
        public B customApplicableEntityTypes(Set<String> customApplicableEntityTypes) {
            this.customApplicableEntityTypes = customApplicableEntityTypes;
            return (B)this.self();
        }

        @Generated
        public B applicableConnection(String applicableConnection) {
            if (this.applicableConnections == null) {
                this.applicableConnections = new ArrayList();
            }
            this.applicableConnections.add(applicableConnection);
            return (B)this.self();
        }

        @JsonDeserialize(using=StringToSetDeserializer.class)
        @Generated
        public B applicableConnections(Collection<? extends String> applicableConnections) {
            if (applicableConnections == null) {
                throw new NullPointerException("applicableConnections cannot be null");
            }
            if (this.applicableConnections == null) {
                this.applicableConnections = new ArrayList();
            }
            this.applicableConnections.addAll(applicableConnections);
            return (B)this.self();
        }

        @Generated
        public B clearApplicableConnections() {
            if (this.applicableConnections != null) {
                this.applicableConnections.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B applicableGlossary(String applicableGlossary) {
            if (this.applicableGlossaries == null) {
                this.applicableGlossaries = new ArrayList();
            }
            this.applicableGlossaries.add(applicableGlossary);
            return (B)this.self();
        }

        @JsonDeserialize(using=StringToSetDeserializer.class)
        @Generated
        public B applicableGlossaries(Collection<? extends String> applicableGlossaries) {
            if (applicableGlossaries == null) {
                throw new NullPointerException("applicableGlossaries cannot be null");
            }
            if (this.applicableGlossaries == null) {
                this.applicableGlossaries = new ArrayList();
            }
            this.applicableGlossaries.addAll(applicableGlossaries);
            return (B)this.self();
        }

        @Generated
        public B clearApplicableGlossaries() {
            if (this.applicableGlossaries != null) {
                this.applicableGlossaries.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B applicableDomain(String applicableDomain) {
            if (this.applicableDomains == null) {
                this.applicableDomains = new ArrayList();
            }
            this.applicableDomains.add(applicableDomain);
            return (B)this.self();
        }

        @JsonDeserialize(using=StringToSetDeserializer.class)
        @Generated
        public B applicableDomains(Collection<? extends String> applicableDomains) {
            if (applicableDomains == null) {
                throw new NullPointerException("applicableDomains cannot be null");
            }
            if (this.applicableDomains == null) {
                this.applicableDomains = new ArrayList();
            }
            this.applicableDomains.addAll(applicableDomains);
            return (B)this.self();
        }

        @Generated
        public B clearApplicableDomains() {
            if (this.applicableDomains != null) {
                this.applicableDomains.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B applicableAssetType(String applicableAssetType) {
            if (this.applicableAssetTypes == null) {
                this.applicableAssetTypes = new ArrayList();
            }
            this.applicableAssetTypes.add(applicableAssetType);
            return (B)this.self();
        }

        @JsonDeserialize(using=StringToSetDeserializer.class)
        @JsonProperty(value="assetTypesList")
        @Generated
        public B applicableAssetTypes(Collection<? extends String> applicableAssetTypes) {
            if (applicableAssetTypes == null) {
                throw new NullPointerException("applicableAssetTypes cannot be null");
            }
            if (this.applicableAssetTypes == null) {
                this.applicableAssetTypes = new ArrayList();
            }
            this.applicableAssetTypes.addAll(applicableAssetTypes);
            return (B)this.self();
        }

        @Generated
        public B clearApplicableAssetTypes() {
            if (this.applicableAssetTypes != null) {
                this.applicableAssetTypes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B applicableGlossaryType(String applicableGlossaryType) {
            if (this.applicableGlossaryTypes == null) {
                this.applicableGlossaryTypes = new ArrayList();
            }
            this.applicableGlossaryTypes.add(applicableGlossaryType);
            return (B)this.self();
        }

        @JsonDeserialize(using=StringToSetDeserializer.class)
        @JsonProperty(value="glossaryTypeList")
        @Generated
        public B applicableGlossaryTypes(Collection<? extends String> applicableGlossaryTypes) {
            if (applicableGlossaryTypes == null) {
                throw new NullPointerException("applicableGlossaryTypes cannot be null");
            }
            if (this.applicableGlossaryTypes == null) {
                this.applicableGlossaryTypes = new ArrayList();
            }
            this.applicableGlossaryTypes.addAll(applicableGlossaryTypes);
            return (B)this.self();
        }

        @Generated
        public B clearApplicableGlossaryTypes() {
            if (this.applicableGlossaryTypes != null) {
                this.applicableGlossaryTypes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B applicableDomainType(String applicableDomainType) {
            if (this.applicableDomainTypes == null) {
                this.applicableDomainTypes = new ArrayList();
            }
            this.applicableDomainTypes.add(applicableDomainType);
            return (B)this.self();
        }

        @JsonDeserialize(using=StringToSetDeserializer.class)
        @JsonProperty(value="domainTypesList")
        @Generated
        public B applicableDomainTypes(Collection<? extends String> applicableDomainTypes) {
            if (applicableDomainTypes == null) {
                throw new NullPointerException("applicableDomainTypes cannot be null");
            }
            if (this.applicableDomainTypes == null) {
                this.applicableDomainTypes = new ArrayList();
            }
            this.applicableDomainTypes.addAll(applicableDomainTypes);
            return (B)this.self();
        }

        @Generated
        public B clearApplicableDomainTypes() {
            if (this.applicableDomainTypes != null) {
                this.applicableDomainTypes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B applicableOtherAssetType(String applicableOtherAssetType) {
            if (this.applicableOtherAssetTypes == null) {
                this.applicableOtherAssetTypes = new ArrayList();
            }
            this.applicableOtherAssetTypes.add(applicableOtherAssetType);
            return (B)this.self();
        }

        @JsonDeserialize(using=StringToSetDeserializer.class)
        @JsonProperty(value="otherAssetTypeList")
        @Generated
        public B applicableOtherAssetTypes(Collection<? extends String> applicableOtherAssetTypes) {
            if (applicableOtherAssetTypes == null) {
                throw new NullPointerException("applicableOtherAssetTypes cannot be null");
            }
            if (this.applicableOtherAssetTypes == null) {
                this.applicableOtherAssetTypes = new ArrayList();
            }
            this.applicableOtherAssetTypes.addAll(applicableOtherAssetTypes);
            return (B)this.self();
        }

        @Generated
        public B clearApplicableOtherAssetTypes() {
            if (this.applicableOtherAssetTypes != null) {
                this.applicableOtherAssetTypes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B allowSearch(Boolean allowSearch) {
            this.allowSearch$value = allowSearch;
            this.allowSearch$set = true;
            return (B)this.self();
        }

        @Generated
        public B maxStrLength(String maxStrLength) {
            this.maxStrLength$value = maxStrLength;
            this.maxStrLength$set = true;
            return (B)this.self();
        }

        @Generated
        public B allowFiltering(Boolean allowFiltering) {
            this.allowFiltering$value = allowFiltering;
            this.allowFiltering$set = true;
            return (B)this.self();
        }

        @Generated
        public B multiValueSelect(Boolean multiValueSelect) {
            this.multiValueSelect$value = multiValueSelect;
            this.multiValueSelect$set = true;
            return (B)this.self();
        }

        @Generated
        public B showInOverview(Boolean showInOverview) {
            this.showInOverview$value = showInOverview;
            this.showInOverview$set = true;
            return (B)this.self();
        }

        @Generated
        public B isDeprecated(String isDeprecated) {
            this.isDeprecated = isDeprecated;
            return (B)this.self();
        }

        @Generated
        public B primitiveType(AtlanCustomAttributePrimitiveType primitiveType) {
            this.primitiveType = primitiveType;
            return (B)this.self();
        }

        @Generated
        public B isEnum(Boolean isEnum) {
            this.isEnum$value = isEnum;
            this.isEnum$set = true;
            return (B)this.self();
        }

        @Generated
        public B enumType(String enumType) {
            this.enumType = enumType;
            return (B)this.self();
        }

        @Generated
        public B customType(String customType) {
            this.customType = customType;
            return (B)this.self();
        }

        @Generated
        public B hasTimePrecision(Boolean hasTimePrecision) {
            this.hasTimePrecision = hasTimePrecision;
            return (B)this.self();
        }

        @Generated
        public B isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return (B)this.self();
        }

        @Generated
        public B archivedAt(Long archivedAt) {
            this.archivedAt = archivedAt;
            return (B)this.self();
        }

        @Generated
        public B archivedBy(String archivedBy) {
            this.archivedBy = archivedBy;
            return (B)this.self();
        }

        @Generated
        public B isSoftReference(String isSoftReference) {
            this.isSoftReference = isSoftReference;
            return (B)this.self();
        }

        @Generated
        public B isAppendOnPartialUpdate(String isAppendOnPartialUpdate) {
            this.isAppendOnPartialUpdate = isAppendOnPartialUpdate;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AttributeDefOptions.AttributeDefOptionsBuilder(super=" + super.toString() + ", customMetadataVersion$value=" + this.customMetadataVersion$value + ", description=" + this.description + ", applicableEntityTypes$value=" + this.applicableEntityTypes$value + ", customApplicableEntityTypes=" + this.customApplicableEntityTypes + ", applicableConnections=" + this.applicableConnections + ", applicableGlossaries=" + this.applicableGlossaries + ", applicableDomains=" + this.applicableDomains + ", applicableAssetTypes=" + this.applicableAssetTypes + ", applicableGlossaryTypes=" + this.applicableGlossaryTypes + ", applicableDomainTypes=" + this.applicableDomainTypes + ", applicableOtherAssetTypes=" + this.applicableOtherAssetTypes + ", allowSearch$value=" + this.allowSearch$value + ", maxStrLength$value=" + this.maxStrLength$value + ", allowFiltering$value=" + this.allowFiltering$value + ", multiValueSelect$value=" + this.multiValueSelect$value + ", showInOverview$value=" + this.showInOverview$value + ", isDeprecated=" + this.isDeprecated + ", primitiveType=" + this.primitiveType + ", isEnum$value=" + this.isEnum$value + ", enumType=" + this.enumType + ", customType=" + this.customType + ", hasTimePrecision=" + this.hasTimePrecision + ", isArchived=" + this.isArchived + ", archivedAt=" + this.archivedAt + ", archivedBy=" + this.archivedBy + ", isSoftReference=" + this.isSoftReference + ", isAppendOnPartialUpdate=" + this.isAppendOnPartialUpdate + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class AttributeDefOptionsBuilderImpl
    extends AttributeDefOptionsBuilder<AttributeDefOptions, AttributeDefOptionsBuilderImpl> {
        @Generated
        private AttributeDefOptionsBuilderImpl() {
        }

        @Override
        @Generated
        protected AttributeDefOptionsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AttributeDefOptions build() {
            return new AttributeDefOptions(this);
        }
    }
}

