/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.typedefs;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.TypeDef;
import com.atlan.model.typedefs.TypeDefResponse;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonDeserialize(builder=EnumDefBuilderImpl.class)
public class EnumDef
extends TypeDef {
    private static final long serialVersionUID = 2L;
    AtlanTypeCategory category;
    List<ElementDef> elementDefs;

    @JsonIgnore
    public List<String> getValidValues() {
        if (this.elementDefs != null && !this.elementDefs.isEmpty()) {
            return this.elementDefs.stream().map(ElementDef::getValue).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static EnumDefBuilder<?, ?> creator(String displayName, List<String> values) {
        return ((EnumDefBuilder)EnumDef.builder().name(displayName)).elementDefs(ElementDef.from(values));
    }

    public static EnumDefBuilder<?, ?> updater(String displayName, List<String> values, boolean replaceExisting) throws AtlanException {
        return EnumDef.updater(Atlan.getDefaultClient(), displayName, values, replaceExisting);
    }

    public static EnumDefBuilder<?, ?> updater(AtlanClient client, String displayName, List<String> values, boolean replaceExisting) throws AtlanException {
        List<String> combined;
        if (replaceExisting) {
            combined = values;
        } else {
            combined = new ArrayList<String>();
            List<String> existing = client.getEnumCache().getByName(displayName).getValidValues();
            for (String one : existing) {
                if (values.contains(one)) continue;
                combined.add(one);
            }
            combined.addAll(values);
        }
        return ((EnumDefBuilder)EnumDef.builder().name(displayName)).elementDefs(ElementDef.from(combined));
    }

    public synchronized EnumDef create() throws AtlanException {
        return this.create(Atlan.getDefaultClient());
    }

    public synchronized EnumDef create(AtlanClient client) throws AtlanException {
        TypeDefResponse response = client.typeDefs.create(this);
        if (response != null && !response.getEnumDefs().isEmpty()) {
            return response.getEnumDefs().get(0);
        }
        return null;
    }

    public synchronized EnumDef update() throws AtlanException {
        return this.update(Atlan.getDefaultClient());
    }

    public synchronized EnumDef update(AtlanClient client) throws AtlanException {
        TypeDefResponse response = client.typeDefs.update(this);
        if (response != null && !response.getEnumDefs().isEmpty()) {
            return response.getEnumDefs().get(0);
        }
        return null;
    }

    public static synchronized void purge(String displayName) throws AtlanException {
        EnumDef.purge(Atlan.getDefaultClient(), displayName);
    }

    public static synchronized void purge(AtlanClient client, String displayName) throws AtlanException {
        client.typeDefs.purge(displayName);
    }

    @Generated
    private static AtlanTypeCategory $default$category() {
        return AtlanTypeCategory.ENUM;
    }

    @Generated
    protected EnumDef(EnumDefBuilder<?, ?> b) {
        super((TypeDef.TypeDefBuilder<?, ?>)b);
        this.category = b.category$set ? b.category$value : EnumDef.$default$category();
        this.elementDefs = switch (b.elementDefs == null ? 0 : b.elementDefs.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.elementDefs.get(0));
            default -> Collections.unmodifiableList(new ArrayList<ElementDef>(b.elementDefs));
        };
    }

    @Generated
    public static EnumDefBuilder<?, ?> builder() {
        return new EnumDefBuilderImpl();
    }

    @Generated
    public EnumDefBuilder<?, ?> toBuilder() {
        return new EnumDefBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public List<ElementDef> getElementDefs() {
        return this.elementDefs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnumDef)) {
            return false;
        }
        EnumDef other = (EnumDef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlanTypeCategory this$category = this.getCategory();
        AtlanTypeCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        List<ElementDef> this$elementDefs = this.getElementDefs();
        List<ElementDef> other$elementDefs = other.getElementDefs();
        return !(this$elementDefs == null ? other$elementDefs != null : !((Object)this$elementDefs).equals(other$elementDefs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EnumDef;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AtlanTypeCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        List<ElementDef> $elementDefs = this.getElementDefs();
        result = result * 59 + ($elementDefs == null ? 43 : ((Object)$elementDefs).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "EnumDef(super=" + super.toString() + ", category=" + this.getCategory() + ", elementDefs=" + this.getElementDefs() + ")";
    }

    @Override
    @Generated
    public AtlanTypeCategory getCategory() {
        return this.category;
    }

    @Generated
    public static abstract class EnumDefBuilder<C extends EnumDef, B extends EnumDefBuilder<C, B>>
    extends TypeDef.TypeDefBuilder<C, B> {
        @Generated
        private boolean category$set;
        @Generated
        private AtlanTypeCategory category$value;
        @Generated
        private ArrayList<ElementDef> elementDefs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EnumDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(EnumDef instance, EnumDefBuilder<?, ?> b) {
            b.category(instance.category);
            b.elementDefs(instance.elementDefs == null ? Collections.emptyList() : instance.elementDefs);
        }

        @Override
        @Generated
        public B category(AtlanTypeCategory category) {
            this.category$value = category;
            this.category$set = true;
            return (B)this.self();
        }

        @Generated
        public B elementDef(ElementDef elementDef) {
            if (this.elementDefs == null) {
                this.elementDefs = new ArrayList();
            }
            this.elementDefs.add(elementDef);
            return (B)this.self();
        }

        @Generated
        public B elementDefs(Collection<? extends ElementDef> elementDefs) {
            if (elementDefs == null) {
                throw new NullPointerException("elementDefs cannot be null");
            }
            if (this.elementDefs == null) {
                this.elementDefs = new ArrayList();
            }
            this.elementDefs.addAll(elementDefs);
            return (B)this.self();
        }

        @Generated
        public B clearElementDefs() {
            if (this.elementDefs != null) {
                this.elementDefs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "EnumDef.EnumDefBuilder(super=" + super.toString() + ", category$value=" + this.category$value + ", elementDefs=" + this.elementDefs + ")";
        }
    }

    @JsonDeserialize(builder=ElementDefBuilderImpl.class)
    public static class ElementDef
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        String value;
        String description;
        Integer ordinal;

        public static ElementDef of(int ordinal, String value) {
            return ((ElementDefBuilder)((ElementDefBuilder)ElementDef.builder().ordinal(ordinal)).value(value)).build();
        }

        protected static List<ElementDef> from(List<String> values) {
            if (values != null && !values.isEmpty()) {
                ArrayList<ElementDef> elements = new ArrayList<ElementDef>();
                for (int i = 0; i < values.size(); ++i) {
                    elements.add(ElementDef.of(i, values.get(i)));
                }
                return Collections.unmodifiableList(elements);
            }
            return Collections.emptyList();
        }

        @Generated
        protected ElementDef(ElementDefBuilder<?, ?> b) {
            super(b);
            this.value = b.value;
            this.description = b.description;
            this.ordinal = b.ordinal;
        }

        @Generated
        public static ElementDefBuilder<?, ?> builder() {
            return new ElementDefBuilderImpl();
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Integer getOrdinal() {
            return this.ordinal;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElementDef)) {
                return false;
            }
            ElementDef other = (ElementDef)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$ordinal = this.getOrdinal();
            Integer other$ordinal = other.getOrdinal();
            if (this$ordinal == null ? other$ordinal != null : !((Object)this$ordinal).equals(other$ordinal)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ElementDef;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $ordinal = this.getOrdinal();
            result = result * 59 + ($ordinal == null ? 43 : ((Object)$ordinal).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "EnumDef.ElementDef(super=" + super.toString() + ", value=" + this.getValue() + ", description=" + this.getDescription() + ", ordinal=" + this.getOrdinal() + ")";
        }

        @Generated
        public static abstract class ElementDefBuilder<C extends ElementDef, B extends ElementDefBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String value;
            @Generated
            private String description;
            @Generated
            private Integer ordinal;

            @Generated
            public B value(String value) {
                this.value = value;
                return (B)this.self();
            }

            @Generated
            public B description(String description) {
                this.description = description;
                return (B)this.self();
            }

            @Generated
            public B ordinal(Integer ordinal) {
                this.ordinal = ordinal;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "EnumDef.ElementDef.ElementDefBuilder(super=" + super.toString() + ", value=" + this.value + ", description=" + this.description + ", ordinal=" + this.ordinal + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class ElementDefBuilderImpl
        extends ElementDefBuilder<ElementDef, ElementDefBuilderImpl> {
            @Generated
            private ElementDefBuilderImpl() {
            }

            @Override
            @Generated
            protected ElementDefBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public ElementDef build() {
                return new ElementDef(this);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class EnumDefBuilderImpl
    extends EnumDefBuilder<EnumDef, EnumDefBuilderImpl> {
        @Generated
        private EnumDefBuilderImpl() {
        }

        @Override
        @Generated
        protected EnumDefBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EnumDef build() {
            return new EnumDef(this);
        }
    }
}

