/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.model.search.AggregationBucketResult;
import com.atlan.model.search.AggregationHitsResult;
import com.atlan.model.search.AggregationMetricResult;
import com.atlan.model.search.AggregationResult;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;

public class AggregationResultDeserializer
extends StdDeserializer<AggregationResult> {
    private static final long serialVersionUID = 2L;

    public AggregationResultDeserializer(Class<?> t) {
        super(t);
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public AggregationResult deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode root = (JsonNode)parser.getCodec().readTree(parser);
        JsonNode value = root.get("value");
        JsonNode buckets = root.get("buckets");
        JsonNode hits = root.get("hits");
        if (root.has("value") && (value == null || value.isNull()) || root.has("buckets") && (buckets == null || buckets.isNull()) || root.has("hits") && (hits == null || hits.isNull())) {
            return null;
        }
        try (JsonParser next = root.traverse(parser.getCodec());){
            AggregationResult result;
            next.nextToken();
            if (value != null && value.isNumber()) {
                result = (AggregationResult)context.readValue(next, AggregationMetricResult.class);
            } else if (buckets != null) {
                result = (AggregationResult)context.readValue(next, AggregationBucketResult.class);
            } else if (hits != null) {
                result = (AggregationResult)context.readValue(next, AggregationHitsResult.class);
            } else {
                throw new IOException("Aggregation currently not handled: " + root);
            }
            result.setRawJsonObject(root);
            AggregationResult aggregationResult = result;
            return aggregationResult;
        }
    }
}

