/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.CustomMetadataAttributes;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMetadataMapDeserializer
extends StdDeserializer<Map<String, CustomMetadataAttributes>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomMetadataMapDeserializer.class);
    private static final long serialVersionUID = 2L;
    private final AtlanClient client;

    public CustomMetadataMapDeserializer(AtlanClient client) {
        super(CustomMetadataMapDeserializer.class);
        this.client = client;
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public Map<String, CustomMetadataAttributes> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return this.deserialize((JsonNode)parser.getCodec().readTree(parser));
    }

    Map<String, CustomMetadataAttributes> deserialize(JsonNode root) throws IOException {
        HashMap<String, CustomMetadataAttributes> map = new HashMap<String, CustomMetadataAttributes>();
        Iterator it = root.fieldNames();
        while (it.hasNext()) {
            String cmId = (String)it.next();
            try {
                String cmName = this.client.getCustomMetadataCache().getNameForId(cmId);
                CustomMetadataAttributes cma = this.client.getCustomMetadataCache().getCustomMetadataAttributes(cmId, root.get(cmId));
                map.put(cmName, cma);
            }
            catch (AtlanException e) {
                log.error("Unable to find custom metadata with ID-string {}, or to translate one of the provided attributes within it.", (Object)cmId, (Object)e);
            }
        }
        return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }
}

