/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import com.atlan.AtlanClient;
import com.atlan.cache.ReflectionCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.relations.RelationshipAttributes;
import com.atlan.model.search.AggregationResult;
import com.atlan.model.structs.AtlanStruct;
import com.atlan.serde.AggregationResultDeserializer;
import com.atlan.serde.ClientAwareDeserializationContext;
import com.atlan.serde.ClientAwareSerializerProvider;
import com.atlan.serde.ElasticAggregationDeserializer;
import com.atlan.serde.ElasticObjectSerializer;
import com.atlan.serde.ElasticQueryDeserializer;
import com.atlan.serde.ElasticSortOptionsDeserializer;
import com.atlan.serde.Removable;
import com.atlan.serde.StructDeserializer;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Serde {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Serde.class);
    public static final String DELETED_AUDIT_OBJECT = "(DELETED)";
    private static final Set<Module> SIMPLE_MODULES = Serde.createModules();
    public static final ObjectMapper allInclusiveMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.ALWAYS);
    static final JsonpMapper jsonpMapper = new JacksonJsonpMapper();
    public static final ObjectMapper yamlMapper = Serde.createMapperYAML();
    private static final Map<String, JsonDeserializer<?>> deserializerCache = new ConcurrentHashMap();
    private static final Map<String, Class<?>> assetClasses;
    private static final Map<String, Class<?>> builderClasses;
    private static final Map<String, Class<?>> relationshipAttributeClasses;

    public static Class<?> getAssetClassForType(String typeName) throws ClassNotFoundException {
        Class result = assetClasses.getOrDefault(typeName, null);
        if (result != null) {
            return result;
        }
        throw new ClassNotFoundException("Unable to find asset class for typeName: " + typeName);
    }

    public static Class<?> getRelationshipAttributesClassForType(String typeName) throws ClassNotFoundException {
        Class result = relationshipAttributeClasses.getOrDefault(typeName, null);
        if (result != null) {
            return result;
        }
        throw new ClassNotFoundException("Unable to find relationship attributes class for typeName: " + typeName);
    }

    public static Class<?> getBuilderClassForType(String typeName) throws ClassNotFoundException {
        Class result = builderClasses.getOrDefault(typeName, null);
        if (result != null) {
            return result;
        }
        throw new ClassNotFoundException("Unable to find builder class for typeName: " + typeName);
    }

    private static Set<Module> createModules() {
        LinkedHashSet<Module> set = new LinkedHashSet<Module>();
        SimpleModule elastic = new SimpleModule().addSerializer(Aggregation.class, new ElasticObjectSerializer()).addDeserializer(Aggregation.class, (JsonDeserializer)new ElasticAggregationDeserializer()).addSerializer(Query.class, new ElasticObjectSerializer()).addDeserializer(Query.class, (JsonDeserializer)new ElasticQueryDeserializer()).addSerializer(SortOptions.class, new ElasticObjectSerializer()).addDeserializer(SortOptions.class, (JsonDeserializer)new ElasticSortOptionsDeserializer());
        set.add((Module)elastic);
        SimpleModule structs = new SimpleModule().setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                Class<?> enclosing = beanDesc.getBeanClass().getEnclosingClass();
                if (enclosing != null && enclosing.getSuperclass() == AtlanStruct.class) {
                    if (!deserializerCache.containsKey(beanDesc.getBeanClass().getCanonicalName())) {
                        deserializerCache.put(beanDesc.getBeanClass().getCanonicalName(), (JsonDeserializer<?>)new StructDeserializer(deserializer));
                    }
                    return deserializerCache.get(beanDesc.getBeanClass().getCanonicalName());
                }
                return deserializer;
            }
        });
        set.add((Module)structs);
        SimpleModule aggResults = new SimpleModule().addDeserializer(AggregationResult.class, (JsonDeserializer)new AggregationResultDeserializer(null));
        set.add((Module)aggResults);
        return set;
    }

    public static ObjectMapper createMapper(AtlanClient client) {
        ObjectMapper om = new ObjectMapper(null, null, (DefaultDeserializationContext)new ClientAwareDeserializationContext((DeserializerFactory)BeanDeserializerFactory.instance, null, client)).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        for (Module m : SIMPLE_MODULES) {
            om.registerModule(m);
        }
        ClientAwareSerializerProvider casp = new ClientAwareSerializerProvider(client);
        om.setSerializerProvider((DefaultSerializerProvider)casp);
        return om;
    }

    public static ObjectMapper createMapperYAML() {
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID)).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        for (Module m : SIMPLE_MODULES) {
            om.registerModule(m);
        }
        return om;
    }

    static Object deserialize(AtlanClient client, JsonNode jsonNode, Method method, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (jsonNode.isValueNode()) {
            return Serde.deserializePrimitive(client, jsonNode, method, fieldName);
        }
        if (jsonNode.isArray()) {
            return Serde.deserializeList(client, (ArrayNode)jsonNode, method, fieldName);
        }
        if (jsonNode.isObject()) {
            return Serde.deserializeObject(client, jsonNode, method);
        }
        return null;
    }

    static Collection<?> deserializeList(AtlanClient client, ArrayNode array, Method method, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        Class<?> paramClass = ReflectionCache.getParameterOfMethod(method);
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonNode element : array) {
            Object deserialized = Serde.deserializeElement(client, element, method, fieldName);
            list.add(deserialized);
        }
        if (paramClass == Collection.class || paramClass == List.class) {
            return list;
        }
        if (paramClass == Set.class || paramClass == SortedSet.class) {
            return new TreeSet(list);
        }
        throw new IOException("Unable to deserialize JSON list to Java class: " + paramClass.getCanonicalName());
    }

    static Object deserializeObject(AtlanClient client, JsonNode jsonObject, Method method) {
        Class<?> paramClass = ReflectionCache.getParameterOfMethod(method);
        if (paramClass == Map.class && ReflectionCache.getParameterizedTypeOfMethod(method).getTypeName().equals("java.util.Map<? extends java.lang.String, ? extends java.lang.Long>")) {
            return client.convertValue(jsonObject, new TypeReference<Map<String, Long>>(){});
        }
        return client.convertValue(jsonObject, paramClass);
    }

    static Object deserializeElement(AtlanClient client, JsonNode element, Method method, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        Type paramType = ReflectionCache.getParameterizedTypeOfMethod(method);
        Class<?> innerClass = ReflectionCache.getClassOfParameterizedType(paramType);
        if (element.isValueNode()) {
            if (fieldName.equals("purposeAtlanTags")) {
                String value;
                try {
                    value = client.getAtlanTagCache().getNameForId(element.asText());
                }
                catch (NotFoundException e) {
                    value = DELETED_AUDIT_OBJECT;
                }
                catch (AtlanException e) {
                    throw new IOException("Unable to deserialize purposeAtlanTags.", e);
                }
                return value;
            }
            return JacksonUtils.deserializePrimitive(element, method, innerClass);
        }
        if (element.isArray()) {
            throw new IOException("Directly-nested arrays are not supported.");
        }
        if (element.isObject()) {
            return client.convertValue(element, innerClass);
        }
        return null;
    }

    static Object deserializePrimitive(AtlanClient client, JsonNode primitive, Method method, String fieldName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (primitive.isNull()) {
            return Removable.NULL;
        }
        Object value = JacksonUtils.deserializePrimitive(primitive, method);
        if (fieldName.equals("mappedAtlanTagName")) {
            try {
                value = client.getAtlanTagCache().getNameForId(primitive.asText());
            }
            catch (NotFoundException e) {
                value = DELETED_AUDIT_OBJECT;
            }
            catch (AtlanException e) {
                throw new IOException("Unable to deserialize mappedAtlanTagName.", e);
            }
        }
        return value;
    }

    static {
        HashMap assetMap = new HashMap();
        HashMap<String, Class> builderMap = new HashMap<String, Class>();
        HashMap relationshipAttributesMap = new HashMap();
        try (ScanResult scanResult = new ClassGraph().enableExternalClasses().ignoreClassVisibility().setMaxBufferedJarRAMSize(0x1000000).scan();){
            String typeName;
            Class<?> typeClass;
            Class builderClass;
            String fullName;
            for (ClassInfo info : scanResult.getSubclasses(Asset.AssetBuilder.class)) {
                fullName = info.getName();
                if (!fullName.endsWith("Impl")) continue;
                try {
                    builderClass = info.loadClass();
                    typeClass = builderClass.getEnclosingClass();
                    typeName = (String)typeClass.getDeclaredField("TYPE_NAME").get(null);
                    assetMap.put(typeName, typeClass);
                    builderMap.put(typeName, builderClass);
                }
                catch (NoSuchFieldException e) {
                    log.debug("Asset class is missing the static TYPE_NAME giving its type (this is fine if this is a relationship): {}", (Object)fullName);
                }
                catch (IllegalAccessException e) {
                    log.error("Unable to access the static TYPE_NAME for the asset class: {}", (Object)fullName, (Object)e);
                }
            }
            for (ClassInfo info : scanResult.getSubclasses(RelationshipAttributes.RelationshipAttributesBuilder.class)) {
                fullName = info.getName();
                if (!fullName.endsWith("Impl")) continue;
                try {
                    builderClass = info.loadClass();
                    typeClass = builderClass.getEnclosingClass();
                    typeName = (String)typeClass.getField("TYPE_NAME").get(null);
                    relationshipAttributesMap.put(typeName, typeClass);
                    builderMap.put(typeName, builderClass);
                }
                catch (NoSuchFieldException e) {
                    log.error("Relationship attributes class is missing the static TYPE_NAME giving its type: {}", (Object)fullName, (Object)e);
                }
                catch (IllegalAccessException e) {
                    log.error("Unable to access the static TYPE_NAME for the relationship attributes class: {}", (Object)fullName, (Object)e);
                }
            }
        }
        assetClasses = Collections.unmodifiableMap(assetMap);
        builderClasses = Collections.unmodifiableMap(builderMap);
        relationshipAttributeClasses = Collections.unmodifiableMap(relationshipAttributesMap);
    }
}

