/*
 * Decompiled with CFR 0.152.
 */
package com.atlan;

import com.atlan.AtlanClient;
import com.atlan.exception.ErrorCode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Atlan {
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_READ_TIMEOUT = 120000;
    public static final int DEFAULT_NETWORK_RETRIES = 5;
    public static final String VERSION = "3.0.0";
    public static final Map<String, List<String>> EXTRA_HEADERS = Map.ofEntries(Map.entry("x-atlan-agent", List.of("sdk")), Map.entry("x-atlan-agent-id", List.of("java")));
    public static volatile boolean enableTelemetry = true;
    private static final Map<String, AtlanClient> clientCache = new ConcurrentHashMap<String, AtlanClient>();
    private static final String INVALID_CLIENT_MSG = ErrorCode.NO_BASE_URL.getMessageDefinition().getErrorId() + " " + ErrorCode.NO_BASE_URL.getMessageDefinition().getErrorMessage(new String[0]) + " " + ErrorCode.NO_BASE_URL.getMessageDefinition().getUserAction();
    private static AtlanClient defaultClient = null;

    public static AtlanClient getClient(String baseURL) {
        return Atlan.getClient(baseURL, null);
    }

    public static AtlanClient getClient(String baseURL, String name) {
        if (baseURL == null) {
            throw new IllegalStateException(INVALID_CLIENT_MSG);
        }
        String prepped = Atlan.prepURL(baseURL);
        String key = Atlan.getClientId(prepped, name);
        if (!clientCache.containsKey(key)) {
            clientCache.put(key, new AtlanClient(prepped));
        }
        return clientCache.get(key);
    }

    public static void removeClient(String baseURL, String name) {
        String key = Atlan.getClientId(Atlan.prepURL(baseURL), name);
        clientCache.remove(key);
    }

    private static String prepURL(String baseURL) {
        String prepped = baseURL;
        if (baseURL.endsWith("/")) {
            prepped = baseURL.substring(0, baseURL.lastIndexOf("/"));
        }
        return prepped;
    }

    private static String getClientId(String baseURL, String name) {
        Object key = baseURL;
        if (name != null && !name.isEmpty()) {
            key = baseURL + "#" + (String)key;
        }
        return key;
    }

    public static void setBaseUrl(String baseURL) {
        defaultClient = Atlan.getClient(baseURL);
    }

    public static void setApiToken(String apiToken) {
        if (defaultClient == null) {
            throw new IllegalStateException(INVALID_CLIENT_MSG);
        }
        defaultClient.setApiToken(apiToken);
    }

    public static AtlanClient getDefaultClient() {
        if (defaultClient == null) {
            throw new IllegalStateException(INVALID_CLIENT_MSG);
        }
        return defaultClient;
    }

    public static String getBaseUrl() {
        return Atlan.getDefaultClient().getBaseUrl();
    }

    public static Map<String, String> getAppInfo() {
        return Atlan.getDefaultClient().getAppInfo();
    }

    public static int getMaxNetworkRetries() {
        return Atlan.getDefaultClient().getMaxNetworkRetries();
    }

    public static void setMaxNetworkRetries(int numRetries) {
        Atlan.getDefaultClient().setMaxNetworkRetries(numRetries);
    }
}

