/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.HeraclesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.ApiToken;
import com.atlan.model.admin.ApiTokenResponse;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;

public class ApiTokensEndpoint
extends HeraclesEndpoint {
    private static final String endpoint = "/apikeys";

    public ApiTokensEndpoint(AtlanClient client) {
        super(client);
    }

    public ApiTokenResponse list() throws AtlanException {
        return this.list(null);
    }

    public ApiTokenResponse list(RequestOptions options) throws AtlanException {
        return this.list(null, "-createdAt", 0, 20, options);
    }

    public ApiTokenResponse list(String filter, String sort, int offset, int limit) throws AtlanException {
        return this.list(filter, sort, offset, limit, null);
    }

    public ApiTokenResponse list(String filter, String sort, int offset, int limit, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s?limit=%s&offset=%s", this.getBaseUrl(), endpoint, limit, offset);
        if (sort != null) {
            url = String.format("%s&sort=%s", url, sort);
        }
        if (filter != null) {
            url = String.format("%s&filter=%s", url, filter);
        }
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", ApiTokenResponse.class, options);
    }

    public ApiToken get(String displayName) throws AtlanException {
        ApiTokenResponse response = this.list("{\"displayName\":\"" + displayName + "\"}", "-createdAt", 0, 2);
        if (response != null && response.getRecords() != null && !response.getRecords().isEmpty()) {
            return response.getRecords().get(0);
        }
        return null;
    }

    public ApiToken getById(String clientId) throws AtlanException {
        ApiTokenResponse response;
        if (clientId != null && clientId.startsWith("service-account-")) {
            clientId = clientId.substring("service-account-".length());
        }
        if ((response = this.list("{\"clientId\":\"" + clientId + "\"}", "-createdAt", 0, 2)) != null && response.getRecords() != null && !response.getRecords().isEmpty()) {
            return response.getRecords().get(0);
        }
        return null;
    }

    public ApiToken getByGuid(String guid) throws AtlanException {
        ApiTokenResponse response = this.list("{\"id\":\"" + guid + "\"}", "-createdAt", 0, 2);
        if (response != null && response.getRecords() != null && !response.getRecords().isEmpty()) {
            return response.getRecords().get(0);
        }
        return null;
    }

    public ApiToken create(String displayName, String description, Set<String> personas, Long validitySeconds) throws AtlanException {
        return this.create(displayName, description, personas, validitySeconds, null);
    }

    public ApiToken create(String displayName, String description, Set<String> personas, Long validitySeconds, RequestOptions options) throws AtlanException {
        WrappedApiToken response;
        String url = String.format("%s%s", this.getBaseUrl(), endpoint);
        ApiTokenRequest atr = new ApiTokenRequest(displayName, description, personas, validitySeconds);
        if (options == null) {
            options = RequestOptions.from(this.client).readTimeout(this.client.getReadTimeout() * 3).build();
        }
        if ((response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, atr, WrappedApiToken.class, options)) != null) {
            ApiToken token = response.getToken();
            token.setRawJsonObject(response.getRawJsonObject());
            return token;
        }
        return null;
    }

    public ApiToken update(String guid, String displayName, String description, Set<String> personas) throws AtlanException {
        return this.update(guid, displayName, description, personas, null);
    }

    public ApiToken update(String guid, String displayName, String description, Set<String> personas, RequestOptions options) throws AtlanException {
        ApiTokenRequest atr;
        String url = String.format("%s%s/%s", this.getBaseUrl(), endpoint, guid);
        WrappedApiToken response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, atr = new ApiTokenRequest(displayName, description, personas, null), WrappedApiToken.class, options);
        if (response != null) {
            ApiToken token = response.getToken();
            token.setRawJsonObject(response.getRawJsonObject());
            return token;
        }
        return null;
    }

    public void purge(String guid) throws AtlanException {
        this.purge(guid, null);
    }

    public void purge(String guid, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s", this.getBaseUrl(), endpoint, guid);
        ApiResource.request(this.client, ApiResource.RequestMethod.DELETE, url, "", options);
    }

    private static final class ApiTokenRequest
    extends ApiResource {
        private static final long serialVersionUID = 2L;
        String displayName;
        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        String description;
        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        @Deprecated
        final Set<String> personas = Collections.emptySet();
        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        Set<String> personaQualifiedNames;
        Long validitySeconds;

        public ApiTokenRequest(String displayName, String description, Set<String> personas, Long validitySeconds) {
            this.displayName = displayName;
            this.description = description == null ? "" : description;
            Set<Object> set = this.personaQualifiedNames = personas == null ? Collections.emptySet() : personas;
            if (validitySeconds != null) {
                this.validitySeconds = validitySeconds < 0L ? Long.valueOf(409968000L) : Long.valueOf(Math.min(validitySeconds, 409968000L));
            }
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Deprecated
        @Generated
        public Set<String> getPersonas() {
            return this.personas;
        }

        @Generated
        public Set<String> getPersonaQualifiedNames() {
            return this.personaQualifiedNames;
        }

        @Generated
        public Long getValiditySeconds() {
            return this.validitySeconds;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiTokenRequest)) {
                return false;
            }
            ApiTokenRequest other = (ApiTokenRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$validitySeconds = this.getValiditySeconds();
            Long other$validitySeconds = other.getValiditySeconds();
            if (this$validitySeconds == null ? other$validitySeconds != null : !((Object)this$validitySeconds).equals(other$validitySeconds)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Set<String> this$personas = this.getPersonas();
            Set<String> other$personas = other.getPersonas();
            if (this$personas == null ? other$personas != null : !((Object)this$personas).equals(other$personas)) {
                return false;
            }
            Set<String> this$personaQualifiedNames = this.getPersonaQualifiedNames();
            Set<String> other$personaQualifiedNames = other.getPersonaQualifiedNames();
            return !(this$personaQualifiedNames == null ? other$personaQualifiedNames != null : !((Object)this$personaQualifiedNames).equals(other$personaQualifiedNames));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApiTokenRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $validitySeconds = this.getValiditySeconds();
            result = result * 59 + ($validitySeconds == null ? 43 : ((Object)$validitySeconds).hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Set<String> $personas = this.getPersonas();
            result = result * 59 + ($personas == null ? 43 : ((Object)$personas).hashCode());
            Set<String> $personaQualifiedNames = this.getPersonaQualifiedNames();
            result = result * 59 + ($personaQualifiedNames == null ? 43 : ((Object)$personaQualifiedNames).hashCode());
            return result;
        }
    }

    @JsonSerialize(using=WrappedApiTokenSerializer.class)
    @JsonDeserialize(using=WrappedApiTokenDeserializer.class)
    private static final class WrappedApiToken
    extends ApiResource {
        private static final long serialVersionUID = 2L;
        ApiToken token;

        public WrappedApiToken(ApiToken token) {
            this.token = token;
        }

        @Generated
        public ApiToken getToken() {
            return this.token;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrappedApiToken)) {
                return false;
            }
            WrappedApiToken other = (WrappedApiToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ApiToken this$token = this.getToken();
            ApiToken other$token = other.getToken();
            return !(this$token == null ? other$token != null : !((Object)this$token).equals(other$token));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WrappedApiToken;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ApiToken $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
            return result;
        }
    }

    private static class WrappedApiTokenSerializer
    extends StdSerializer<WrappedApiToken> {
        private static final long serialVersionUID = 2L;
        private final AtlanClient client;

        public WrappedApiTokenSerializer(AtlanClient client) {
            this(WrappedApiToken.class, client);
        }

        public WrappedApiTokenSerializer(Class<WrappedApiToken> t, AtlanClient client) {
            super(t);
            this.client = client;
        }

        public void serialize(WrappedApiToken wrappedToken, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            ApiToken token = wrappedToken.getToken();
            this.client.writeValue(gen, token);
        }
    }

    private static class WrappedApiTokenDeserializer
    extends StdDeserializer<WrappedApiToken> {
        private static final long serialVersionUID = 2L;

        public WrappedApiTokenDeserializer() {
            this(WrappedApiToken.class);
        }

        public WrappedApiTokenDeserializer(Class<?> t) {
            super(t);
        }

        public WrappedApiToken deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ApiToken token = (ApiToken)parser.getCodec().readValue(parser, (TypeReference)new TypeReference<ApiToken>(){});
            return new WrappedApiToken(token);
        }
    }
}

