/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.HeraclesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanUser;
import com.atlan.model.admin.GroupRequest;
import com.atlan.model.admin.GroupResponse;
import com.atlan.model.admin.SessionResponse;
import com.atlan.model.admin.UserMinimalResponse;
import com.atlan.model.admin.UserRequest;
import com.atlan.model.admin.UserResponse;
import com.atlan.model.core.AtlanObject;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class UsersEndpoint
extends HeraclesEndpoint {
    public static final List<String> DEFAULT_PROJECTIONS = List.of("firstName", "lastName", "username", "id", "email", "emailVerified", "enabled", "roles", "defaultRoles", "groupCount", "attributes", "personas", "createdTimestamp", "lastLoginTime", "loginEvents", "isLocked", "workspaceRole");
    private static final String endpoint = "/users";

    public UsersEndpoint(AtlanClient client) {
        super(client);
    }

    public UserResponse list(UserRequest request) throws AtlanException {
        return this.list(request, null);
    }

    public UserResponse list(UserRequest request, RequestOptions options) throws AtlanException {
        ArrayList<CallSite> queryParams = new ArrayList<CallSite>();
        queryParams.add((CallSite)((Object)("maxLoginEvents=" + request.getMaxLoginEvents())));
        if (request.getFilter() != null) {
            queryParams.add((CallSite)((Object)("filter=" + ApiResource.urlEncode(request.getFilter()))));
        }
        if (request.getSort() != null) {
            queryParams.add((CallSite)((Object)("sort=" + ApiResource.urlEncode(request.getSort()))));
        }
        queryParams.add((CallSite)((Object)("count=" + request.getCount())));
        queryParams.add((CallSite)((Object)("offset=" + request.getOffset())));
        queryParams.add((CallSite)((Object)("limit=" + request.getLimit())));
        if (!request.getColumns().isEmpty()) {
            queryParams.add((CallSite)((Object)("columns=" + String.join((CharSequence)"&columns=", request.getColumns()))));
        }
        String url = String.format("%s%s?%s", this.getBaseUrl(), endpoint, String.join((CharSequence)"&", queryParams));
        UserResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", UserResponse.class, options);
        response.setClient(this.client);
        response.setRequest(request);
        return response;
    }

    public UserResponse list(String filter, String sort, boolean count, int offset, int limit) throws AtlanException {
        return this.list((UserRequest)((UserRequest.UserRequestBuilder)((UserRequest.UserRequestBuilder)((UserRequest.UserRequestBuilder)((UserRequest.UserRequestBuilder)((UserRequest.UserRequestBuilder)UserRequest.builder().filter(filter)).sort(sort)).count(count)).offset(offset)).limit(limit)).build(), null);
    }

    public UserResponse list(String filter, String sort, boolean count, int offset, int limit, RequestOptions options) throws AtlanException {
        return this.list((UserRequest)((UserRequest.UserRequestBuilder)((UserRequest.UserRequestBuilder)((UserRequest.UserRequestBuilder)((UserRequest.UserRequestBuilder)((UserRequest.UserRequestBuilder)UserRequest.builder().filter(filter)).sort(sort)).count(count)).offset(offset)).limit(limit)).build(), options);
    }

    public UserResponse list(String filter) throws AtlanException {
        return this.list((UserRequest)((UserRequest.UserRequestBuilder)UserRequest.builder().filter(filter)).build(), null);
    }

    public UserResponse list(String filter, RequestOptions options) throws AtlanException {
        return this.list((UserRequest)((UserRequest.UserRequestBuilder)((UserRequest.UserRequestBuilder)UserRequest.builder().filter(filter)).columns(DEFAULT_PROJECTIONS)).build(), options);
    }

    public List<AtlanUser> list() throws AtlanException {
        return this.list((RequestOptions)null);
    }

    public List<AtlanUser> list(RequestOptions options) throws AtlanException {
        return this.list(20, options);
    }

    public List<AtlanUser> list(int pageSize, RequestOptions options) throws AtlanException {
        ArrayList<AtlanUser> users = new ArrayList<AtlanUser>();
        UserResponse response = this.list((UserRequest)((UserRequest.UserRequestBuilder)((UserRequest.UserRequestBuilder)UserRequest.builder().limit(pageSize)).columns(DEFAULT_PROJECTIONS)).build(), options);
        if (response != null) {
            for (AtlanUser user : response) {
                users.add(user);
            }
        }
        return users;
    }

    public List<AtlanUser> getByEmail(String email) throws AtlanException {
        return this.getByEmail(email, null);
    }

    public List<AtlanUser> getByEmail(String email, RequestOptions options) throws AtlanException {
        UserResponse response = this.list("{\"email\":{\"$ilike\":\"%" + email + "%\"}}", options);
        if (response != null && response.getRecords() != null) {
            return response.getRecords();
        }
        return null;
    }

    public List<AtlanUser> getByEmails(List<String> emails) throws AtlanException {
        return this.getByEmails(emails, null);
    }

    public List<AtlanUser> getByEmails(List<String> emails, RequestOptions options) throws AtlanException {
        Object emailList = emails == null || emails.isEmpty() ? "[\"\"]" : "[" + emails.stream().map(u -> "\"" + u + "\"").collect(Collectors.joining(",")) + "]";
        UserResponse response = this.list("{\"email\":{\"$in\":" + (String)emailList + "}}", options);
        if (response != null && response.getRecords() != null) {
            return response.getRecords();
        }
        return Collections.emptyList();
    }

    public AtlanUser getByUsername(String user) throws AtlanException {
        return this.getByUsername(user, null);
    }

    public AtlanUser getByUsername(String user, RequestOptions options) throws AtlanException {
        UserResponse response = this.list("{\"username\":\"" + user + "\"}", options);
        if (response != null && response.getRecords() != null && !response.getRecords().isEmpty()) {
            return response.getRecords().get(0);
        }
        return null;
    }

    public List<AtlanUser> getByUsernames(List<String> users) throws AtlanException {
        return this.getByUsernames(users, null);
    }

    public List<AtlanUser> getByUsernames(List<String> users, RequestOptions options) throws AtlanException {
        Object userList = users == null || users.isEmpty() ? "[\"\"]" : "[" + users.stream().map(u -> "\"" + u + "\"").collect(Collectors.joining(",")) + "]";
        UserResponse response = this.list("{\"username\":{\"$in\":" + (String)userList + "}}", options);
        if (response != null && response.getRecords() != null) {
            return response.getRecords();
        }
        return Collections.emptyList();
    }

    public AtlanUser getByGuid(String guid) throws AtlanException {
        return this.getByGuid(guid, null);
    }

    public AtlanUser getByGuid(String guid, RequestOptions options) throws AtlanException {
        UserResponse response = this.list("{\"id\":\"" + guid + "\"}", options);
        if (response != null && response.getRecords() != null && !response.getRecords().isEmpty()) {
            return response.getRecords().get(0);
        }
        return null;
    }

    public void create(AtlanUser user) throws AtlanException {
        this.create(user, (RequestOptions)null);
    }

    public void create(AtlanUser user, RequestOptions options) throws AtlanException {
        this.create(List.of(user), options);
    }

    public AtlanUser create(AtlanUser user, boolean returnUser) throws AtlanException {
        return this.create(user, returnUser, null);
    }

    public AtlanUser create(AtlanUser user, boolean returnUser, RequestOptions options) throws AtlanException {
        this.create(List.of(user), options);
        if (returnUser) {
            return this.getByUsername(user.getUsername());
        }
        return null;
    }

    public void create(List<AtlanUser> users) throws AtlanException {
        this.create(users, null);
    }

    public void create(List<AtlanUser> users, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), endpoint);
        CreateUserRequest.CreateUserRequestBuilder<?, ?> cur = CreateUserRequest.builder();
        for (AtlanUser user : users) {
            String roleName = user.getWorkspaceRole();
            cur.user((CreateUser)((CreateUser.CreateUserBuilder)((CreateUser.CreateUserBuilder)((CreateUser.CreateUserBuilder)CreateUser.builder().email(user.getEmail())).roleName(roleName)).roleId(this.client.getRoleCache().getIdForName(roleName))).build());
        }
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, cur.build(), options);
    }

    public List<AtlanUser> create(List<AtlanUser> users, boolean returnUsers) throws AtlanException {
        return this.create(users, returnUsers, null);
    }

    public List<AtlanUser> create(List<AtlanUser> users, boolean returnUsers, RequestOptions options) throws AtlanException {
        this.create(users, options);
        if (returnUsers) {
            return this.getByUsernames(users.stream().map(AtlanUser::getUsername).collect(Collectors.toList()), options);
        }
        return Collections.emptyList();
    }

    public UserMinimalResponse update(String id, AtlanUser user) throws AtlanException {
        return this.update(id, user, null);
    }

    public UserMinimalResponse update(String id, AtlanUser user, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s", this.getBaseUrl(), endpoint, id);
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, user, UserMinimalResponse.class, options);
    }

    public GroupResponse listGroups(String id, GroupRequest request) throws AtlanException {
        return this.listGroups(id, request, null);
    }

    public GroupResponse listGroups(String id, GroupRequest request, RequestOptions options) throws AtlanException {
        ArrayList<CallSite> queryParams = new ArrayList<CallSite>();
        queryParams.add((CallSite)((Object)("offset=" + request.getOffset())));
        queryParams.add((CallSite)((Object)("limit=" + request.getLimit())));
        queryParams.add((CallSite)((Object)("sort=" + ApiResource.urlEncode(request.getSort()))));
        if (request.getFilter() != null) {
            queryParams.add((CallSite)((Object)("filter=" + ApiResource.urlEncode(request.getFilter()))));
        }
        String url = String.format("%s%s/%s/groups?%s", this.getBaseUrl(), endpoint, id, String.join((CharSequence)"&", queryParams));
        GroupResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", GroupResponse.class, options);
        response.setClient(this.client);
        response.setRequest(request);
        return response;
    }

    public GroupResponse listGroups(String id) throws AtlanException {
        return this.listGroups(id, (RequestOptions)null);
    }

    public GroupResponse listGroups(String id, RequestOptions options) throws AtlanException {
        return this.listGroups(id, (GroupRequest)GroupRequest.builder().build(), options);
    }

    public void addToGroups(String id, List<String> groupIds) throws AtlanException {
        this.addToGroups(id, groupIds, null);
    }

    public void addToGroups(String id, List<String> groupIds, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/groups", this.getBaseUrl(), endpoint, id);
        AtlanObject atgr = ((AddToGroupsRequest.AddToGroupsRequestBuilder)AddToGroupsRequest.builder().groups(groupIds)).build();
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, atgr, options);
    }

    public void changeRole(String id, String roleId) throws AtlanException {
        this.changeRole(id, roleId, null);
    }

    public void changeRole(String id, String roleId, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/roles/update", this.getBaseUrl(), endpoint, id);
        AtlanObject crr = ((ChangeRoleRequest.ChangeRoleRequestBuilder)ChangeRoleRequest.builder().roleId(roleId)).build();
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, crr, options);
    }

    public UserMinimalResponse getCurrentUser() throws AtlanException {
        return this.getCurrentUser(null);
    }

    public UserMinimalResponse getCurrentUser(RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/current", this.getBaseUrl(), endpoint);
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", UserMinimalResponse.class, options);
    }

    public SessionResponse listSessions(String id) throws AtlanException {
        return this.listSessions(id, null);
    }

    public SessionResponse listSessions(String id, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/sessions", this.getBaseUrl(), endpoint, id);
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", SessionResponse.class, options);
    }

    static final class CreateUserRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        List<CreateUser> users;

        @Generated
        protected CreateUserRequest(CreateUserRequestBuilder<?, ?> b) {
            super(b);
            this.users = switch (b.users == null ? 0 : b.users.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.users.get(0));
                default -> Collections.unmodifiableList(new ArrayList<CreateUser>(b.users));
            };
        }

        @Generated
        public static CreateUserRequestBuilder<?, ?> builder() {
            return new CreateUserRequestBuilderImpl();
        }

        @Generated
        public List<CreateUser> getUsers() {
            return this.users;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateUserRequest)) {
                return false;
            }
            CreateUserRequest other = (CreateUserRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<CreateUser> this$users = this.getUsers();
            List<CreateUser> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateUserRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<CreateUser> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }

        @Generated
        public static abstract class CreateUserRequestBuilder<C extends CreateUserRequest, B extends CreateUserRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private ArrayList<CreateUser> users;

            @Generated
            public B user(CreateUser user) {
                if (this.users == null) {
                    this.users = new ArrayList();
                }
                this.users.add(user);
                return (B)this.self();
            }

            @Generated
            public B users(Collection<? extends CreateUser> users) {
                if (users == null) {
                    throw new NullPointerException("users cannot be null");
                }
                if (this.users == null) {
                    this.users = new ArrayList();
                }
                this.users.addAll(users);
                return (B)this.self();
            }

            @Generated
            public B clearUsers() {
                if (this.users != null) {
                    this.users.clear();
                }
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "UsersEndpoint.CreateUserRequest.CreateUserRequestBuilder(super=" + super.toString() + ", users=" + this.users + ")";
            }
        }

        @Generated
        private static final class CreateUserRequestBuilderImpl
        extends CreateUserRequestBuilder<CreateUserRequest, CreateUserRequestBuilderImpl> {
            @Generated
            private CreateUserRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected CreateUserRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CreateUserRequest build() {
                return new CreateUserRequest(this);
            }
        }
    }

    private static final class CreateUser
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        String email;
        String roleName;
        String roleId;

        @Generated
        protected CreateUser(CreateUserBuilder<?, ?> b) {
            super(b);
            this.email = b.email;
            this.roleName = b.roleName;
            this.roleId = b.roleId;
        }

        @Generated
        public static CreateUserBuilder<?, ?> builder() {
            return new CreateUserBuilderImpl();
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getRoleName() {
            return this.roleName;
        }

        @Generated
        public String getRoleId() {
            return this.roleId;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateUser)) {
                return false;
            }
            CreateUser other = (CreateUser)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$roleName = this.getRoleName();
            String other$roleName = other.getRoleName();
            if (this$roleName == null ? other$roleName != null : !this$roleName.equals(other$roleName)) {
                return false;
            }
            String this$roleId = this.getRoleId();
            String other$roleId = other.getRoleId();
            return !(this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateUser;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $roleName = this.getRoleName();
            result = result * 59 + ($roleName == null ? 43 : $roleName.hashCode());
            String $roleId = this.getRoleId();
            result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
            return result;
        }

        @Generated
        public static abstract class CreateUserBuilder<C extends CreateUser, B extends CreateUserBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String email;
            @Generated
            private String roleName;
            @Generated
            private String roleId;

            @Generated
            public B email(String email) {
                this.email = email;
                return (B)this.self();
            }

            @Generated
            public B roleName(String roleName) {
                this.roleName = roleName;
                return (B)this.self();
            }

            @Generated
            public B roleId(String roleId) {
                this.roleId = roleId;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "UsersEndpoint.CreateUser.CreateUserBuilder(super=" + super.toString() + ", email=" + this.email + ", roleName=" + this.roleName + ", roleId=" + this.roleId + ")";
            }
        }

        @Generated
        private static final class CreateUserBuilderImpl
        extends CreateUserBuilder<CreateUser, CreateUserBuilderImpl> {
            @Generated
            private CreateUserBuilderImpl() {
            }

            @Override
            @Generated
            protected CreateUserBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CreateUser build() {
                return new CreateUser(this);
            }
        }
    }

    static final class AddToGroupsRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        List<String> groups;

        @Generated
        protected AddToGroupsRequest(AddToGroupsRequestBuilder<?, ?> b) {
            super(b);
            this.groups = b.groups;
        }

        @Generated
        public static AddToGroupsRequestBuilder<?, ?> builder() {
            return new AddToGroupsRequestBuilderImpl();
        }

        @Generated
        public List<String> getGroups() {
            return this.groups;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddToGroupsRequest)) {
                return false;
            }
            AddToGroupsRequest other = (AddToGroupsRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$groups = this.getGroups();
            List<String> other$groups = other.getGroups();
            return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AddToGroupsRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $groups = this.getGroups();
            result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
            return result;
        }

        @Generated
        public static abstract class AddToGroupsRequestBuilder<C extends AddToGroupsRequest, B extends AddToGroupsRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private List<String> groups;

            @Generated
            public B groups(List<String> groups) {
                this.groups = groups;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "UsersEndpoint.AddToGroupsRequest.AddToGroupsRequestBuilder(super=" + super.toString() + ", groups=" + this.groups + ")";
            }
        }

        @Generated
        private static final class AddToGroupsRequestBuilderImpl
        extends AddToGroupsRequestBuilder<AddToGroupsRequest, AddToGroupsRequestBuilderImpl> {
            @Generated
            private AddToGroupsRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected AddToGroupsRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AddToGroupsRequest build() {
                return new AddToGroupsRequest(this);
            }
        }
    }

    static final class ChangeRoleRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        String roleId;

        @Generated
        protected ChangeRoleRequest(ChangeRoleRequestBuilder<?, ?> b) {
            super(b);
            this.roleId = b.roleId;
        }

        @Generated
        public static ChangeRoleRequestBuilder<?, ?> builder() {
            return new ChangeRoleRequestBuilderImpl();
        }

        @Generated
        public String getRoleId() {
            return this.roleId;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangeRoleRequest)) {
                return false;
            }
            ChangeRoleRequest other = (ChangeRoleRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$roleId = this.getRoleId();
            String other$roleId = other.getRoleId();
            return !(this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChangeRoleRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $roleId = this.getRoleId();
            result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
            return result;
        }

        @Generated
        public static abstract class ChangeRoleRequestBuilder<C extends ChangeRoleRequest, B extends ChangeRoleRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String roleId;

            @Generated
            public B roleId(String roleId) {
                this.roleId = roleId;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "UsersEndpoint.ChangeRoleRequest.ChangeRoleRequestBuilder(super=" + super.toString() + ", roleId=" + this.roleId + ")";
            }
        }

        @Generated
        private static final class ChangeRoleRequestBuilderImpl
        extends ChangeRoleRequestBuilder<ChangeRoleRequest, ChangeRoleRequestBuilderImpl> {
            @Generated
            private ChangeRoleRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected ChangeRoleRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public ChangeRoleRequest build() {
                return new ChangeRoleRequest(this);
            }
        }
    }
}

