/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.cache.AbstractOffHeapCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.core.AtlanObject;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMassCache<T extends AtlanObject>
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMassCache.class);
    private final AtlanClient client;
    private final String cacheName;
    private volatile Map<String, String> mapIdToName = new ConcurrentHashMap<String, String>();
    private volatile Map<String, String> mapNameToId = new ConcurrentHashMap<String, String>();
    private volatile Map<String, String> mapIdToSid = new ConcurrentHashMap<String, String>();
    private volatile Map<String, String> mapSidToId = new ConcurrentHashMap<String, String>();
    private volatile AbstractOffHeapCache<T> mapIdToObject;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected AtomicBoolean bulkRefresh = new AtomicBoolean(true);

    public AbstractMassCache(AtlanClient client, String cacheName) {
        this.client = client;
        this.cacheName = cacheName;
        this.mapIdToObject = new AbstractOffHeapCache(client, cacheName);
    }

    private void resetOffHeap() {
        if (this.mapIdToObject != null) {
            try {
                this.mapIdToObject.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close existing off-heap cache.", e);
            }
        }
        this.mapIdToObject = new AbstractOffHeapCache(this.client, this.cacheName);
    }

    public void refresh() throws AtlanException {
        this.lock.writeLock().lock();
        try {
            this.mapIdToName.clear();
            this.mapNameToId.clear();
            this.mapIdToSid.clear();
            this.mapSidToId.clear();
            this.resetOffHeap();
            this.refreshCache();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void cacheById(String id) throws AtlanException {
        if (this.bulkRefresh.get()) {
            this.refresh();
        } else {
            this.lock.writeLock().lock();
            try {
                this.lookupById(id);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void cacheBySid(String sid) throws AtlanException {
        if (this.bulkRefresh.get()) {
            this.refresh();
        } else {
            this.lock.writeLock().lock();
            try {
                this.lookupBySid(sid);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void cacheByName(String name) throws AtlanException {
        if (this.bulkRefresh.get()) {
            this.refresh();
        } else {
            this.lock.writeLock().lock();
            try {
                this.lookupByName(name);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    protected abstract void refreshCache() throws AtlanException;

    protected abstract void lookupById(String var1) throws AtlanException;

    protected void lookupBySid(String sid) throws AtlanException {
        throw new InvalidRequestException(ErrorCode.CANNOT_CACHE_REFRESH_BY_SID);
    }

    protected abstract void lookupByName(String var1) throws AtlanException;

    protected void cache(String id, String name, T object) {
        this.mapIdToName.put(id, name);
        this.mapNameToId.put(name, id);
        this.mapIdToObject.put(id, object);
    }

    protected void cache(String id, String sid, String name, T object) {
        this.cache(id, name, object);
        this.mapIdToSid.put(id, sid);
        this.mapSidToId.put(sid, id);
    }

    protected boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            if (this.mapIdToObject == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.mapIdToObject.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected Stream<Map.Entry<String, T>> entrySet() {
        this.lock.readLock().lock();
        try {
            if (this.mapIdToObject == null) {
                Stream<Map.Entry<String, T>> stream = Stream.empty();
                return stream;
            }
            Stream<Map.Entry<String, T>> stream = this.mapIdToObject.entrySet();
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNameKnown(String name) {
        this.lock.readLock().lock();
        try {
            String id = this.mapNameToId.get(name);
            if (id == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mapIdToObject.containsKey(id);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isIdKnown(String id) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mapIdToObject.containsKey(id);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected String getIdFromName(String name) {
        if (name == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            String string = this.mapNameToId.get(name);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected String getNameFromId(String id) {
        if (id == null) {
            return null;
        }
        return this.getNameFromId(id, false);
    }

    protected String getNameFromId(String id, boolean bypassReadLock) {
        if (id == null) {
            return null;
        }
        if (bypassReadLock) {
            return this.getNameFromIdWithoutLock(id);
        }
        return this.getNameFromIdWithLock(id);
    }

    private String getNameFromIdWithoutLock(String id) {
        return this.mapNameToId.get(id);
    }

    private String getNameFromIdWithLock(String id) {
        this.lock.readLock().lock();
        try {
            String string = this.mapIdToName.get(id);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected String getIdFromSid(String sid) {
        if (sid == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            String string = this.mapSidToId.get(sid);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected String getSidFromId(String id) {
        if (id == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            String string = this.mapIdToSid.get(id);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected String getSidFromName(String name) {
        String id = this.getIdFromName(name);
        return this.getSidFromId(id);
    }

    protected String getNameFromSid(String sid) {
        String id = this.getIdFromSid(sid);
        return this.getNameFromId(id);
    }

    protected T getObjectById(String id) {
        if (id == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            if (this.mapIdToObject == null) {
                T t = null;
                return t;
            }
            T t = this.mapIdToObject.get(id);
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getIdForName(String name) throws AtlanException {
        return this.getIdForName(name, true);
    }

    public String getIdForName(String name, boolean allowRefresh) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            String id = this.getIdFromName(name);
            if (id == null && allowRefresh) {
                this.cacheByName(name);
                id = this.getIdFromName(name);
            }
            if (id == null) {
                throw new NotFoundException(ErrorCode.ID_NOT_FOUND_BY_NAME, name);
            }
            return id;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_NAME);
    }

    public String getIdForSid(String sid) throws AtlanException {
        return this.getIdForSid(sid, true);
    }

    public String getIdForSid(String sid, boolean allowRefresh) throws AtlanException {
        if (sid != null && !sid.isEmpty()) {
            String id = this.getIdFromSid(sid);
            if (id == null && allowRefresh) {
                this.cacheBySid(sid);
                id = this.getIdFromSid(sid);
            }
            if (id == null) {
                throw new NotFoundException(ErrorCode.ID_NOT_FOUND_BY_SID, sid);
            }
            return id;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    public String getSidForName(String name) throws AtlanException {
        return this.getSidForName(name, true);
    }

    public String getSidForName(String name, boolean allowRefresh) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            String id = this.getSidFromName(name);
            if (id == null && allowRefresh) {
                this.cacheByName(name);
                id = this.getSidFromName(name);
            }
            if (id == null) {
                throw new NotFoundException(ErrorCode.ID_NOT_FOUND_BY_NAME, name);
            }
            return id;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_NAME);
    }

    public String getNameForId(String id) throws AtlanException {
        return this.getNameForId(id, true);
    }

    public String getNameForId(String id, boolean allowRefresh) throws AtlanException {
        if (id != null && !id.isEmpty()) {
            String name = this.getNameFromId(id);
            if (name == null && allowRefresh) {
                this.cacheById(id);
                name = this.getNameFromId(id);
            }
            if (name == null) {
                throw new NotFoundException(ErrorCode.NAME_NOT_FOUND_BY_ID, id);
            }
            return name;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    public String getNameForSid(String sid) throws AtlanException {
        return this.getNameForSid(sid, true);
    }

    public String getNameForSid(String sid, boolean allowRefresh) throws AtlanException {
        if (sid != null && !sid.isEmpty()) {
            String name = this.getNameFromSid(sid);
            if (name == null && allowRefresh) {
                this.cacheBySid(sid);
                name = this.getNameFromSid(sid);
            }
            if (name == null) {
                throw new NotFoundException(ErrorCode.NAME_NOT_FOUND_BY_ID, sid);
            }
            return name;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    public T getById(String id) throws AtlanException {
        return this.getById(id, true);
    }

    public T getById(String id, boolean allowRefresh) throws AtlanException {
        if (id != null && !id.isEmpty()) {
            T result = this.getObjectById(id);
            if (result == null && allowRefresh) {
                this.cacheById(id);
                result = this.getObjectById(id);
            }
            if (result == null) {
                throw new NotFoundException(ErrorCode.NAME_NOT_FOUND_BY_ID, id);
            }
            return result;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    public T getBySid(String sid) throws AtlanException {
        return this.getBySid(sid, true);
    }

    public T getBySid(String sid, boolean allowRefresh) throws AtlanException {
        if (sid != null && !sid.isEmpty()) {
            String id = this.getIdForSid(sid, allowRefresh);
            return this.getById(id, false);
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    public T getByName(String name) throws AtlanException {
        return this.getByName(name, true);
    }

    public T getByName(String name, boolean allowRefresh) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            String id = this.getIdForName(name, allowRefresh);
            return this.getById(id, false);
        }
        throw new InvalidRequestException(ErrorCode.MISSING_NAME);
    }

    @Override
    public void close() throws IOException {
        this.lock.writeLock().lock();
        try {
            if (this.mapIdToObject != null) {
                this.mapIdToObject.close();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Generated
    public AtomicBoolean getBulkRefresh() {
        return this.bulkRefresh;
    }
}

