/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.model.core.AtlanObject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AbstractOffHeapCache<T extends AtlanObject>
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractOffHeapCache.class);
    private final AtlanClient client;
    private final Path backingStore;
    private volatile RocksDB internal;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final String name;

    public AbstractOffHeapCache(AtlanClient client, String name) {
        this.client = client;
        this.name = name;
        this.lock.writeLock().lock();
        try {
            this.backingStore = Files.createTempDirectory("rdb_" + name + "_", new FileAttribute[0]);
            this.internal = RocksDB.open((String)this.backingStore.toString());
        }
        catch (IOException | RocksDBException e) {
            throw new RuntimeException("Unable to create off-heap cache for tracking.", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static byte[] serializeKey(String key) {
        return key.getBytes(StandardCharsets.UTF_8);
    }

    private static String deserializeKey(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private byte[] serializeValue(T value) {
        byte[] typeName = value.getClass().getCanonicalName().getBytes(StandardCharsets.UTF_8);
        int typeNameLength = typeName.length;
        try {
            byte[] json = this.client.writeValueAsBytes(value);
            ByteBuffer buffer = ByteBuffer.allocate(typeNameLength + 4 + json.length);
            buffer.putInt(typeNameLength);
            buffer.put(typeName);
            buffer.put(json);
            if (buffer.hasArray()) {
                return buffer.array();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize value.", e);
        }
    }

    private static Object _deserializeValue(AtlanClient client, byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int typeNameLength = buffer.getInt();
        byte[] typeNameBytes = new byte[typeNameLength];
        buffer.get(typeNameBytes);
        String typeName = new String(typeNameBytes, StandardCharsets.UTF_8);
        try {
            Class<?> type = Class.forName(typeName);
            byte[] json = new byte[buffer.remaining()];
            buffer.get(json);
            return client.readValue(json, type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to find type: " + typeName + ".", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize value.", e);
        }
    }

    private T deserializeValue(byte[] bytes) throws IOException {
        return (T)((AtlanObject)AbstractOffHeapCache._deserializeValue(this.client, bytes));
    }

    public T get(String id) {
        byte[] value;
        byte[] key = AbstractOffHeapCache.serializeKey(id);
        this.lock.readLock().lock();
        try {
            value = this.internal.get(key);
        }
        catch (RocksDBException e) {
            throw new IllegalStateException("Unable to get value for key: " + id, e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            if (value == null || value.length == 0) {
                log.warn("Null or empty value retrieved for ID: {} -- short-circuiting.", (Object)id);
                return null;
            }
            return this.deserializeValue(value);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to translate value for key: " + id, e);
        }
    }

    protected void put(String id, T object) {
        byte[] key = AbstractOffHeapCache.serializeKey(id);
        byte[] value = this.serializeValue(object);
        if (value == null || value.length == 0) {
            log.warn(" ... zero-length serialized object being added ({}): {}", (Object)id, object);
        }
        this.lock.writeLock().lock();
        try {
            this.internal.put(key, value);
        }
        catch (RocksDBException e) {
            throw new IllegalStateException("Unable to put value for key: " + id, e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putAll(AbstractOffHeapCache<T> other) {
        try (WriteBatch batch = new WriteBatch();
             WriteOptions options = new WriteOptions();){
            try (RocksIterator iterator = other.internal.newIterator();){
                iterator.seekToFirst();
                while (iterator.isValid()) {
                    batch.put(iterator.key(), iterator.value());
                    iterator.next();
                }
            }
            this.lock.writeLock().lock();
            try {
                this.internal.write(options, batch);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (RocksDBException e) {
            throw new IllegalStateException("Error putting all values into cache.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String id) {
        byte[] key = AbstractOffHeapCache.serializeKey(id);
        this.lock.readLock().lock();
        try {
            boolean bl = this.internal.keyExists(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long size() {
        return this.entrySet().count();
    }

    public long getSize() {
        return this.size();
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public Stream<T> values() {
        return new EntryIterator(this.client, this.internal.newIterator()).stream().map(Map.Entry::getValue);
    }

    public Stream<Map.Entry<String, T>> entrySet() {
        return new EntryIterator(this.client, this.internal.newIterator()).stream();
    }

    public boolean isNotClosed() {
        return !this.internal.isClosed();
    }

    @Override
    public void close() throws IOException {
        log.debug("Closing off-heap cache ({}): {}", (Object)this.getName(), (Object)this.backingStore);
        this.lock.writeLock().lock();
        try {
            this.internal.close();
            File file = this.backingStore.toFile();
            if (file.exists() && file.isDirectory()) {
                this.deleteDirectory(this.backingStore);
                log.debug(" ... cache deleted.");
            } else {
                log.debug(" ... cache already deleted.");
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void deleteDirectory(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Generated
    public String getName() {
        return this.name;
    }

    static final class EntryIterator<T extends AtlanObject>
    implements Iterator<Map.Entry<String, T>>,
    AutoCloseable {
        private final AtlanClient client;
        private final RocksIterator iterator;

        public EntryIterator(AtlanClient client, RocksIterator iterator) {
            this.client = client;
            this.iterator = iterator;
            this.iterator.seekToFirst();
        }

        private T deserializeValue(byte[] bytes) throws IOException {
            return (T)((AtlanObject)AbstractOffHeapCache._deserializeValue(this.client, bytes));
        }

        @Override
        public boolean hasNext() {
            return this.iterator.isValid();
        }

        @Override
        public Map.Entry<String, T> next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("No more elements in the cache.");
            }
            byte[] key = this.iterator.key();
            byte[] value = this.iterator.value();
            try {
                AbstractMap.SimpleEntry<String, T> entry = new AbstractMap.SimpleEntry<String, T>(AbstractOffHeapCache.deserializeKey(key), this.deserializeValue(value));
                this.iterator.next();
                return entry;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to deserialize value.", e);
            }
        }

        @Override
        public void close() {
            this.iterator.close();
        }

        public Stream<Map.Entry<String, T>> stream() {
            return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 272), false).onClose(this::close);
        }
    }
}

