/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.cache.AbstractAssetCache;
import com.atlan.cache.ObjectName;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.search.FluentSearch;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionCache
extends AbstractAssetCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionCache.class);
    private static final List<AtlanField> connectionAttributes = List.of(Connection.NAME, Connection.CONNECTOR_TYPE, Connection.STATUS);

    public ConnectionCache(AtlanClient client) {
        super(client);
    }

    @Override
    public void lookupByGuid(String guid) throws AtlanException {
        Asset asset;
        Optional<Asset> candidate;
        if (guid != null && !guid.isEmpty() && (candidate = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Connection.select(this.client).where(Connection.GUID.eq(guid))).includesOnResults(connectionAttributes)).stream().findFirst()).isPresent() && (asset = candidate.get()) instanceof Connection) {
            Connection connection = (Connection)asset;
            this.cache(connection);
        }
    }

    @Override
    public void lookupByQualifiedName(String connectionQN) throws AtlanException {
        Asset asset;
        Optional<Asset> candidate;
        if (connectionQN != null && !connectionQN.isEmpty() && (candidate = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Connection.select(this.client).where(Connection.QUALIFIED_NAME.eq(connectionQN))).includesOnResults(connectionAttributes)).stream().findFirst()).isPresent() && (asset = candidate.get()) instanceof Connection) {
            Connection connection = (Connection)asset;
            this.cache(connection);
        }
    }

    @Override
    public void lookupByName(ObjectName name) throws AtlanException {
        ConnectionName identity;
        List<Connection> results;
        if (name instanceof ConnectionName && !(results = Connection.findByName(this.client, (identity = (ConnectionName)name).getName(), identity.getType(), connectionAttributes)).isEmpty()) {
            if (results.size() > 1) {
                log.warn("Found multiple connections of the same type with the same name, caching only the first: {}", (Object)name);
            }
            this.cache(results.get(0));
        }
    }

    @Override
    public ObjectName getName(Asset asset) {
        if (asset instanceof Connection) {
            Connection connection = (Connection)asset;
            return new ConnectionName(connection);
        }
        return null;
    }

    public static final class ConnectionName
    implements ObjectName {
        String name;
        AtlanConnectorType type;

        public ConnectionName(Connection connection) {
            this.name = connection.getName();
            this.type = connection.getConnectorType();
        }

        public ConnectionName(String identity) {
            String[] tokens;
            if (identity != null && !identity.isEmpty() && (tokens = identity.split("/")).length > 1) {
                this.type = AtlanConnectorType.fromValue(tokens[0]);
                this.name = identity.substring(tokens[0].length() + 1);
            }
        }

        @Override
        public String toString() {
            return this.type.getValue() + "/" + this.name;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public AtlanConnectorType getType() {
            return this.type;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConnectionName)) {
                return false;
            }
            ConnectionName other = (ConnectionName)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            AtlanConnectorType this$type = this.getType();
            AtlanConnectorType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            AtlanConnectorType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }
}

