/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.api.TypeDefsEndpoint;
import com.atlan.cache.AbstractMassCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.LogicException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.CustomMetadataDef;
import com.atlan.model.typedefs.TypeDefResponse;
import com.atlan.serde.Removable;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMetadataCache
extends AbstractMassCache<CustomMetadataDef> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomMetadataCache.class);
    private volatile Map<String, AttributeDef> attrCacheBySid = new ConcurrentHashMap<String, AttributeDef>();
    private volatile Map<String, Map<String, String>> mapAttrSidToName = new ConcurrentHashMap<String, Map<String, String>>();
    private volatile Map<String, Map<String, String>> mapAttrNameToSid = new ConcurrentHashMap<String, Map<String, String>>();
    private volatile Set<String> archivedAttrSids = ConcurrentHashMap.newKeySet();
    private final TypeDefsEndpoint typeDefsEndpoint;

    public CustomMetadataCache(AtlanClient client) {
        super(client, "cm");
        this.typeDefsEndpoint = client.typeDefs;
    }

    @Override
    protected void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of custom metadata...");
        TypeDefResponse response = this.typeDefsEndpoint.list(List.of(AtlanTypeCategory.CUSTOM_METADATA, AtlanTypeCategory.STRUCT));
        if (response == null || response.getStructDefs() == null || response.getStructDefs().isEmpty()) {
            throw new AuthenticationException(ErrorCode.EXPIRED_API_TOKEN);
        }
        List<CustomMetadataDef> customMetadata = response.getCustomMetadataDefs();
        this.attrCacheBySid.clear();
        this.mapAttrSidToName.clear();
        this.mapAttrNameToSid.clear();
        this.archivedAttrSids.clear();
        for (CustomMetadataDef bmDef : customMetadata) {
            String typeId = bmDef.getName();
            this.cache(bmDef.getGuid(), typeId, bmDef.getDisplayName(), bmDef);
            this.mapAttrSidToName.put(typeId, new ConcurrentHashMap());
            this.mapAttrNameToSid.put(typeId, new ConcurrentHashMap());
            for (AttributeDef attributeDef : bmDef.getAttributeDefs()) {
                String attrId = attributeDef.getName();
                String attrName = attributeDef.getDisplayName();
                this.mapAttrSidToName.get(typeId).put(attrId, attrName);
                this.attrCacheBySid.put(attrId, attributeDef);
                if (attributeDef.isArchived()) {
                    this.archivedAttrSids.add(attrId);
                    continue;
                }
                String existingId = this.mapAttrNameToSid.get(typeId).put(attributeDef.getDisplayName(), attributeDef.getName());
                if (existingId == null) continue;
                throw new LogicException(ErrorCode.DUPLICATE_CUSTOM_ATTRIBUTES, attributeDef.getDisplayName(), bmDef.getDisplayName());
            }
        }
    }

    @Override
    protected void lookupByName(String name) {
    }

    @Override
    protected void lookupById(String id) {
    }

    private AttributeDef getAttrById(String id) {
        this.lock.readLock().lock();
        try {
            AttributeDef attributeDef = this.attrCacheBySid.get(id);
            return attributeDef;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Map<String, String> getAttrNameFromId(String id) {
        this.lock.readLock().lock();
        try {
            Map<String, String> map = this.mapAttrSidToName.get(id);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Map<String, String> getAttrIdFromName(String name) {
        this.lock.readLock().lock();
        try {
            Map<String, String> map = this.mapAttrNameToSid.get(name);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean isArchivedAttr(String id) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.archivedAttrSids.contains(id);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<String, List<AttributeDef>> getAllCustomAttributes() throws AtlanException {
        return this.getAllCustomAttributes(false);
    }

    public Map<String, List<AttributeDef>> getAllCustomAttributes(boolean includeDeleted) throws AtlanException {
        return this.getAllCustomAttributes(includeDeleted, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<AttributeDef>> getAllCustomAttributes(boolean includeDeleted, boolean forceRefresh) throws AtlanException {
        if (this.isEmpty() || forceRefresh) {
            this.refresh();
        }
        HashMap map = new HashMap();
        Stream<Map.Entry<String, Map.Entry>> entrySet = this.entrySet();
        this.lock.readLock().lock();
        try {
            AtomicReference found = new AtomicReference();
            entrySet.forEach(entry -> {
                try {
                    List<AttributeDef> toInclude;
                    String id = (String)entry.getKey();
                    String typeName = this.getNameForId(id);
                    CustomMetadataDef typeDef = (CustomMetadataDef)entry.getValue();
                    List<AttributeDef> attributeDefs = typeDef.getAttributeDefs();
                    if (includeDeleted) {
                        toInclude = attributeDefs;
                    } else {
                        toInclude = new ArrayList<AttributeDef>();
                        for (AttributeDef attributeDef : attributeDefs) {
                            if (attributeDef.isArchived()) continue;
                            toInclude.add(attributeDef);
                        }
                    }
                    map.put(typeName, toInclude);
                }
                catch (AtlanException e) {
                    if (found.get() != null) {
                        ((AtlanException)found.get()).addSuppressed(e);
                    }
                    found.set(e);
                }
            });
            if (found.get() != null) {
                throw (AtlanException)found.get();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Collections.unmodifiableMap(map);
    }

    public String getAttrIdForName(String setName, String attributeName) throws AtlanException {
        return this.getAttrIdForName(setName, attributeName, true);
    }

    public String getAttrIdForName(String setName, String attributeName, boolean allowRefresh) throws AtlanException {
        String setId = this.getSidForName(setName, allowRefresh);
        return this.getAttrIdForNameFromSetId(setId, attributeName, allowRefresh);
    }

    public String getAttributeForSearchResults(String setName, String attributeName) throws AtlanException {
        return this.getAttributeForSearchResults(setName, attributeName, true);
    }

    public String getAttributeForSearchResults(String setName, String attributeName, boolean allowRefresh) throws AtlanException {
        String setId = this.getSidForName(setName, allowRefresh);
        String attrId = this._getAttributeForSearchResults(setId, attributeName);
        if (attrId == null && allowRefresh) {
            this.refresh();
            attrId = this._getAttributeForSearchResults(setId, attributeName);
        }
        return attrId;
    }

    public Set<String> getAttributesForSearchResults(String setName) throws AtlanException {
        return this.getAttributesForSearchResults(setName, true);
    }

    public Set<String> getAttributesForSearchResults(String setName, boolean allowRefresh) throws AtlanException {
        String setId = this.getSidForName(setName, allowRefresh);
        Set<String> dotNames = this._getAttributesForSearchResults(setId);
        if (dotNames == null && allowRefresh) {
            this.refresh();
            dotNames = this._getAttributesForSearchResults(setId);
        }
        return dotNames == null ? Collections.emptySet() : Collections.unmodifiableSet(dotNames);
    }

    private Set<String> _getAttributesForSearchResults(String setId) {
        Map<String, String> subMap = this.getAttrIdFromName(setId);
        if (subMap != null) {
            Collection<String> attrIds = subMap.values();
            HashSet<String> dotNames = new HashSet<String>();
            for (String attrId : attrIds) {
                dotNames.add(setId + "." + attrId);
            }
            return dotNames;
        }
        return null;
    }

    private String _getAttributeForSearchResults(String setId, String attrName) {
        Map<String, String> subMap = this.getAttrIdFromName(setId);
        if (subMap != null && subMap.containsKey(attrName)) {
            return setId + "." + subMap.get(attrName);
        }
        return null;
    }

    public AttributeDef getAttributeDef(String attributeId) throws AtlanException {
        return this.getAttributeDef(attributeId, true);
    }

    public AttributeDef getAttributeDef(String attributeId, boolean allowRefresh) throws AtlanException {
        if (attributeId == null || attributeId.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_CM_ATTR_ID);
        }
        AttributeDef found = this.getAttrById(attributeId);
        if (found == null && allowRefresh) {
            this.refresh();
        }
        return this.getAttrById(attributeId);
    }

    private String getAttrIdForNameFromSetId(String setId, String attributeName, boolean allowRefresh) throws AtlanException {
        if (setId != null && !setId.isEmpty()) {
            Map<String, String> subMap = this.getAttrIdFromName(setId);
            if (attributeName != null && !attributeName.isEmpty()) {
                String attrId = null;
                if (subMap != null) {
                    attrId = subMap.get(attributeName);
                }
                if (attrId == null) {
                    if (allowRefresh) {
                        this.refresh();
                        subMap = this.getAttrIdFromName(setId);
                    }
                    if (subMap == null) {
                        throw new NotFoundException(ErrorCode.CM_NO_ATTRIBUTES, setId);
                    }
                } else {
                    return attrId;
                }
                attrId = subMap.get(attributeName);
                if (attrId == null) {
                    throw new NotFoundException(ErrorCode.CM_ATTR_NOT_FOUND_BY_NAME, attributeName, setId);
                }
                return attrId;
            }
            throw new InvalidRequestException(ErrorCode.MISSING_CM_ATTR_NAME);
        }
        throw new InvalidRequestException(ErrorCode.MISSING_CM_ID);
    }

    private String getAttrNameForIdFromSetId(String setId, String attributeId, boolean allowRefresh) throws AtlanException {
        if (setId != null && !setId.isEmpty()) {
            Map<String, String> subMap = this.getAttrNameFromId(setId);
            if (attributeId != null && !attributeId.isEmpty()) {
                String attrName = null;
                if (subMap != null) {
                    attrName = subMap.get(attributeId);
                }
                if (attrName == null) {
                    if (allowRefresh) {
                        this.refresh();
                        subMap = this.getAttrNameFromId(setId);
                    }
                    if (subMap == null) {
                        throw new NotFoundException(ErrorCode.CM_NO_ATTRIBUTES, setId);
                    }
                } else {
                    return attrName;
                }
                attrName = subMap.get(attributeId);
                if (attrName == null) {
                    throw new NotFoundException(ErrorCode.CM_ATTR_NOT_FOUND_BY_ID, attributeId, setId);
                }
                return attrName;
            }
            throw new InvalidRequestException(ErrorCode.MISSING_CM_ATTR_ID);
        }
        throw new InvalidRequestException(ErrorCode.MISSING_CM_ID);
    }

    public Map<String, Object> getEmptyAttributes(String customMetadataName) throws AtlanException {
        return this.getEmptyAttributes(customMetadataName, true);
    }

    public Map<String, Object> getEmptyAttributes(String customMetadataName, boolean allowRefresh) throws AtlanException {
        String cmId = this.getSidForName(customMetadataName, allowRefresh);
        Map<String, String> attributes = this.getAttrIdFromName(cmId);
        LinkedHashMap<String, Object> empty = new LinkedHashMap<String, Object>();
        for (String attrName : attributes.keySet()) {
            empty.put(attrName, Removable.NULL);
        }
        return empty;
    }

    public void getBusinessAttributesFromCustomMetadata(Map<String, CustomMetadataAttributes> customMetadata, Map<String, Map<String, Object>> businessAttributes) throws AtlanException {
        this.getBusinessAttributesFromCustomMetadata(customMetadata, businessAttributes, true);
    }

    public void getBusinessAttributesFromCustomMetadata(Map<String, CustomMetadataAttributes> customMetadata, Map<String, Map<String, Object>> businessAttributes, boolean allowRefresh) throws AtlanException {
        if (customMetadata != null) {
            for (Map.Entry<String, CustomMetadataAttributes> entry : customMetadata.entrySet()) {
                String cmName = entry.getKey();
                String cmId = this.getSidForName(cmName, allowRefresh);
                CustomMetadataAttributes attrs = entry.getValue();
                Map bmAttrs = businessAttributes.getOrDefault(cmId, new LinkedHashMap());
                this.getAttributesFromCustomMetadata(cmId, cmName, attrs, bmAttrs, allowRefresh);
                businessAttributes.put(cmId, bmAttrs);
            }
        }
    }

    public void getAttributesFromCustomMetadata(String cmId, String cmName, CustomMetadataAttributes cma, Map<String, Object> attributes) throws AtlanException {
        this.getAttributesFromCustomMetadata(cmId, cmName, cma, attributes, true);
    }

    public void getAttributesFromCustomMetadata(String cmId, String cmName, CustomMetadataAttributes cma, Map<String, Object> attributes, boolean allowRefresh) throws AtlanException {
        if (cma.getArchivedAttributes() != null) {
            for (Map.Entry<String, Object> archived : cma.getArchivedAttributes().entrySet()) {
                String archivedAttrName = archived.getKey();
                String archivedAttrId = this.getAttrIdForNameFromSetId(cmId, archivedAttrName, allowRefresh);
                attributes.put(archivedAttrId, archived.getValue());
            }
        }
        this.getIdMapFromNameMap(cmName, cma.getAttributes(), attributes, allowRefresh);
    }

    public void getIdMapFromNameMap(String customMetadataName, Map<String, Object> nameToValue, Map<String, Object> idToValue) throws AtlanException {
        this.getIdMapFromNameMap(customMetadataName, nameToValue, idToValue, true);
    }

    public void getIdMapFromNameMap(String customMetadataName, Map<String, Object> nameToValue, Map<String, Object> idToValue, boolean allowRefresh) throws AtlanException {
        String cmId = this.getSidForName(customMetadataName, allowRefresh);
        for (Map.Entry<String, Object> entry : nameToValue.entrySet()) {
            String attrName = entry.getKey();
            String cmAttrId = this.getAttrIdForNameFromSetId(cmId, attrName, allowRefresh);
            idToValue.put(cmAttrId, entry.getValue());
        }
    }

    public Map<String, CustomMetadataAttributes> getCustomMetadataFromBusinessAttributes(JsonNode businessAttributes) throws AtlanException {
        return this.getCustomMetadataFromBusinessAttributes(businessAttributes, true);
    }

    public Map<String, CustomMetadataAttributes> getCustomMetadataFromBusinessAttributes(JsonNode businessAttributes, boolean allowRefresh) throws AtlanException {
        LinkedHashMap<String, CustomMetadataAttributes> map = new LinkedHashMap<String, CustomMetadataAttributes>();
        Iterator itrCM = businessAttributes.fieldNames();
        while (itrCM.hasNext()) {
            String cmId = (String)itrCM.next();
            try {
                String cmName = this.getNameForSid(cmId, allowRefresh);
                JsonNode bmAttrs = businessAttributes.get(cmId);
                CustomMetadataAttributes cma = this.getCustomMetadataAttributes(cmId, bmAttrs, allowRefresh);
                if (cma.isEmpty()) continue;
                map.put(cmName, cma);
            }
            catch (NotFoundException e) {
                log.warn("Custom metadata with ID {} could not be found, likely deleted in parallel with this processing so it will be skipped.", (Object)cmId);
                log.debug("Details:", (Throwable)e);
            }
        }
        return map;
    }

    public CustomMetadataAttributes getCustomMetadataAttributes(String cmId, JsonNode attributes) throws AtlanException {
        return this.getCustomMetadataAttributes(cmId, attributes, true);
    }

    public CustomMetadataAttributes getCustomMetadataAttributes(String cmId, JsonNode attributes, boolean allowRefresh) throws AtlanException {
        CustomMetadataAttributes.CustomMetadataAttributesBuilder<?, ?> builder = CustomMetadataAttributes.builder();
        Iterator itrCMA = attributes.fieldNames();
        while (itrCMA.hasNext()) {
            String attrId = (String)itrCMA.next();
            String cmAttrName = this.getAttrNameForIdFromSetId(cmId, attrId, allowRefresh);
            JsonNode jsonValue = attributes.get(attrId);
            if (jsonValue.isArray()) {
                HashSet<Object> values = new HashSet<Object>();
                ArrayNode array = (ArrayNode)jsonValue;
                for (JsonNode element : array) {
                    Object primitive = CustomMetadataCache.deserializePrimitive(element);
                    values.add(primitive);
                }
                if (values.isEmpty()) continue;
                if (this.isArchivedAttr(attrId)) {
                    builder.archivedAttribute(cmAttrName, values);
                    continue;
                }
                builder.attribute(cmAttrName, values);
                continue;
            }
            if (jsonValue.isValueNode()) {
                Object primitive = CustomMetadataCache.deserializePrimitive(jsonValue);
                if (this.isArchivedAttr(attrId)) {
                    builder.archivedAttribute(cmAttrName, primitive);
                    continue;
                }
                builder.attribute(cmAttrName, primitive);
                continue;
            }
            throw new LogicException(ErrorCode.UNABLE_TO_DESERIALIZE, jsonValue.toString());
        }
        return builder.build();
    }

    public Map<String, CustomMetadataAttributes> getCustomMetadataFromSearchResult(Map<String, JsonNode> embeddedAttributes) throws AtlanException {
        return this.getCustomMetadataFromSearchResult(embeddedAttributes, true);
    }

    public Map<String, CustomMetadataAttributes> getCustomMetadataFromSearchResult(Map<String, JsonNode> embeddedAttributes, boolean allowRefresh) throws AtlanException {
        LinkedHashMap<String, CustomMetadataAttributes> map = new LinkedHashMap<String, CustomMetadataAttributes>();
        LinkedHashMap builderMap = new LinkedHashMap();
        for (Map.Entry<String, JsonNode> entry : embeddedAttributes.entrySet()) {
            String compositeId = entry.getKey();
            int indexOfDot = compositeId.indexOf(".");
            if (indexOfDot <= 0) continue;
            String cmId = compositeId.substring(0, indexOfDot);
            try {
                String cmName = this.getNameForSid(cmId, allowRefresh);
                if (!builderMap.containsKey(cmName)) {
                    builderMap.put(cmName, CustomMetadataAttributes.builder());
                }
                String attrId = compositeId.substring(indexOfDot + 1);
                String cmAttrName = this.getAttrNameForIdFromSetId(cmId, attrId, allowRefresh);
                JsonNode jsonValue = entry.getValue();
                if (jsonValue.isArray()) {
                    HashSet<Object> values = new HashSet<Object>();
                    ArrayNode array = (ArrayNode)jsonValue;
                    for (JsonNode element : array) {
                        Object primitive = CustomMetadataCache.deserializePrimitive(element);
                        values.add(primitive);
                    }
                    if (values.isEmpty()) continue;
                    if (this.isArchivedAttr(attrId)) {
                        ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)builderMap.get(cmName)).archivedAttribute(cmAttrName, values);
                        continue;
                    }
                    ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)builderMap.get(cmName)).attribute(cmAttrName, values);
                    continue;
                }
                if (jsonValue.isValueNode()) {
                    Object primitive = CustomMetadataCache.deserializePrimitive(jsonValue);
                    if (this.isArchivedAttr(attrId)) {
                        ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)builderMap.get(cmName)).archivedAttribute(cmAttrName, primitive);
                        continue;
                    }
                    ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)builderMap.get(cmName)).attribute(cmAttrName, primitive);
                    continue;
                }
                throw new LogicException(ErrorCode.UNABLE_TO_DESERIALIZE, jsonValue.toString());
            }
            catch (NotFoundException e) {
                log.warn("Custom metadata with ID {} could not be found, likely deleted in parallel with this processing so it will be skipped.", (Object)cmId);
                log.debug("Details:", (Throwable)e);
            }
        }
        for (Map.Entry<String, Object> entry : builderMap.entrySet()) {
            String cmName = entry.getKey();
            AtlanObject cma = ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)entry.getValue()).build();
            if (((CustomMetadataAttributes)cma).isEmpty()) continue;
            map.put(cmName, (CustomMetadataAttributes)cma);
        }
        return map;
    }

    public static Object deserializePrimitive(JsonNode jsonValue) throws LogicException {
        if (jsonValue.isValueNode()) {
            if (jsonValue.isTextual()) {
                return jsonValue.asText();
            }
            if (jsonValue.isBoolean()) {
                return jsonValue.asBoolean();
            }
            if (jsonValue.isIntegralNumber()) {
                return jsonValue.asLong();
            }
            if (jsonValue.isFloatingPointNumber()) {
                return jsonValue.asDouble();
            }
            if (jsonValue.isNull()) {
                return null;
            }
            throw new LogicException(ErrorCode.UNABLE_TO_DESERIALIZE, jsonValue.toString());
        }
        throw new LogicException(ErrorCode.UNABLE_TO_DESERIALIZE, jsonValue.toString());
    }
}

