/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.cache.AbstractOffHeapCache;
import com.atlan.model.assets.Asset;
import java.io.IOException;
import java.util.function.Predicate;

public class OffHeapAssetCache
extends AbstractOffHeapCache<Asset> {
    public OffHeapAssetCache(AtlanClient client, String name) {
        super(client, name);
    }

    public void add(Asset asset) {
        this.put(asset.getGuid(), asset);
    }

    public void extendedWith(OffHeapAssetCache other, boolean closeOriginal) throws IOException {
        if (other != null) {
            this.putAll(other);
            if (closeOriginal) {
                other.close();
            }
        }
    }

    public void extendedWith(OffHeapAssetCache other, boolean closeOriginal, Predicate<Asset> isValid) throws IOException {
        if (other != null) {
            other.values().forEach(one -> {
                if (isValid.test((Asset)one)) {
                    this.put(one.getGuid(), one);
                }
            });
            if (closeOriginal) {
                other.close();
            }
        }
    }
}

