/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.events;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.IAWS;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.events.AtlanEvent;
import com.atlan.model.events.AtlanEventPayload;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.util.AssetBatch;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import org.slf4j.Logger;

public interface AtlanEventHandler {
    public static final String WEBHOOK_VALIDATION_REQUEST = "{\"atlan-webhook\": \"Hello, humans of data! It worked. Excited to see what you build!\"}";

    default public boolean validatePrerequisites(AtlanEvent event, Logger log) throws AtlanException {
        return event != null && event.getPayload() != null && event.getPayload().getAsset() != null;
    }

    default public Asset getCurrentState(AtlanClient client, Asset fromEvent, Logger log) throws AtlanException {
        return AtlanEventHandler.getCurrentViewOfAsset(client, fromEvent, null, false, false);
    }

    public Collection<Asset> calculateChanges(Asset var1, Logger var2) throws AtlanException;

    default public boolean hasChanges(Asset current, Asset modified, Logger log) {
        return !Objects.equals(current, modified);
    }

    default public void saveChanges(AtlanClient client, Collection<Asset> changedAssets, Logger log) throws AtlanException {
        AssetBatch batch = new AssetBatch(client, 20, false, AssetBatch.CustomMetadataHandling.MERGE);
        for (Asset one : changedAssets) {
            batch.add(one);
        }
        batch.flush();
    }

    public static boolean isValidationRequest(String data) {
        return WEBHOOK_VALIDATION_REQUEST.equals(data);
    }

    public static boolean validSignature(String expectedSignature, Map<String, String> headers) {
        if (headers == null) {
            return false;
        }
        String found = headers.getOrDefault("x-atlan-signing-secret", null);
        return found != null && found.equals(expectedSignature);
    }

    public static AtlanEvent getAtlanEvent(AtlanClient client, String data) throws IOException {
        return client.readValue(data, AtlanEvent.class);
    }

    public static AtlanEvent getAtlanEvent(AtlanClient client, byte[] data) throws IOException {
        return client.readValue(data, AtlanEvent.class);
    }

    public static Asset getCurrentFullAsset(AtlanClient client, AtlanEvent event) throws AtlanException {
        AtlanEventPayload payload = event.getPayload();
        if (payload != null && payload.getAsset() != null) {
            return Asset.get(client, payload.getAsset().getGuid(), true);
        }
        return null;
    }

    public static Asset getCurrentViewOfAsset(AtlanClient client, AtlanEvent event, Collection<String> limitedToAttributes, boolean includeMeanings, boolean includeAtlanTags) throws AtlanException {
        AtlanEventPayload payload = event.getPayload();
        if (payload != null && payload.getAsset() != null) {
            return AtlanEventHandler.getCurrentViewOfAsset(client, payload.getAsset(), limitedToAttributes, includeMeanings, includeAtlanTags);
        }
        return null;
    }

    public static Asset getCurrentViewOfAsset(AtlanClient client, Asset fromEvent, Collection<String> limitedToAttributes, boolean includeMeanings, boolean includeAtlanTags) throws AtlanException {
        AtlanObject request = ((IndexSearchRequest.IndexSearchRequestBuilder)((IndexSearchRequest.IndexSearchRequestBuilder)((IndexSearchRequest.IndexSearchRequestBuilder)((IndexSearchRequest.IndexSearchRequestBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)client.assets.select().where(Asset.TYPE_NAME.eq(fromEvent.getTypeName()))).where(Asset.QUALIFIED_NAME.eq(fromEvent.getQualifiedName()))).includeOnResults(IGlossaryTerm.ANCHOR)).includeOnResults(IAWS.AWS_ARN)).includeOnRelations(IReferenceable.GUID)).includeOnRelations(Asset.NAME)).includeOnRelations(Asset.DESCRIPTION)).toRequestBuilder().excludeAtlanTags(!includeAtlanTags)).excludeMeanings(!includeMeanings)).allowDeletedRelations(false)).attributes(limitedToAttributes == null ? Collections.emptySet() : limitedToAttributes)).build();
        IndexSearchResponse response = ((IndexSearchRequest)request).search(client);
        if (response != null && response.getAssets() != null && !response.getAssets().isEmpty()) {
            return response.getAssets().get(0);
        }
        return null;
    }

    public static boolean hasDescription(Asset asset) {
        String description = asset.getUserDescription();
        if (description == null || description.isEmpty()) {
            description = asset.getDescription();
        }
        return description != null && !description.isEmpty();
    }

    public static boolean hasOwner(Asset asset) {
        SortedSet<String> ownerUsers = asset.getOwnerUsers();
        SortedSet<String> ownerGroups = asset.getOwnerGroups();
        return ownerUsers != null && !ownerUsers.isEmpty() || ownerGroups != null && !ownerGroups.isEmpty();
    }

    public static boolean hasAssignedTerms(Asset asset) {
        return asset.getAssignedTerms() != null && !asset.getAssignedTerms().isEmpty();
    }

    public static boolean hasAtlanTags(Asset asset) {
        return asset.getAtlanTags() != null && !asset.getAtlanTags().isEmpty();
    }

    public static boolean hasLineage(Asset asset) {
        if (asset instanceof ICatalog) {
            ICatalog details = (ICatalog)((Object)asset);
            SortedSet<ILineageProcess> downstream = details.getInputToProcesses();
            SortedSet<ILineageProcess> upstream = details.getOutputFromProcesses();
            return downstream != null && !downstream.isEmpty() || upstream != null && !upstream.isEmpty();
        }
        return asset.getHasLineage();
    }

    public static boolean hasReadme(Asset asset) {
        return asset.getReadme() != null && asset.getReadme().getDescription() != null && !asset.getReadme().getDescription().isEmpty();
    }
}

