/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.ADLSAccount;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IADLS;
import com.atlan.model.assets.IADLSAccount;
import com.atlan.model.assets.IADLSContainer;
import com.atlan.model.assets.IADLSObject;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAzure;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICloud;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IObjectStore;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.ADLSLeaseState;
import com.atlan.model.enums.ADLSLeaseStatus;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.AzureTag;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADLSContainer
extends Asset
implements IADLSContainer,
IADLS,
IObjectStore,
IAzure,
ICatalog,
IAsset,
IReferenceable,
ICloud {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ADLSContainer.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ADLSContainer";
    String typeName;
    @Attribute
    IADLSAccount adlsAccount;
    @Attribute
    String adlsAccountQualifiedName;
    @Attribute
    String adlsAccountSecondaryLocation;
    @Attribute
    String adlsContainerEncryptionScope;
    @Attribute
    ADLSLeaseState adlsContainerLeaseState;
    @Attribute
    ADLSLeaseStatus adlsContainerLeaseStatus;
    @Attribute
    String adlsContainerUrl;
    @Attribute
    Boolean adlsContainerVersionLevelImmutabilitySupport;
    @Attribute
    Integer adlsObjectCount;
    @Attribute
    SortedSet<IADLSObject> adlsObjects;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    String azureLocation;
    @Attribute
    String azureResourceId;
    @Attribute
    List<AzureTag> azureTags;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public ADLSContainer trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ADLSContainer.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ADLSContainer.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ADLSContainer.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return ADLSContainer.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ADLSContainer.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return ADLSContainer.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static ADLSContainer refByGuid(String guid) {
        return ADLSContainer.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static ADLSContainer refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ADLSContainerBuilder)((ADLSContainerBuilder)ADLSContainer._internal().guid(guid)).semantic(semantic)).build();
    }

    public static ADLSContainer refByQualifiedName(String qualifiedName) {
        return ADLSContainer.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static ADLSContainer refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ADLSContainerBuilder)((ADLSContainerBuilder)ADLSContainer._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static ADLSContainer get(String id) throws AtlanException {
        return ADLSContainer.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static ADLSContainer get(AtlanClient client, String id) throws AtlanException {
        return ADLSContainer.get(client, id, true);
    }

    @JsonIgnore
    public static ADLSContainer get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ADLSContainer) {
                return (ADLSContainer)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof ADLSContainer) {
            return (ADLSContainer)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return ADLSContainer.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ADLSContainerBuilder<?, ?> creator(String name, ADLSAccount account) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("connectionQualifiedName", account.getConnectionQualifiedName());
        map.put("qualifiedName", account.getQualifiedName());
        ADLSContainer.validateRelationship("ADLSAccount", map);
        return ADLSContainer.creator(name, account.getConnectionQualifiedName(), account.getQualifiedName()).adlsAccount(account.trimToReference());
    }

    public static ADLSContainerBuilder<?, ?> creator(String name, String accountQualifiedName) {
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(accountQualifiedName);
        return ADLSContainer.creator(name, connectionQualifiedName, accountQualifiedName);
    }

    public static ADLSContainerBuilder<?, ?> creator(String name, String connectionQualifiedName, String accountQualifiedName) {
        return (ADLSContainerBuilder)((ADLSContainerBuilder)((Asset.AssetBuilder)((ADLSContainerBuilder)((ADLSContainerBuilder)((ADLSContainerBuilder)((ADLSContainerBuilder)ADLSContainer._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(ADLSContainer.generateQualifiedName(name, accountQualifiedName))).name(name)).adlsAccount(ADLSAccount.refByQualifiedName(accountQualifiedName))).adlsAccountQualifiedName(accountQualifiedName)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.ADLS);
    }

    public static String generateQualifiedName(String name, String accountQualifiedName) {
        return accountQualifiedName + "/" + name;
    }

    public static ADLSContainerBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ADLSContainerBuilder)((ADLSContainerBuilder)((ADLSContainerBuilder)ADLSContainer._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ADLSContainerBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        ADLSContainer.validateRequired(TYPE_NAME, map);
        return ADLSContainer.updater(this.getQualifiedName(), this.getName());
    }

    public static ADLSContainer removeDescription(String qualifiedName, String name) throws AtlanException {
        return ADLSContainer.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSContainer removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSContainer)Asset.removeDescription(client, ADLSContainer.updater(qualifiedName, name));
    }

    public static ADLSContainer removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return ADLSContainer.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSContainer removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSContainer)Asset.removeUserDescription(client, ADLSContainer.updater(qualifiedName, name));
    }

    public static ADLSContainer removeOwners(String qualifiedName, String name) throws AtlanException {
        return ADLSContainer.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSContainer removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSContainer)Asset.removeOwners(client, ADLSContainer.updater(qualifiedName, name));
    }

    public static ADLSContainer updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return ADLSContainer.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static ADLSContainer updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ADLSContainer)Asset.updateCertificate(client, ADLSContainer._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ADLSContainer removeCertificate(String qualifiedName, String name) throws AtlanException {
        return ADLSContainer.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSContainer removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSContainer)Asset.removeCertificate(client, ADLSContainer.updater(qualifiedName, name));
    }

    public static ADLSContainer updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return ADLSContainer.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static ADLSContainer updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ADLSContainer)Asset.updateAnnouncement(client, ADLSContainer._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ADLSContainer removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return ADLSContainer.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSContainer removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSContainer)Asset.removeAnnouncement(client, ADLSContainer.updater(qualifiedName, name));
    }

    public static ADLSContainer replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return ADLSContainer.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static ADLSContainer replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSContainer)Asset.replaceTerms(client, ADLSContainer.updater(qualifiedName, name), terms);
    }

    public static ADLSContainer appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ADLSContainer.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ADLSContainer appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSContainer)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ADLSContainer removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ADLSContainer.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ADLSContainer removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSContainer)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ADLSContainer appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return ADLSContainer.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static ADLSContainer appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ADLSContainer)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static ADLSContainer appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return ADLSContainer.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static ADLSContainer appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ADLSContainer)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        ADLSContainer.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ADLSContainer(ADLSContainerBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ADLSContainer.$default$typeName();
        this.adlsAccount = b.adlsAccount;
        this.adlsAccountQualifiedName = b.adlsAccountQualifiedName;
        this.adlsAccountSecondaryLocation = b.adlsAccountSecondaryLocation;
        this.adlsContainerEncryptionScope = b.adlsContainerEncryptionScope;
        this.adlsContainerLeaseState = b.adlsContainerLeaseState;
        this.adlsContainerLeaseStatus = b.adlsContainerLeaseStatus;
        this.adlsContainerUrl = b.adlsContainerUrl;
        this.adlsContainerVersionLevelImmutabilitySupport = b.adlsContainerVersionLevelImmutabilitySupport;
        this.adlsObjectCount = b.adlsObjectCount;
        SortedSet<IADLSObject> adlsObjects = new TreeSet<IADLSObject>();
        if (b.adlsObjects != null) {
            adlsObjects.addAll(b.adlsObjects);
        }
        adlsObjects = Collections.unmodifiableSortedSet(adlsObjects);
        this.adlsObjects = adlsObjects;
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        this.azureLocation = b.azureLocation;
        this.azureResourceId = b.azureResourceId;
        this.azureTags = switch (b.azureTags == null ? 0 : b.azureTags.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.azureTags.get(0));
            default -> Collections.unmodifiableList(new ArrayList<AzureTag>(b.azureTags));
        };
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static ADLSContainerBuilder<?, ?> _internal() {
        return new ADLSContainerBuilderImpl();
    }

    @Generated
    public ADLSContainerBuilder<?, ?> toBuilder() {
        return new ADLSContainerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IADLSAccount getAdlsAccount() {
        return this.adlsAccount;
    }

    @Override
    @Generated
    public String getAdlsAccountQualifiedName() {
        return this.adlsAccountQualifiedName;
    }

    @Override
    @Generated
    public String getAdlsAccountSecondaryLocation() {
        return this.adlsAccountSecondaryLocation;
    }

    @Override
    @Generated
    public String getAdlsContainerEncryptionScope() {
        return this.adlsContainerEncryptionScope;
    }

    @Override
    @Generated
    public ADLSLeaseState getAdlsContainerLeaseState() {
        return this.adlsContainerLeaseState;
    }

    @Override
    @Generated
    public ADLSLeaseStatus getAdlsContainerLeaseStatus() {
        return this.adlsContainerLeaseStatus;
    }

    @Override
    @Generated
    public String getAdlsContainerUrl() {
        return this.adlsContainerUrl;
    }

    @Override
    @Generated
    public Boolean getAdlsContainerVersionLevelImmutabilitySupport() {
        return this.adlsContainerVersionLevelImmutabilitySupport;
    }

    @Override
    @Generated
    public Integer getAdlsObjectCount() {
        return this.adlsObjectCount;
    }

    @Override
    @Generated
    public SortedSet<IADLSObject> getAdlsObjects() {
        return this.adlsObjects;
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public String getAzureLocation() {
        return this.azureLocation;
    }

    @Override
    @Generated
    public String getAzureResourceId() {
        return this.azureResourceId;
    }

    @Override
    @Generated
    public List<AzureTag> getAzureTags() {
        return this.azureTags;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ADLSContainer)) {
            return false;
        }
        ADLSContainer other = (ADLSContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$adlsContainerVersionLevelImmutabilitySupport = this.getAdlsContainerVersionLevelImmutabilitySupport();
        Boolean other$adlsContainerVersionLevelImmutabilitySupport = other.getAdlsContainerVersionLevelImmutabilitySupport();
        if (this$adlsContainerVersionLevelImmutabilitySupport == null ? other$adlsContainerVersionLevelImmutabilitySupport != null : !((Object)this$adlsContainerVersionLevelImmutabilitySupport).equals(other$adlsContainerVersionLevelImmutabilitySupport)) {
            return false;
        }
        Integer this$adlsObjectCount = this.getAdlsObjectCount();
        Integer other$adlsObjectCount = other.getAdlsObjectCount();
        if (this$adlsObjectCount == null ? other$adlsObjectCount != null : !((Object)this$adlsObjectCount).equals(other$adlsObjectCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IADLSAccount this$adlsAccount = this.getAdlsAccount();
        IADLSAccount other$adlsAccount = other.getAdlsAccount();
        if (this$adlsAccount == null ? other$adlsAccount != null : !this$adlsAccount.equals(other$adlsAccount)) {
            return false;
        }
        String this$adlsAccountQualifiedName = this.getAdlsAccountQualifiedName();
        String other$adlsAccountQualifiedName = other.getAdlsAccountQualifiedName();
        if (this$adlsAccountQualifiedName == null ? other$adlsAccountQualifiedName != null : !this$adlsAccountQualifiedName.equals(other$adlsAccountQualifiedName)) {
            return false;
        }
        String this$adlsAccountSecondaryLocation = this.getAdlsAccountSecondaryLocation();
        String other$adlsAccountSecondaryLocation = other.getAdlsAccountSecondaryLocation();
        if (this$adlsAccountSecondaryLocation == null ? other$adlsAccountSecondaryLocation != null : !this$adlsAccountSecondaryLocation.equals(other$adlsAccountSecondaryLocation)) {
            return false;
        }
        String this$adlsContainerEncryptionScope = this.getAdlsContainerEncryptionScope();
        String other$adlsContainerEncryptionScope = other.getAdlsContainerEncryptionScope();
        if (this$adlsContainerEncryptionScope == null ? other$adlsContainerEncryptionScope != null : !this$adlsContainerEncryptionScope.equals(other$adlsContainerEncryptionScope)) {
            return false;
        }
        ADLSLeaseState this$adlsContainerLeaseState = this.getAdlsContainerLeaseState();
        ADLSLeaseState other$adlsContainerLeaseState = other.getAdlsContainerLeaseState();
        if (this$adlsContainerLeaseState == null ? other$adlsContainerLeaseState != null : !this$adlsContainerLeaseState.equals(other$adlsContainerLeaseState)) {
            return false;
        }
        ADLSLeaseStatus this$adlsContainerLeaseStatus = this.getAdlsContainerLeaseStatus();
        ADLSLeaseStatus other$adlsContainerLeaseStatus = other.getAdlsContainerLeaseStatus();
        if (this$adlsContainerLeaseStatus == null ? other$adlsContainerLeaseStatus != null : !this$adlsContainerLeaseStatus.equals(other$adlsContainerLeaseStatus)) {
            return false;
        }
        String this$adlsContainerUrl = this.getAdlsContainerUrl();
        String other$adlsContainerUrl = other.getAdlsContainerUrl();
        if (this$adlsContainerUrl == null ? other$adlsContainerUrl != null : !this$adlsContainerUrl.equals(other$adlsContainerUrl)) {
            return false;
        }
        SortedSet<IADLSObject> this$adlsObjects = this.getAdlsObjects();
        SortedSet<IADLSObject> other$adlsObjects = other.getAdlsObjects();
        if (this$adlsObjects == null ? other$adlsObjects != null : !this$adlsObjects.equals(other$adlsObjects)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        String this$azureLocation = this.getAzureLocation();
        String other$azureLocation = other.getAzureLocation();
        if (this$azureLocation == null ? other$azureLocation != null : !this$azureLocation.equals(other$azureLocation)) {
            return false;
        }
        String this$azureResourceId = this.getAzureResourceId();
        String other$azureResourceId = other.getAzureResourceId();
        if (this$azureResourceId == null ? other$azureResourceId != null : !this$azureResourceId.equals(other$azureResourceId)) {
            return false;
        }
        List<AzureTag> this$azureTags = this.getAzureTags();
        List<AzureTag> other$azureTags = other.getAzureTags();
        if (this$azureTags == null ? other$azureTags != null : !((Object)this$azureTags).equals(other$azureTags)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ADLSContainer;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $adlsContainerVersionLevelImmutabilitySupport = this.getAdlsContainerVersionLevelImmutabilitySupport();
        result = result * 59 + ($adlsContainerVersionLevelImmutabilitySupport == null ? 43 : ((Object)$adlsContainerVersionLevelImmutabilitySupport).hashCode());
        Integer $adlsObjectCount = this.getAdlsObjectCount();
        result = result * 59 + ($adlsObjectCount == null ? 43 : ((Object)$adlsObjectCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IADLSAccount $adlsAccount = this.getAdlsAccount();
        result = result * 59 + ($adlsAccount == null ? 43 : $adlsAccount.hashCode());
        String $adlsAccountQualifiedName = this.getAdlsAccountQualifiedName();
        result = result * 59 + ($adlsAccountQualifiedName == null ? 43 : $adlsAccountQualifiedName.hashCode());
        String $adlsAccountSecondaryLocation = this.getAdlsAccountSecondaryLocation();
        result = result * 59 + ($adlsAccountSecondaryLocation == null ? 43 : $adlsAccountSecondaryLocation.hashCode());
        String $adlsContainerEncryptionScope = this.getAdlsContainerEncryptionScope();
        result = result * 59 + ($adlsContainerEncryptionScope == null ? 43 : $adlsContainerEncryptionScope.hashCode());
        ADLSLeaseState $adlsContainerLeaseState = this.getAdlsContainerLeaseState();
        result = result * 59 + ($adlsContainerLeaseState == null ? 43 : $adlsContainerLeaseState.hashCode());
        ADLSLeaseStatus $adlsContainerLeaseStatus = this.getAdlsContainerLeaseStatus();
        result = result * 59 + ($adlsContainerLeaseStatus == null ? 43 : $adlsContainerLeaseStatus.hashCode());
        String $adlsContainerUrl = this.getAdlsContainerUrl();
        result = result * 59 + ($adlsContainerUrl == null ? 43 : $adlsContainerUrl.hashCode());
        SortedSet<IADLSObject> $adlsObjects = this.getAdlsObjects();
        result = result * 59 + ($adlsObjects == null ? 43 : $adlsObjects.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        String $azureLocation = this.getAzureLocation();
        result = result * 59 + ($azureLocation == null ? 43 : $azureLocation.hashCode());
        String $azureResourceId = this.getAzureResourceId();
        result = result * 59 + ($azureResourceId == null ? 43 : $azureResourceId.hashCode());
        List<AzureTag> $azureTags = this.getAzureTags();
        result = result * 59 + ($azureTags == null ? 43 : ((Object)$azureTags).hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ADLSContainer(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", adlsAccount=" + this.getAdlsAccount() + ", adlsAccountQualifiedName=" + this.getAdlsAccountQualifiedName() + ", adlsAccountSecondaryLocation=" + this.getAdlsAccountSecondaryLocation() + ", adlsContainerEncryptionScope=" + this.getAdlsContainerEncryptionScope() + ", adlsContainerLeaseState=" + this.getAdlsContainerLeaseState() + ", adlsContainerLeaseStatus=" + this.getAdlsContainerLeaseStatus() + ", adlsContainerUrl=" + this.getAdlsContainerUrl() + ", adlsContainerVersionLevelImmutabilitySupport=" + this.getAdlsContainerVersionLevelImmutabilitySupport() + ", adlsObjectCount=" + this.getAdlsObjectCount() + ", adlsObjects=" + this.getAdlsObjects() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", azureLocation=" + this.getAzureLocation() + ", azureResourceId=" + this.getAzureResourceId() + ", azureTags=" + this.getAzureTags() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class ADLSContainerBuilder<C extends ADLSContainer, B extends ADLSContainerBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IADLSAccount adlsAccount;
        @Generated
        private String adlsAccountQualifiedName;
        @Generated
        private String adlsAccountSecondaryLocation;
        @Generated
        private String adlsContainerEncryptionScope;
        @Generated
        private ADLSLeaseState adlsContainerLeaseState;
        @Generated
        private ADLSLeaseStatus adlsContainerLeaseStatus;
        @Generated
        private String adlsContainerUrl;
        @Generated
        private Boolean adlsContainerVersionLevelImmutabilitySupport;
        @Generated
        private Integer adlsObjectCount;
        @Generated
        private ArrayList<IADLSObject> adlsObjects;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private String azureLocation;
        @Generated
        private String azureResourceId;
        @Generated
        private ArrayList<AzureTag> azureTags;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ADLSContainerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ADLSContainer instance, ADLSContainerBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.adlsAccount(instance.adlsAccount);
            b.adlsAccountQualifiedName(instance.adlsAccountQualifiedName);
            b.adlsAccountSecondaryLocation(instance.adlsAccountSecondaryLocation);
            b.adlsContainerEncryptionScope(instance.adlsContainerEncryptionScope);
            b.adlsContainerLeaseState(instance.adlsContainerLeaseState);
            b.adlsContainerLeaseStatus(instance.adlsContainerLeaseStatus);
            b.adlsContainerUrl(instance.adlsContainerUrl);
            b.adlsContainerVersionLevelImmutabilitySupport(instance.adlsContainerVersionLevelImmutabilitySupport);
            b.adlsObjectCount(instance.adlsObjectCount);
            b.adlsObjects(instance.adlsObjects == null ? Collections.emptySortedSet() : instance.adlsObjects);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.azureLocation(instance.azureLocation);
            b.azureResourceId(instance.azureResourceId);
            b.azureTags(instance.azureTags == null ? Collections.emptyList() : instance.azureTags);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B adlsAccount(IADLSAccount adlsAccount) {
            this.adlsAccount = adlsAccount;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountQualifiedName(String adlsAccountQualifiedName) {
            this.adlsAccountQualifiedName = adlsAccountQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountSecondaryLocation(String adlsAccountSecondaryLocation) {
            this.adlsAccountSecondaryLocation = adlsAccountSecondaryLocation;
            return (B)this.self();
        }

        @Generated
        public B adlsContainerEncryptionScope(String adlsContainerEncryptionScope) {
            this.adlsContainerEncryptionScope = adlsContainerEncryptionScope;
            return (B)this.self();
        }

        @Generated
        public B adlsContainerLeaseState(ADLSLeaseState adlsContainerLeaseState) {
            this.adlsContainerLeaseState = adlsContainerLeaseState;
            return (B)this.self();
        }

        @Generated
        public B adlsContainerLeaseStatus(ADLSLeaseStatus adlsContainerLeaseStatus) {
            this.adlsContainerLeaseStatus = adlsContainerLeaseStatus;
            return (B)this.self();
        }

        @Generated
        public B adlsContainerUrl(String adlsContainerUrl) {
            this.adlsContainerUrl = adlsContainerUrl;
            return (B)this.self();
        }

        @Generated
        public B adlsContainerVersionLevelImmutabilitySupport(Boolean adlsContainerVersionLevelImmutabilitySupport) {
            this.adlsContainerVersionLevelImmutabilitySupport = adlsContainerVersionLevelImmutabilitySupport;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectCount(Integer adlsObjectCount) {
            this.adlsObjectCount = adlsObjectCount;
            return (B)this.self();
        }

        @Generated
        public B adlsObject(IADLSObject adlsObject) {
            if (this.adlsObjects == null) {
                this.adlsObjects = new ArrayList();
            }
            this.adlsObjects.add(adlsObject);
            return (B)this.self();
        }

        @Generated
        public B adlsObjects(Collection<? extends IADLSObject> adlsObjects) {
            if (adlsObjects == null) {
                throw new NullPointerException("adlsObjects cannot be null");
            }
            if (this.adlsObjects == null) {
                this.adlsObjects = new ArrayList();
            }
            this.adlsObjects.addAll(adlsObjects);
            return (B)this.self();
        }

        @Generated
        public B clearAdlsObjects() {
            if (this.adlsObjects != null) {
                this.adlsObjects.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B azureLocation(String azureLocation) {
            this.azureLocation = azureLocation;
            return (B)this.self();
        }

        @Generated
        public B azureResourceId(String azureResourceId) {
            this.azureResourceId = azureResourceId;
            return (B)this.self();
        }

        @Generated
        public B azureTag(AzureTag azureTag) {
            if (this.azureTags == null) {
                this.azureTags = new ArrayList();
            }
            this.azureTags.add(azureTag);
            return (B)this.self();
        }

        @Generated
        public B azureTags(Collection<? extends AzureTag> azureTags) {
            if (azureTags == null) {
                throw new NullPointerException("azureTags cannot be null");
            }
            if (this.azureTags == null) {
                this.azureTags = new ArrayList();
            }
            this.azureTags.addAll(azureTags);
            return (B)this.self();
        }

        @Generated
        public B clearAzureTags() {
            if (this.azureTags != null) {
                this.azureTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ADLSContainer.ADLSContainerBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", adlsAccount=" + this.adlsAccount + ", adlsAccountQualifiedName=" + this.adlsAccountQualifiedName + ", adlsAccountSecondaryLocation=" + this.adlsAccountSecondaryLocation + ", adlsContainerEncryptionScope=" + this.adlsContainerEncryptionScope + ", adlsContainerLeaseState=" + this.adlsContainerLeaseState + ", adlsContainerLeaseStatus=" + this.adlsContainerLeaseStatus + ", adlsContainerUrl=" + this.adlsContainerUrl + ", adlsContainerVersionLevelImmutabilitySupport=" + this.adlsContainerVersionLevelImmutabilitySupport + ", adlsObjectCount=" + this.adlsObjectCount + ", adlsObjects=" + this.adlsObjects + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", azureLocation=" + this.azureLocation + ", azureResourceId=" + this.azureResourceId + ", azureTags=" + this.azureTags + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class ADLSContainerBuilderImpl
    extends ADLSContainerBuilder<ADLSContainer, ADLSContainerBuilderImpl> {
        @Generated
        private ADLSContainerBuilderImpl() {
        }

        @Override
        @Generated
        protected ADLSContainerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ADLSContainer build() {
            return new ADLSContainer(this);
        }
    }
}

