/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAuthService;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthService
extends Asset
implements IAuthService,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthService.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AuthService";
    String typeName;
    @Attribute
    Map<String, String> authServiceConfig;
    @Attribute
    Boolean authServiceIsEnabled;
    @Attribute
    Long authServicePolicyLastSync;
    @Attribute
    String authServiceType;
    @Attribute
    String tagService;

    @Override
    public AuthService trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AuthService.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AuthService.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AuthService.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return AuthService.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AuthService.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return AuthService.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AuthService refByGuid(String guid) {
        return AuthService.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AuthService refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AuthServiceBuilder)((AuthServiceBuilder)AuthService._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AuthService refByQualifiedName(String qualifiedName) {
        return AuthService.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AuthService refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AuthServiceBuilder)((AuthServiceBuilder)AuthService._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AuthService get(String id) throws AtlanException {
        return AuthService.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static AuthService get(AtlanClient client, String id) throws AtlanException {
        return AuthService.get(client, id, true);
    }

    @JsonIgnore
    public static AuthService get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AuthService) {
                return (AuthService)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof AuthService) {
            return (AuthService)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return AuthService.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AuthServiceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AuthServiceBuilder)((AuthServiceBuilder)((AuthServiceBuilder)AuthService._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AuthServiceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AuthService.validateRequired(TYPE_NAME, map);
        return AuthService.updater(this.getQualifiedName(), this.getName());
    }

    public static AuthService removeDescription(String qualifiedName, String name) throws AtlanException {
        return AuthService.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static AuthService removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AuthService)Asset.removeDescription(client, AuthService.updater(qualifiedName, name));
    }

    public static AuthService removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return AuthService.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static AuthService removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AuthService)Asset.removeUserDescription(client, AuthService.updater(qualifiedName, name));
    }

    public static AuthService removeOwners(String qualifiedName, String name) throws AtlanException {
        return AuthService.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static AuthService removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AuthService)Asset.removeOwners(client, AuthService.updater(qualifiedName, name));
    }

    public static AuthService updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return AuthService.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static AuthService updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AuthService)Asset.updateCertificate(client, AuthService._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AuthService removeCertificate(String qualifiedName, String name) throws AtlanException {
        return AuthService.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static AuthService removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AuthService)Asset.removeCertificate(client, AuthService.updater(qualifiedName, name));
    }

    public static AuthService updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return AuthService.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static AuthService updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AuthService)Asset.updateAnnouncement(client, AuthService._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AuthService removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return AuthService.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static AuthService removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AuthService)Asset.removeAnnouncement(client, AuthService.updater(qualifiedName, name));
    }

    public static AuthService replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return AuthService.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static AuthService replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AuthService)Asset.replaceTerms(client, AuthService.updater(qualifiedName, name), terms);
    }

    public static AuthService appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return AuthService.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static AuthService appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AuthService)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AuthService removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return AuthService.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static AuthService removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AuthService)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static AuthService appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return AuthService.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static AuthService appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AuthService)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static AuthService appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return AuthService.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static AuthService appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AuthService)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        AuthService.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AuthService(AuthServiceBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> authServiceConfig;
        this.typeName = b.typeName$set ? b.typeName$value : AuthService.$default$typeName();
        switch (b.authServiceConfig$key == null ? 0 : b.authServiceConfig$key.size()) {
            case 0: {
                authServiceConfig = Collections.emptyMap();
                break;
            }
            case 1: {
                authServiceConfig = Collections.singletonMap(b.authServiceConfig$key.get(0), b.authServiceConfig$value.get(0));
                break;
            }
            default: {
                authServiceConfig = new LinkedHashMap(b.authServiceConfig$key.size() < 0x40000000 ? 1 + b.authServiceConfig$key.size() + (b.authServiceConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.authServiceConfig$key.size(); ++$i) {
                    authServiceConfig.put(b.authServiceConfig$key.get($i), b.authServiceConfig$value.get($i));
                }
                authServiceConfig = Collections.unmodifiableMap(authServiceConfig);
            }
        }
        this.authServiceConfig = authServiceConfig;
        this.authServiceIsEnabled = b.authServiceIsEnabled;
        this.authServicePolicyLastSync = b.authServicePolicyLastSync;
        this.authServiceType = b.authServiceType;
        this.tagService = b.tagService;
    }

    @Generated
    public static AuthServiceBuilder<?, ?> _internal() {
        return new AuthServiceBuilderImpl();
    }

    @Generated
    public AuthServiceBuilder<?, ?> toBuilder() {
        return new AuthServiceBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Map<String, String> getAuthServiceConfig() {
        return this.authServiceConfig;
    }

    @Override
    @Generated
    public Boolean getAuthServiceIsEnabled() {
        return this.authServiceIsEnabled;
    }

    @Override
    @Generated
    public Long getAuthServicePolicyLastSync() {
        return this.authServicePolicyLastSync;
    }

    @Override
    @Generated
    public String getAuthServiceType() {
        return this.authServiceType;
    }

    @Override
    @Generated
    public String getTagService() {
        return this.tagService;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthService)) {
            return false;
        }
        AuthService other = (AuthService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$authServiceIsEnabled = this.getAuthServiceIsEnabled();
        Boolean other$authServiceIsEnabled = other.getAuthServiceIsEnabled();
        if (this$authServiceIsEnabled == null ? other$authServiceIsEnabled != null : !((Object)this$authServiceIsEnabled).equals(other$authServiceIsEnabled)) {
            return false;
        }
        Long this$authServicePolicyLastSync = this.getAuthServicePolicyLastSync();
        Long other$authServicePolicyLastSync = other.getAuthServicePolicyLastSync();
        if (this$authServicePolicyLastSync == null ? other$authServicePolicyLastSync != null : !((Object)this$authServicePolicyLastSync).equals(other$authServicePolicyLastSync)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        Map<String, String> this$authServiceConfig = this.getAuthServiceConfig();
        Map<String, String> other$authServiceConfig = other.getAuthServiceConfig();
        if (this$authServiceConfig == null ? other$authServiceConfig != null : !((Object)this$authServiceConfig).equals(other$authServiceConfig)) {
            return false;
        }
        String this$authServiceType = this.getAuthServiceType();
        String other$authServiceType = other.getAuthServiceType();
        if (this$authServiceType == null ? other$authServiceType != null : !this$authServiceType.equals(other$authServiceType)) {
            return false;
        }
        String this$tagService = this.getTagService();
        String other$tagService = other.getTagService();
        return !(this$tagService == null ? other$tagService != null : !this$tagService.equals(other$tagService));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthService;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $authServiceIsEnabled = this.getAuthServiceIsEnabled();
        result = result * 59 + ($authServiceIsEnabled == null ? 43 : ((Object)$authServiceIsEnabled).hashCode());
        Long $authServicePolicyLastSync = this.getAuthServicePolicyLastSync();
        result = result * 59 + ($authServicePolicyLastSync == null ? 43 : ((Object)$authServicePolicyLastSync).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        Map<String, String> $authServiceConfig = this.getAuthServiceConfig();
        result = result * 59 + ($authServiceConfig == null ? 43 : ((Object)$authServiceConfig).hashCode());
        String $authServiceType = this.getAuthServiceType();
        result = result * 59 + ($authServiceType == null ? 43 : $authServiceType.hashCode());
        String $tagService = this.getTagService();
        result = result * 59 + ($tagService == null ? 43 : $tagService.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AuthService(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", authServiceConfig=" + this.getAuthServiceConfig() + ", authServiceIsEnabled=" + this.getAuthServiceIsEnabled() + ", authServicePolicyLastSync=" + this.getAuthServicePolicyLastSync() + ", authServiceType=" + this.getAuthServiceType() + ", tagService=" + this.getTagService() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class AuthServiceBuilder<C extends AuthService, B extends AuthServiceBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<String> authServiceConfig$key;
        @Generated
        private ArrayList<String> authServiceConfig$value;
        @Generated
        private Boolean authServiceIsEnabled;
        @Generated
        private Long authServicePolicyLastSync;
        @Generated
        private String authServiceType;
        @Generated
        private String tagService;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AuthServiceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AuthService instance, AuthServiceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.authServiceConfig(instance.authServiceConfig == null ? Collections.emptyMap() : instance.authServiceConfig);
            b.authServiceIsEnabled(instance.authServiceIsEnabled);
            b.authServicePolicyLastSync(instance.authServicePolicyLastSync);
            b.authServiceType(instance.authServiceType);
            b.tagService(instance.tagService);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B putAuthServiceConfig(String putAuthServiceConfigKey, String putAuthServiceConfigValue) {
            if (this.authServiceConfig$key == null) {
                this.authServiceConfig$key = new ArrayList();
                this.authServiceConfig$value = new ArrayList();
            }
            this.authServiceConfig$key.add(putAuthServiceConfigKey);
            this.authServiceConfig$value.add(putAuthServiceConfigValue);
            return (B)this.self();
        }

        @Generated
        public B authServiceConfig(Map<? extends String, ? extends String> authServiceConfig) {
            if (authServiceConfig == null) {
                throw new NullPointerException("authServiceConfig cannot be null");
            }
            if (this.authServiceConfig$key == null) {
                this.authServiceConfig$key = new ArrayList();
                this.authServiceConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : authServiceConfig.entrySet()) {
                this.authServiceConfig$key.add($lombokEntry.getKey());
                this.authServiceConfig$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearAuthServiceConfig() {
            if (this.authServiceConfig$key != null) {
                this.authServiceConfig$key.clear();
                this.authServiceConfig$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B authServiceIsEnabled(Boolean authServiceIsEnabled) {
            this.authServiceIsEnabled = authServiceIsEnabled;
            return (B)this.self();
        }

        @Generated
        public B authServicePolicyLastSync(Long authServicePolicyLastSync) {
            this.authServicePolicyLastSync = authServicePolicyLastSync;
            return (B)this.self();
        }

        @Generated
        public B authServiceType(String authServiceType) {
            this.authServiceType = authServiceType;
            return (B)this.self();
        }

        @Generated
        public B tagService(String tagService) {
            this.tagService = tagService;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AuthService.AuthServiceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", authServiceConfig$key=" + this.authServiceConfig$key + ", authServiceConfig$value=" + this.authServiceConfig$value + ", authServiceIsEnabled=" + this.authServiceIsEnabled + ", authServicePolicyLastSync=" + this.authServicePolicyLastSync + ", authServiceType=" + this.authServiceType + ", tagService=" + this.tagService + ")";
        }
    }

    @Generated
    private static final class AuthServiceBuilderImpl
    extends AuthServiceBuilder<AuthService, AuthServiceBuilderImpl> {
        @Generated
        private AuthServiceBuilderImpl() {
        }

        @Override
        @Generated
        protected AuthServiceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AuthService build() {
            return new AuthService(this);
        }
    }
}

