/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBadge;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.BadgeCondition;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Badge
extends Asset
implements IBadge,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Badge.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Badge";
    String typeName;
    @Attribute
    List<BadgeCondition> badgeConditions;
    @Attribute
    String badgeMetadataAttribute;

    @Override
    public Badge trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Badge.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Badge.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Badge.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return Badge.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Badge.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return Badge.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Badge refByGuid(String guid) {
        return Badge.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Badge refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((BadgeBuilder)((BadgeBuilder)Badge._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Badge refByQualifiedName(String qualifiedName) {
        return Badge.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Badge refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((BadgeBuilder)((BadgeBuilder)Badge._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Badge get(String id) throws AtlanException {
        return Badge.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static Badge get(AtlanClient client, String id) throws AtlanException {
        return Badge.get(client, id, true);
    }

    @JsonIgnore
    public static Badge get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Badge) {
                return (Badge)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof Badge) {
            return (Badge)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Badge.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static BadgeBuilder<?, ?> creator(String name, String cmName, String cmAttribute) throws AtlanException {
        return Badge.creator(Atlan.getDefaultClient(), name, cmName, cmAttribute);
    }

    public static BadgeBuilder<?, ?> creator(AtlanClient client, String name, String cmName, String cmAttribute) throws AtlanException {
        String cmId = client.getCustomMetadataCache().getIdForName(cmName);
        String cmAttrId = client.getCustomMetadataCache().getAttrIdForName(cmName, cmAttribute);
        return ((BadgeBuilder)((BadgeBuilder)((BadgeBuilder)Badge._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(Badge.generateQualifiedName(client, cmName, cmAttribute))).name(name)).badgeMetadataAttribute(cmId + "." + cmAttrId);
    }

    public static String generateQualifiedName(String cmName, String cmAttribute) throws AtlanException {
        return Badge.generateQualifiedName(Atlan.getDefaultClient(), cmName, cmAttribute);
    }

    public static String generateQualifiedName(AtlanClient client, String cmName, String cmAttribute) throws AtlanException {
        String cmId = client.getCustomMetadataCache().getIdForName(cmName);
        String cmAttrId = client.getCustomMetadataCache().getAttrIdForName(cmName, cmAttribute);
        return "badges/global/" + cmId + "." + cmAttrId;
    }

    public static BadgeBuilder<?, ?> updater(String qualifiedName, String name) {
        return (BadgeBuilder)((BadgeBuilder)((BadgeBuilder)Badge._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public BadgeBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        Badge.validateRequired(TYPE_NAME, map);
        return Badge.updater(this.getQualifiedName(), this.getName());
    }

    public static Badge removeDescription(String qualifiedName, String name) throws AtlanException {
        return Badge.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Badge removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Badge)Asset.removeDescription(client, Badge.updater(qualifiedName, name));
    }

    public static Badge removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return Badge.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Badge removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Badge)Asset.removeUserDescription(client, Badge.updater(qualifiedName, name));
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Badge(BadgeBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Badge.$default$typeName();
        this.badgeConditions = switch (b.badgeConditions == null ? 0 : b.badgeConditions.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.badgeConditions.get(0));
            default -> Collections.unmodifiableList(new ArrayList<BadgeCondition>(b.badgeConditions));
        };
        this.badgeMetadataAttribute = b.badgeMetadataAttribute;
    }

    @Generated
    public static BadgeBuilder<?, ?> _internal() {
        return new BadgeBuilderImpl();
    }

    @Generated
    public BadgeBuilder<?, ?> toBuilder() {
        return new BadgeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public List<BadgeCondition> getBadgeConditions() {
        return this.badgeConditions;
    }

    @Override
    @Generated
    public String getBadgeMetadataAttribute() {
        return this.badgeMetadataAttribute;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Badge)) {
            return false;
        }
        Badge other = (Badge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        List<BadgeCondition> this$badgeConditions = this.getBadgeConditions();
        List<BadgeCondition> other$badgeConditions = other.getBadgeConditions();
        if (this$badgeConditions == null ? other$badgeConditions != null : !((Object)this$badgeConditions).equals(other$badgeConditions)) {
            return false;
        }
        String this$badgeMetadataAttribute = this.getBadgeMetadataAttribute();
        String other$badgeMetadataAttribute = other.getBadgeMetadataAttribute();
        return !(this$badgeMetadataAttribute == null ? other$badgeMetadataAttribute != null : !this$badgeMetadataAttribute.equals(other$badgeMetadataAttribute));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Badge;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        List<BadgeCondition> $badgeConditions = this.getBadgeConditions();
        result = result * 59 + ($badgeConditions == null ? 43 : ((Object)$badgeConditions).hashCode());
        String $badgeMetadataAttribute = this.getBadgeMetadataAttribute();
        result = result * 59 + ($badgeMetadataAttribute == null ? 43 : $badgeMetadataAttribute.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Badge(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", badgeConditions=" + this.getBadgeConditions() + ", badgeMetadataAttribute=" + this.getBadgeMetadataAttribute() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class BadgeBuilder<C extends Badge, B extends BadgeBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<BadgeCondition> badgeConditions;
        @Generated
        private String badgeMetadataAttribute;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BadgeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Badge instance, BadgeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.badgeConditions(instance.badgeConditions == null ? Collections.emptyList() : instance.badgeConditions);
            b.badgeMetadataAttribute(instance.badgeMetadataAttribute);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B badgeCondition(BadgeCondition badgeCondition) {
            if (this.badgeConditions == null) {
                this.badgeConditions = new ArrayList();
            }
            this.badgeConditions.add(badgeCondition);
            return (B)this.self();
        }

        @Generated
        public B badgeConditions(Collection<? extends BadgeCondition> badgeConditions) {
            if (badgeConditions == null) {
                throw new NullPointerException("badgeConditions cannot be null");
            }
            if (this.badgeConditions == null) {
                this.badgeConditions = new ArrayList();
            }
            this.badgeConditions.addAll(badgeConditions);
            return (B)this.self();
        }

        @Generated
        public B clearBadgeConditions() {
            if (this.badgeConditions != null) {
                this.badgeConditions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B badgeMetadataAttribute(String badgeMetadataAttribute) {
            this.badgeMetadataAttribute = badgeMetadataAttribute;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Badge.BadgeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", badgeConditions=" + this.badgeConditions + ", badgeMetadataAttribute=" + this.badgeMetadataAttribute + ")";
        }
    }

    @Generated
    private static final class BadgeBuilderImpl
    extends BadgeBuilder<Badge, BadgeBuilderImpl> {
        @Generated
        private BadgeBuilderImpl() {
        }

        @Override
        @Generated
        protected BadgeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Badge build() {
            return new Badge(this);
        }
    }
}

