/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBusinessPolicyLog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessPolicyLog
extends Asset
implements IBusinessPolicyLog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessPolicyLog.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "BusinessPolicyLog";
    String typeName;
    @Attribute
    String businessPolicyId;
    @Attribute
    String businessPolicyLogPolicyType;
    @Attribute
    Long compliantAssetsCount;
    @Attribute
    Long governedAssetsCount;
    @Attribute
    Long nonCompliantAssetsCount;
    @Attribute
    Long nonGovernedAssetsCount;

    @Override
    public BusinessPolicyLog trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return BusinessPolicyLog.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return BusinessPolicyLog.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return BusinessPolicyLog.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return BusinessPolicyLog.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return BusinessPolicyLog.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return BusinessPolicyLog.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static BusinessPolicyLog refByGuid(String guid) {
        return BusinessPolicyLog.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static BusinessPolicyLog refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((BusinessPolicyLogBuilder)((BusinessPolicyLogBuilder)BusinessPolicyLog._internal().guid(guid)).semantic(semantic)).build();
    }

    public static BusinessPolicyLog refByQualifiedName(String qualifiedName) {
        return BusinessPolicyLog.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static BusinessPolicyLog refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((BusinessPolicyLogBuilder)((BusinessPolicyLogBuilder)BusinessPolicyLog._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static BusinessPolicyLog get(String id) throws AtlanException {
        return BusinessPolicyLog.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static BusinessPolicyLog get(AtlanClient client, String id) throws AtlanException {
        return BusinessPolicyLog.get(client, id, true);
    }

    @JsonIgnore
    public static BusinessPolicyLog get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof BusinessPolicyLog) {
                return (BusinessPolicyLog)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof BusinessPolicyLog) {
            return (BusinessPolicyLog)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return BusinessPolicyLog.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static BusinessPolicyLogBuilder<?, ?> updater(String qualifiedName, String name) {
        return (BusinessPolicyLogBuilder)((BusinessPolicyLogBuilder)((BusinessPolicyLogBuilder)BusinessPolicyLog._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public BusinessPolicyLogBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        BusinessPolicyLog.validateRequired(TYPE_NAME, map);
        return BusinessPolicyLog.updater(this.getQualifiedName(), this.getName());
    }

    public static BusinessPolicyLog removeDescription(String qualifiedName, String name) throws AtlanException {
        return BusinessPolicyLog.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BusinessPolicyLog removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyLog)Asset.removeDescription(client, BusinessPolicyLog.updater(qualifiedName, name));
    }

    public static BusinessPolicyLog removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return BusinessPolicyLog.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BusinessPolicyLog removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyLog)Asset.removeUserDescription(client, BusinessPolicyLog.updater(qualifiedName, name));
    }

    public static BusinessPolicyLog removeOwners(String qualifiedName, String name) throws AtlanException {
        return BusinessPolicyLog.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BusinessPolicyLog removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyLog)Asset.removeOwners(client, BusinessPolicyLog.updater(qualifiedName, name));
    }

    public static BusinessPolicyLog updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return BusinessPolicyLog.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static BusinessPolicyLog updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (BusinessPolicyLog)Asset.updateCertificate(client, BusinessPolicyLog._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static BusinessPolicyLog removeCertificate(String qualifiedName, String name) throws AtlanException {
        return BusinessPolicyLog.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BusinessPolicyLog removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyLog)Asset.removeCertificate(client, BusinessPolicyLog.updater(qualifiedName, name));
    }

    public static BusinessPolicyLog updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return BusinessPolicyLog.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static BusinessPolicyLog updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (BusinessPolicyLog)Asset.updateAnnouncement(client, BusinessPolicyLog._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static BusinessPolicyLog removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return BusinessPolicyLog.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BusinessPolicyLog removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyLog)Asset.removeAnnouncement(client, BusinessPolicyLog.updater(qualifiedName, name));
    }

    public static BusinessPolicyLog replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return BusinessPolicyLog.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static BusinessPolicyLog replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicyLog)Asset.replaceTerms(client, BusinessPolicyLog.updater(qualifiedName, name), terms);
    }

    public static BusinessPolicyLog appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return BusinessPolicyLog.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static BusinessPolicyLog appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicyLog)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static BusinessPolicyLog removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return BusinessPolicyLog.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static BusinessPolicyLog removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicyLog)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static BusinessPolicyLog appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return BusinessPolicyLog.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static BusinessPolicyLog appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (BusinessPolicyLog)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static BusinessPolicyLog appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return BusinessPolicyLog.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static BusinessPolicyLog appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (BusinessPolicyLog)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        BusinessPolicyLog.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected BusinessPolicyLog(BusinessPolicyLogBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : BusinessPolicyLog.$default$typeName();
        this.businessPolicyId = b.businessPolicyId;
        this.businessPolicyLogPolicyType = b.businessPolicyLogPolicyType;
        this.compliantAssetsCount = b.compliantAssetsCount;
        this.governedAssetsCount = b.governedAssetsCount;
        this.nonCompliantAssetsCount = b.nonCompliantAssetsCount;
        this.nonGovernedAssetsCount = b.nonGovernedAssetsCount;
    }

    @Generated
    public static BusinessPolicyLogBuilder<?, ?> _internal() {
        return new BusinessPolicyLogBuilderImpl();
    }

    @Generated
    public BusinessPolicyLogBuilder<?, ?> toBuilder() {
        return new BusinessPolicyLogBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getBusinessPolicyId() {
        return this.businessPolicyId;
    }

    @Override
    @Generated
    public String getBusinessPolicyLogPolicyType() {
        return this.businessPolicyLogPolicyType;
    }

    @Override
    @Generated
    public Long getCompliantAssetsCount() {
        return this.compliantAssetsCount;
    }

    @Override
    @Generated
    public Long getGovernedAssetsCount() {
        return this.governedAssetsCount;
    }

    @Override
    @Generated
    public Long getNonCompliantAssetsCount() {
        return this.nonCompliantAssetsCount;
    }

    @Override
    @Generated
    public Long getNonGovernedAssetsCount() {
        return this.nonGovernedAssetsCount;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessPolicyLog)) {
            return false;
        }
        BusinessPolicyLog other = (BusinessPolicyLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$compliantAssetsCount = this.getCompliantAssetsCount();
        Long other$compliantAssetsCount = other.getCompliantAssetsCount();
        if (this$compliantAssetsCount == null ? other$compliantAssetsCount != null : !((Object)this$compliantAssetsCount).equals(other$compliantAssetsCount)) {
            return false;
        }
        Long this$governedAssetsCount = this.getGovernedAssetsCount();
        Long other$governedAssetsCount = other.getGovernedAssetsCount();
        if (this$governedAssetsCount == null ? other$governedAssetsCount != null : !((Object)this$governedAssetsCount).equals(other$governedAssetsCount)) {
            return false;
        }
        Long this$nonCompliantAssetsCount = this.getNonCompliantAssetsCount();
        Long other$nonCompliantAssetsCount = other.getNonCompliantAssetsCount();
        if (this$nonCompliantAssetsCount == null ? other$nonCompliantAssetsCount != null : !((Object)this$nonCompliantAssetsCount).equals(other$nonCompliantAssetsCount)) {
            return false;
        }
        Long this$nonGovernedAssetsCount = this.getNonGovernedAssetsCount();
        Long other$nonGovernedAssetsCount = other.getNonGovernedAssetsCount();
        if (this$nonGovernedAssetsCount == null ? other$nonGovernedAssetsCount != null : !((Object)this$nonGovernedAssetsCount).equals(other$nonGovernedAssetsCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$businessPolicyId = this.getBusinessPolicyId();
        String other$businessPolicyId = other.getBusinessPolicyId();
        if (this$businessPolicyId == null ? other$businessPolicyId != null : !this$businessPolicyId.equals(other$businessPolicyId)) {
            return false;
        }
        String this$businessPolicyLogPolicyType = this.getBusinessPolicyLogPolicyType();
        String other$businessPolicyLogPolicyType = other.getBusinessPolicyLogPolicyType();
        return !(this$businessPolicyLogPolicyType == null ? other$businessPolicyLogPolicyType != null : !this$businessPolicyLogPolicyType.equals(other$businessPolicyLogPolicyType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BusinessPolicyLog;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $compliantAssetsCount = this.getCompliantAssetsCount();
        result = result * 59 + ($compliantAssetsCount == null ? 43 : ((Object)$compliantAssetsCount).hashCode());
        Long $governedAssetsCount = this.getGovernedAssetsCount();
        result = result * 59 + ($governedAssetsCount == null ? 43 : ((Object)$governedAssetsCount).hashCode());
        Long $nonCompliantAssetsCount = this.getNonCompliantAssetsCount();
        result = result * 59 + ($nonCompliantAssetsCount == null ? 43 : ((Object)$nonCompliantAssetsCount).hashCode());
        Long $nonGovernedAssetsCount = this.getNonGovernedAssetsCount();
        result = result * 59 + ($nonGovernedAssetsCount == null ? 43 : ((Object)$nonGovernedAssetsCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $businessPolicyId = this.getBusinessPolicyId();
        result = result * 59 + ($businessPolicyId == null ? 43 : $businessPolicyId.hashCode());
        String $businessPolicyLogPolicyType = this.getBusinessPolicyLogPolicyType();
        result = result * 59 + ($businessPolicyLogPolicyType == null ? 43 : $businessPolicyLogPolicyType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BusinessPolicyLog(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", businessPolicyId=" + this.getBusinessPolicyId() + ", businessPolicyLogPolicyType=" + this.getBusinessPolicyLogPolicyType() + ", compliantAssetsCount=" + this.getCompliantAssetsCount() + ", governedAssetsCount=" + this.getGovernedAssetsCount() + ", nonCompliantAssetsCount=" + this.getNonCompliantAssetsCount() + ", nonGovernedAssetsCount=" + this.getNonGovernedAssetsCount() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class BusinessPolicyLogBuilder<C extends BusinessPolicyLog, B extends BusinessPolicyLogBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String businessPolicyId;
        @Generated
        private String businessPolicyLogPolicyType;
        @Generated
        private Long compliantAssetsCount;
        @Generated
        private Long governedAssetsCount;
        @Generated
        private Long nonCompliantAssetsCount;
        @Generated
        private Long nonGovernedAssetsCount;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BusinessPolicyLogBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BusinessPolicyLog instance, BusinessPolicyLogBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.businessPolicyId(instance.businessPolicyId);
            b.businessPolicyLogPolicyType(instance.businessPolicyLogPolicyType);
            b.compliantAssetsCount(instance.compliantAssetsCount);
            b.governedAssetsCount(instance.governedAssetsCount);
            b.nonCompliantAssetsCount(instance.nonCompliantAssetsCount);
            b.nonGovernedAssetsCount(instance.nonGovernedAssetsCount);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyId(String businessPolicyId) {
            this.businessPolicyId = businessPolicyId;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyLogPolicyType(String businessPolicyLogPolicyType) {
            this.businessPolicyLogPolicyType = businessPolicyLogPolicyType;
            return (B)this.self();
        }

        @Generated
        public B compliantAssetsCount(Long compliantAssetsCount) {
            this.compliantAssetsCount = compliantAssetsCount;
            return (B)this.self();
        }

        @Generated
        public B governedAssetsCount(Long governedAssetsCount) {
            this.governedAssetsCount = governedAssetsCount;
            return (B)this.self();
        }

        @Generated
        public B nonCompliantAssetsCount(Long nonCompliantAssetsCount) {
            this.nonCompliantAssetsCount = nonCompliantAssetsCount;
            return (B)this.self();
        }

        @Generated
        public B nonGovernedAssetsCount(Long nonGovernedAssetsCount) {
            this.nonGovernedAssetsCount = nonGovernedAssetsCount;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BusinessPolicyLog.BusinessPolicyLogBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", businessPolicyId=" + this.businessPolicyId + ", businessPolicyLogPolicyType=" + this.businessPolicyLogPolicyType + ", compliantAssetsCount=" + this.compliantAssetsCount + ", governedAssetsCount=" + this.governedAssetsCount + ", nonCompliantAssetsCount=" + this.nonCompliantAssetsCount + ", nonGovernedAssetsCount=" + this.nonGovernedAssetsCount + ")";
        }
    }

    @Generated
    private static final class BusinessPolicyLogBuilderImpl
    extends BusinessPolicyLogBuilder<BusinessPolicyLog, BusinessPolicyLogBuilderImpl> {
        @Generated
        private BusinessPolicyLogBuilderImpl() {
        }

        @Override
        @Generated
        protected BusinessPolicyLogBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BusinessPolicyLog build() {
            return new BusinessPolicyLog(this);
        }
    }
}

