/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICognos;
import com.atlan.model.assets.ICognosFolder;
import com.atlan.model.assets.ICognosPackage;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CognosPackage
extends Asset
implements ICognosPackage,
ICognos,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CognosPackage.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CognosPackage";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    String cognosDefaultScreenTip;
    @Attribute
    ICognosFolder cognosFolder;
    @Attribute
    String cognosId;
    @Attribute
    Boolean cognosIsDisabled;
    @Attribute
    Boolean cognosIsHidden;
    @Attribute
    String cognosParentName;
    @Attribute
    String cognosParentQualifiedName;
    @Attribute
    String cognosPath;
    @Attribute
    String cognosType;
    @Attribute
    String cognosVersion;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public CognosPackage trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CognosPackage.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CognosPackage.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CognosPackage.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return CognosPackage.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CognosPackage.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return CognosPackage.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CognosPackage refByGuid(String guid) {
        return CognosPackage.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CognosPackage refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CognosPackageBuilder)((CognosPackageBuilder)CognosPackage._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CognosPackage refByQualifiedName(String qualifiedName) {
        return CognosPackage.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CognosPackage refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CognosPackageBuilder)((CognosPackageBuilder)CognosPackage._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CognosPackage get(String id) throws AtlanException {
        return CognosPackage.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static CognosPackage get(AtlanClient client, String id) throws AtlanException {
        return CognosPackage.get(client, id, true);
    }

    @JsonIgnore
    public static CognosPackage get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CognosPackage) {
                return (CognosPackage)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof CognosPackage) {
            return (CognosPackage)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return CognosPackage.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CognosPackageBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CognosPackageBuilder)((CognosPackageBuilder)((CognosPackageBuilder)CognosPackage._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public CognosPackageBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        CognosPackage.validateRequired(TYPE_NAME, map);
        return CognosPackage.updater(this.getQualifiedName(), this.getName());
    }

    public static CognosPackage removeDescription(String qualifiedName, String name) throws AtlanException {
        return CognosPackage.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CognosPackage removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CognosPackage)Asset.removeDescription(client, CognosPackage.updater(qualifiedName, name));
    }

    public static CognosPackage removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return CognosPackage.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CognosPackage removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CognosPackage)Asset.removeUserDescription(client, CognosPackage.updater(qualifiedName, name));
    }

    public static CognosPackage removeOwners(String qualifiedName, String name) throws AtlanException {
        return CognosPackage.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CognosPackage removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CognosPackage)Asset.removeOwners(client, CognosPackage.updater(qualifiedName, name));
    }

    public static CognosPackage updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return CognosPackage.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static CognosPackage updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CognosPackage)Asset.updateCertificate(client, CognosPackage._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CognosPackage removeCertificate(String qualifiedName, String name) throws AtlanException {
        return CognosPackage.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CognosPackage removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CognosPackage)Asset.removeCertificate(client, CognosPackage.updater(qualifiedName, name));
    }

    public static CognosPackage updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return CognosPackage.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static CognosPackage updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CognosPackage)Asset.updateAnnouncement(client, CognosPackage._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CognosPackage removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return CognosPackage.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CognosPackage removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CognosPackage)Asset.removeAnnouncement(client, CognosPackage.updater(qualifiedName, name));
    }

    public static CognosPackage replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return CognosPackage.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static CognosPackage replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CognosPackage)Asset.replaceTerms(client, CognosPackage.updater(qualifiedName, name), terms);
    }

    public static CognosPackage appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return CognosPackage.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static CognosPackage appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CognosPackage)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static CognosPackage removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return CognosPackage.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static CognosPackage removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CognosPackage)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static CognosPackage appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return CognosPackage.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static CognosPackage appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CognosPackage)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static CognosPackage appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return CognosPackage.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static CognosPackage appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CognosPackage)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        CognosPackage.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CognosPackage(CognosPackageBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : CognosPackage.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        this.cognosDefaultScreenTip = b.cognosDefaultScreenTip;
        this.cognosFolder = b.cognosFolder;
        this.cognosId = b.cognosId;
        this.cognosIsDisabled = b.cognosIsDisabled;
        this.cognosIsHidden = b.cognosIsHidden;
        this.cognosParentName = b.cognosParentName;
        this.cognosParentQualifiedName = b.cognosParentQualifiedName;
        this.cognosPath = b.cognosPath;
        this.cognosType = b.cognosType;
        this.cognosVersion = b.cognosVersion;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static CognosPackageBuilder<?, ?> _internal() {
        return new CognosPackageBuilderImpl();
    }

    @Generated
    public CognosPackageBuilder<?, ?> toBuilder() {
        return new CognosPackageBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public String getCognosDefaultScreenTip() {
        return this.cognosDefaultScreenTip;
    }

    @Override
    @Generated
    public ICognosFolder getCognosFolder() {
        return this.cognosFolder;
    }

    @Override
    @Generated
    public String getCognosId() {
        return this.cognosId;
    }

    @Override
    @Generated
    public Boolean getCognosIsDisabled() {
        return this.cognosIsDisabled;
    }

    @Override
    @Generated
    public Boolean getCognosIsHidden() {
        return this.cognosIsHidden;
    }

    @Override
    @Generated
    public String getCognosParentName() {
        return this.cognosParentName;
    }

    @Override
    @Generated
    public String getCognosParentQualifiedName() {
        return this.cognosParentQualifiedName;
    }

    @Override
    @Generated
    public String getCognosPath() {
        return this.cognosPath;
    }

    @Override
    @Generated
    public String getCognosType() {
        return this.cognosType;
    }

    @Override
    @Generated
    public String getCognosVersion() {
        return this.cognosVersion;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CognosPackage)) {
            return false;
        }
        CognosPackage other = (CognosPackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$cognosIsDisabled = this.getCognosIsDisabled();
        Boolean other$cognosIsDisabled = other.getCognosIsDisabled();
        if (this$cognosIsDisabled == null ? other$cognosIsDisabled != null : !((Object)this$cognosIsDisabled).equals(other$cognosIsDisabled)) {
            return false;
        }
        Boolean this$cognosIsHidden = this.getCognosIsHidden();
        Boolean other$cognosIsHidden = other.getCognosIsHidden();
        if (this$cognosIsHidden == null ? other$cognosIsHidden != null : !((Object)this$cognosIsHidden).equals(other$cognosIsHidden)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        String this$cognosDefaultScreenTip = this.getCognosDefaultScreenTip();
        String other$cognosDefaultScreenTip = other.getCognosDefaultScreenTip();
        if (this$cognosDefaultScreenTip == null ? other$cognosDefaultScreenTip != null : !this$cognosDefaultScreenTip.equals(other$cognosDefaultScreenTip)) {
            return false;
        }
        ICognosFolder this$cognosFolder = this.getCognosFolder();
        ICognosFolder other$cognosFolder = other.getCognosFolder();
        if (this$cognosFolder == null ? other$cognosFolder != null : !this$cognosFolder.equals(other$cognosFolder)) {
            return false;
        }
        String this$cognosId = this.getCognosId();
        String other$cognosId = other.getCognosId();
        if (this$cognosId == null ? other$cognosId != null : !this$cognosId.equals(other$cognosId)) {
            return false;
        }
        String this$cognosParentName = this.getCognosParentName();
        String other$cognosParentName = other.getCognosParentName();
        if (this$cognosParentName == null ? other$cognosParentName != null : !this$cognosParentName.equals(other$cognosParentName)) {
            return false;
        }
        String this$cognosParentQualifiedName = this.getCognosParentQualifiedName();
        String other$cognosParentQualifiedName = other.getCognosParentQualifiedName();
        if (this$cognosParentQualifiedName == null ? other$cognosParentQualifiedName != null : !this$cognosParentQualifiedName.equals(other$cognosParentQualifiedName)) {
            return false;
        }
        String this$cognosPath = this.getCognosPath();
        String other$cognosPath = other.getCognosPath();
        if (this$cognosPath == null ? other$cognosPath != null : !this$cognosPath.equals(other$cognosPath)) {
            return false;
        }
        String this$cognosType = this.getCognosType();
        String other$cognosType = other.getCognosType();
        if (this$cognosType == null ? other$cognosType != null : !this$cognosType.equals(other$cognosType)) {
            return false;
        }
        String this$cognosVersion = this.getCognosVersion();
        String other$cognosVersion = other.getCognosVersion();
        if (this$cognosVersion == null ? other$cognosVersion != null : !this$cognosVersion.equals(other$cognosVersion)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CognosPackage;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $cognosIsDisabled = this.getCognosIsDisabled();
        result = result * 59 + ($cognosIsDisabled == null ? 43 : ((Object)$cognosIsDisabled).hashCode());
        Boolean $cognosIsHidden = this.getCognosIsHidden();
        result = result * 59 + ($cognosIsHidden == null ? 43 : ((Object)$cognosIsHidden).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        String $cognosDefaultScreenTip = this.getCognosDefaultScreenTip();
        result = result * 59 + ($cognosDefaultScreenTip == null ? 43 : $cognosDefaultScreenTip.hashCode());
        ICognosFolder $cognosFolder = this.getCognosFolder();
        result = result * 59 + ($cognosFolder == null ? 43 : $cognosFolder.hashCode());
        String $cognosId = this.getCognosId();
        result = result * 59 + ($cognosId == null ? 43 : $cognosId.hashCode());
        String $cognosParentName = this.getCognosParentName();
        result = result * 59 + ($cognosParentName == null ? 43 : $cognosParentName.hashCode());
        String $cognosParentQualifiedName = this.getCognosParentQualifiedName();
        result = result * 59 + ($cognosParentQualifiedName == null ? 43 : $cognosParentQualifiedName.hashCode());
        String $cognosPath = this.getCognosPath();
        result = result * 59 + ($cognosPath == null ? 43 : $cognosPath.hashCode());
        String $cognosType = this.getCognosType();
        result = result * 59 + ($cognosType == null ? 43 : $cognosType.hashCode());
        String $cognosVersion = this.getCognosVersion();
        result = result * 59 + ($cognosVersion == null ? 43 : $cognosVersion.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CognosPackage(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", cognosDefaultScreenTip=" + this.getCognosDefaultScreenTip() + ", cognosFolder=" + this.getCognosFolder() + ", cognosId=" + this.getCognosId() + ", cognosIsDisabled=" + this.getCognosIsDisabled() + ", cognosIsHidden=" + this.getCognosIsHidden() + ", cognosParentName=" + this.getCognosParentName() + ", cognosParentQualifiedName=" + this.getCognosParentQualifiedName() + ", cognosPath=" + this.getCognosPath() + ", cognosType=" + this.getCognosType() + ", cognosVersion=" + this.getCognosVersion() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class CognosPackageBuilder<C extends CognosPackage, B extends CognosPackageBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private String cognosDefaultScreenTip;
        @Generated
        private ICognosFolder cognosFolder;
        @Generated
        private String cognosId;
        @Generated
        private Boolean cognosIsDisabled;
        @Generated
        private Boolean cognosIsHidden;
        @Generated
        private String cognosParentName;
        @Generated
        private String cognosParentQualifiedName;
        @Generated
        private String cognosPath;
        @Generated
        private String cognosType;
        @Generated
        private String cognosVersion;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CognosPackageBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CognosPackage instance, CognosPackageBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.cognosDefaultScreenTip(instance.cognosDefaultScreenTip);
            b.cognosFolder(instance.cognosFolder);
            b.cognosId(instance.cognosId);
            b.cognosIsDisabled(instance.cognosIsDisabled);
            b.cognosIsHidden(instance.cognosIsHidden);
            b.cognosParentName(instance.cognosParentName);
            b.cognosParentQualifiedName(instance.cognosParentQualifiedName);
            b.cognosPath(instance.cognosPath);
            b.cognosType(instance.cognosType);
            b.cognosVersion(instance.cognosVersion);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cognosDefaultScreenTip(String cognosDefaultScreenTip) {
            this.cognosDefaultScreenTip = cognosDefaultScreenTip;
            return (B)this.self();
        }

        @Generated
        public B cognosFolder(ICognosFolder cognosFolder) {
            this.cognosFolder = cognosFolder;
            return (B)this.self();
        }

        @Generated
        public B cognosId(String cognosId) {
            this.cognosId = cognosId;
            return (B)this.self();
        }

        @Generated
        public B cognosIsDisabled(Boolean cognosIsDisabled) {
            this.cognosIsDisabled = cognosIsDisabled;
            return (B)this.self();
        }

        @Generated
        public B cognosIsHidden(Boolean cognosIsHidden) {
            this.cognosIsHidden = cognosIsHidden;
            return (B)this.self();
        }

        @Generated
        public B cognosParentName(String cognosParentName) {
            this.cognosParentName = cognosParentName;
            return (B)this.self();
        }

        @Generated
        public B cognosParentQualifiedName(String cognosParentQualifiedName) {
            this.cognosParentQualifiedName = cognosParentQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cognosPath(String cognosPath) {
            this.cognosPath = cognosPath;
            return (B)this.self();
        }

        @Generated
        public B cognosType(String cognosType) {
            this.cognosType = cognosType;
            return (B)this.self();
        }

        @Generated
        public B cognosVersion(String cognosVersion) {
            this.cognosVersion = cognosVersion;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CognosPackage.CognosPackageBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", cognosDefaultScreenTip=" + this.cognosDefaultScreenTip + ", cognosFolder=" + this.cognosFolder + ", cognosId=" + this.cognosId + ", cognosIsDisabled=" + this.cognosIsDisabled + ", cognosIsHidden=" + this.cognosIsHidden + ", cognosParentName=" + this.cognosParentName + ", cognosParentQualifiedName=" + this.cognosParentQualifiedName + ", cognosPath=" + this.cognosPath + ", cognosType=" + this.cognosType + ", cognosVersion=" + this.cognosVersion + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class CognosPackageBuilderImpl
    extends CognosPackageBuilder<CognosPackage, CognosPackageBuilderImpl> {
        @Generated
        private CognosPackageBuilderImpl() {
        }

        @Override
        @Generated
        protected CognosPackageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CognosPackage build() {
            return new CognosPackage(this);
        }
    }
}

