/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.Cube;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICube;
import com.atlan.model.assets.ICubeDimension;
import com.atlan.model.assets.ICubeHierarchy;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IMultiDimensionalDataset;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeDimension
extends Asset
implements ICubeDimension,
IMultiDimensionalDataset,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CubeDimension.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CubeDimension";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    ICube cube;
    @Attribute
    String cubeDimensionName;
    @Attribute
    String cubeDimensionQualifiedName;
    @Attribute
    SortedSet<ICubeHierarchy> cubeHierarchies;
    @Attribute
    Long cubeHierarchyCount;
    @Attribute
    String cubeHierarchyName;
    @Attribute
    String cubeHierarchyQualifiedName;
    @Attribute
    String cubeName;
    @Attribute
    String cubeQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public CubeDimension trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CubeDimension.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CubeDimension.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CubeDimension.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return CubeDimension.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CubeDimension.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return CubeDimension.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CubeDimension refByGuid(String guid) {
        return CubeDimension.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CubeDimension refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CubeDimensionBuilder)((CubeDimensionBuilder)CubeDimension._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CubeDimension refByQualifiedName(String qualifiedName) {
        return CubeDimension.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CubeDimension refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CubeDimensionBuilder)((CubeDimensionBuilder)CubeDimension._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CubeDimension get(String id) throws AtlanException {
        return CubeDimension.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static CubeDimension get(AtlanClient client, String id) throws AtlanException {
        return CubeDimension.get(client, id, true);
    }

    @JsonIgnore
    public static CubeDimension get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CubeDimension) {
                return (CubeDimension)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof CubeDimension) {
            return (CubeDimension)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return CubeDimension.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CubeDimensionBuilder<?, ?> creator(String name, Cube cube) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", cube.getQualifiedName());
        map.put("name", cube.getName());
        map.put("connectionQualifiedName", cube.getConnectionQualifiedName());
        CubeDimension.validateRelationship("Cube", map);
        return CubeDimension.creator(name, cube.getConnectionQualifiedName(), cube.getName(), cube.getQualifiedName()).cube(cube.trimToReference());
    }

    public static CubeDimensionBuilder<?, ?> creator(String name, String cubeQualifiedName) {
        String cubeSlug = StringUtils.getNameFromQualifiedName(cubeQualifiedName);
        String cubeName = IMultiDimensionalDataset.getNameFromSlug(cubeSlug);
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(cubeQualifiedName);
        return CubeDimension.creator(name, connectionQualifiedName, cubeName, cubeQualifiedName);
    }

    public static CubeDimensionBuilder<?, ?> creator(String name, String connectionQualifiedName, String cubeName, String cubeQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return (CubeDimensionBuilder)((CubeDimensionBuilder)((Asset.AssetBuilder)((CubeDimensionBuilder)((CubeDimensionBuilder)((CubeDimensionBuilder)((CubeDimensionBuilder)((CubeDimensionBuilder)CubeDimension._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(CubeDimension.generateQualifiedName(name, cubeQualifiedName))).cubeName(cubeName)).cubeQualifiedName(cubeQualifiedName)).cube(Cube.refByQualifiedName(cubeQualifiedName))).connectorType(connectorType)).connectionQualifiedName(connectionQualifiedName);
    }

    public static CubeDimensionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CubeDimensionBuilder)((CubeDimensionBuilder)((CubeDimensionBuilder)CubeDimension._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public static String generateQualifiedName(String name, String cubeQualifiedName) {
        return cubeQualifiedName + "/" + IMultiDimensionalDataset.getSlugForName(name);
    }

    public CubeDimensionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        CubeDimension.validateRequired(TYPE_NAME, map);
        return CubeDimension.updater(this.getQualifiedName(), this.getName());
    }

    public static CubeDimension removeDescription(String qualifiedName, String name) throws AtlanException {
        return CubeDimension.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CubeDimension removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeDimension)Asset.removeDescription(client, CubeDimension.updater(qualifiedName, name));
    }

    public static CubeDimension removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return CubeDimension.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CubeDimension removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeDimension)Asset.removeUserDescription(client, CubeDimension.updater(qualifiedName, name));
    }

    public static CubeDimension removeOwners(String qualifiedName, String name) throws AtlanException {
        return CubeDimension.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CubeDimension removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeDimension)Asset.removeOwners(client, CubeDimension.updater(qualifiedName, name));
    }

    public static CubeDimension updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return CubeDimension.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static CubeDimension updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CubeDimension)Asset.updateCertificate(client, CubeDimension._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CubeDimension removeCertificate(String qualifiedName, String name) throws AtlanException {
        return CubeDimension.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CubeDimension removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeDimension)Asset.removeCertificate(client, CubeDimension.updater(qualifiedName, name));
    }

    public static CubeDimension updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return CubeDimension.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static CubeDimension updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CubeDimension)Asset.updateAnnouncement(client, CubeDimension._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CubeDimension removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return CubeDimension.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CubeDimension removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeDimension)Asset.removeAnnouncement(client, CubeDimension.updater(qualifiedName, name));
    }

    public static CubeDimension replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return CubeDimension.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static CubeDimension replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeDimension)Asset.replaceTerms(client, CubeDimension.updater(qualifiedName, name), terms);
    }

    public static CubeDimension appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return CubeDimension.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static CubeDimension appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeDimension)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static CubeDimension removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return CubeDimension.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static CubeDimension removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeDimension)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static CubeDimension appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return CubeDimension.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static CubeDimension appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CubeDimension)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static CubeDimension appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return CubeDimension.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static CubeDimension appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CubeDimension)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        CubeDimension.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CubeDimension(CubeDimensionBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : CubeDimension.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        this.cube = b.cube;
        this.cubeDimensionName = b.cubeDimensionName;
        this.cubeDimensionQualifiedName = b.cubeDimensionQualifiedName;
        SortedSet<ICubeHierarchy> cubeHierarchies = new TreeSet<ICubeHierarchy>();
        if (b.cubeHierarchies != null) {
            cubeHierarchies.addAll(b.cubeHierarchies);
        }
        cubeHierarchies = Collections.unmodifiableSortedSet(cubeHierarchies);
        this.cubeHierarchies = cubeHierarchies;
        this.cubeHierarchyCount = b.cubeHierarchyCount;
        this.cubeHierarchyName = b.cubeHierarchyName;
        this.cubeHierarchyQualifiedName = b.cubeHierarchyQualifiedName;
        this.cubeName = b.cubeName;
        this.cubeQualifiedName = b.cubeQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static CubeDimensionBuilder<?, ?> _internal() {
        return new CubeDimensionBuilderImpl();
    }

    @Generated
    public CubeDimensionBuilder<?, ?> toBuilder() {
        return new CubeDimensionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public ICube getCube() {
        return this.cube;
    }

    @Override
    @Generated
    public String getCubeDimensionName() {
        return this.cubeDimensionName;
    }

    @Override
    @Generated
    public String getCubeDimensionQualifiedName() {
        return this.cubeDimensionQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ICubeHierarchy> getCubeHierarchies() {
        return this.cubeHierarchies;
    }

    @Override
    @Generated
    public Long getCubeHierarchyCount() {
        return this.cubeHierarchyCount;
    }

    @Override
    @Generated
    public String getCubeHierarchyName() {
        return this.cubeHierarchyName;
    }

    @Override
    @Generated
    public String getCubeHierarchyQualifiedName() {
        return this.cubeHierarchyQualifiedName;
    }

    @Override
    @Generated
    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    @Generated
    public String getCubeQualifiedName() {
        return this.cubeQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CubeDimension)) {
            return false;
        }
        CubeDimension other = (CubeDimension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$cubeHierarchyCount = this.getCubeHierarchyCount();
        Long other$cubeHierarchyCount = other.getCubeHierarchyCount();
        if (this$cubeHierarchyCount == null ? other$cubeHierarchyCount != null : !((Object)this$cubeHierarchyCount).equals(other$cubeHierarchyCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        ICube this$cube = this.getCube();
        ICube other$cube = other.getCube();
        if (this$cube == null ? other$cube != null : !this$cube.equals(other$cube)) {
            return false;
        }
        String this$cubeDimensionName = this.getCubeDimensionName();
        String other$cubeDimensionName = other.getCubeDimensionName();
        if (this$cubeDimensionName == null ? other$cubeDimensionName != null : !this$cubeDimensionName.equals(other$cubeDimensionName)) {
            return false;
        }
        String this$cubeDimensionQualifiedName = this.getCubeDimensionQualifiedName();
        String other$cubeDimensionQualifiedName = other.getCubeDimensionQualifiedName();
        if (this$cubeDimensionQualifiedName == null ? other$cubeDimensionQualifiedName != null : !this$cubeDimensionQualifiedName.equals(other$cubeDimensionQualifiedName)) {
            return false;
        }
        SortedSet<ICubeHierarchy> this$cubeHierarchies = this.getCubeHierarchies();
        SortedSet<ICubeHierarchy> other$cubeHierarchies = other.getCubeHierarchies();
        if (this$cubeHierarchies == null ? other$cubeHierarchies != null : !this$cubeHierarchies.equals(other$cubeHierarchies)) {
            return false;
        }
        String this$cubeHierarchyName = this.getCubeHierarchyName();
        String other$cubeHierarchyName = other.getCubeHierarchyName();
        if (this$cubeHierarchyName == null ? other$cubeHierarchyName != null : !this$cubeHierarchyName.equals(other$cubeHierarchyName)) {
            return false;
        }
        String this$cubeHierarchyQualifiedName = this.getCubeHierarchyQualifiedName();
        String other$cubeHierarchyQualifiedName = other.getCubeHierarchyQualifiedName();
        if (this$cubeHierarchyQualifiedName == null ? other$cubeHierarchyQualifiedName != null : !this$cubeHierarchyQualifiedName.equals(other$cubeHierarchyQualifiedName)) {
            return false;
        }
        String this$cubeName = this.getCubeName();
        String other$cubeName = other.getCubeName();
        if (this$cubeName == null ? other$cubeName != null : !this$cubeName.equals(other$cubeName)) {
            return false;
        }
        String this$cubeQualifiedName = this.getCubeQualifiedName();
        String other$cubeQualifiedName = other.getCubeQualifiedName();
        if (this$cubeQualifiedName == null ? other$cubeQualifiedName != null : !this$cubeQualifiedName.equals(other$cubeQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CubeDimension;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $cubeHierarchyCount = this.getCubeHierarchyCount();
        result = result * 59 + ($cubeHierarchyCount == null ? 43 : ((Object)$cubeHierarchyCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        ICube $cube = this.getCube();
        result = result * 59 + ($cube == null ? 43 : $cube.hashCode());
        String $cubeDimensionName = this.getCubeDimensionName();
        result = result * 59 + ($cubeDimensionName == null ? 43 : $cubeDimensionName.hashCode());
        String $cubeDimensionQualifiedName = this.getCubeDimensionQualifiedName();
        result = result * 59 + ($cubeDimensionQualifiedName == null ? 43 : $cubeDimensionQualifiedName.hashCode());
        SortedSet<ICubeHierarchy> $cubeHierarchies = this.getCubeHierarchies();
        result = result * 59 + ($cubeHierarchies == null ? 43 : $cubeHierarchies.hashCode());
        String $cubeHierarchyName = this.getCubeHierarchyName();
        result = result * 59 + ($cubeHierarchyName == null ? 43 : $cubeHierarchyName.hashCode());
        String $cubeHierarchyQualifiedName = this.getCubeHierarchyQualifiedName();
        result = result * 59 + ($cubeHierarchyQualifiedName == null ? 43 : $cubeHierarchyQualifiedName.hashCode());
        String $cubeName = this.getCubeName();
        result = result * 59 + ($cubeName == null ? 43 : $cubeName.hashCode());
        String $cubeQualifiedName = this.getCubeQualifiedName();
        result = result * 59 + ($cubeQualifiedName == null ? 43 : $cubeQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CubeDimension(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", cube=" + this.getCube() + ", cubeDimensionName=" + this.getCubeDimensionName() + ", cubeDimensionQualifiedName=" + this.getCubeDimensionQualifiedName() + ", cubeHierarchies=" + this.getCubeHierarchies() + ", cubeHierarchyCount=" + this.getCubeHierarchyCount() + ", cubeHierarchyName=" + this.getCubeHierarchyName() + ", cubeHierarchyQualifiedName=" + this.getCubeHierarchyQualifiedName() + ", cubeName=" + this.getCubeName() + ", cubeQualifiedName=" + this.getCubeQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class CubeDimensionBuilder<C extends CubeDimension, B extends CubeDimensionBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private ICube cube;
        @Generated
        private String cubeDimensionName;
        @Generated
        private String cubeDimensionQualifiedName;
        @Generated
        private ArrayList<ICubeHierarchy> cubeHierarchies;
        @Generated
        private Long cubeHierarchyCount;
        @Generated
        private String cubeHierarchyName;
        @Generated
        private String cubeHierarchyQualifiedName;
        @Generated
        private String cubeName;
        @Generated
        private String cubeQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CubeDimensionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CubeDimension instance, CubeDimensionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.cube(instance.cube);
            b.cubeDimensionName(instance.cubeDimensionName);
            b.cubeDimensionQualifiedName(instance.cubeDimensionQualifiedName);
            b.cubeHierarchies(instance.cubeHierarchies == null ? Collections.emptySortedSet() : instance.cubeHierarchies);
            b.cubeHierarchyCount(instance.cubeHierarchyCount);
            b.cubeHierarchyName(instance.cubeHierarchyName);
            b.cubeHierarchyQualifiedName(instance.cubeHierarchyQualifiedName);
            b.cubeName(instance.cubeName);
            b.cubeQualifiedName(instance.cubeQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cube(ICube cube) {
            this.cube = cube;
            return (B)this.self();
        }

        @Generated
        public B cubeDimensionName(String cubeDimensionName) {
            this.cubeDimensionName = cubeDimensionName;
            return (B)this.self();
        }

        @Generated
        public B cubeDimensionQualifiedName(String cubeDimensionQualifiedName) {
            this.cubeDimensionQualifiedName = cubeDimensionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cubeHierarchy(ICubeHierarchy cubeHierarchy) {
            if (this.cubeHierarchies == null) {
                this.cubeHierarchies = new ArrayList();
            }
            this.cubeHierarchies.add(cubeHierarchy);
            return (B)this.self();
        }

        @Generated
        public B cubeHierarchies(Collection<? extends ICubeHierarchy> cubeHierarchies) {
            if (cubeHierarchies == null) {
                throw new NullPointerException("cubeHierarchies cannot be null");
            }
            if (this.cubeHierarchies == null) {
                this.cubeHierarchies = new ArrayList();
            }
            this.cubeHierarchies.addAll(cubeHierarchies);
            return (B)this.self();
        }

        @Generated
        public B clearCubeHierarchies() {
            if (this.cubeHierarchies != null) {
                this.cubeHierarchies.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cubeHierarchyCount(Long cubeHierarchyCount) {
            this.cubeHierarchyCount = cubeHierarchyCount;
            return (B)this.self();
        }

        @Generated
        public B cubeHierarchyName(String cubeHierarchyName) {
            this.cubeHierarchyName = cubeHierarchyName;
            return (B)this.self();
        }

        @Generated
        public B cubeHierarchyQualifiedName(String cubeHierarchyQualifiedName) {
            this.cubeHierarchyQualifiedName = cubeHierarchyQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cubeName(String cubeName) {
            this.cubeName = cubeName;
            return (B)this.self();
        }

        @Generated
        public B cubeQualifiedName(String cubeQualifiedName) {
            this.cubeQualifiedName = cubeQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CubeDimension.CubeDimensionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", cube=" + this.cube + ", cubeDimensionName=" + this.cubeDimensionName + ", cubeDimensionQualifiedName=" + this.cubeDimensionQualifiedName + ", cubeHierarchies=" + this.cubeHierarchies + ", cubeHierarchyCount=" + this.cubeHierarchyCount + ", cubeHierarchyName=" + this.cubeHierarchyName + ", cubeHierarchyQualifiedName=" + this.cubeHierarchyQualifiedName + ", cubeName=" + this.cubeName + ", cubeQualifiedName=" + this.cubeQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class CubeDimensionBuilderImpl
    extends CubeDimensionBuilder<CubeDimension, CubeDimensionBuilderImpl> {
        @Generated
        private CubeDimensionBuilderImpl() {
        }

        @Override
        @Generated
        protected CubeDimensionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CubeDimension build() {
            return new CubeDimension(this);
        }
    }
}

