/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDataContract;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataContract
extends Asset
implements IDataContract,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataContract.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DataContract";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    IAsset dataContractAssetCertified;
    @Attribute
    String dataContractAssetGuid;
    @Attribute
    IAsset dataContractAssetLatest;
    @Attribute
    String dataContractJson;
    @Attribute
    IDataContract dataContractNextVersion;
    @Attribute
    IDataContract dataContractPreviousVersion;
    @Attribute
    String dataContractSpec;
    @Attribute
    Long dataContractVersion;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public DataContract trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DataContract.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DataContract.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DataContract.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return DataContract.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DataContract.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return DataContract.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DataContract refByGuid(String guid) {
        return DataContract.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DataContract refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DataContractBuilder)((DataContractBuilder)DataContract._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DataContract refByQualifiedName(String qualifiedName) {
        return DataContract.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DataContract refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DataContractBuilder)((DataContractBuilder)DataContract._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DataContract get(String id) throws AtlanException {
        return DataContract.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static DataContract get(AtlanClient client, String id) throws AtlanException {
        return DataContract.get(client, id, true);
    }

    @JsonIgnore
    public static DataContract get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DataContract) {
                return (DataContract)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof DataContract) {
            return (DataContract)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return DataContract.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DataContractBuilder<?, ?> creator(String contract, Asset asset) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", asset.getQualifiedName());
        map.put("name", asset.getName());
        DataContract.validateRelationship(asset.getTypeName(), map);
        return DataContract.creator(contract, asset.getName(), asset.getQualifiedName());
    }

    public static DataContractBuilder<?, ?> creator(String contract, String assetQualifiedName) {
        return DataContract.creator(contract, StringUtils.getNameFromQualifiedName(assetQualifiedName), assetQualifiedName);
    }

    public static DataContractBuilder<?, ?> creator(String contract, String assetName, String assetQualifiedName) {
        String contractName = "Data contract for " + assetName;
        return ((DataContractBuilder)((DataContractBuilder)((DataContractBuilder)DataContract._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(contractName)).qualifiedName(DataContract.generateQualifiedName(assetQualifiedName))).dataContractJson(contract);
    }

    public static DataContractBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DataContractBuilder)((DataContractBuilder)((DataContractBuilder)DataContract._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public static String generateQualifiedName(String assetQualifiedName) {
        return assetQualifiedName + "/contract";
    }

    public DataContractBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        DataContract.validateRequired(TYPE_NAME, map);
        return DataContract.updater(this.getQualifiedName(), this.getName());
    }

    public static DataContract removeDescription(String qualifiedName, String name) throws AtlanException {
        return DataContract.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DataContract removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataContract)Asset.removeDescription(client, DataContract.updater(qualifiedName, name));
    }

    public static DataContract removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return DataContract.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DataContract removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataContract)Asset.removeUserDescription(client, DataContract.updater(qualifiedName, name));
    }

    public static DataContract removeOwners(String qualifiedName, String name) throws AtlanException {
        return DataContract.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DataContract removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataContract)Asset.removeOwners(client, DataContract.updater(qualifiedName, name));
    }

    public static DataContract updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return DataContract.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static DataContract updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DataContract)Asset.updateCertificate(client, DataContract._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DataContract removeCertificate(String qualifiedName, String name) throws AtlanException {
        return DataContract.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DataContract removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataContract)Asset.removeCertificate(client, DataContract.updater(qualifiedName, name));
    }

    public static DataContract updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return DataContract.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static DataContract updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DataContract)Asset.updateAnnouncement(client, DataContract._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DataContract removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return DataContract.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DataContract removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataContract)Asset.removeAnnouncement(client, DataContract.updater(qualifiedName, name));
    }

    public static DataContract replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return DataContract.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static DataContract replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataContract)Asset.replaceTerms(client, DataContract.updater(qualifiedName, name), terms);
    }

    public static DataContract appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DataContract.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DataContract appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataContract)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DataContract removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DataContract.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DataContract removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataContract)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DataContract appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return DataContract.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static DataContract appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DataContract)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static DataContract appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return DataContract.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static DataContract appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DataContract)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        DataContract.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DataContract(DataContractBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DataContract.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        this.dataContractAssetCertified = b.dataContractAssetCertified;
        this.dataContractAssetGuid = b.dataContractAssetGuid;
        this.dataContractAssetLatest = b.dataContractAssetLatest;
        this.dataContractJson = b.dataContractJson;
        this.dataContractNextVersion = b.dataContractNextVersion;
        this.dataContractPreviousVersion = b.dataContractPreviousVersion;
        this.dataContractSpec = b.dataContractSpec;
        this.dataContractVersion = b.dataContractVersion;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static DataContractBuilder<?, ?> _internal() {
        return new DataContractBuilderImpl();
    }

    @Generated
    public DataContractBuilder<?, ?> toBuilder() {
        return new DataContractBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public IAsset getDataContractAssetCertified() {
        return this.dataContractAssetCertified;
    }

    @Override
    @Generated
    public String getDataContractAssetGuid() {
        return this.dataContractAssetGuid;
    }

    @Override
    @Generated
    public IAsset getDataContractAssetLatest() {
        return this.dataContractAssetLatest;
    }

    @Override
    @Generated
    public String getDataContractJson() {
        return this.dataContractJson;
    }

    @Override
    @Generated
    public IDataContract getDataContractNextVersion() {
        return this.dataContractNextVersion;
    }

    @Override
    @Generated
    public IDataContract getDataContractPreviousVersion() {
        return this.dataContractPreviousVersion;
    }

    @Override
    @Generated
    public String getDataContractSpec() {
        return this.dataContractSpec;
    }

    @Override
    @Generated
    public Long getDataContractVersion() {
        return this.dataContractVersion;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataContract)) {
            return false;
        }
        DataContract other = (DataContract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$dataContractVersion = this.getDataContractVersion();
        Long other$dataContractVersion = other.getDataContractVersion();
        if (this$dataContractVersion == null ? other$dataContractVersion != null : !((Object)this$dataContractVersion).equals(other$dataContractVersion)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        IAsset this$dataContractAssetCertified = this.getDataContractAssetCertified();
        IAsset other$dataContractAssetCertified = other.getDataContractAssetCertified();
        if (this$dataContractAssetCertified == null ? other$dataContractAssetCertified != null : !this$dataContractAssetCertified.equals(other$dataContractAssetCertified)) {
            return false;
        }
        String this$dataContractAssetGuid = this.getDataContractAssetGuid();
        String other$dataContractAssetGuid = other.getDataContractAssetGuid();
        if (this$dataContractAssetGuid == null ? other$dataContractAssetGuid != null : !this$dataContractAssetGuid.equals(other$dataContractAssetGuid)) {
            return false;
        }
        IAsset this$dataContractAssetLatest = this.getDataContractAssetLatest();
        IAsset other$dataContractAssetLatest = other.getDataContractAssetLatest();
        if (this$dataContractAssetLatest == null ? other$dataContractAssetLatest != null : !this$dataContractAssetLatest.equals(other$dataContractAssetLatest)) {
            return false;
        }
        String this$dataContractJson = this.getDataContractJson();
        String other$dataContractJson = other.getDataContractJson();
        if (this$dataContractJson == null ? other$dataContractJson != null : !this$dataContractJson.equals(other$dataContractJson)) {
            return false;
        }
        IDataContract this$dataContractNextVersion = this.getDataContractNextVersion();
        IDataContract other$dataContractNextVersion = other.getDataContractNextVersion();
        if (this$dataContractNextVersion == null ? other$dataContractNextVersion != null : !this$dataContractNextVersion.equals(other$dataContractNextVersion)) {
            return false;
        }
        IDataContract this$dataContractPreviousVersion = this.getDataContractPreviousVersion();
        IDataContract other$dataContractPreviousVersion = other.getDataContractPreviousVersion();
        if (this$dataContractPreviousVersion == null ? other$dataContractPreviousVersion != null : !this$dataContractPreviousVersion.equals(other$dataContractPreviousVersion)) {
            return false;
        }
        String this$dataContractSpec = this.getDataContractSpec();
        String other$dataContractSpec = other.getDataContractSpec();
        if (this$dataContractSpec == null ? other$dataContractSpec != null : !this$dataContractSpec.equals(other$dataContractSpec)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataContract;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $dataContractVersion = this.getDataContractVersion();
        result = result * 59 + ($dataContractVersion == null ? 43 : ((Object)$dataContractVersion).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        IAsset $dataContractAssetCertified = this.getDataContractAssetCertified();
        result = result * 59 + ($dataContractAssetCertified == null ? 43 : $dataContractAssetCertified.hashCode());
        String $dataContractAssetGuid = this.getDataContractAssetGuid();
        result = result * 59 + ($dataContractAssetGuid == null ? 43 : $dataContractAssetGuid.hashCode());
        IAsset $dataContractAssetLatest = this.getDataContractAssetLatest();
        result = result * 59 + ($dataContractAssetLatest == null ? 43 : $dataContractAssetLatest.hashCode());
        String $dataContractJson = this.getDataContractJson();
        result = result * 59 + ($dataContractJson == null ? 43 : $dataContractJson.hashCode());
        IDataContract $dataContractNextVersion = this.getDataContractNextVersion();
        result = result * 59 + ($dataContractNextVersion == null ? 43 : $dataContractNextVersion.hashCode());
        IDataContract $dataContractPreviousVersion = this.getDataContractPreviousVersion();
        result = result * 59 + ($dataContractPreviousVersion == null ? 43 : $dataContractPreviousVersion.hashCode());
        String $dataContractSpec = this.getDataContractSpec();
        result = result * 59 + ($dataContractSpec == null ? 43 : $dataContractSpec.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DataContract(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", dataContractAssetCertified=" + this.getDataContractAssetCertified() + ", dataContractAssetGuid=" + this.getDataContractAssetGuid() + ", dataContractAssetLatest=" + this.getDataContractAssetLatest() + ", dataContractJson=" + this.getDataContractJson() + ", dataContractNextVersion=" + this.getDataContractNextVersion() + ", dataContractPreviousVersion=" + this.getDataContractPreviousVersion() + ", dataContractSpec=" + this.getDataContractSpec() + ", dataContractVersion=" + this.getDataContractVersion() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class DataContractBuilder<C extends DataContract, B extends DataContractBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private IAsset dataContractAssetCertified;
        @Generated
        private String dataContractAssetGuid;
        @Generated
        private IAsset dataContractAssetLatest;
        @Generated
        private String dataContractJson;
        @Generated
        private IDataContract dataContractNextVersion;
        @Generated
        private IDataContract dataContractPreviousVersion;
        @Generated
        private String dataContractSpec;
        @Generated
        private Long dataContractVersion;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataContractBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DataContract instance, DataContractBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.dataContractAssetCertified(instance.dataContractAssetCertified);
            b.dataContractAssetGuid(instance.dataContractAssetGuid);
            b.dataContractAssetLatest(instance.dataContractAssetLatest);
            b.dataContractJson(instance.dataContractJson);
            b.dataContractNextVersion(instance.dataContractNextVersion);
            b.dataContractPreviousVersion(instance.dataContractPreviousVersion);
            b.dataContractSpec(instance.dataContractSpec);
            b.dataContractVersion(instance.dataContractVersion);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dataContractAssetCertified(IAsset dataContractAssetCertified) {
            this.dataContractAssetCertified = dataContractAssetCertified;
            return (B)this.self();
        }

        @Generated
        public B dataContractAssetGuid(String dataContractAssetGuid) {
            this.dataContractAssetGuid = dataContractAssetGuid;
            return (B)this.self();
        }

        @Generated
        public B dataContractAssetLatest(IAsset dataContractAssetLatest) {
            this.dataContractAssetLatest = dataContractAssetLatest;
            return (B)this.self();
        }

        @Generated
        public B dataContractJson(String dataContractJson) {
            this.dataContractJson = dataContractJson;
            return (B)this.self();
        }

        @Generated
        public B dataContractNextVersion(IDataContract dataContractNextVersion) {
            this.dataContractNextVersion = dataContractNextVersion;
            return (B)this.self();
        }

        @Generated
        public B dataContractPreviousVersion(IDataContract dataContractPreviousVersion) {
            this.dataContractPreviousVersion = dataContractPreviousVersion;
            return (B)this.self();
        }

        @Generated
        public B dataContractSpec(String dataContractSpec) {
            this.dataContractSpec = dataContractSpec;
            return (B)this.self();
        }

        @Generated
        public B dataContractVersion(Long dataContractVersion) {
            this.dataContractVersion = dataContractVersion;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DataContract.DataContractBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", dataContractAssetCertified=" + this.dataContractAssetCertified + ", dataContractAssetGuid=" + this.dataContractAssetGuid + ", dataContractAssetLatest=" + this.dataContractAssetLatest + ", dataContractJson=" + this.dataContractJson + ", dataContractNextVersion=" + this.dataContractNextVersion + ", dataContractPreviousVersion=" + this.dataContractPreviousVersion + ", dataContractSpec=" + this.dataContractSpec + ", dataContractVersion=" + this.dataContractVersion + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class DataContractBuilderImpl
    extends DataContractBuilder<DataContract, DataContractBuilderImpl> {
        @Generated
        private DataContractBuilderImpl() {
        }

        @Override
        @Generated
        protected DataContractBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DataContract build() {
            return new DataContract(this);
        }
    }
}

