/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDbt;
import com.atlan.model.assets.IDbtSource;
import com.atlan.model.assets.IDbtTest;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISQL;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.DbtJobRun;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbtSource
extends Asset
implements IDbtSource,
IDbt,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbtSource.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtSource";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    String dbtAccountName;
    @Attribute
    String dbtAlias;
    @Attribute
    String dbtConnectionContext;
    @Attribute
    String dbtEnvironmentDbtVersion;
    @Attribute
    String dbtEnvironmentName;
    @Attribute
    String dbtFreshnessCriteria;
    @Attribute
    @Date
    Long dbtJobLastRun;
    @Attribute
    String dbtJobName;
    @Attribute
    @Date
    Long dbtJobNextRun;
    @Attribute
    String dbtJobNextRunHumanized;
    @Attribute
    List<DbtJobRun> dbtJobRuns;
    @Attribute
    String dbtJobSchedule;
    @Attribute
    String dbtJobScheduleCronHumanized;
    @Attribute
    String dbtJobStatus;
    @Attribute
    String dbtMeta;
    @Attribute
    String dbtPackageName;
    @Attribute
    String dbtProjectName;
    @Attribute
    String dbtSemanticLayerProxyUrl;
    @Attribute
    String dbtState;
    @Attribute
    SortedSet<String> dbtTags;
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    @Attribute
    String dbtUniqueId;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    @JsonProperty(value="sqlAsset")
    ISQL primarySqlAsset;
    @Attribute
    SortedSet<ISQL> sqlAssets;

    @Override
    public DbtSource trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DbtSource.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DbtSource.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DbtSource.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return DbtSource.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DbtSource.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return DbtSource.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DbtSource refByGuid(String guid) {
        return DbtSource.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DbtSource refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DbtSourceBuilder)((DbtSourceBuilder)DbtSource._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DbtSource refByQualifiedName(String qualifiedName) {
        return DbtSource.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DbtSource refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DbtSourceBuilder)((DbtSourceBuilder)DbtSource._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DbtSource get(String id) throws AtlanException {
        return DbtSource.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static DbtSource get(AtlanClient client, String id) throws AtlanException {
        return DbtSource.get(client, id, true);
    }

    @JsonIgnore
    public static DbtSource get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DbtSource) {
                return (DbtSource)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof DbtSource) {
            return (DbtSource)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return DbtSource.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DbtSourceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DbtSourceBuilder)((DbtSourceBuilder)((DbtSourceBuilder)DbtSource._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DbtSourceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        DbtSource.validateRequired(TYPE_NAME, map);
        return DbtSource.updater(this.getQualifiedName(), this.getName());
    }

    public static DbtSource removeDescription(String qualifiedName, String name) throws AtlanException {
        return DbtSource.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtSource removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtSource)Asset.removeDescription(client, DbtSource.updater(qualifiedName, name));
    }

    public static DbtSource removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return DbtSource.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtSource removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtSource)Asset.removeUserDescription(client, DbtSource.updater(qualifiedName, name));
    }

    public static DbtSource removeOwners(String qualifiedName, String name) throws AtlanException {
        return DbtSource.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtSource removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtSource)Asset.removeOwners(client, DbtSource.updater(qualifiedName, name));
    }

    public static DbtSource updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return DbtSource.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static DbtSource updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DbtSource)Asset.updateCertificate(client, DbtSource._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DbtSource removeCertificate(String qualifiedName, String name) throws AtlanException {
        return DbtSource.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtSource removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtSource)Asset.removeCertificate(client, DbtSource.updater(qualifiedName, name));
    }

    public static DbtSource updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return DbtSource.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static DbtSource updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtSource)Asset.updateAnnouncement(client, DbtSource._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DbtSource removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return DbtSource.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtSource removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtSource)Asset.removeAnnouncement(client, DbtSource.updater(qualifiedName, name));
    }

    public static DbtSource replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtSource.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static DbtSource replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtSource)Asset.replaceTerms(client, DbtSource.updater(qualifiedName, name), terms);
    }

    public static DbtSource appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtSource.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DbtSource appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtSource)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DbtSource removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtSource.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DbtSource removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtSource)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DbtSource appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return DbtSource.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static DbtSource appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DbtSource)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static DbtSource appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return DbtSource.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static DbtSource appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DbtSource)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        DbtSource.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DbtSource(DbtSourceBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DbtSource.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        this.dbtAccountName = b.dbtAccountName;
        this.dbtAlias = b.dbtAlias;
        this.dbtConnectionContext = b.dbtConnectionContext;
        this.dbtEnvironmentDbtVersion = b.dbtEnvironmentDbtVersion;
        this.dbtEnvironmentName = b.dbtEnvironmentName;
        this.dbtFreshnessCriteria = b.dbtFreshnessCriteria;
        this.dbtJobLastRun = b.dbtJobLastRun;
        this.dbtJobName = b.dbtJobName;
        this.dbtJobNextRun = b.dbtJobNextRun;
        this.dbtJobNextRunHumanized = b.dbtJobNextRunHumanized;
        this.dbtJobRuns = switch (b.dbtJobRuns == null ? 0 : b.dbtJobRuns.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.dbtJobRuns.get(0));
            default -> Collections.unmodifiableList(new ArrayList<DbtJobRun>(b.dbtJobRuns));
        };
        this.dbtJobSchedule = b.dbtJobSchedule;
        this.dbtJobScheduleCronHumanized = b.dbtJobScheduleCronHumanized;
        this.dbtJobStatus = b.dbtJobStatus;
        this.dbtMeta = b.dbtMeta;
        this.dbtPackageName = b.dbtPackageName;
        this.dbtProjectName = b.dbtProjectName;
        this.dbtSemanticLayerProxyUrl = b.dbtSemanticLayerProxyUrl;
        this.dbtState = b.dbtState;
        SortedSet<String> dbtTags = new TreeSet<String>();
        if (b.dbtTags != null) {
            dbtTags.addAll(b.dbtTags);
        }
        dbtTags = Collections.unmodifiableSortedSet(dbtTags);
        this.dbtTags = dbtTags;
        SortedSet<IDbtTest> dbtTests = new TreeSet<IDbtTest>();
        if (b.dbtTests != null) {
            dbtTests.addAll(b.dbtTests);
        }
        dbtTests = Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        this.dbtUniqueId = b.dbtUniqueId;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.primarySqlAsset = b.primarySqlAsset;
        SortedSet<ISQL> sqlAssets = new TreeSet<ISQL>();
        if (b.sqlAssets != null) {
            sqlAssets.addAll(b.sqlAssets);
        }
        sqlAssets = Collections.unmodifiableSortedSet(sqlAssets);
        this.sqlAssets = sqlAssets;
    }

    @Generated
    public static DbtSourceBuilder<?, ?> _internal() {
        return new DbtSourceBuilderImpl();
    }

    @Generated
    public DbtSourceBuilder<?, ?> toBuilder() {
        return new DbtSourceBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public String getDbtAccountName() {
        return this.dbtAccountName;
    }

    @Override
    @Generated
    public String getDbtAlias() {
        return this.dbtAlias;
    }

    @Override
    @Generated
    public String getDbtConnectionContext() {
        return this.dbtConnectionContext;
    }

    @Override
    @Generated
    public String getDbtEnvironmentDbtVersion() {
        return this.dbtEnvironmentDbtVersion;
    }

    @Override
    @Generated
    public String getDbtEnvironmentName() {
        return this.dbtEnvironmentName;
    }

    @Override
    @Generated
    public String getDbtFreshnessCriteria() {
        return this.dbtFreshnessCriteria;
    }

    @Override
    @Generated
    public Long getDbtJobLastRun() {
        return this.dbtJobLastRun;
    }

    @Override
    @Generated
    public String getDbtJobName() {
        return this.dbtJobName;
    }

    @Override
    @Generated
    public Long getDbtJobNextRun() {
        return this.dbtJobNextRun;
    }

    @Override
    @Generated
    public String getDbtJobNextRunHumanized() {
        return this.dbtJobNextRunHumanized;
    }

    @Override
    @Generated
    public List<DbtJobRun> getDbtJobRuns() {
        return this.dbtJobRuns;
    }

    @Override
    @Generated
    public String getDbtJobSchedule() {
        return this.dbtJobSchedule;
    }

    @Override
    @Generated
    public String getDbtJobScheduleCronHumanized() {
        return this.dbtJobScheduleCronHumanized;
    }

    @Override
    @Generated
    public String getDbtJobStatus() {
        return this.dbtJobStatus;
    }

    @Override
    @Generated
    public String getDbtMeta() {
        return this.dbtMeta;
    }

    @Override
    @Generated
    public String getDbtPackageName() {
        return this.dbtPackageName;
    }

    @Override
    @Generated
    public String getDbtProjectName() {
        return this.dbtProjectName;
    }

    @Override
    @Generated
    public String getDbtSemanticLayerProxyUrl() {
        return this.dbtSemanticLayerProxyUrl;
    }

    @Override
    @Generated
    public String getDbtState() {
        return this.dbtState;
    }

    @Override
    @Generated
    public SortedSet<String> getDbtTags() {
        return this.dbtTags;
    }

    @Override
    @Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    @Override
    @Generated
    public String getDbtUniqueId() {
        return this.dbtUniqueId;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ISQL getPrimarySqlAsset() {
        return this.primarySqlAsset;
    }

    @Override
    @Generated
    public SortedSet<ISQL> getSqlAssets() {
        return this.sqlAssets;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtSource)) {
            return false;
        }
        DbtSource other = (DbtSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$dbtJobLastRun = this.getDbtJobLastRun();
        Long other$dbtJobLastRun = other.getDbtJobLastRun();
        if (this$dbtJobLastRun == null ? other$dbtJobLastRun != null : !((Object)this$dbtJobLastRun).equals(other$dbtJobLastRun)) {
            return false;
        }
        Long this$dbtJobNextRun = this.getDbtJobNextRun();
        Long other$dbtJobNextRun = other.getDbtJobNextRun();
        if (this$dbtJobNextRun == null ? other$dbtJobNextRun != null : !((Object)this$dbtJobNextRun).equals(other$dbtJobNextRun)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        String this$dbtAccountName = this.getDbtAccountName();
        String other$dbtAccountName = other.getDbtAccountName();
        if (this$dbtAccountName == null ? other$dbtAccountName != null : !this$dbtAccountName.equals(other$dbtAccountName)) {
            return false;
        }
        String this$dbtAlias = this.getDbtAlias();
        String other$dbtAlias = other.getDbtAlias();
        if (this$dbtAlias == null ? other$dbtAlias != null : !this$dbtAlias.equals(other$dbtAlias)) {
            return false;
        }
        String this$dbtConnectionContext = this.getDbtConnectionContext();
        String other$dbtConnectionContext = other.getDbtConnectionContext();
        if (this$dbtConnectionContext == null ? other$dbtConnectionContext != null : !this$dbtConnectionContext.equals(other$dbtConnectionContext)) {
            return false;
        }
        String this$dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        String other$dbtEnvironmentDbtVersion = other.getDbtEnvironmentDbtVersion();
        if (this$dbtEnvironmentDbtVersion == null ? other$dbtEnvironmentDbtVersion != null : !this$dbtEnvironmentDbtVersion.equals(other$dbtEnvironmentDbtVersion)) {
            return false;
        }
        String this$dbtEnvironmentName = this.getDbtEnvironmentName();
        String other$dbtEnvironmentName = other.getDbtEnvironmentName();
        if (this$dbtEnvironmentName == null ? other$dbtEnvironmentName != null : !this$dbtEnvironmentName.equals(other$dbtEnvironmentName)) {
            return false;
        }
        String this$dbtFreshnessCriteria = this.getDbtFreshnessCriteria();
        String other$dbtFreshnessCriteria = other.getDbtFreshnessCriteria();
        if (this$dbtFreshnessCriteria == null ? other$dbtFreshnessCriteria != null : !this$dbtFreshnessCriteria.equals(other$dbtFreshnessCriteria)) {
            return false;
        }
        String this$dbtJobName = this.getDbtJobName();
        String other$dbtJobName = other.getDbtJobName();
        if (this$dbtJobName == null ? other$dbtJobName != null : !this$dbtJobName.equals(other$dbtJobName)) {
            return false;
        }
        String this$dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        String other$dbtJobNextRunHumanized = other.getDbtJobNextRunHumanized();
        if (this$dbtJobNextRunHumanized == null ? other$dbtJobNextRunHumanized != null : !this$dbtJobNextRunHumanized.equals(other$dbtJobNextRunHumanized)) {
            return false;
        }
        List<DbtJobRun> this$dbtJobRuns = this.getDbtJobRuns();
        List<DbtJobRun> other$dbtJobRuns = other.getDbtJobRuns();
        if (this$dbtJobRuns == null ? other$dbtJobRuns != null : !((Object)this$dbtJobRuns).equals(other$dbtJobRuns)) {
            return false;
        }
        String this$dbtJobSchedule = this.getDbtJobSchedule();
        String other$dbtJobSchedule = other.getDbtJobSchedule();
        if (this$dbtJobSchedule == null ? other$dbtJobSchedule != null : !this$dbtJobSchedule.equals(other$dbtJobSchedule)) {
            return false;
        }
        String this$dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        String other$dbtJobScheduleCronHumanized = other.getDbtJobScheduleCronHumanized();
        if (this$dbtJobScheduleCronHumanized == null ? other$dbtJobScheduleCronHumanized != null : !this$dbtJobScheduleCronHumanized.equals(other$dbtJobScheduleCronHumanized)) {
            return false;
        }
        String this$dbtJobStatus = this.getDbtJobStatus();
        String other$dbtJobStatus = other.getDbtJobStatus();
        if (this$dbtJobStatus == null ? other$dbtJobStatus != null : !this$dbtJobStatus.equals(other$dbtJobStatus)) {
            return false;
        }
        String this$dbtMeta = this.getDbtMeta();
        String other$dbtMeta = other.getDbtMeta();
        if (this$dbtMeta == null ? other$dbtMeta != null : !this$dbtMeta.equals(other$dbtMeta)) {
            return false;
        }
        String this$dbtPackageName = this.getDbtPackageName();
        String other$dbtPackageName = other.getDbtPackageName();
        if (this$dbtPackageName == null ? other$dbtPackageName != null : !this$dbtPackageName.equals(other$dbtPackageName)) {
            return false;
        }
        String this$dbtProjectName = this.getDbtProjectName();
        String other$dbtProjectName = other.getDbtProjectName();
        if (this$dbtProjectName == null ? other$dbtProjectName != null : !this$dbtProjectName.equals(other$dbtProjectName)) {
            return false;
        }
        String this$dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        String other$dbtSemanticLayerProxyUrl = other.getDbtSemanticLayerProxyUrl();
        if (this$dbtSemanticLayerProxyUrl == null ? other$dbtSemanticLayerProxyUrl != null : !this$dbtSemanticLayerProxyUrl.equals(other$dbtSemanticLayerProxyUrl)) {
            return false;
        }
        String this$dbtState = this.getDbtState();
        String other$dbtState = other.getDbtState();
        if (this$dbtState == null ? other$dbtState != null : !this$dbtState.equals(other$dbtState)) {
            return false;
        }
        SortedSet<String> this$dbtTags = this.getDbtTags();
        SortedSet<String> other$dbtTags = other.getDbtTags();
        if (this$dbtTags == null ? other$dbtTags != null : !this$dbtTags.equals(other$dbtTags)) {
            return false;
        }
        SortedSet<IDbtTest> this$dbtTests = this.getDbtTests();
        SortedSet<IDbtTest> other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) {
            return false;
        }
        String this$dbtUniqueId = this.getDbtUniqueId();
        String other$dbtUniqueId = other.getDbtUniqueId();
        if (this$dbtUniqueId == null ? other$dbtUniqueId != null : !this$dbtUniqueId.equals(other$dbtUniqueId)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ISQL this$primarySqlAsset = this.getPrimarySqlAsset();
        ISQL other$primarySqlAsset = other.getPrimarySqlAsset();
        if (this$primarySqlAsset == null ? other$primarySqlAsset != null : !this$primarySqlAsset.equals(other$primarySqlAsset)) {
            return false;
        }
        SortedSet<ISQL> this$sqlAssets = this.getSqlAssets();
        SortedSet<ISQL> other$sqlAssets = other.getSqlAssets();
        return !(this$sqlAssets == null ? other$sqlAssets != null : !this$sqlAssets.equals(other$sqlAssets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $dbtJobLastRun = this.getDbtJobLastRun();
        result = result * 59 + ($dbtJobLastRun == null ? 43 : ((Object)$dbtJobLastRun).hashCode());
        Long $dbtJobNextRun = this.getDbtJobNextRun();
        result = result * 59 + ($dbtJobNextRun == null ? 43 : ((Object)$dbtJobNextRun).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        String $dbtAccountName = this.getDbtAccountName();
        result = result * 59 + ($dbtAccountName == null ? 43 : $dbtAccountName.hashCode());
        String $dbtAlias = this.getDbtAlias();
        result = result * 59 + ($dbtAlias == null ? 43 : $dbtAlias.hashCode());
        String $dbtConnectionContext = this.getDbtConnectionContext();
        result = result * 59 + ($dbtConnectionContext == null ? 43 : $dbtConnectionContext.hashCode());
        String $dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        result = result * 59 + ($dbtEnvironmentDbtVersion == null ? 43 : $dbtEnvironmentDbtVersion.hashCode());
        String $dbtEnvironmentName = this.getDbtEnvironmentName();
        result = result * 59 + ($dbtEnvironmentName == null ? 43 : $dbtEnvironmentName.hashCode());
        String $dbtFreshnessCriteria = this.getDbtFreshnessCriteria();
        result = result * 59 + ($dbtFreshnessCriteria == null ? 43 : $dbtFreshnessCriteria.hashCode());
        String $dbtJobName = this.getDbtJobName();
        result = result * 59 + ($dbtJobName == null ? 43 : $dbtJobName.hashCode());
        String $dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        result = result * 59 + ($dbtJobNextRunHumanized == null ? 43 : $dbtJobNextRunHumanized.hashCode());
        List<DbtJobRun> $dbtJobRuns = this.getDbtJobRuns();
        result = result * 59 + ($dbtJobRuns == null ? 43 : ((Object)$dbtJobRuns).hashCode());
        String $dbtJobSchedule = this.getDbtJobSchedule();
        result = result * 59 + ($dbtJobSchedule == null ? 43 : $dbtJobSchedule.hashCode());
        String $dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        result = result * 59 + ($dbtJobScheduleCronHumanized == null ? 43 : $dbtJobScheduleCronHumanized.hashCode());
        String $dbtJobStatus = this.getDbtJobStatus();
        result = result * 59 + ($dbtJobStatus == null ? 43 : $dbtJobStatus.hashCode());
        String $dbtMeta = this.getDbtMeta();
        result = result * 59 + ($dbtMeta == null ? 43 : $dbtMeta.hashCode());
        String $dbtPackageName = this.getDbtPackageName();
        result = result * 59 + ($dbtPackageName == null ? 43 : $dbtPackageName.hashCode());
        String $dbtProjectName = this.getDbtProjectName();
        result = result * 59 + ($dbtProjectName == null ? 43 : $dbtProjectName.hashCode());
        String $dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        result = result * 59 + ($dbtSemanticLayerProxyUrl == null ? 43 : $dbtSemanticLayerProxyUrl.hashCode());
        String $dbtState = this.getDbtState();
        result = result * 59 + ($dbtState == null ? 43 : $dbtState.hashCode());
        SortedSet<String> $dbtTags = this.getDbtTags();
        result = result * 59 + ($dbtTags == null ? 43 : $dbtTags.hashCode());
        SortedSet<IDbtTest> $dbtTests = this.getDbtTests();
        result = result * 59 + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        String $dbtUniqueId = this.getDbtUniqueId();
        result = result * 59 + ($dbtUniqueId == null ? 43 : $dbtUniqueId.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ISQL $primarySqlAsset = this.getPrimarySqlAsset();
        result = result * 59 + ($primarySqlAsset == null ? 43 : $primarySqlAsset.hashCode());
        SortedSet<ISQL> $sqlAssets = this.getSqlAssets();
        result = result * 59 + ($sqlAssets == null ? 43 : $sqlAssets.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DbtSource(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", dbtAccountName=" + this.getDbtAccountName() + ", dbtAlias=" + this.getDbtAlias() + ", dbtConnectionContext=" + this.getDbtConnectionContext() + ", dbtEnvironmentDbtVersion=" + this.getDbtEnvironmentDbtVersion() + ", dbtEnvironmentName=" + this.getDbtEnvironmentName() + ", dbtFreshnessCriteria=" + this.getDbtFreshnessCriteria() + ", dbtJobLastRun=" + this.getDbtJobLastRun() + ", dbtJobName=" + this.getDbtJobName() + ", dbtJobNextRun=" + this.getDbtJobNextRun() + ", dbtJobNextRunHumanized=" + this.getDbtJobNextRunHumanized() + ", dbtJobRuns=" + this.getDbtJobRuns() + ", dbtJobSchedule=" + this.getDbtJobSchedule() + ", dbtJobScheduleCronHumanized=" + this.getDbtJobScheduleCronHumanized() + ", dbtJobStatus=" + this.getDbtJobStatus() + ", dbtMeta=" + this.getDbtMeta() + ", dbtPackageName=" + this.getDbtPackageName() + ", dbtProjectName=" + this.getDbtProjectName() + ", dbtSemanticLayerProxyUrl=" + this.getDbtSemanticLayerProxyUrl() + ", dbtState=" + this.getDbtState() + ", dbtTags=" + this.getDbtTags() + ", dbtTests=" + this.getDbtTests() + ", dbtUniqueId=" + this.getDbtUniqueId() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", primarySqlAsset=" + this.getPrimarySqlAsset() + ", sqlAssets=" + this.getSqlAssets() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class DbtSourceBuilder<C extends DbtSource, B extends DbtSourceBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private String dbtAccountName;
        @Generated
        private String dbtAlias;
        @Generated
        private String dbtConnectionContext;
        @Generated
        private String dbtEnvironmentDbtVersion;
        @Generated
        private String dbtEnvironmentName;
        @Generated
        private String dbtFreshnessCriteria;
        @Generated
        private Long dbtJobLastRun;
        @Generated
        private String dbtJobName;
        @Generated
        private Long dbtJobNextRun;
        @Generated
        private String dbtJobNextRunHumanized;
        @Generated
        private ArrayList<DbtJobRun> dbtJobRuns;
        @Generated
        private String dbtJobSchedule;
        @Generated
        private String dbtJobScheduleCronHumanized;
        @Generated
        private String dbtJobStatus;
        @Generated
        private String dbtMeta;
        @Generated
        private String dbtPackageName;
        @Generated
        private String dbtProjectName;
        @Generated
        private String dbtSemanticLayerProxyUrl;
        @Generated
        private String dbtState;
        @Generated
        private ArrayList<String> dbtTags;
        @Generated
        private ArrayList<IDbtTest> dbtTests;
        @Generated
        private String dbtUniqueId;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ISQL primarySqlAsset;
        @Generated
        private ArrayList<ISQL> sqlAssets;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtSourceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtSource instance, DbtSourceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.dbtAccountName(instance.dbtAccountName);
            b.dbtAlias(instance.dbtAlias);
            b.dbtConnectionContext(instance.dbtConnectionContext);
            b.dbtEnvironmentDbtVersion(instance.dbtEnvironmentDbtVersion);
            b.dbtEnvironmentName(instance.dbtEnvironmentName);
            b.dbtFreshnessCriteria(instance.dbtFreshnessCriteria);
            b.dbtJobLastRun(instance.dbtJobLastRun);
            b.dbtJobName(instance.dbtJobName);
            b.dbtJobNextRun(instance.dbtJobNextRun);
            b.dbtJobNextRunHumanized(instance.dbtJobNextRunHumanized);
            b.dbtJobRuns(instance.dbtJobRuns == null ? Collections.emptyList() : instance.dbtJobRuns);
            b.dbtJobSchedule(instance.dbtJobSchedule);
            b.dbtJobScheduleCronHumanized(instance.dbtJobScheduleCronHumanized);
            b.dbtJobStatus(instance.dbtJobStatus);
            b.dbtMeta(instance.dbtMeta);
            b.dbtPackageName(instance.dbtPackageName);
            b.dbtProjectName(instance.dbtProjectName);
            b.dbtSemanticLayerProxyUrl(instance.dbtSemanticLayerProxyUrl);
            b.dbtState(instance.dbtState);
            b.dbtTags(instance.dbtTags == null ? Collections.emptySortedSet() : instance.dbtTags);
            b.dbtTests(instance.dbtTests == null ? Collections.emptySortedSet() : instance.dbtTests);
            b.dbtUniqueId(instance.dbtUniqueId);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.primarySqlAsset(instance.primarySqlAsset);
            b.sqlAssets(instance.sqlAssets == null ? Collections.emptySortedSet() : instance.sqlAssets);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dbtAccountName(String dbtAccountName) {
            this.dbtAccountName = dbtAccountName;
            return (B)this.self();
        }

        @Generated
        public B dbtAlias(String dbtAlias) {
            this.dbtAlias = dbtAlias;
            return (B)this.self();
        }

        @Generated
        public B dbtConnectionContext(String dbtConnectionContext) {
            this.dbtConnectionContext = dbtConnectionContext;
            return (B)this.self();
        }

        @Generated
        public B dbtEnvironmentDbtVersion(String dbtEnvironmentDbtVersion) {
            this.dbtEnvironmentDbtVersion = dbtEnvironmentDbtVersion;
            return (B)this.self();
        }

        @Generated
        public B dbtEnvironmentName(String dbtEnvironmentName) {
            this.dbtEnvironmentName = dbtEnvironmentName;
            return (B)this.self();
        }

        @Generated
        public B dbtFreshnessCriteria(String dbtFreshnessCriteria) {
            this.dbtFreshnessCriteria = dbtFreshnessCriteria;
            return (B)this.self();
        }

        @Generated
        public B dbtJobLastRun(Long dbtJobLastRun) {
            this.dbtJobLastRun = dbtJobLastRun;
            return (B)this.self();
        }

        @Generated
        public B dbtJobName(String dbtJobName) {
            this.dbtJobName = dbtJobName;
            return (B)this.self();
        }

        @Generated
        public B dbtJobNextRun(Long dbtJobNextRun) {
            this.dbtJobNextRun = dbtJobNextRun;
            return (B)this.self();
        }

        @Generated
        public B dbtJobNextRunHumanized(String dbtJobNextRunHumanized) {
            this.dbtJobNextRunHumanized = dbtJobNextRunHumanized;
            return (B)this.self();
        }

        @Generated
        public B dbtJobRun(DbtJobRun dbtJobRun) {
            if (this.dbtJobRuns == null) {
                this.dbtJobRuns = new ArrayList();
            }
            this.dbtJobRuns.add(dbtJobRun);
            return (B)this.self();
        }

        @Generated
        public B dbtJobRuns(Collection<? extends DbtJobRun> dbtJobRuns) {
            if (dbtJobRuns == null) {
                throw new NullPointerException("dbtJobRuns cannot be null");
            }
            if (this.dbtJobRuns == null) {
                this.dbtJobRuns = new ArrayList();
            }
            this.dbtJobRuns.addAll(dbtJobRuns);
            return (B)this.self();
        }

        @Generated
        public B clearDbtJobRuns() {
            if (this.dbtJobRuns != null) {
                this.dbtJobRuns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtJobSchedule(String dbtJobSchedule) {
            this.dbtJobSchedule = dbtJobSchedule;
            return (B)this.self();
        }

        @Generated
        public B dbtJobScheduleCronHumanized(String dbtJobScheduleCronHumanized) {
            this.dbtJobScheduleCronHumanized = dbtJobScheduleCronHumanized;
            return (B)this.self();
        }

        @Generated
        public B dbtJobStatus(String dbtJobStatus) {
            this.dbtJobStatus = dbtJobStatus;
            return (B)this.self();
        }

        @Generated
        public B dbtMeta(String dbtMeta) {
            this.dbtMeta = dbtMeta;
            return (B)this.self();
        }

        @Generated
        public B dbtPackageName(String dbtPackageName) {
            this.dbtPackageName = dbtPackageName;
            return (B)this.self();
        }

        @Generated
        public B dbtProjectName(String dbtProjectName) {
            this.dbtProjectName = dbtProjectName;
            return (B)this.self();
        }

        @Generated
        public B dbtSemanticLayerProxyUrl(String dbtSemanticLayerProxyUrl) {
            this.dbtSemanticLayerProxyUrl = dbtSemanticLayerProxyUrl;
            return (B)this.self();
        }

        @Generated
        public B dbtState(String dbtState) {
            this.dbtState = dbtState;
            return (B)this.self();
        }

        @Generated
        public B dbtTag(String dbtTag) {
            if (this.dbtTags == null) {
                this.dbtTags = new ArrayList();
            }
            this.dbtTags.add(dbtTag);
            return (B)this.self();
        }

        @Generated
        public B dbtTags(Collection<? extends String> dbtTags) {
            if (dbtTags == null) {
                throw new NullPointerException("dbtTags cannot be null");
            }
            if (this.dbtTags == null) {
                this.dbtTags = new ArrayList();
            }
            this.dbtTags.addAll(dbtTags);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTags() {
            if (this.dbtTags != null) {
                this.dbtTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtTest(IDbtTest dbtTest) {
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.add(dbtTest);
            return (B)this.self();
        }

        @Generated
        public B dbtTests(Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.addAll(dbtTests);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) {
                this.dbtTests.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtUniqueId(String dbtUniqueId) {
            this.dbtUniqueId = dbtUniqueId;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="sqlAsset")
        @Generated
        public B primarySqlAsset(ISQL primarySqlAsset) {
            this.primarySqlAsset = primarySqlAsset;
            return (B)this.self();
        }

        @Generated
        public B sqlAsset(ISQL sqlAsset) {
            if (this.sqlAssets == null) {
                this.sqlAssets = new ArrayList();
            }
            this.sqlAssets.add(sqlAsset);
            return (B)this.self();
        }

        @Generated
        public B sqlAssets(Collection<? extends ISQL> sqlAssets) {
            if (sqlAssets == null) {
                throw new NullPointerException("sqlAssets cannot be null");
            }
            if (this.sqlAssets == null) {
                this.sqlAssets = new ArrayList();
            }
            this.sqlAssets.addAll(sqlAssets);
            return (B)this.self();
        }

        @Generated
        public B clearSqlAssets() {
            if (this.sqlAssets != null) {
                this.sqlAssets.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DbtSource.DbtSourceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", dbtAccountName=" + this.dbtAccountName + ", dbtAlias=" + this.dbtAlias + ", dbtConnectionContext=" + this.dbtConnectionContext + ", dbtEnvironmentDbtVersion=" + this.dbtEnvironmentDbtVersion + ", dbtEnvironmentName=" + this.dbtEnvironmentName + ", dbtFreshnessCriteria=" + this.dbtFreshnessCriteria + ", dbtJobLastRun=" + this.dbtJobLastRun + ", dbtJobName=" + this.dbtJobName + ", dbtJobNextRun=" + this.dbtJobNextRun + ", dbtJobNextRunHumanized=" + this.dbtJobNextRunHumanized + ", dbtJobRuns=" + this.dbtJobRuns + ", dbtJobSchedule=" + this.dbtJobSchedule + ", dbtJobScheduleCronHumanized=" + this.dbtJobScheduleCronHumanized + ", dbtJobStatus=" + this.dbtJobStatus + ", dbtMeta=" + this.dbtMeta + ", dbtPackageName=" + this.dbtPackageName + ", dbtProjectName=" + this.dbtProjectName + ", dbtSemanticLayerProxyUrl=" + this.dbtSemanticLayerProxyUrl + ", dbtState=" + this.dbtState + ", dbtTags=" + this.dbtTags + ", dbtTests=" + this.dbtTests + ", dbtUniqueId=" + this.dbtUniqueId + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", primarySqlAsset=" + this.primarySqlAsset + ", sqlAssets=" + this.sqlAssets + ")";
        }
    }

    @Generated
    private static final class DbtSourceBuilderImpl
    extends DbtSourceBuilder<DbtSource, DbtSourceBuilderImpl> {
        @Generated
        private DbtSourceBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtSourceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtSource build() {
            return new DbtSource(this);
        }
    }
}

