/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IFile;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.IResource;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.FileType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class File
extends Asset
implements IFile,
IResource,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(File.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "File";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    IAsset fileAssets;
    @Attribute
    String filePath;
    @Attribute
    FileType fileType;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Boolean isGlobal;
    @Attribute
    String link;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String reference;
    @Attribute
    Map<String, String> resourceMetadata;

    @Override
    public File trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return File.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return File.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return File.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return File.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return File.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return File.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static File refByGuid(String guid) {
        return File.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static File refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((FileBuilder)((FileBuilder)File._internal().guid(guid)).semantic(semantic)).build();
    }

    public static File refByQualifiedName(String qualifiedName) {
        return File.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static File refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((FileBuilder)((FileBuilder)File._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static File get(String id) throws AtlanException {
        return File.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static File get(AtlanClient client, String id) throws AtlanException {
        return File.get(client, id, true);
    }

    @JsonIgnore
    public static File get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof File) {
                return (File)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof File) {
            return (File)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return File.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static FileBuilder<?, ?> creator(String name, String connectionQualifiedName, FileType type) {
        return ((FileBuilder)((FileBuilder)((FileBuilder)((FileBuilder)File._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).connectionQualifiedName(connectionQualifiedName)).name(name)).qualifiedName(File.generateQualifiedName(connectionQualifiedName, name))).fileType(type);
    }

    public static String generateQualifiedName(String connectionQualifiedName, String name) {
        return connectionQualifiedName + "/" + StringUtils.trimPathDelimiters(name);
    }

    public static FileBuilder<?, ?> updater(String qualifiedName, String name) {
        return (FileBuilder)((FileBuilder)((FileBuilder)File._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public FileBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        File.validateRequired(TYPE_NAME, map);
        return File.updater(this.getQualifiedName(), this.getName());
    }

    public static File removeDescription(String qualifiedName, String name) throws AtlanException {
        return File.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static File removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (File)Asset.removeDescription(client, File.updater(qualifiedName, name));
    }

    public static File removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return File.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static File removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (File)Asset.removeUserDescription(client, File.updater(qualifiedName, name));
    }

    public static File removeOwners(String qualifiedName, String name) throws AtlanException {
        return File.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static File removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (File)Asset.removeOwners(client, File.updater(qualifiedName, name));
    }

    public static File updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return File.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static File updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (File)Asset.updateCertificate(client, File._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static File removeCertificate(String qualifiedName, String name) throws AtlanException {
        return File.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static File removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (File)Asset.removeCertificate(client, File.updater(qualifiedName, name));
    }

    public static File updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return File.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static File updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (File)Asset.updateAnnouncement(client, File._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static File removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return File.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static File removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (File)Asset.removeAnnouncement(client, File.updater(qualifiedName, name));
    }

    public static File replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return File.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static File replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (File)Asset.replaceTerms(client, File.updater(qualifiedName, name), terms);
    }

    public static File appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return File.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static File appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (File)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static File removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return File.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static File removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (File)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static File appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return File.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static File appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (File)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static File appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return File.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static File appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (File)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        File.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected File(FileBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> resourceMetadata;
        this.typeName = b.typeName$set ? b.typeName$value : File.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        this.fileAssets = b.fileAssets;
        this.filePath = b.filePath;
        this.fileType = b.fileType;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isGlobal = b.isGlobal;
        this.link = b.link;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.reference = b.reference;
        switch (b.resourceMetadata$key == null ? 0 : b.resourceMetadata$key.size()) {
            case 0: {
                resourceMetadata = Collections.emptyMap();
                break;
            }
            case 1: {
                resourceMetadata = Collections.singletonMap(b.resourceMetadata$key.get(0), b.resourceMetadata$value.get(0));
                break;
            }
            default: {
                resourceMetadata = new LinkedHashMap(b.resourceMetadata$key.size() < 0x40000000 ? 1 + b.resourceMetadata$key.size() + (b.resourceMetadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.resourceMetadata$key.size(); ++$i) {
                    resourceMetadata.put(b.resourceMetadata$key.get($i), b.resourceMetadata$value.get($i));
                }
                resourceMetadata = Collections.unmodifiableMap(resourceMetadata);
            }
        }
        this.resourceMetadata = resourceMetadata;
    }

    @Generated
    public static FileBuilder<?, ?> _internal() {
        return new FileBuilderImpl();
    }

    @Generated
    public FileBuilder<?, ?> toBuilder() {
        return new FileBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public IAsset getFileAssets() {
        return this.fileAssets;
    }

    @Override
    @Generated
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    @Generated
    public FileType getFileType() {
        return this.fileType;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Boolean getIsGlobal() {
        return this.isGlobal;
    }

    @Override
    @Generated
    public String getLink() {
        return this.link;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getReference() {
        return this.reference;
    }

    @Override
    @Generated
    public Map<String, String> getResourceMetadata() {
        return this.resourceMetadata;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof File)) {
            return false;
        }
        File other = (File)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isGlobal = this.getIsGlobal();
        Boolean other$isGlobal = other.getIsGlobal();
        if (this$isGlobal == null ? other$isGlobal != null : !((Object)this$isGlobal).equals(other$isGlobal)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        IAsset this$fileAssets = this.getFileAssets();
        IAsset other$fileAssets = other.getFileAssets();
        if (this$fileAssets == null ? other$fileAssets != null : !this$fileAssets.equals(other$fileAssets)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        FileType this$fileType = this.getFileType();
        FileType other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        Map<String, String> this$resourceMetadata = this.getResourceMetadata();
        Map<String, String> other$resourceMetadata = other.getResourceMetadata();
        return !(this$resourceMetadata == null ? other$resourceMetadata != null : !((Object)this$resourceMetadata).equals(other$resourceMetadata));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof File;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isGlobal = this.getIsGlobal();
        result = result * 59 + ($isGlobal == null ? 43 : ((Object)$isGlobal).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        IAsset $fileAssets = this.getFileAssets();
        result = result * 59 + ($fileAssets == null ? 43 : $fileAssets.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        FileType $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        Map<String, String> $resourceMetadata = this.getResourceMetadata();
        result = result * 59 + ($resourceMetadata == null ? 43 : ((Object)$resourceMetadata).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "File(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", fileAssets=" + this.getFileAssets() + ", filePath=" + this.getFilePath() + ", fileType=" + this.getFileType() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isGlobal=" + this.getIsGlobal() + ", link=" + this.getLink() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", reference=" + this.getReference() + ", resourceMetadata=" + this.getResourceMetadata() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class FileBuilder<C extends File, B extends FileBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private IAsset fileAssets;
        @Generated
        private String filePath;
        @Generated
        private FileType fileType;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Boolean isGlobal;
        @Generated
        private String link;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String reference;
        @Generated
        private ArrayList<String> resourceMetadata$key;
        @Generated
        private ArrayList<String> resourceMetadata$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FileBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(File instance, FileBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.fileAssets(instance.fileAssets);
            b.filePath(instance.filePath);
            b.fileType(instance.fileType);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.isGlobal(instance.isGlobal);
            b.link(instance.link);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.reference(instance.reference);
            b.resourceMetadata(instance.resourceMetadata == null ? Collections.emptyMap() : instance.resourceMetadata);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B fileAssets(IAsset fileAssets) {
            this.fileAssets = fileAssets;
            return (B)this.self();
        }

        @Generated
        public B filePath(String filePath) {
            this.filePath = filePath;
            return (B)this.self();
        }

        @Generated
        public B fileType(FileType fileType) {
            this.fileType = fileType;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            return (B)this.self();
        }

        @Generated
        public B link(String link) {
            this.link = link;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B reference(String reference) {
            this.reference = reference;
            return (B)this.self();
        }

        @Generated
        public B putResourceMetadata(String putResourceMetadataKey, String putResourceMetadataValue) {
            if (this.resourceMetadata$key == null) {
                this.resourceMetadata$key = new ArrayList();
                this.resourceMetadata$value = new ArrayList();
            }
            this.resourceMetadata$key.add(putResourceMetadataKey);
            this.resourceMetadata$value.add(putResourceMetadataValue);
            return (B)this.self();
        }

        @Generated
        public B resourceMetadata(Map<? extends String, ? extends String> resourceMetadata) {
            if (resourceMetadata == null) {
                throw new NullPointerException("resourceMetadata cannot be null");
            }
            if (this.resourceMetadata$key == null) {
                this.resourceMetadata$key = new ArrayList();
                this.resourceMetadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : resourceMetadata.entrySet()) {
                this.resourceMetadata$key.add($lombokEntry.getKey());
                this.resourceMetadata$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearResourceMetadata() {
            if (this.resourceMetadata$key != null) {
                this.resourceMetadata$key.clear();
                this.resourceMetadata$value.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "File.FileBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", fileAssets=" + this.fileAssets + ", filePath=" + this.filePath + ", fileType=" + this.fileType + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isGlobal=" + this.isGlobal + ", link=" + this.link + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", reference=" + this.reference + ", resourceMetadata$key=" + this.resourceMetadata$key + ", resourceMetadata$value=" + this.resourceMetadata$value + ")";
        }
    }

    @Generated
    private static final class FileBuilderImpl
    extends FileBuilder<File, FileBuilderImpl> {
        @Generated
        private FileBuilderImpl() {
        }

        @Override
        @Generated
        protected FileBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public File build() {
            return new File(this);
        }
    }
}

