/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IFivetran;
import com.atlan.model.assets.IFivetranConnector;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.FivetranConnectorStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FivetranConnector
extends Asset
implements IFivetranConnector,
IFivetran,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FivetranConnector.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "FivetranConnector";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    Double fivetranConnectorCreditsUsed;
    @Attribute
    String fivetranConnectorDestinationName;
    @Attribute
    String fivetranConnectorDestinationType;
    @Attribute
    String fivetranConnectorDestinationURL;
    @Attribute
    Double fivetranConnectorLastSyncExtractTimeSeconds;
    @Attribute
    Double fivetranConnectorLastSyncExtractVolumeMegabytes;
    @Attribute
    @Date
    Long fivetranConnectorLastSyncFinishedAt;
    @Attribute
    String fivetranConnectorLastSyncId;
    @Attribute
    Double fivetranConnectorLastSyncLoadTimeSeconds;
    @Attribute
    Double fivetranConnectorLastSyncLoadVolumeMegabytes;
    @Attribute
    Double fivetranConnectorLastSyncProcessTimeSeconds;
    @Attribute
    Double fivetranConnectorLastSyncProcessVolumeMegabytes;
    @Attribute
    String fivetranConnectorLastSyncReason;
    @Attribute
    @Date
    Long fivetranConnectorLastSyncRescheduledAt;
    @Attribute
    @Date
    Long fivetranConnectorLastSyncStartedAt;
    @Attribute
    Long fivetranConnectorLastSyncTablesSynced;
    @Attribute
    String fivetranConnectorLastSyncTaskType;
    @Attribute
    Double fivetranConnectorLastSyncTotalTimeSeconds;
    @Attribute
    Double fivetranConnectorMonthlyActiveRowsChangePercentageFree;
    @Attribute
    Double fivetranConnectorMonthlyActiveRowsChangePercentagePaid;
    @Attribute
    Double fivetranConnectorMonthlyActiveRowsChangePercentageTotal;
    @Attribute
    Long fivetranConnectorMonthlyActiveRowsFree;
    @Attribute
    Double fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount;
    @Attribute
    Long fivetranConnectorMonthlyActiveRowsPaid;
    @Attribute
    Double fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount;
    @Attribute
    Long fivetranConnectorMonthlyActiveRowsTotal;
    @Attribute
    Double fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount;
    @Attribute
    String fivetranConnectorName;
    @Attribute
    String fivetranConnectorSyncFrequency;
    @Attribute
    Boolean fivetranConnectorSyncPaused;
    @Attribute
    @Date
    Long fivetranConnectorSyncSetupOn;
    @Attribute
    String fivetranConnectorSyncSetupUserEmail;
    @Attribute
    String fivetranConnectorSyncSetupUserFullName;
    @Attribute
    String fivetranConnectorTopTablesByMAR;
    @Attribute
    Long fivetranConnectorTotalTablesSynced;
    @Attribute
    String fivetranConnectorType;
    @Attribute
    String fivetranConnectorURL;
    @Attribute
    Double fivetranConnectorUsageCost;
    @Attribute
    Long fivetranLastSyncRecordsUpdated;
    @Attribute
    FivetranConnectorStatus fivetranLastSyncStatus;
    @Attribute
    String fivetranWorkflowName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<ILineageProcess> processes;

    @Override
    public FivetranConnector trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return FivetranConnector.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return FivetranConnector.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return FivetranConnector.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return FivetranConnector.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return FivetranConnector.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return FivetranConnector.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static FivetranConnector refByGuid(String guid) {
        return FivetranConnector.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static FivetranConnector refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((FivetranConnectorBuilder)((FivetranConnectorBuilder)FivetranConnector._internal().guid(guid)).semantic(semantic)).build();
    }

    public static FivetranConnector refByQualifiedName(String qualifiedName) {
        return FivetranConnector.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static FivetranConnector refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((FivetranConnectorBuilder)((FivetranConnectorBuilder)FivetranConnector._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static FivetranConnector get(String id) throws AtlanException {
        return FivetranConnector.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static FivetranConnector get(AtlanClient client, String id) throws AtlanException {
        return FivetranConnector.get(client, id, true);
    }

    @JsonIgnore
    public static FivetranConnector get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof FivetranConnector) {
                return (FivetranConnector)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof FivetranConnector) {
            return (FivetranConnector)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return FivetranConnector.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static FivetranConnectorBuilder<?, ?> updater(String qualifiedName, String name) {
        return (FivetranConnectorBuilder)((FivetranConnectorBuilder)((FivetranConnectorBuilder)FivetranConnector._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public FivetranConnectorBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        FivetranConnector.validateRequired(TYPE_NAME, map);
        return FivetranConnector.updater(this.getQualifiedName(), this.getName());
    }

    public static FivetranConnector removeDescription(String qualifiedName, String name) throws AtlanException {
        return FivetranConnector.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static FivetranConnector removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FivetranConnector)Asset.removeDescription(client, FivetranConnector.updater(qualifiedName, name));
    }

    public static FivetranConnector removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return FivetranConnector.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static FivetranConnector removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FivetranConnector)Asset.removeUserDescription(client, FivetranConnector.updater(qualifiedName, name));
    }

    public static FivetranConnector removeOwners(String qualifiedName, String name) throws AtlanException {
        return FivetranConnector.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static FivetranConnector removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FivetranConnector)Asset.removeOwners(client, FivetranConnector.updater(qualifiedName, name));
    }

    public static FivetranConnector updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return FivetranConnector.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static FivetranConnector updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (FivetranConnector)Asset.updateCertificate(client, FivetranConnector._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static FivetranConnector removeCertificate(String qualifiedName, String name) throws AtlanException {
        return FivetranConnector.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static FivetranConnector removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FivetranConnector)Asset.removeCertificate(client, FivetranConnector.updater(qualifiedName, name));
    }

    public static FivetranConnector updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return FivetranConnector.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static FivetranConnector updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (FivetranConnector)Asset.updateAnnouncement(client, FivetranConnector._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static FivetranConnector removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return FivetranConnector.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static FivetranConnector removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FivetranConnector)Asset.removeAnnouncement(client, FivetranConnector.updater(qualifiedName, name));
    }

    public static FivetranConnector replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return FivetranConnector.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static FivetranConnector replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (FivetranConnector)Asset.replaceTerms(client, FivetranConnector.updater(qualifiedName, name), terms);
    }

    public static FivetranConnector appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return FivetranConnector.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static FivetranConnector appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (FivetranConnector)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static FivetranConnector removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return FivetranConnector.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static FivetranConnector removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (FivetranConnector)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static FivetranConnector appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return FivetranConnector.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static FivetranConnector appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (FivetranConnector)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static FivetranConnector appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return FivetranConnector.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static FivetranConnector appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (FivetranConnector)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        FivetranConnector.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected FivetranConnector(FivetranConnectorBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : FivetranConnector.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        this.fivetranConnectorCreditsUsed = b.fivetranConnectorCreditsUsed;
        this.fivetranConnectorDestinationName = b.fivetranConnectorDestinationName;
        this.fivetranConnectorDestinationType = b.fivetranConnectorDestinationType;
        this.fivetranConnectorDestinationURL = b.fivetranConnectorDestinationURL;
        this.fivetranConnectorLastSyncExtractTimeSeconds = b.fivetranConnectorLastSyncExtractTimeSeconds;
        this.fivetranConnectorLastSyncExtractVolumeMegabytes = b.fivetranConnectorLastSyncExtractVolumeMegabytes;
        this.fivetranConnectorLastSyncFinishedAt = b.fivetranConnectorLastSyncFinishedAt;
        this.fivetranConnectorLastSyncId = b.fivetranConnectorLastSyncId;
        this.fivetranConnectorLastSyncLoadTimeSeconds = b.fivetranConnectorLastSyncLoadTimeSeconds;
        this.fivetranConnectorLastSyncLoadVolumeMegabytes = b.fivetranConnectorLastSyncLoadVolumeMegabytes;
        this.fivetranConnectorLastSyncProcessTimeSeconds = b.fivetranConnectorLastSyncProcessTimeSeconds;
        this.fivetranConnectorLastSyncProcessVolumeMegabytes = b.fivetranConnectorLastSyncProcessVolumeMegabytes;
        this.fivetranConnectorLastSyncReason = b.fivetranConnectorLastSyncReason;
        this.fivetranConnectorLastSyncRescheduledAt = b.fivetranConnectorLastSyncRescheduledAt;
        this.fivetranConnectorLastSyncStartedAt = b.fivetranConnectorLastSyncStartedAt;
        this.fivetranConnectorLastSyncTablesSynced = b.fivetranConnectorLastSyncTablesSynced;
        this.fivetranConnectorLastSyncTaskType = b.fivetranConnectorLastSyncTaskType;
        this.fivetranConnectorLastSyncTotalTimeSeconds = b.fivetranConnectorLastSyncTotalTimeSeconds;
        this.fivetranConnectorMonthlyActiveRowsChangePercentageFree = b.fivetranConnectorMonthlyActiveRowsChangePercentageFree;
        this.fivetranConnectorMonthlyActiveRowsChangePercentagePaid = b.fivetranConnectorMonthlyActiveRowsChangePercentagePaid;
        this.fivetranConnectorMonthlyActiveRowsChangePercentageTotal = b.fivetranConnectorMonthlyActiveRowsChangePercentageTotal;
        this.fivetranConnectorMonthlyActiveRowsFree = b.fivetranConnectorMonthlyActiveRowsFree;
        this.fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount = b.fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount;
        this.fivetranConnectorMonthlyActiveRowsPaid = b.fivetranConnectorMonthlyActiveRowsPaid;
        this.fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount = b.fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount;
        this.fivetranConnectorMonthlyActiveRowsTotal = b.fivetranConnectorMonthlyActiveRowsTotal;
        this.fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount = b.fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount;
        this.fivetranConnectorName = b.fivetranConnectorName;
        this.fivetranConnectorSyncFrequency = b.fivetranConnectorSyncFrequency;
        this.fivetranConnectorSyncPaused = b.fivetranConnectorSyncPaused;
        this.fivetranConnectorSyncSetupOn = b.fivetranConnectorSyncSetupOn;
        this.fivetranConnectorSyncSetupUserEmail = b.fivetranConnectorSyncSetupUserEmail;
        this.fivetranConnectorSyncSetupUserFullName = b.fivetranConnectorSyncSetupUserFullName;
        this.fivetranConnectorTopTablesByMAR = b.fivetranConnectorTopTablesByMAR;
        this.fivetranConnectorTotalTablesSynced = b.fivetranConnectorTotalTablesSynced;
        this.fivetranConnectorType = b.fivetranConnectorType;
        this.fivetranConnectorURL = b.fivetranConnectorURL;
        this.fivetranConnectorUsageCost = b.fivetranConnectorUsageCost;
        this.fivetranLastSyncRecordsUpdated = b.fivetranLastSyncRecordsUpdated;
        this.fivetranLastSyncStatus = b.fivetranLastSyncStatus;
        this.fivetranWorkflowName = b.fivetranWorkflowName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<ILineageProcess> processes = new TreeSet<ILineageProcess>();
        if (b.processes != null) {
            processes.addAll(b.processes);
        }
        processes = Collections.unmodifiableSortedSet(processes);
        this.processes = processes;
    }

    @Generated
    public static FivetranConnectorBuilder<?, ?> _internal() {
        return new FivetranConnectorBuilderImpl();
    }

    @Generated
    public FivetranConnectorBuilder<?, ?> toBuilder() {
        return new FivetranConnectorBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public Double getFivetranConnectorCreditsUsed() {
        return this.fivetranConnectorCreditsUsed;
    }

    @Override
    @Generated
    public String getFivetranConnectorDestinationName() {
        return this.fivetranConnectorDestinationName;
    }

    @Override
    @Generated
    public String getFivetranConnectorDestinationType() {
        return this.fivetranConnectorDestinationType;
    }

    @Override
    @Generated
    public String getFivetranConnectorDestinationURL() {
        return this.fivetranConnectorDestinationURL;
    }

    @Override
    @Generated
    public Double getFivetranConnectorLastSyncExtractTimeSeconds() {
        return this.fivetranConnectorLastSyncExtractTimeSeconds;
    }

    @Override
    @Generated
    public Double getFivetranConnectorLastSyncExtractVolumeMegabytes() {
        return this.fivetranConnectorLastSyncExtractVolumeMegabytes;
    }

    @Override
    @Generated
    public Long getFivetranConnectorLastSyncFinishedAt() {
        return this.fivetranConnectorLastSyncFinishedAt;
    }

    @Override
    @Generated
    public String getFivetranConnectorLastSyncId() {
        return this.fivetranConnectorLastSyncId;
    }

    @Override
    @Generated
    public Double getFivetranConnectorLastSyncLoadTimeSeconds() {
        return this.fivetranConnectorLastSyncLoadTimeSeconds;
    }

    @Override
    @Generated
    public Double getFivetranConnectorLastSyncLoadVolumeMegabytes() {
        return this.fivetranConnectorLastSyncLoadVolumeMegabytes;
    }

    @Override
    @Generated
    public Double getFivetranConnectorLastSyncProcessTimeSeconds() {
        return this.fivetranConnectorLastSyncProcessTimeSeconds;
    }

    @Override
    @Generated
    public Double getFivetranConnectorLastSyncProcessVolumeMegabytes() {
        return this.fivetranConnectorLastSyncProcessVolumeMegabytes;
    }

    @Override
    @Generated
    public String getFivetranConnectorLastSyncReason() {
        return this.fivetranConnectorLastSyncReason;
    }

    @Override
    @Generated
    public Long getFivetranConnectorLastSyncRescheduledAt() {
        return this.fivetranConnectorLastSyncRescheduledAt;
    }

    @Override
    @Generated
    public Long getFivetranConnectorLastSyncStartedAt() {
        return this.fivetranConnectorLastSyncStartedAt;
    }

    @Override
    @Generated
    public Long getFivetranConnectorLastSyncTablesSynced() {
        return this.fivetranConnectorLastSyncTablesSynced;
    }

    @Override
    @Generated
    public String getFivetranConnectorLastSyncTaskType() {
        return this.fivetranConnectorLastSyncTaskType;
    }

    @Override
    @Generated
    public Double getFivetranConnectorLastSyncTotalTimeSeconds() {
        return this.fivetranConnectorLastSyncTotalTimeSeconds;
    }

    @Override
    @Generated
    public Double getFivetranConnectorMonthlyActiveRowsChangePercentageFree() {
        return this.fivetranConnectorMonthlyActiveRowsChangePercentageFree;
    }

    @Override
    @Generated
    public Double getFivetranConnectorMonthlyActiveRowsChangePercentagePaid() {
        return this.fivetranConnectorMonthlyActiveRowsChangePercentagePaid;
    }

    @Override
    @Generated
    public Double getFivetranConnectorMonthlyActiveRowsChangePercentageTotal() {
        return this.fivetranConnectorMonthlyActiveRowsChangePercentageTotal;
    }

    @Override
    @Generated
    public Long getFivetranConnectorMonthlyActiveRowsFree() {
        return this.fivetranConnectorMonthlyActiveRowsFree;
    }

    @Override
    @Generated
    public Double getFivetranConnectorMonthlyActiveRowsFreePercentageOfAccount() {
        return this.fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount;
    }

    @Override
    @Generated
    public Long getFivetranConnectorMonthlyActiveRowsPaid() {
        return this.fivetranConnectorMonthlyActiveRowsPaid;
    }

    @Override
    @Generated
    public Double getFivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount() {
        return this.fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount;
    }

    @Override
    @Generated
    public Long getFivetranConnectorMonthlyActiveRowsTotal() {
        return this.fivetranConnectorMonthlyActiveRowsTotal;
    }

    @Override
    @Generated
    public Double getFivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount() {
        return this.fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount;
    }

    @Override
    @Generated
    public String getFivetranConnectorName() {
        return this.fivetranConnectorName;
    }

    @Override
    @Generated
    public String getFivetranConnectorSyncFrequency() {
        return this.fivetranConnectorSyncFrequency;
    }

    @Override
    @Generated
    public Boolean getFivetranConnectorSyncPaused() {
        return this.fivetranConnectorSyncPaused;
    }

    @Override
    @Generated
    public Long getFivetranConnectorSyncSetupOn() {
        return this.fivetranConnectorSyncSetupOn;
    }

    @Override
    @Generated
    public String getFivetranConnectorSyncSetupUserEmail() {
        return this.fivetranConnectorSyncSetupUserEmail;
    }

    @Override
    @Generated
    public String getFivetranConnectorSyncSetupUserFullName() {
        return this.fivetranConnectorSyncSetupUserFullName;
    }

    @Override
    @Generated
    public String getFivetranConnectorTopTablesByMAR() {
        return this.fivetranConnectorTopTablesByMAR;
    }

    @Override
    @Generated
    public Long getFivetranConnectorTotalTablesSynced() {
        return this.fivetranConnectorTotalTablesSynced;
    }

    @Override
    @Generated
    public String getFivetranConnectorType() {
        return this.fivetranConnectorType;
    }

    @Override
    @Generated
    public String getFivetranConnectorURL() {
        return this.fivetranConnectorURL;
    }

    @Override
    @Generated
    public Double getFivetranConnectorUsageCost() {
        return this.fivetranConnectorUsageCost;
    }

    @Override
    @Generated
    public Long getFivetranLastSyncRecordsUpdated() {
        return this.fivetranLastSyncRecordsUpdated;
    }

    @Override
    @Generated
    public FivetranConnectorStatus getFivetranLastSyncStatus() {
        return this.fivetranLastSyncStatus;
    }

    @Override
    @Generated
    public String getFivetranWorkflowName() {
        return this.fivetranWorkflowName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getProcesses() {
        return this.processes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FivetranConnector)) {
            return false;
        }
        FivetranConnector other = (FivetranConnector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$fivetranConnectorCreditsUsed = this.getFivetranConnectorCreditsUsed();
        Double other$fivetranConnectorCreditsUsed = other.getFivetranConnectorCreditsUsed();
        if (this$fivetranConnectorCreditsUsed == null ? other$fivetranConnectorCreditsUsed != null : !((Object)this$fivetranConnectorCreditsUsed).equals(other$fivetranConnectorCreditsUsed)) {
            return false;
        }
        Double this$fivetranConnectorLastSyncExtractTimeSeconds = this.getFivetranConnectorLastSyncExtractTimeSeconds();
        Double other$fivetranConnectorLastSyncExtractTimeSeconds = other.getFivetranConnectorLastSyncExtractTimeSeconds();
        if (this$fivetranConnectorLastSyncExtractTimeSeconds == null ? other$fivetranConnectorLastSyncExtractTimeSeconds != null : !((Object)this$fivetranConnectorLastSyncExtractTimeSeconds).equals(other$fivetranConnectorLastSyncExtractTimeSeconds)) {
            return false;
        }
        Double this$fivetranConnectorLastSyncExtractVolumeMegabytes = this.getFivetranConnectorLastSyncExtractVolumeMegabytes();
        Double other$fivetranConnectorLastSyncExtractVolumeMegabytes = other.getFivetranConnectorLastSyncExtractVolumeMegabytes();
        if (this$fivetranConnectorLastSyncExtractVolumeMegabytes == null ? other$fivetranConnectorLastSyncExtractVolumeMegabytes != null : !((Object)this$fivetranConnectorLastSyncExtractVolumeMegabytes).equals(other$fivetranConnectorLastSyncExtractVolumeMegabytes)) {
            return false;
        }
        Long this$fivetranConnectorLastSyncFinishedAt = this.getFivetranConnectorLastSyncFinishedAt();
        Long other$fivetranConnectorLastSyncFinishedAt = other.getFivetranConnectorLastSyncFinishedAt();
        if (this$fivetranConnectorLastSyncFinishedAt == null ? other$fivetranConnectorLastSyncFinishedAt != null : !((Object)this$fivetranConnectorLastSyncFinishedAt).equals(other$fivetranConnectorLastSyncFinishedAt)) {
            return false;
        }
        Double this$fivetranConnectorLastSyncLoadTimeSeconds = this.getFivetranConnectorLastSyncLoadTimeSeconds();
        Double other$fivetranConnectorLastSyncLoadTimeSeconds = other.getFivetranConnectorLastSyncLoadTimeSeconds();
        if (this$fivetranConnectorLastSyncLoadTimeSeconds == null ? other$fivetranConnectorLastSyncLoadTimeSeconds != null : !((Object)this$fivetranConnectorLastSyncLoadTimeSeconds).equals(other$fivetranConnectorLastSyncLoadTimeSeconds)) {
            return false;
        }
        Double this$fivetranConnectorLastSyncLoadVolumeMegabytes = this.getFivetranConnectorLastSyncLoadVolumeMegabytes();
        Double other$fivetranConnectorLastSyncLoadVolumeMegabytes = other.getFivetranConnectorLastSyncLoadVolumeMegabytes();
        if (this$fivetranConnectorLastSyncLoadVolumeMegabytes == null ? other$fivetranConnectorLastSyncLoadVolumeMegabytes != null : !((Object)this$fivetranConnectorLastSyncLoadVolumeMegabytes).equals(other$fivetranConnectorLastSyncLoadVolumeMegabytes)) {
            return false;
        }
        Double this$fivetranConnectorLastSyncProcessTimeSeconds = this.getFivetranConnectorLastSyncProcessTimeSeconds();
        Double other$fivetranConnectorLastSyncProcessTimeSeconds = other.getFivetranConnectorLastSyncProcessTimeSeconds();
        if (this$fivetranConnectorLastSyncProcessTimeSeconds == null ? other$fivetranConnectorLastSyncProcessTimeSeconds != null : !((Object)this$fivetranConnectorLastSyncProcessTimeSeconds).equals(other$fivetranConnectorLastSyncProcessTimeSeconds)) {
            return false;
        }
        Double this$fivetranConnectorLastSyncProcessVolumeMegabytes = this.getFivetranConnectorLastSyncProcessVolumeMegabytes();
        Double other$fivetranConnectorLastSyncProcessVolumeMegabytes = other.getFivetranConnectorLastSyncProcessVolumeMegabytes();
        if (this$fivetranConnectorLastSyncProcessVolumeMegabytes == null ? other$fivetranConnectorLastSyncProcessVolumeMegabytes != null : !((Object)this$fivetranConnectorLastSyncProcessVolumeMegabytes).equals(other$fivetranConnectorLastSyncProcessVolumeMegabytes)) {
            return false;
        }
        Long this$fivetranConnectorLastSyncRescheduledAt = this.getFivetranConnectorLastSyncRescheduledAt();
        Long other$fivetranConnectorLastSyncRescheduledAt = other.getFivetranConnectorLastSyncRescheduledAt();
        if (this$fivetranConnectorLastSyncRescheduledAt == null ? other$fivetranConnectorLastSyncRescheduledAt != null : !((Object)this$fivetranConnectorLastSyncRescheduledAt).equals(other$fivetranConnectorLastSyncRescheduledAt)) {
            return false;
        }
        Long this$fivetranConnectorLastSyncStartedAt = this.getFivetranConnectorLastSyncStartedAt();
        Long other$fivetranConnectorLastSyncStartedAt = other.getFivetranConnectorLastSyncStartedAt();
        if (this$fivetranConnectorLastSyncStartedAt == null ? other$fivetranConnectorLastSyncStartedAt != null : !((Object)this$fivetranConnectorLastSyncStartedAt).equals(other$fivetranConnectorLastSyncStartedAt)) {
            return false;
        }
        Long this$fivetranConnectorLastSyncTablesSynced = this.getFivetranConnectorLastSyncTablesSynced();
        Long other$fivetranConnectorLastSyncTablesSynced = other.getFivetranConnectorLastSyncTablesSynced();
        if (this$fivetranConnectorLastSyncTablesSynced == null ? other$fivetranConnectorLastSyncTablesSynced != null : !((Object)this$fivetranConnectorLastSyncTablesSynced).equals(other$fivetranConnectorLastSyncTablesSynced)) {
            return false;
        }
        Double this$fivetranConnectorLastSyncTotalTimeSeconds = this.getFivetranConnectorLastSyncTotalTimeSeconds();
        Double other$fivetranConnectorLastSyncTotalTimeSeconds = other.getFivetranConnectorLastSyncTotalTimeSeconds();
        if (this$fivetranConnectorLastSyncTotalTimeSeconds == null ? other$fivetranConnectorLastSyncTotalTimeSeconds != null : !((Object)this$fivetranConnectorLastSyncTotalTimeSeconds).equals(other$fivetranConnectorLastSyncTotalTimeSeconds)) {
            return false;
        }
        Double this$fivetranConnectorMonthlyActiveRowsChangePercentageFree = this.getFivetranConnectorMonthlyActiveRowsChangePercentageFree();
        Double other$fivetranConnectorMonthlyActiveRowsChangePercentageFree = other.getFivetranConnectorMonthlyActiveRowsChangePercentageFree();
        if (this$fivetranConnectorMonthlyActiveRowsChangePercentageFree == null ? other$fivetranConnectorMonthlyActiveRowsChangePercentageFree != null : !((Object)this$fivetranConnectorMonthlyActiveRowsChangePercentageFree).equals(other$fivetranConnectorMonthlyActiveRowsChangePercentageFree)) {
            return false;
        }
        Double this$fivetranConnectorMonthlyActiveRowsChangePercentagePaid = this.getFivetranConnectorMonthlyActiveRowsChangePercentagePaid();
        Double other$fivetranConnectorMonthlyActiveRowsChangePercentagePaid = other.getFivetranConnectorMonthlyActiveRowsChangePercentagePaid();
        if (this$fivetranConnectorMonthlyActiveRowsChangePercentagePaid == null ? other$fivetranConnectorMonthlyActiveRowsChangePercentagePaid != null : !((Object)this$fivetranConnectorMonthlyActiveRowsChangePercentagePaid).equals(other$fivetranConnectorMonthlyActiveRowsChangePercentagePaid)) {
            return false;
        }
        Double this$fivetranConnectorMonthlyActiveRowsChangePercentageTotal = this.getFivetranConnectorMonthlyActiveRowsChangePercentageTotal();
        Double other$fivetranConnectorMonthlyActiveRowsChangePercentageTotal = other.getFivetranConnectorMonthlyActiveRowsChangePercentageTotal();
        if (this$fivetranConnectorMonthlyActiveRowsChangePercentageTotal == null ? other$fivetranConnectorMonthlyActiveRowsChangePercentageTotal != null : !((Object)this$fivetranConnectorMonthlyActiveRowsChangePercentageTotal).equals(other$fivetranConnectorMonthlyActiveRowsChangePercentageTotal)) {
            return false;
        }
        Long this$fivetranConnectorMonthlyActiveRowsFree = this.getFivetranConnectorMonthlyActiveRowsFree();
        Long other$fivetranConnectorMonthlyActiveRowsFree = other.getFivetranConnectorMonthlyActiveRowsFree();
        if (this$fivetranConnectorMonthlyActiveRowsFree == null ? other$fivetranConnectorMonthlyActiveRowsFree != null : !((Object)this$fivetranConnectorMonthlyActiveRowsFree).equals(other$fivetranConnectorMonthlyActiveRowsFree)) {
            return false;
        }
        Double this$fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount = this.getFivetranConnectorMonthlyActiveRowsFreePercentageOfAccount();
        Double other$fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount = other.getFivetranConnectorMonthlyActiveRowsFreePercentageOfAccount();
        if (this$fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount == null ? other$fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount != null : !((Object)this$fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount).equals(other$fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount)) {
            return false;
        }
        Long this$fivetranConnectorMonthlyActiveRowsPaid = this.getFivetranConnectorMonthlyActiveRowsPaid();
        Long other$fivetranConnectorMonthlyActiveRowsPaid = other.getFivetranConnectorMonthlyActiveRowsPaid();
        if (this$fivetranConnectorMonthlyActiveRowsPaid == null ? other$fivetranConnectorMonthlyActiveRowsPaid != null : !((Object)this$fivetranConnectorMonthlyActiveRowsPaid).equals(other$fivetranConnectorMonthlyActiveRowsPaid)) {
            return false;
        }
        Double this$fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount = this.getFivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount();
        Double other$fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount = other.getFivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount();
        if (this$fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount == null ? other$fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount != null : !((Object)this$fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount).equals(other$fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount)) {
            return false;
        }
        Long this$fivetranConnectorMonthlyActiveRowsTotal = this.getFivetranConnectorMonthlyActiveRowsTotal();
        Long other$fivetranConnectorMonthlyActiveRowsTotal = other.getFivetranConnectorMonthlyActiveRowsTotal();
        if (this$fivetranConnectorMonthlyActiveRowsTotal == null ? other$fivetranConnectorMonthlyActiveRowsTotal != null : !((Object)this$fivetranConnectorMonthlyActiveRowsTotal).equals(other$fivetranConnectorMonthlyActiveRowsTotal)) {
            return false;
        }
        Double this$fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount = this.getFivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount();
        Double other$fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount = other.getFivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount();
        if (this$fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount == null ? other$fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount != null : !((Object)this$fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount).equals(other$fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount)) {
            return false;
        }
        Boolean this$fivetranConnectorSyncPaused = this.getFivetranConnectorSyncPaused();
        Boolean other$fivetranConnectorSyncPaused = other.getFivetranConnectorSyncPaused();
        if (this$fivetranConnectorSyncPaused == null ? other$fivetranConnectorSyncPaused != null : !((Object)this$fivetranConnectorSyncPaused).equals(other$fivetranConnectorSyncPaused)) {
            return false;
        }
        Long this$fivetranConnectorSyncSetupOn = this.getFivetranConnectorSyncSetupOn();
        Long other$fivetranConnectorSyncSetupOn = other.getFivetranConnectorSyncSetupOn();
        if (this$fivetranConnectorSyncSetupOn == null ? other$fivetranConnectorSyncSetupOn != null : !((Object)this$fivetranConnectorSyncSetupOn).equals(other$fivetranConnectorSyncSetupOn)) {
            return false;
        }
        Long this$fivetranConnectorTotalTablesSynced = this.getFivetranConnectorTotalTablesSynced();
        Long other$fivetranConnectorTotalTablesSynced = other.getFivetranConnectorTotalTablesSynced();
        if (this$fivetranConnectorTotalTablesSynced == null ? other$fivetranConnectorTotalTablesSynced != null : !((Object)this$fivetranConnectorTotalTablesSynced).equals(other$fivetranConnectorTotalTablesSynced)) {
            return false;
        }
        Double this$fivetranConnectorUsageCost = this.getFivetranConnectorUsageCost();
        Double other$fivetranConnectorUsageCost = other.getFivetranConnectorUsageCost();
        if (this$fivetranConnectorUsageCost == null ? other$fivetranConnectorUsageCost != null : !((Object)this$fivetranConnectorUsageCost).equals(other$fivetranConnectorUsageCost)) {
            return false;
        }
        Long this$fivetranLastSyncRecordsUpdated = this.getFivetranLastSyncRecordsUpdated();
        Long other$fivetranLastSyncRecordsUpdated = other.getFivetranLastSyncRecordsUpdated();
        if (this$fivetranLastSyncRecordsUpdated == null ? other$fivetranLastSyncRecordsUpdated != null : !((Object)this$fivetranLastSyncRecordsUpdated).equals(other$fivetranLastSyncRecordsUpdated)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        String this$fivetranConnectorDestinationName = this.getFivetranConnectorDestinationName();
        String other$fivetranConnectorDestinationName = other.getFivetranConnectorDestinationName();
        if (this$fivetranConnectorDestinationName == null ? other$fivetranConnectorDestinationName != null : !this$fivetranConnectorDestinationName.equals(other$fivetranConnectorDestinationName)) {
            return false;
        }
        String this$fivetranConnectorDestinationType = this.getFivetranConnectorDestinationType();
        String other$fivetranConnectorDestinationType = other.getFivetranConnectorDestinationType();
        if (this$fivetranConnectorDestinationType == null ? other$fivetranConnectorDestinationType != null : !this$fivetranConnectorDestinationType.equals(other$fivetranConnectorDestinationType)) {
            return false;
        }
        String this$fivetranConnectorDestinationURL = this.getFivetranConnectorDestinationURL();
        String other$fivetranConnectorDestinationURL = other.getFivetranConnectorDestinationURL();
        if (this$fivetranConnectorDestinationURL == null ? other$fivetranConnectorDestinationURL != null : !this$fivetranConnectorDestinationURL.equals(other$fivetranConnectorDestinationURL)) {
            return false;
        }
        String this$fivetranConnectorLastSyncId = this.getFivetranConnectorLastSyncId();
        String other$fivetranConnectorLastSyncId = other.getFivetranConnectorLastSyncId();
        if (this$fivetranConnectorLastSyncId == null ? other$fivetranConnectorLastSyncId != null : !this$fivetranConnectorLastSyncId.equals(other$fivetranConnectorLastSyncId)) {
            return false;
        }
        String this$fivetranConnectorLastSyncReason = this.getFivetranConnectorLastSyncReason();
        String other$fivetranConnectorLastSyncReason = other.getFivetranConnectorLastSyncReason();
        if (this$fivetranConnectorLastSyncReason == null ? other$fivetranConnectorLastSyncReason != null : !this$fivetranConnectorLastSyncReason.equals(other$fivetranConnectorLastSyncReason)) {
            return false;
        }
        String this$fivetranConnectorLastSyncTaskType = this.getFivetranConnectorLastSyncTaskType();
        String other$fivetranConnectorLastSyncTaskType = other.getFivetranConnectorLastSyncTaskType();
        if (this$fivetranConnectorLastSyncTaskType == null ? other$fivetranConnectorLastSyncTaskType != null : !this$fivetranConnectorLastSyncTaskType.equals(other$fivetranConnectorLastSyncTaskType)) {
            return false;
        }
        String this$fivetranConnectorName = this.getFivetranConnectorName();
        String other$fivetranConnectorName = other.getFivetranConnectorName();
        if (this$fivetranConnectorName == null ? other$fivetranConnectorName != null : !this$fivetranConnectorName.equals(other$fivetranConnectorName)) {
            return false;
        }
        String this$fivetranConnectorSyncFrequency = this.getFivetranConnectorSyncFrequency();
        String other$fivetranConnectorSyncFrequency = other.getFivetranConnectorSyncFrequency();
        if (this$fivetranConnectorSyncFrequency == null ? other$fivetranConnectorSyncFrequency != null : !this$fivetranConnectorSyncFrequency.equals(other$fivetranConnectorSyncFrequency)) {
            return false;
        }
        String this$fivetranConnectorSyncSetupUserEmail = this.getFivetranConnectorSyncSetupUserEmail();
        String other$fivetranConnectorSyncSetupUserEmail = other.getFivetranConnectorSyncSetupUserEmail();
        if (this$fivetranConnectorSyncSetupUserEmail == null ? other$fivetranConnectorSyncSetupUserEmail != null : !this$fivetranConnectorSyncSetupUserEmail.equals(other$fivetranConnectorSyncSetupUserEmail)) {
            return false;
        }
        String this$fivetranConnectorSyncSetupUserFullName = this.getFivetranConnectorSyncSetupUserFullName();
        String other$fivetranConnectorSyncSetupUserFullName = other.getFivetranConnectorSyncSetupUserFullName();
        if (this$fivetranConnectorSyncSetupUserFullName == null ? other$fivetranConnectorSyncSetupUserFullName != null : !this$fivetranConnectorSyncSetupUserFullName.equals(other$fivetranConnectorSyncSetupUserFullName)) {
            return false;
        }
        String this$fivetranConnectorTopTablesByMAR = this.getFivetranConnectorTopTablesByMAR();
        String other$fivetranConnectorTopTablesByMAR = other.getFivetranConnectorTopTablesByMAR();
        if (this$fivetranConnectorTopTablesByMAR == null ? other$fivetranConnectorTopTablesByMAR != null : !this$fivetranConnectorTopTablesByMAR.equals(other$fivetranConnectorTopTablesByMAR)) {
            return false;
        }
        String this$fivetranConnectorType = this.getFivetranConnectorType();
        String other$fivetranConnectorType = other.getFivetranConnectorType();
        if (this$fivetranConnectorType == null ? other$fivetranConnectorType != null : !this$fivetranConnectorType.equals(other$fivetranConnectorType)) {
            return false;
        }
        String this$fivetranConnectorURL = this.getFivetranConnectorURL();
        String other$fivetranConnectorURL = other.getFivetranConnectorURL();
        if (this$fivetranConnectorURL == null ? other$fivetranConnectorURL != null : !this$fivetranConnectorURL.equals(other$fivetranConnectorURL)) {
            return false;
        }
        FivetranConnectorStatus this$fivetranLastSyncStatus = this.getFivetranLastSyncStatus();
        FivetranConnectorStatus other$fivetranLastSyncStatus = other.getFivetranLastSyncStatus();
        if (this$fivetranLastSyncStatus == null ? other$fivetranLastSyncStatus != null : !this$fivetranLastSyncStatus.equals(other$fivetranLastSyncStatus)) {
            return false;
        }
        String this$fivetranWorkflowName = this.getFivetranWorkflowName();
        String other$fivetranWorkflowName = other.getFivetranWorkflowName();
        if (this$fivetranWorkflowName == null ? other$fivetranWorkflowName != null : !this$fivetranWorkflowName.equals(other$fivetranWorkflowName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<ILineageProcess> this$processes = this.getProcesses();
        SortedSet<ILineageProcess> other$processes = other.getProcesses();
        return !(this$processes == null ? other$processes != null : !this$processes.equals(other$processes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FivetranConnector;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $fivetranConnectorCreditsUsed = this.getFivetranConnectorCreditsUsed();
        result = result * 59 + ($fivetranConnectorCreditsUsed == null ? 43 : ((Object)$fivetranConnectorCreditsUsed).hashCode());
        Double $fivetranConnectorLastSyncExtractTimeSeconds = this.getFivetranConnectorLastSyncExtractTimeSeconds();
        result = result * 59 + ($fivetranConnectorLastSyncExtractTimeSeconds == null ? 43 : ((Object)$fivetranConnectorLastSyncExtractTimeSeconds).hashCode());
        Double $fivetranConnectorLastSyncExtractVolumeMegabytes = this.getFivetranConnectorLastSyncExtractVolumeMegabytes();
        result = result * 59 + ($fivetranConnectorLastSyncExtractVolumeMegabytes == null ? 43 : ((Object)$fivetranConnectorLastSyncExtractVolumeMegabytes).hashCode());
        Long $fivetranConnectorLastSyncFinishedAt = this.getFivetranConnectorLastSyncFinishedAt();
        result = result * 59 + ($fivetranConnectorLastSyncFinishedAt == null ? 43 : ((Object)$fivetranConnectorLastSyncFinishedAt).hashCode());
        Double $fivetranConnectorLastSyncLoadTimeSeconds = this.getFivetranConnectorLastSyncLoadTimeSeconds();
        result = result * 59 + ($fivetranConnectorLastSyncLoadTimeSeconds == null ? 43 : ((Object)$fivetranConnectorLastSyncLoadTimeSeconds).hashCode());
        Double $fivetranConnectorLastSyncLoadVolumeMegabytes = this.getFivetranConnectorLastSyncLoadVolumeMegabytes();
        result = result * 59 + ($fivetranConnectorLastSyncLoadVolumeMegabytes == null ? 43 : ((Object)$fivetranConnectorLastSyncLoadVolumeMegabytes).hashCode());
        Double $fivetranConnectorLastSyncProcessTimeSeconds = this.getFivetranConnectorLastSyncProcessTimeSeconds();
        result = result * 59 + ($fivetranConnectorLastSyncProcessTimeSeconds == null ? 43 : ((Object)$fivetranConnectorLastSyncProcessTimeSeconds).hashCode());
        Double $fivetranConnectorLastSyncProcessVolumeMegabytes = this.getFivetranConnectorLastSyncProcessVolumeMegabytes();
        result = result * 59 + ($fivetranConnectorLastSyncProcessVolumeMegabytes == null ? 43 : ((Object)$fivetranConnectorLastSyncProcessVolumeMegabytes).hashCode());
        Long $fivetranConnectorLastSyncRescheduledAt = this.getFivetranConnectorLastSyncRescheduledAt();
        result = result * 59 + ($fivetranConnectorLastSyncRescheduledAt == null ? 43 : ((Object)$fivetranConnectorLastSyncRescheduledAt).hashCode());
        Long $fivetranConnectorLastSyncStartedAt = this.getFivetranConnectorLastSyncStartedAt();
        result = result * 59 + ($fivetranConnectorLastSyncStartedAt == null ? 43 : ((Object)$fivetranConnectorLastSyncStartedAt).hashCode());
        Long $fivetranConnectorLastSyncTablesSynced = this.getFivetranConnectorLastSyncTablesSynced();
        result = result * 59 + ($fivetranConnectorLastSyncTablesSynced == null ? 43 : ((Object)$fivetranConnectorLastSyncTablesSynced).hashCode());
        Double $fivetranConnectorLastSyncTotalTimeSeconds = this.getFivetranConnectorLastSyncTotalTimeSeconds();
        result = result * 59 + ($fivetranConnectorLastSyncTotalTimeSeconds == null ? 43 : ((Object)$fivetranConnectorLastSyncTotalTimeSeconds).hashCode());
        Double $fivetranConnectorMonthlyActiveRowsChangePercentageFree = this.getFivetranConnectorMonthlyActiveRowsChangePercentageFree();
        result = result * 59 + ($fivetranConnectorMonthlyActiveRowsChangePercentageFree == null ? 43 : ((Object)$fivetranConnectorMonthlyActiveRowsChangePercentageFree).hashCode());
        Double $fivetranConnectorMonthlyActiveRowsChangePercentagePaid = this.getFivetranConnectorMonthlyActiveRowsChangePercentagePaid();
        result = result * 59 + ($fivetranConnectorMonthlyActiveRowsChangePercentagePaid == null ? 43 : ((Object)$fivetranConnectorMonthlyActiveRowsChangePercentagePaid).hashCode());
        Double $fivetranConnectorMonthlyActiveRowsChangePercentageTotal = this.getFivetranConnectorMonthlyActiveRowsChangePercentageTotal();
        result = result * 59 + ($fivetranConnectorMonthlyActiveRowsChangePercentageTotal == null ? 43 : ((Object)$fivetranConnectorMonthlyActiveRowsChangePercentageTotal).hashCode());
        Long $fivetranConnectorMonthlyActiveRowsFree = this.getFivetranConnectorMonthlyActiveRowsFree();
        result = result * 59 + ($fivetranConnectorMonthlyActiveRowsFree == null ? 43 : ((Object)$fivetranConnectorMonthlyActiveRowsFree).hashCode());
        Double $fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount = this.getFivetranConnectorMonthlyActiveRowsFreePercentageOfAccount();
        result = result * 59 + ($fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount == null ? 43 : ((Object)$fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount).hashCode());
        Long $fivetranConnectorMonthlyActiveRowsPaid = this.getFivetranConnectorMonthlyActiveRowsPaid();
        result = result * 59 + ($fivetranConnectorMonthlyActiveRowsPaid == null ? 43 : ((Object)$fivetranConnectorMonthlyActiveRowsPaid).hashCode());
        Double $fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount = this.getFivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount();
        result = result * 59 + ($fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount == null ? 43 : ((Object)$fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount).hashCode());
        Long $fivetranConnectorMonthlyActiveRowsTotal = this.getFivetranConnectorMonthlyActiveRowsTotal();
        result = result * 59 + ($fivetranConnectorMonthlyActiveRowsTotal == null ? 43 : ((Object)$fivetranConnectorMonthlyActiveRowsTotal).hashCode());
        Double $fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount = this.getFivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount();
        result = result * 59 + ($fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount == null ? 43 : ((Object)$fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount).hashCode());
        Boolean $fivetranConnectorSyncPaused = this.getFivetranConnectorSyncPaused();
        result = result * 59 + ($fivetranConnectorSyncPaused == null ? 43 : ((Object)$fivetranConnectorSyncPaused).hashCode());
        Long $fivetranConnectorSyncSetupOn = this.getFivetranConnectorSyncSetupOn();
        result = result * 59 + ($fivetranConnectorSyncSetupOn == null ? 43 : ((Object)$fivetranConnectorSyncSetupOn).hashCode());
        Long $fivetranConnectorTotalTablesSynced = this.getFivetranConnectorTotalTablesSynced();
        result = result * 59 + ($fivetranConnectorTotalTablesSynced == null ? 43 : ((Object)$fivetranConnectorTotalTablesSynced).hashCode());
        Double $fivetranConnectorUsageCost = this.getFivetranConnectorUsageCost();
        result = result * 59 + ($fivetranConnectorUsageCost == null ? 43 : ((Object)$fivetranConnectorUsageCost).hashCode());
        Long $fivetranLastSyncRecordsUpdated = this.getFivetranLastSyncRecordsUpdated();
        result = result * 59 + ($fivetranLastSyncRecordsUpdated == null ? 43 : ((Object)$fivetranLastSyncRecordsUpdated).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        String $fivetranConnectorDestinationName = this.getFivetranConnectorDestinationName();
        result = result * 59 + ($fivetranConnectorDestinationName == null ? 43 : $fivetranConnectorDestinationName.hashCode());
        String $fivetranConnectorDestinationType = this.getFivetranConnectorDestinationType();
        result = result * 59 + ($fivetranConnectorDestinationType == null ? 43 : $fivetranConnectorDestinationType.hashCode());
        String $fivetranConnectorDestinationURL = this.getFivetranConnectorDestinationURL();
        result = result * 59 + ($fivetranConnectorDestinationURL == null ? 43 : $fivetranConnectorDestinationURL.hashCode());
        String $fivetranConnectorLastSyncId = this.getFivetranConnectorLastSyncId();
        result = result * 59 + ($fivetranConnectorLastSyncId == null ? 43 : $fivetranConnectorLastSyncId.hashCode());
        String $fivetranConnectorLastSyncReason = this.getFivetranConnectorLastSyncReason();
        result = result * 59 + ($fivetranConnectorLastSyncReason == null ? 43 : $fivetranConnectorLastSyncReason.hashCode());
        String $fivetranConnectorLastSyncTaskType = this.getFivetranConnectorLastSyncTaskType();
        result = result * 59 + ($fivetranConnectorLastSyncTaskType == null ? 43 : $fivetranConnectorLastSyncTaskType.hashCode());
        String $fivetranConnectorName = this.getFivetranConnectorName();
        result = result * 59 + ($fivetranConnectorName == null ? 43 : $fivetranConnectorName.hashCode());
        String $fivetranConnectorSyncFrequency = this.getFivetranConnectorSyncFrequency();
        result = result * 59 + ($fivetranConnectorSyncFrequency == null ? 43 : $fivetranConnectorSyncFrequency.hashCode());
        String $fivetranConnectorSyncSetupUserEmail = this.getFivetranConnectorSyncSetupUserEmail();
        result = result * 59 + ($fivetranConnectorSyncSetupUserEmail == null ? 43 : $fivetranConnectorSyncSetupUserEmail.hashCode());
        String $fivetranConnectorSyncSetupUserFullName = this.getFivetranConnectorSyncSetupUserFullName();
        result = result * 59 + ($fivetranConnectorSyncSetupUserFullName == null ? 43 : $fivetranConnectorSyncSetupUserFullName.hashCode());
        String $fivetranConnectorTopTablesByMAR = this.getFivetranConnectorTopTablesByMAR();
        result = result * 59 + ($fivetranConnectorTopTablesByMAR == null ? 43 : $fivetranConnectorTopTablesByMAR.hashCode());
        String $fivetranConnectorType = this.getFivetranConnectorType();
        result = result * 59 + ($fivetranConnectorType == null ? 43 : $fivetranConnectorType.hashCode());
        String $fivetranConnectorURL = this.getFivetranConnectorURL();
        result = result * 59 + ($fivetranConnectorURL == null ? 43 : $fivetranConnectorURL.hashCode());
        FivetranConnectorStatus $fivetranLastSyncStatus = this.getFivetranLastSyncStatus();
        result = result * 59 + ($fivetranLastSyncStatus == null ? 43 : $fivetranLastSyncStatus.hashCode());
        String $fivetranWorkflowName = this.getFivetranWorkflowName();
        result = result * 59 + ($fivetranWorkflowName == null ? 43 : $fivetranWorkflowName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<ILineageProcess> $processes = this.getProcesses();
        result = result * 59 + ($processes == null ? 43 : $processes.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FivetranConnector(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", fivetranConnectorCreditsUsed=" + this.getFivetranConnectorCreditsUsed() + ", fivetranConnectorDestinationName=" + this.getFivetranConnectorDestinationName() + ", fivetranConnectorDestinationType=" + this.getFivetranConnectorDestinationType() + ", fivetranConnectorDestinationURL=" + this.getFivetranConnectorDestinationURL() + ", fivetranConnectorLastSyncExtractTimeSeconds=" + this.getFivetranConnectorLastSyncExtractTimeSeconds() + ", fivetranConnectorLastSyncExtractVolumeMegabytes=" + this.getFivetranConnectorLastSyncExtractVolumeMegabytes() + ", fivetranConnectorLastSyncFinishedAt=" + this.getFivetranConnectorLastSyncFinishedAt() + ", fivetranConnectorLastSyncId=" + this.getFivetranConnectorLastSyncId() + ", fivetranConnectorLastSyncLoadTimeSeconds=" + this.getFivetranConnectorLastSyncLoadTimeSeconds() + ", fivetranConnectorLastSyncLoadVolumeMegabytes=" + this.getFivetranConnectorLastSyncLoadVolumeMegabytes() + ", fivetranConnectorLastSyncProcessTimeSeconds=" + this.getFivetranConnectorLastSyncProcessTimeSeconds() + ", fivetranConnectorLastSyncProcessVolumeMegabytes=" + this.getFivetranConnectorLastSyncProcessVolumeMegabytes() + ", fivetranConnectorLastSyncReason=" + this.getFivetranConnectorLastSyncReason() + ", fivetranConnectorLastSyncRescheduledAt=" + this.getFivetranConnectorLastSyncRescheduledAt() + ", fivetranConnectorLastSyncStartedAt=" + this.getFivetranConnectorLastSyncStartedAt() + ", fivetranConnectorLastSyncTablesSynced=" + this.getFivetranConnectorLastSyncTablesSynced() + ", fivetranConnectorLastSyncTaskType=" + this.getFivetranConnectorLastSyncTaskType() + ", fivetranConnectorLastSyncTotalTimeSeconds=" + this.getFivetranConnectorLastSyncTotalTimeSeconds() + ", fivetranConnectorMonthlyActiveRowsChangePercentageFree=" + this.getFivetranConnectorMonthlyActiveRowsChangePercentageFree() + ", fivetranConnectorMonthlyActiveRowsChangePercentagePaid=" + this.getFivetranConnectorMonthlyActiveRowsChangePercentagePaid() + ", fivetranConnectorMonthlyActiveRowsChangePercentageTotal=" + this.getFivetranConnectorMonthlyActiveRowsChangePercentageTotal() + ", fivetranConnectorMonthlyActiveRowsFree=" + this.getFivetranConnectorMonthlyActiveRowsFree() + ", fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount=" + this.getFivetranConnectorMonthlyActiveRowsFreePercentageOfAccount() + ", fivetranConnectorMonthlyActiveRowsPaid=" + this.getFivetranConnectorMonthlyActiveRowsPaid() + ", fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount=" + this.getFivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount() + ", fivetranConnectorMonthlyActiveRowsTotal=" + this.getFivetranConnectorMonthlyActiveRowsTotal() + ", fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount=" + this.getFivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount() + ", fivetranConnectorName=" + this.getFivetranConnectorName() + ", fivetranConnectorSyncFrequency=" + this.getFivetranConnectorSyncFrequency() + ", fivetranConnectorSyncPaused=" + this.getFivetranConnectorSyncPaused() + ", fivetranConnectorSyncSetupOn=" + this.getFivetranConnectorSyncSetupOn() + ", fivetranConnectorSyncSetupUserEmail=" + this.getFivetranConnectorSyncSetupUserEmail() + ", fivetranConnectorSyncSetupUserFullName=" + this.getFivetranConnectorSyncSetupUserFullName() + ", fivetranConnectorTopTablesByMAR=" + this.getFivetranConnectorTopTablesByMAR() + ", fivetranConnectorTotalTablesSynced=" + this.getFivetranConnectorTotalTablesSynced() + ", fivetranConnectorType=" + this.getFivetranConnectorType() + ", fivetranConnectorURL=" + this.getFivetranConnectorURL() + ", fivetranConnectorUsageCost=" + this.getFivetranConnectorUsageCost() + ", fivetranLastSyncRecordsUpdated=" + this.getFivetranLastSyncRecordsUpdated() + ", fivetranLastSyncStatus=" + this.getFivetranLastSyncStatus() + ", fivetranWorkflowName=" + this.getFivetranWorkflowName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", processes=" + this.getProcesses() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class FivetranConnectorBuilder<C extends FivetranConnector, B extends FivetranConnectorBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private Double fivetranConnectorCreditsUsed;
        @Generated
        private String fivetranConnectorDestinationName;
        @Generated
        private String fivetranConnectorDestinationType;
        @Generated
        private String fivetranConnectorDestinationURL;
        @Generated
        private Double fivetranConnectorLastSyncExtractTimeSeconds;
        @Generated
        private Double fivetranConnectorLastSyncExtractVolumeMegabytes;
        @Generated
        private Long fivetranConnectorLastSyncFinishedAt;
        @Generated
        private String fivetranConnectorLastSyncId;
        @Generated
        private Double fivetranConnectorLastSyncLoadTimeSeconds;
        @Generated
        private Double fivetranConnectorLastSyncLoadVolumeMegabytes;
        @Generated
        private Double fivetranConnectorLastSyncProcessTimeSeconds;
        @Generated
        private Double fivetranConnectorLastSyncProcessVolumeMegabytes;
        @Generated
        private String fivetranConnectorLastSyncReason;
        @Generated
        private Long fivetranConnectorLastSyncRescheduledAt;
        @Generated
        private Long fivetranConnectorLastSyncStartedAt;
        @Generated
        private Long fivetranConnectorLastSyncTablesSynced;
        @Generated
        private String fivetranConnectorLastSyncTaskType;
        @Generated
        private Double fivetranConnectorLastSyncTotalTimeSeconds;
        @Generated
        private Double fivetranConnectorMonthlyActiveRowsChangePercentageFree;
        @Generated
        private Double fivetranConnectorMonthlyActiveRowsChangePercentagePaid;
        @Generated
        private Double fivetranConnectorMonthlyActiveRowsChangePercentageTotal;
        @Generated
        private Long fivetranConnectorMonthlyActiveRowsFree;
        @Generated
        private Double fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount;
        @Generated
        private Long fivetranConnectorMonthlyActiveRowsPaid;
        @Generated
        private Double fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount;
        @Generated
        private Long fivetranConnectorMonthlyActiveRowsTotal;
        @Generated
        private Double fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount;
        @Generated
        private String fivetranConnectorName;
        @Generated
        private String fivetranConnectorSyncFrequency;
        @Generated
        private Boolean fivetranConnectorSyncPaused;
        @Generated
        private Long fivetranConnectorSyncSetupOn;
        @Generated
        private String fivetranConnectorSyncSetupUserEmail;
        @Generated
        private String fivetranConnectorSyncSetupUserFullName;
        @Generated
        private String fivetranConnectorTopTablesByMAR;
        @Generated
        private Long fivetranConnectorTotalTablesSynced;
        @Generated
        private String fivetranConnectorType;
        @Generated
        private String fivetranConnectorURL;
        @Generated
        private Double fivetranConnectorUsageCost;
        @Generated
        private Long fivetranLastSyncRecordsUpdated;
        @Generated
        private FivetranConnectorStatus fivetranLastSyncStatus;
        @Generated
        private String fivetranWorkflowName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<ILineageProcess> processes;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FivetranConnectorBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(FivetranConnector instance, FivetranConnectorBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.fivetranConnectorCreditsUsed(instance.fivetranConnectorCreditsUsed);
            b.fivetranConnectorDestinationName(instance.fivetranConnectorDestinationName);
            b.fivetranConnectorDestinationType(instance.fivetranConnectorDestinationType);
            b.fivetranConnectorDestinationURL(instance.fivetranConnectorDestinationURL);
            b.fivetranConnectorLastSyncExtractTimeSeconds(instance.fivetranConnectorLastSyncExtractTimeSeconds);
            b.fivetranConnectorLastSyncExtractVolumeMegabytes(instance.fivetranConnectorLastSyncExtractVolumeMegabytes);
            b.fivetranConnectorLastSyncFinishedAt(instance.fivetranConnectorLastSyncFinishedAt);
            b.fivetranConnectorLastSyncId(instance.fivetranConnectorLastSyncId);
            b.fivetranConnectorLastSyncLoadTimeSeconds(instance.fivetranConnectorLastSyncLoadTimeSeconds);
            b.fivetranConnectorLastSyncLoadVolumeMegabytes(instance.fivetranConnectorLastSyncLoadVolumeMegabytes);
            b.fivetranConnectorLastSyncProcessTimeSeconds(instance.fivetranConnectorLastSyncProcessTimeSeconds);
            b.fivetranConnectorLastSyncProcessVolumeMegabytes(instance.fivetranConnectorLastSyncProcessVolumeMegabytes);
            b.fivetranConnectorLastSyncReason(instance.fivetranConnectorLastSyncReason);
            b.fivetranConnectorLastSyncRescheduledAt(instance.fivetranConnectorLastSyncRescheduledAt);
            b.fivetranConnectorLastSyncStartedAt(instance.fivetranConnectorLastSyncStartedAt);
            b.fivetranConnectorLastSyncTablesSynced(instance.fivetranConnectorLastSyncTablesSynced);
            b.fivetranConnectorLastSyncTaskType(instance.fivetranConnectorLastSyncTaskType);
            b.fivetranConnectorLastSyncTotalTimeSeconds(instance.fivetranConnectorLastSyncTotalTimeSeconds);
            b.fivetranConnectorMonthlyActiveRowsChangePercentageFree(instance.fivetranConnectorMonthlyActiveRowsChangePercentageFree);
            b.fivetranConnectorMonthlyActiveRowsChangePercentagePaid(instance.fivetranConnectorMonthlyActiveRowsChangePercentagePaid);
            b.fivetranConnectorMonthlyActiveRowsChangePercentageTotal(instance.fivetranConnectorMonthlyActiveRowsChangePercentageTotal);
            b.fivetranConnectorMonthlyActiveRowsFree(instance.fivetranConnectorMonthlyActiveRowsFree);
            b.fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount(instance.fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount);
            b.fivetranConnectorMonthlyActiveRowsPaid(instance.fivetranConnectorMonthlyActiveRowsPaid);
            b.fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount(instance.fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount);
            b.fivetranConnectorMonthlyActiveRowsTotal(instance.fivetranConnectorMonthlyActiveRowsTotal);
            b.fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount(instance.fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount);
            b.fivetranConnectorName(instance.fivetranConnectorName);
            b.fivetranConnectorSyncFrequency(instance.fivetranConnectorSyncFrequency);
            b.fivetranConnectorSyncPaused(instance.fivetranConnectorSyncPaused);
            b.fivetranConnectorSyncSetupOn(instance.fivetranConnectorSyncSetupOn);
            b.fivetranConnectorSyncSetupUserEmail(instance.fivetranConnectorSyncSetupUserEmail);
            b.fivetranConnectorSyncSetupUserFullName(instance.fivetranConnectorSyncSetupUserFullName);
            b.fivetranConnectorTopTablesByMAR(instance.fivetranConnectorTopTablesByMAR);
            b.fivetranConnectorTotalTablesSynced(instance.fivetranConnectorTotalTablesSynced);
            b.fivetranConnectorType(instance.fivetranConnectorType);
            b.fivetranConnectorURL(instance.fivetranConnectorURL);
            b.fivetranConnectorUsageCost(instance.fivetranConnectorUsageCost);
            b.fivetranLastSyncRecordsUpdated(instance.fivetranLastSyncRecordsUpdated);
            b.fivetranLastSyncStatus(instance.fivetranLastSyncStatus);
            b.fivetranWorkflowName(instance.fivetranWorkflowName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.processes(instance.processes == null ? Collections.emptySortedSet() : instance.processes);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorCreditsUsed(Double fivetranConnectorCreditsUsed) {
            this.fivetranConnectorCreditsUsed = fivetranConnectorCreditsUsed;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorDestinationName(String fivetranConnectorDestinationName) {
            this.fivetranConnectorDestinationName = fivetranConnectorDestinationName;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorDestinationType(String fivetranConnectorDestinationType) {
            this.fivetranConnectorDestinationType = fivetranConnectorDestinationType;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorDestinationURL(String fivetranConnectorDestinationURL) {
            this.fivetranConnectorDestinationURL = fivetranConnectorDestinationURL;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncExtractTimeSeconds(Double fivetranConnectorLastSyncExtractTimeSeconds) {
            this.fivetranConnectorLastSyncExtractTimeSeconds = fivetranConnectorLastSyncExtractTimeSeconds;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncExtractVolumeMegabytes(Double fivetranConnectorLastSyncExtractVolumeMegabytes) {
            this.fivetranConnectorLastSyncExtractVolumeMegabytes = fivetranConnectorLastSyncExtractVolumeMegabytes;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncFinishedAt(Long fivetranConnectorLastSyncFinishedAt) {
            this.fivetranConnectorLastSyncFinishedAt = fivetranConnectorLastSyncFinishedAt;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncId(String fivetranConnectorLastSyncId) {
            this.fivetranConnectorLastSyncId = fivetranConnectorLastSyncId;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncLoadTimeSeconds(Double fivetranConnectorLastSyncLoadTimeSeconds) {
            this.fivetranConnectorLastSyncLoadTimeSeconds = fivetranConnectorLastSyncLoadTimeSeconds;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncLoadVolumeMegabytes(Double fivetranConnectorLastSyncLoadVolumeMegabytes) {
            this.fivetranConnectorLastSyncLoadVolumeMegabytes = fivetranConnectorLastSyncLoadVolumeMegabytes;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncProcessTimeSeconds(Double fivetranConnectorLastSyncProcessTimeSeconds) {
            this.fivetranConnectorLastSyncProcessTimeSeconds = fivetranConnectorLastSyncProcessTimeSeconds;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncProcessVolumeMegabytes(Double fivetranConnectorLastSyncProcessVolumeMegabytes) {
            this.fivetranConnectorLastSyncProcessVolumeMegabytes = fivetranConnectorLastSyncProcessVolumeMegabytes;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncReason(String fivetranConnectorLastSyncReason) {
            this.fivetranConnectorLastSyncReason = fivetranConnectorLastSyncReason;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncRescheduledAt(Long fivetranConnectorLastSyncRescheduledAt) {
            this.fivetranConnectorLastSyncRescheduledAt = fivetranConnectorLastSyncRescheduledAt;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncStartedAt(Long fivetranConnectorLastSyncStartedAt) {
            this.fivetranConnectorLastSyncStartedAt = fivetranConnectorLastSyncStartedAt;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncTablesSynced(Long fivetranConnectorLastSyncTablesSynced) {
            this.fivetranConnectorLastSyncTablesSynced = fivetranConnectorLastSyncTablesSynced;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncTaskType(String fivetranConnectorLastSyncTaskType) {
            this.fivetranConnectorLastSyncTaskType = fivetranConnectorLastSyncTaskType;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorLastSyncTotalTimeSeconds(Double fivetranConnectorLastSyncTotalTimeSeconds) {
            this.fivetranConnectorLastSyncTotalTimeSeconds = fivetranConnectorLastSyncTotalTimeSeconds;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorMonthlyActiveRowsChangePercentageFree(Double fivetranConnectorMonthlyActiveRowsChangePercentageFree) {
            this.fivetranConnectorMonthlyActiveRowsChangePercentageFree = fivetranConnectorMonthlyActiveRowsChangePercentageFree;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorMonthlyActiveRowsChangePercentagePaid(Double fivetranConnectorMonthlyActiveRowsChangePercentagePaid) {
            this.fivetranConnectorMonthlyActiveRowsChangePercentagePaid = fivetranConnectorMonthlyActiveRowsChangePercentagePaid;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorMonthlyActiveRowsChangePercentageTotal(Double fivetranConnectorMonthlyActiveRowsChangePercentageTotal) {
            this.fivetranConnectorMonthlyActiveRowsChangePercentageTotal = fivetranConnectorMonthlyActiveRowsChangePercentageTotal;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorMonthlyActiveRowsFree(Long fivetranConnectorMonthlyActiveRowsFree) {
            this.fivetranConnectorMonthlyActiveRowsFree = fivetranConnectorMonthlyActiveRowsFree;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount(Double fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount) {
            this.fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount = fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorMonthlyActiveRowsPaid(Long fivetranConnectorMonthlyActiveRowsPaid) {
            this.fivetranConnectorMonthlyActiveRowsPaid = fivetranConnectorMonthlyActiveRowsPaid;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount(Double fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount) {
            this.fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount = fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorMonthlyActiveRowsTotal(Long fivetranConnectorMonthlyActiveRowsTotal) {
            this.fivetranConnectorMonthlyActiveRowsTotal = fivetranConnectorMonthlyActiveRowsTotal;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount(Double fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount) {
            this.fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount = fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorName(String fivetranConnectorName) {
            this.fivetranConnectorName = fivetranConnectorName;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorSyncFrequency(String fivetranConnectorSyncFrequency) {
            this.fivetranConnectorSyncFrequency = fivetranConnectorSyncFrequency;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorSyncPaused(Boolean fivetranConnectorSyncPaused) {
            this.fivetranConnectorSyncPaused = fivetranConnectorSyncPaused;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorSyncSetupOn(Long fivetranConnectorSyncSetupOn) {
            this.fivetranConnectorSyncSetupOn = fivetranConnectorSyncSetupOn;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorSyncSetupUserEmail(String fivetranConnectorSyncSetupUserEmail) {
            this.fivetranConnectorSyncSetupUserEmail = fivetranConnectorSyncSetupUserEmail;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorSyncSetupUserFullName(String fivetranConnectorSyncSetupUserFullName) {
            this.fivetranConnectorSyncSetupUserFullName = fivetranConnectorSyncSetupUserFullName;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorTopTablesByMAR(String fivetranConnectorTopTablesByMAR) {
            this.fivetranConnectorTopTablesByMAR = fivetranConnectorTopTablesByMAR;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorTotalTablesSynced(Long fivetranConnectorTotalTablesSynced) {
            this.fivetranConnectorTotalTablesSynced = fivetranConnectorTotalTablesSynced;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorType(String fivetranConnectorType) {
            this.fivetranConnectorType = fivetranConnectorType;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorURL(String fivetranConnectorURL) {
            this.fivetranConnectorURL = fivetranConnectorURL;
            return (B)this.self();
        }

        @Generated
        public B fivetranConnectorUsageCost(Double fivetranConnectorUsageCost) {
            this.fivetranConnectorUsageCost = fivetranConnectorUsageCost;
            return (B)this.self();
        }

        @Generated
        public B fivetranLastSyncRecordsUpdated(Long fivetranLastSyncRecordsUpdated) {
            this.fivetranLastSyncRecordsUpdated = fivetranLastSyncRecordsUpdated;
            return (B)this.self();
        }

        @Generated
        public B fivetranLastSyncStatus(FivetranConnectorStatus fivetranLastSyncStatus) {
            this.fivetranLastSyncStatus = fivetranLastSyncStatus;
            return (B)this.self();
        }

        @Generated
        public B fivetranWorkflowName(String fivetranWorkflowName) {
            this.fivetranWorkflowName = fivetranWorkflowName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B process(ILineageProcess process) {
            if (this.processes == null) {
                this.processes = new ArrayList();
            }
            this.processes.add(process);
            return (B)this.self();
        }

        @Generated
        public B processes(Collection<? extends ILineageProcess> processes) {
            if (processes == null) {
                throw new NullPointerException("processes cannot be null");
            }
            if (this.processes == null) {
                this.processes = new ArrayList();
            }
            this.processes.addAll(processes);
            return (B)this.self();
        }

        @Generated
        public B clearProcesses() {
            if (this.processes != null) {
                this.processes.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FivetranConnector.FivetranConnectorBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", fivetranConnectorCreditsUsed=" + this.fivetranConnectorCreditsUsed + ", fivetranConnectorDestinationName=" + this.fivetranConnectorDestinationName + ", fivetranConnectorDestinationType=" + this.fivetranConnectorDestinationType + ", fivetranConnectorDestinationURL=" + this.fivetranConnectorDestinationURL + ", fivetranConnectorLastSyncExtractTimeSeconds=" + this.fivetranConnectorLastSyncExtractTimeSeconds + ", fivetranConnectorLastSyncExtractVolumeMegabytes=" + this.fivetranConnectorLastSyncExtractVolumeMegabytes + ", fivetranConnectorLastSyncFinishedAt=" + this.fivetranConnectorLastSyncFinishedAt + ", fivetranConnectorLastSyncId=" + this.fivetranConnectorLastSyncId + ", fivetranConnectorLastSyncLoadTimeSeconds=" + this.fivetranConnectorLastSyncLoadTimeSeconds + ", fivetranConnectorLastSyncLoadVolumeMegabytes=" + this.fivetranConnectorLastSyncLoadVolumeMegabytes + ", fivetranConnectorLastSyncProcessTimeSeconds=" + this.fivetranConnectorLastSyncProcessTimeSeconds + ", fivetranConnectorLastSyncProcessVolumeMegabytes=" + this.fivetranConnectorLastSyncProcessVolumeMegabytes + ", fivetranConnectorLastSyncReason=" + this.fivetranConnectorLastSyncReason + ", fivetranConnectorLastSyncRescheduledAt=" + this.fivetranConnectorLastSyncRescheduledAt + ", fivetranConnectorLastSyncStartedAt=" + this.fivetranConnectorLastSyncStartedAt + ", fivetranConnectorLastSyncTablesSynced=" + this.fivetranConnectorLastSyncTablesSynced + ", fivetranConnectorLastSyncTaskType=" + this.fivetranConnectorLastSyncTaskType + ", fivetranConnectorLastSyncTotalTimeSeconds=" + this.fivetranConnectorLastSyncTotalTimeSeconds + ", fivetranConnectorMonthlyActiveRowsChangePercentageFree=" + this.fivetranConnectorMonthlyActiveRowsChangePercentageFree + ", fivetranConnectorMonthlyActiveRowsChangePercentagePaid=" + this.fivetranConnectorMonthlyActiveRowsChangePercentagePaid + ", fivetranConnectorMonthlyActiveRowsChangePercentageTotal=" + this.fivetranConnectorMonthlyActiveRowsChangePercentageTotal + ", fivetranConnectorMonthlyActiveRowsFree=" + this.fivetranConnectorMonthlyActiveRowsFree + ", fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount=" + this.fivetranConnectorMonthlyActiveRowsFreePercentageOfAccount + ", fivetranConnectorMonthlyActiveRowsPaid=" + this.fivetranConnectorMonthlyActiveRowsPaid + ", fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount=" + this.fivetranConnectorMonthlyActiveRowsPaidPercentageOfAccount + ", fivetranConnectorMonthlyActiveRowsTotal=" + this.fivetranConnectorMonthlyActiveRowsTotal + ", fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount=" + this.fivetranConnectorMonthlyActiveRowsTotalPercentageOfAccount + ", fivetranConnectorName=" + this.fivetranConnectorName + ", fivetranConnectorSyncFrequency=" + this.fivetranConnectorSyncFrequency + ", fivetranConnectorSyncPaused=" + this.fivetranConnectorSyncPaused + ", fivetranConnectorSyncSetupOn=" + this.fivetranConnectorSyncSetupOn + ", fivetranConnectorSyncSetupUserEmail=" + this.fivetranConnectorSyncSetupUserEmail + ", fivetranConnectorSyncSetupUserFullName=" + this.fivetranConnectorSyncSetupUserFullName + ", fivetranConnectorTopTablesByMAR=" + this.fivetranConnectorTopTablesByMAR + ", fivetranConnectorTotalTablesSynced=" + this.fivetranConnectorTotalTablesSynced + ", fivetranConnectorType=" + this.fivetranConnectorType + ", fivetranConnectorURL=" + this.fivetranConnectorURL + ", fivetranConnectorUsageCost=" + this.fivetranConnectorUsageCost + ", fivetranLastSyncRecordsUpdated=" + this.fivetranLastSyncRecordsUpdated + ", fivetranLastSyncStatus=" + this.fivetranLastSyncStatus + ", fivetranWorkflowName=" + this.fivetranWorkflowName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", processes=" + this.processes + ")";
        }
    }

    @Generated
    private static final class FivetranConnectorBuilderImpl
    extends FivetranConnectorBuilder<FivetranConnector, FivetranConnectorBuilderImpl> {
        @Generated
        private FivetranConnectorBuilderImpl() {
        }

        @Override
        @Generated
        protected FivetranConnectorBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FivetranConnector build() {
            return new FivetranConnector(this);
        }
    }
}

