/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.AtlanCollection;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAtlanQuery;
import com.atlan.model.assets.IFolder;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.INamespace;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Folder
extends Asset
implements IFolder,
INamespace,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Folder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Folder";
    String typeName;
    @Attribute
    SortedSet<IFolder> childrenFolders;
    @Attribute
    SortedSet<IAtlanQuery> childrenQueries;
    @Attribute
    String collectionQualifiedName;
    @Attribute
    INamespace parent;
    @Attribute
    String parentQualifiedName;

    @Override
    public Folder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Folder.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Folder.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Folder.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return Folder.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Folder.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return Folder.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Folder refByGuid(String guid) {
        return Folder.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Folder refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((FolderBuilder)((FolderBuilder)Folder._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Folder refByQualifiedName(String qualifiedName) {
        return Folder.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Folder refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((FolderBuilder)((FolderBuilder)Folder._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Folder get(String id) throws AtlanException {
        return Folder.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static Folder get(AtlanClient client, String id) throws AtlanException {
        return Folder.get(client, id, true);
    }

    @JsonIgnore
    public static Folder get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Folder) {
                return (Folder)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof Folder) {
            return (Folder)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Folder.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static FolderBuilder<?, ?> creator(String name, Folder parentFolder) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", parentFolder.getQualifiedName());
        map.put("collectionQualifiedName", parentFolder.getCollectionQualifiedName());
        Folder.validateRelationship("Collection", map);
        return Folder.creator(name, parentFolder.getCollectionQualifiedName(), parentFolder.getQualifiedName()).parent(parentFolder.trimToReference());
    }

    public static FolderBuilder<?, ?> creator(String name, AtlanCollection collection) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", collection.getQualifiedName());
        Folder.validateRequired("Collection", map);
        return Folder.creator(name, collection.getQualifiedName(), null).parent(collection.trimToReference());
    }

    public static FolderBuilder<?, ?> creator(String name, String collectionQualifiedName, String parentQualifiedName) {
        String qualifiedName = parentQualifiedName == null ? Folder.generateQualifiedName(name, collectionQualifiedName) : Folder.generateQualifiedName(name, parentQualifiedName);
        Object builder = ((FolderBuilder)((FolderBuilder)((FolderBuilder)((FolderBuilder)((FolderBuilder)Folder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(qualifiedName)).collectionQualifiedName(collectionQualifiedName)).parentQualifiedName(collectionQualifiedName)).parent(AtlanCollection.refByQualifiedName(collectionQualifiedName));
        if (parentQualifiedName != null) {
            ((FolderBuilder)((FolderBuilder)builder).parentQualifiedName(parentQualifiedName)).parent(Folder.refByQualifiedName(parentQualifiedName));
        }
        return builder;
    }

    public static String generateQualifiedName(String name, String parentQualifiedName) {
        return parentQualifiedName + "/" + name;
    }

    public static FolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return (FolderBuilder)((FolderBuilder)((FolderBuilder)Folder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public FolderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        Folder.validateRequired(TYPE_NAME, map);
        return Folder.updater(this.getQualifiedName(), this.getName());
    }

    public static Folder removeDescription(String qualifiedName, String name) throws AtlanException {
        return Folder.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Folder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Folder)Asset.removeDescription(client, Folder.updater(qualifiedName, name));
    }

    public static Folder removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return Folder.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Folder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Folder)Asset.removeUserDescription(client, Folder.updater(qualifiedName, name));
    }

    public static Folder removeOwners(String qualifiedName, String name) throws AtlanException {
        return Folder.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Folder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Folder)Asset.removeOwners(client, Folder.updater(qualifiedName, name));
    }

    public static Folder updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return Folder.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static Folder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Folder)Asset.updateCertificate(client, Folder._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Folder removeCertificate(String qualifiedName, String name) throws AtlanException {
        return Folder.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Folder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Folder)Asset.removeCertificate(client, Folder.updater(qualifiedName, name));
    }

    public static Folder updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return Folder.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static Folder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Folder)Asset.updateAnnouncement(client, Folder._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Folder removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return Folder.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Folder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Folder)Asset.removeAnnouncement(client, Folder.updater(qualifiedName, name));
    }

    public static Folder replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return Folder.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static Folder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Folder)Asset.replaceTerms(client, Folder.updater(qualifiedName, name), terms);
    }

    public static Folder appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return Folder.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static Folder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Folder)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static Folder removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return Folder.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static Folder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Folder)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static Folder appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return Folder.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static Folder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Folder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static Folder appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return Folder.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static Folder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Folder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        Folder.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Folder(FolderBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Folder.$default$typeName();
        SortedSet<IFolder> childrenFolders = new TreeSet<IFolder>();
        if (b.childrenFolders != null) {
            childrenFolders.addAll(b.childrenFolders);
        }
        childrenFolders = Collections.unmodifiableSortedSet(childrenFolders);
        this.childrenFolders = childrenFolders;
        SortedSet<IAtlanQuery> childrenQueries = new TreeSet<IAtlanQuery>();
        if (b.childrenQueries != null) {
            childrenQueries.addAll(b.childrenQueries);
        }
        childrenQueries = Collections.unmodifiableSortedSet(childrenQueries);
        this.childrenQueries = childrenQueries;
        this.collectionQualifiedName = b.collectionQualifiedName;
        this.parent = b.parent;
        this.parentQualifiedName = b.parentQualifiedName;
    }

    @Generated
    public static FolderBuilder<?, ?> _internal() {
        return new FolderBuilderImpl();
    }

    @Generated
    public FolderBuilder<?, ?> toBuilder() {
        return new FolderBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IFolder> getChildrenFolders() {
        return this.childrenFolders;
    }

    @Override
    @Generated
    public SortedSet<IAtlanQuery> getChildrenQueries() {
        return this.childrenQueries;
    }

    @Override
    @Generated
    public String getCollectionQualifiedName() {
        return this.collectionQualifiedName;
    }

    @Override
    @Generated
    public INamespace getParent() {
        return this.parent;
    }

    @Override
    @Generated
    public String getParentQualifiedName() {
        return this.parentQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Folder)) {
            return false;
        }
        Folder other = (Folder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IFolder> this$childrenFolders = this.getChildrenFolders();
        SortedSet<IFolder> other$childrenFolders = other.getChildrenFolders();
        if (this$childrenFolders == null ? other$childrenFolders != null : !this$childrenFolders.equals(other$childrenFolders)) {
            return false;
        }
        SortedSet<IAtlanQuery> this$childrenQueries = this.getChildrenQueries();
        SortedSet<IAtlanQuery> other$childrenQueries = other.getChildrenQueries();
        if (this$childrenQueries == null ? other$childrenQueries != null : !this$childrenQueries.equals(other$childrenQueries)) {
            return false;
        }
        String this$collectionQualifiedName = this.getCollectionQualifiedName();
        String other$collectionQualifiedName = other.getCollectionQualifiedName();
        if (this$collectionQualifiedName == null ? other$collectionQualifiedName != null : !this$collectionQualifiedName.equals(other$collectionQualifiedName)) {
            return false;
        }
        INamespace this$parent = this.getParent();
        INamespace other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        String this$parentQualifiedName = this.getParentQualifiedName();
        String other$parentQualifiedName = other.getParentQualifiedName();
        return !(this$parentQualifiedName == null ? other$parentQualifiedName != null : !this$parentQualifiedName.equals(other$parentQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Folder;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IFolder> $childrenFolders = this.getChildrenFolders();
        result = result * 59 + ($childrenFolders == null ? 43 : $childrenFolders.hashCode());
        SortedSet<IAtlanQuery> $childrenQueries = this.getChildrenQueries();
        result = result * 59 + ($childrenQueries == null ? 43 : $childrenQueries.hashCode());
        String $collectionQualifiedName = this.getCollectionQualifiedName();
        result = result * 59 + ($collectionQualifiedName == null ? 43 : $collectionQualifiedName.hashCode());
        INamespace $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        String $parentQualifiedName = this.getParentQualifiedName();
        result = result * 59 + ($parentQualifiedName == null ? 43 : $parentQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Folder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", childrenFolders=" + this.getChildrenFolders() + ", childrenQueries=" + this.getChildrenQueries() + ", collectionQualifiedName=" + this.getCollectionQualifiedName() + ", parent=" + this.getParent() + ", parentQualifiedName=" + this.getParentQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class FolderBuilder<C extends Folder, B extends FolderBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IFolder> childrenFolders;
        @Generated
        private ArrayList<IAtlanQuery> childrenQueries;
        @Generated
        private String collectionQualifiedName;
        @Generated
        private INamespace parent;
        @Generated
        private String parentQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Folder instance, FolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.childrenFolders(instance.childrenFolders == null ? Collections.emptySortedSet() : instance.childrenFolders);
            b.childrenQueries(instance.childrenQueries == null ? Collections.emptySortedSet() : instance.childrenQueries);
            b.collectionQualifiedName(instance.collectionQualifiedName);
            b.parent(instance.parent);
            b.parentQualifiedName(instance.parentQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B childrenFolder(IFolder childrenFolder) {
            if (this.childrenFolders == null) {
                this.childrenFolders = new ArrayList();
            }
            this.childrenFolders.add(childrenFolder);
            return (B)this.self();
        }

        @Generated
        public B childrenFolders(Collection<? extends IFolder> childrenFolders) {
            if (childrenFolders == null) {
                throw new NullPointerException("childrenFolders cannot be null");
            }
            if (this.childrenFolders == null) {
                this.childrenFolders = new ArrayList();
            }
            this.childrenFolders.addAll(childrenFolders);
            return (B)this.self();
        }

        @Generated
        public B clearChildrenFolders() {
            if (this.childrenFolders != null) {
                this.childrenFolders.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B childrenQuery(IAtlanQuery childrenQuery) {
            if (this.childrenQueries == null) {
                this.childrenQueries = new ArrayList();
            }
            this.childrenQueries.add(childrenQuery);
            return (B)this.self();
        }

        @Generated
        public B childrenQueries(Collection<? extends IAtlanQuery> childrenQueries) {
            if (childrenQueries == null) {
                throw new NullPointerException("childrenQueries cannot be null");
            }
            if (this.childrenQueries == null) {
                this.childrenQueries = new ArrayList();
            }
            this.childrenQueries.addAll(childrenQueries);
            return (B)this.self();
        }

        @Generated
        public B clearChildrenQueries() {
            if (this.childrenQueries != null) {
                this.childrenQueries.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B collectionQualifiedName(String collectionQualifiedName) {
            this.collectionQualifiedName = collectionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B parent(INamespace parent) {
            this.parent = parent;
            return (B)this.self();
        }

        @Generated
        public B parentQualifiedName(String parentQualifiedName) {
            this.parentQualifiedName = parentQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Folder.FolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", childrenFolders=" + this.childrenFolders + ", childrenQueries=" + this.childrenQueries + ", collectionQualifiedName=" + this.collectionQualifiedName + ", parent=" + this.parent + ", parentQualifiedName=" + this.parentQualifiedName + ")";
        }
    }

    @Generated
    private static final class FolderBuilderImpl
    extends FolderBuilder<Folder, FolderBuilderImpl> {
        @Generated
        private FolderBuilderImpl() {
        }

        @Override
        @Generated
        protected FolderBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Folder build() {
            return new Folder(this);
        }
    }
}

