/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.ILooker;
import com.atlan.model.assets.ILookerExplore;
import com.atlan.model.assets.ILookerField;
import com.atlan.model.assets.ILookerModel;
import com.atlan.model.assets.ILookerProject;
import com.atlan.model.assets.ILookerView;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookerProject
extends Asset
implements ILookerProject,
ILooker,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookerProject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerProject";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    SortedSet<ILookerExplore> explores;
    @Attribute
    SortedSet<ILookerField> fields;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<ILookerProject> lookerChildProjects;
    @Attribute
    SortedSet<ILookerProject> lookerParentProjects;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<ILookerModel> models;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<ILookerView> views;

    @Override
    public LookerProject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return LookerProject.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return LookerProject.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return LookerProject.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return LookerProject.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return LookerProject.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return LookerProject.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static LookerProject refByGuid(String guid) {
        return LookerProject.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static LookerProject refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((LookerProjectBuilder)((LookerProjectBuilder)LookerProject._internal().guid(guid)).semantic(semantic)).build();
    }

    public static LookerProject refByQualifiedName(String qualifiedName) {
        return LookerProject.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static LookerProject refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((LookerProjectBuilder)((LookerProjectBuilder)LookerProject._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static LookerProject get(String id) throws AtlanException {
        return LookerProject.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static LookerProject get(AtlanClient client, String id) throws AtlanException {
        return LookerProject.get(client, id, true);
    }

    @JsonIgnore
    public static LookerProject get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof LookerProject) {
                return (LookerProject)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof LookerProject) {
            return (LookerProject)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return LookerProject.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static LookerProjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerProjectBuilder)((LookerProjectBuilder)((LookerProjectBuilder)LookerProject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public LookerProjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        LookerProject.validateRequired(TYPE_NAME, map);
        return LookerProject.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerProject removeDescription(String qualifiedName, String name) throws AtlanException {
        return LookerProject.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerProject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerProject)Asset.removeDescription(client, LookerProject.updater(qualifiedName, name));
    }

    public static LookerProject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return LookerProject.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerProject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerProject)Asset.removeUserDescription(client, LookerProject.updater(qualifiedName, name));
    }

    public static LookerProject removeOwners(String qualifiedName, String name) throws AtlanException {
        return LookerProject.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerProject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerProject)Asset.removeOwners(client, LookerProject.updater(qualifiedName, name));
    }

    public static LookerProject updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return LookerProject.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static LookerProject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerProject)Asset.updateCertificate(client, LookerProject._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerProject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return LookerProject.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerProject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerProject)Asset.removeCertificate(client, LookerProject.updater(qualifiedName, name));
    }

    public static LookerProject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return LookerProject.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static LookerProject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerProject)Asset.updateAnnouncement(client, LookerProject._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerProject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return LookerProject.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerProject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerProject)Asset.removeAnnouncement(client, LookerProject.updater(qualifiedName, name));
    }

    public static LookerProject replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerProject.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static LookerProject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerProject)Asset.replaceTerms(client, LookerProject.updater(qualifiedName, name), terms);
    }

    public static LookerProject appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerProject.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LookerProject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerProject)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LookerProject removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerProject.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LookerProject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerProject)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LookerProject appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return LookerProject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static LookerProject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerProject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static LookerProject appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return LookerProject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static LookerProject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerProject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        LookerProject.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerProject(LookerProjectBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerProject.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        SortedSet<ILookerExplore> explores = new TreeSet<ILookerExplore>();
        if (b.explores != null) {
            explores.addAll(b.explores);
        }
        explores = Collections.unmodifiableSortedSet(explores);
        this.explores = explores;
        SortedSet<ILookerField> fields = new TreeSet<ILookerField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<ILookerProject> lookerChildProjects = new TreeSet<ILookerProject>();
        if (b.lookerChildProjects != null) {
            lookerChildProjects.addAll(b.lookerChildProjects);
        }
        lookerChildProjects = Collections.unmodifiableSortedSet(lookerChildProjects);
        this.lookerChildProjects = lookerChildProjects;
        SortedSet<ILookerProject> lookerParentProjects = new TreeSet<ILookerProject>();
        if (b.lookerParentProjects != null) {
            lookerParentProjects.addAll(b.lookerParentProjects);
        }
        lookerParentProjects = Collections.unmodifiableSortedSet(lookerParentProjects);
        this.lookerParentProjects = lookerParentProjects;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<ILookerModel> models = new TreeSet<ILookerModel>();
        if (b.models != null) {
            models.addAll(b.models);
        }
        models = Collections.unmodifiableSortedSet(models);
        this.models = models;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<ILookerView> views = new TreeSet<ILookerView>();
        if (b.views != null) {
            views.addAll(b.views);
        }
        views = Collections.unmodifiableSortedSet(views);
        this.views = views;
    }

    @Generated
    public static LookerProjectBuilder<?, ?> _internal() {
        return new LookerProjectBuilderImpl();
    }

    @Generated
    public LookerProjectBuilder<?, ?> toBuilder() {
        return new LookerProjectBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ILookerExplore> getExplores() {
        return this.explores;
    }

    @Override
    @Generated
    public SortedSet<ILookerField> getFields() {
        return this.fields;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ILookerProject> getLookerChildProjects() {
        return this.lookerChildProjects;
    }

    @Override
    @Generated
    public SortedSet<ILookerProject> getLookerParentProjects() {
        return this.lookerParentProjects;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<ILookerModel> getModels() {
        return this.models;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ILookerView> getViews() {
        return this.views;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerProject)) {
            return false;
        }
        LookerProject other = (LookerProject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        SortedSet<ILookerExplore> this$explores = this.getExplores();
        SortedSet<ILookerExplore> other$explores = other.getExplores();
        if (this$explores == null ? other$explores != null : !this$explores.equals(other$explores)) {
            return false;
        }
        SortedSet<ILookerField> this$fields = this.getFields();
        SortedSet<ILookerField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<ILookerProject> this$lookerChildProjects = this.getLookerChildProjects();
        SortedSet<ILookerProject> other$lookerChildProjects = other.getLookerChildProjects();
        if (this$lookerChildProjects == null ? other$lookerChildProjects != null : !this$lookerChildProjects.equals(other$lookerChildProjects)) {
            return false;
        }
        SortedSet<ILookerProject> this$lookerParentProjects = this.getLookerParentProjects();
        SortedSet<ILookerProject> other$lookerParentProjects = other.getLookerParentProjects();
        if (this$lookerParentProjects == null ? other$lookerParentProjects != null : !this$lookerParentProjects.equals(other$lookerParentProjects)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<ILookerModel> this$models = this.getModels();
        SortedSet<ILookerModel> other$models = other.getModels();
        if (this$models == null ? other$models != null : !this$models.equals(other$models)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<ILookerView> this$views = this.getViews();
        SortedSet<ILookerView> other$views = other.getViews();
        return !(this$views == null ? other$views != null : !this$views.equals(other$views));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerProject;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        SortedSet<ILookerExplore> $explores = this.getExplores();
        result = result * 59 + ($explores == null ? 43 : $explores.hashCode());
        SortedSet<ILookerField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<ILookerProject> $lookerChildProjects = this.getLookerChildProjects();
        result = result * 59 + ($lookerChildProjects == null ? 43 : $lookerChildProjects.hashCode());
        SortedSet<ILookerProject> $lookerParentProjects = this.getLookerParentProjects();
        result = result * 59 + ($lookerParentProjects == null ? 43 : $lookerParentProjects.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<ILookerModel> $models = this.getModels();
        result = result * 59 + ($models == null ? 43 : $models.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<ILookerView> $views = this.getViews();
        result = result * 59 + ($views == null ? 43 : $views.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LookerProject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", explores=" + this.getExplores() + ", fields=" + this.getFields() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", lookerChildProjects=" + this.getLookerChildProjects() + ", lookerParentProjects=" + this.getLookerParentProjects() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", models=" + this.getModels() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", views=" + this.getViews() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class LookerProjectBuilder<C extends LookerProject, B extends LookerProjectBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private ArrayList<ILookerExplore> explores;
        @Generated
        private ArrayList<ILookerField> fields;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<ILookerProject> lookerChildProjects;
        @Generated
        private ArrayList<ILookerProject> lookerParentProjects;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<ILookerModel> models;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<ILookerView> views;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerProjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerProject instance, LookerProjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.explores(instance.explores == null ? Collections.emptySortedSet() : instance.explores);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.lookerChildProjects(instance.lookerChildProjects == null ? Collections.emptySortedSet() : instance.lookerChildProjects);
            b.lookerParentProjects(instance.lookerParentProjects == null ? Collections.emptySortedSet() : instance.lookerParentProjects);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.models(instance.models == null ? Collections.emptySortedSet() : instance.models);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.views(instance.views == null ? Collections.emptySortedSet() : instance.views);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B explore(ILookerExplore explore) {
            if (this.explores == null) {
                this.explores = new ArrayList();
            }
            this.explores.add(explore);
            return (B)this.self();
        }

        @Generated
        public B explores(Collection<? extends ILookerExplore> explores) {
            if (explores == null) {
                throw new NullPointerException("explores cannot be null");
            }
            if (this.explores == null) {
                this.explores = new ArrayList();
            }
            this.explores.addAll(explores);
            return (B)this.self();
        }

        @Generated
        public B clearExplores() {
            if (this.explores != null) {
                this.explores.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B field(ILookerField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends ILookerField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B lookerChildProject(ILookerProject lookerChildProject) {
            if (this.lookerChildProjects == null) {
                this.lookerChildProjects = new ArrayList();
            }
            this.lookerChildProjects.add(lookerChildProject);
            return (B)this.self();
        }

        @Generated
        public B lookerChildProjects(Collection<? extends ILookerProject> lookerChildProjects) {
            if (lookerChildProjects == null) {
                throw new NullPointerException("lookerChildProjects cannot be null");
            }
            if (this.lookerChildProjects == null) {
                this.lookerChildProjects = new ArrayList();
            }
            this.lookerChildProjects.addAll(lookerChildProjects);
            return (B)this.self();
        }

        @Generated
        public B clearLookerChildProjects() {
            if (this.lookerChildProjects != null) {
                this.lookerChildProjects.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B lookerParentProject(ILookerProject lookerParentProject) {
            if (this.lookerParentProjects == null) {
                this.lookerParentProjects = new ArrayList();
            }
            this.lookerParentProjects.add(lookerParentProject);
            return (B)this.self();
        }

        @Generated
        public B lookerParentProjects(Collection<? extends ILookerProject> lookerParentProjects) {
            if (lookerParentProjects == null) {
                throw new NullPointerException("lookerParentProjects cannot be null");
            }
            if (this.lookerParentProjects == null) {
                this.lookerParentProjects = new ArrayList();
            }
            this.lookerParentProjects.addAll(lookerParentProjects);
            return (B)this.self();
        }

        @Generated
        public B clearLookerParentProjects() {
            if (this.lookerParentProjects != null) {
                this.lookerParentProjects.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B model(ILookerModel model) {
            if (this.models == null) {
                this.models = new ArrayList();
            }
            this.models.add(model);
            return (B)this.self();
        }

        @Generated
        public B models(Collection<? extends ILookerModel> models) {
            if (models == null) {
                throw new NullPointerException("models cannot be null");
            }
            if (this.models == null) {
                this.models = new ArrayList();
            }
            this.models.addAll(models);
            return (B)this.self();
        }

        @Generated
        public B clearModels() {
            if (this.models != null) {
                this.models.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B view(ILookerView view) {
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.add(view);
            return (B)this.self();
        }

        @Generated
        public B views(Collection<? extends ILookerView> views) {
            if (views == null) {
                throw new NullPointerException("views cannot be null");
            }
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.addAll(views);
            return (B)this.self();
        }

        @Generated
        public B clearViews() {
            if (this.views != null) {
                this.views.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LookerProject.LookerProjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", explores=" + this.explores + ", fields=" + this.fields + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", lookerChildProjects=" + this.lookerChildProjects + ", lookerParentProjects=" + this.lookerParentProjects + ", modelImplementedEntities=" + this.modelImplementedEntities + ", models=" + this.models + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", views=" + this.views + ")";
        }
    }

    @Generated
    private static final class LookerProjectBuilderImpl
    extends LookerProjectBuilder<LookerProject, LookerProjectBuilderImpl> {
        @Generated
        private LookerProjectBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerProjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerProject build() {
            return new LookerProject(this);
        }
    }
}

