/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAWS;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICloud;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IObjectStore;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.IS3;
import com.atlan.model.assets.IS3Bucket;
import com.atlan.model.assets.IS3Object;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.AwsTag;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Bucket
extends Asset
implements IS3Bucket,
IS3,
IObjectStore,
IAWS,
ICatalog,
IAsset,
IReferenceable,
ICloud {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3Bucket.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "S3Bucket";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    String awsAccountId;
    @Attribute
    String awsArn;
    @Attribute
    String awsOwnerId;
    @Attribute
    String awsOwnerName;
    @Attribute
    String awsPartition;
    @Attribute
    String awsRegion;
    @Attribute
    String awsResourceId;
    @Attribute
    String awsService;
    @Attribute
    List<AwsTag> awsTags;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IS3Object> objects;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    Boolean s3BucketVersioningEnabled;
    @Attribute
    String s3ETag;
    @Attribute
    String s3Encryption;
    @Attribute
    Long s3ObjectCount;

    @Override
    public S3Bucket trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return S3Bucket.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return S3Bucket.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return S3Bucket.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return S3Bucket.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return S3Bucket.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return S3Bucket.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static S3Bucket refByGuid(String guid) {
        return S3Bucket.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static S3Bucket refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((S3BucketBuilder)((S3BucketBuilder)S3Bucket._internal().guid(guid)).semantic(semantic)).build();
    }

    public static S3Bucket refByQualifiedName(String qualifiedName) {
        return S3Bucket.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static S3Bucket refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((S3BucketBuilder)((S3BucketBuilder)S3Bucket._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static S3Bucket get(String id) throws AtlanException {
        return S3Bucket.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static S3Bucket get(AtlanClient client, String id) throws AtlanException {
        return S3Bucket.get(client, id, true);
    }

    @JsonIgnore
    public static S3Bucket get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof S3Bucket) {
                return (S3Bucket)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof S3Bucket) {
            return (S3Bucket)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return S3Bucket.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static S3BucketBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return (S3BucketBuilder)((S3BucketBuilder)((S3BucketBuilder)((S3BucketBuilder)((S3BucketBuilder)S3Bucket._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(IS3.generateQualifiedName(connectionQualifiedName, name))).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.S3);
    }

    public static S3BucketBuilder<?, ?> creator(String name, String connectionQualifiedName, String awsArn) {
        return ((S3BucketBuilder)((S3BucketBuilder)((S3BucketBuilder)((S3BucketBuilder)((S3BucketBuilder)S3Bucket._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(IS3.generateQualifiedName(connectionQualifiedName, awsArn))).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.S3)).awsArn(awsArn);
    }

    public static S3BucketBuilder<?, ?> updater(String qualifiedName, String name) {
        return (S3BucketBuilder)((S3BucketBuilder)((S3BucketBuilder)S3Bucket._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public S3BucketBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        S3Bucket.validateRequired(TYPE_NAME, map);
        return S3Bucket.updater(this.getQualifiedName(), this.getName());
    }

    public static S3Bucket removeDescription(String qualifiedName, String name) throws AtlanException {
        return S3Bucket.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static S3Bucket removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Bucket)Asset.removeDescription(client, S3Bucket.updater(qualifiedName, name));
    }

    public static S3Bucket removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return S3Bucket.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static S3Bucket removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Bucket)Asset.removeUserDescription(client, S3Bucket.updater(qualifiedName, name));
    }

    public static S3Bucket removeOwners(String qualifiedName, String name) throws AtlanException {
        return S3Bucket.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static S3Bucket removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Bucket)Asset.removeOwners(client, S3Bucket.updater(qualifiedName, name));
    }

    public static S3Bucket updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return S3Bucket.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static S3Bucket updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (S3Bucket)Asset.updateCertificate(client, S3Bucket._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static S3Bucket removeCertificate(String qualifiedName, String name) throws AtlanException {
        return S3Bucket.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static S3Bucket removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Bucket)Asset.removeCertificate(client, S3Bucket.updater(qualifiedName, name));
    }

    public static S3Bucket updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return S3Bucket.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static S3Bucket updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (S3Bucket)Asset.updateAnnouncement(client, S3Bucket._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static S3Bucket removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return S3Bucket.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static S3Bucket removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Bucket)Asset.removeAnnouncement(client, S3Bucket.updater(qualifiedName, name));
    }

    public static S3Bucket replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return S3Bucket.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static S3Bucket replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (S3Bucket)Asset.replaceTerms(client, S3Bucket.updater(qualifiedName, name), terms);
    }

    public static S3Bucket appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return S3Bucket.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static S3Bucket appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (S3Bucket)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static S3Bucket removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return S3Bucket.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static S3Bucket removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (S3Bucket)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static S3Bucket appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return S3Bucket.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static S3Bucket appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (S3Bucket)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static S3Bucket appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return S3Bucket.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static S3Bucket appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (S3Bucket)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        S3Bucket.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected S3Bucket(S3BucketBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : S3Bucket.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        this.awsAccountId = b.awsAccountId;
        this.awsArn = b.awsArn;
        this.awsOwnerId = b.awsOwnerId;
        this.awsOwnerName = b.awsOwnerName;
        this.awsPartition = b.awsPartition;
        this.awsRegion = b.awsRegion;
        this.awsResourceId = b.awsResourceId;
        this.awsService = b.awsService;
        this.awsTags = switch (b.awsTags == null ? 0 : b.awsTags.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.awsTags.get(0));
            default -> Collections.unmodifiableList(new ArrayList<AwsTag>(b.awsTags));
        };
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IS3Object> objects = new TreeSet<IS3Object>();
        if (b.objects != null) {
            objects.addAll(b.objects);
        }
        objects = Collections.unmodifiableSortedSet(objects);
        this.objects = objects;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.s3BucketVersioningEnabled = b.s3BucketVersioningEnabled;
        this.s3ETag = b.s3ETag;
        this.s3Encryption = b.s3Encryption;
        this.s3ObjectCount = b.s3ObjectCount;
    }

    @Generated
    public static S3BucketBuilder<?, ?> _internal() {
        return new S3BucketBuilderImpl();
    }

    @Generated
    public S3BucketBuilder<?, ?> toBuilder() {
        return new S3BucketBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    @Override
    @Generated
    public String getAwsArn() {
        return this.awsArn;
    }

    @Override
    @Generated
    public String getAwsOwnerId() {
        return this.awsOwnerId;
    }

    @Override
    @Generated
    public String getAwsOwnerName() {
        return this.awsOwnerName;
    }

    @Override
    @Generated
    public String getAwsPartition() {
        return this.awsPartition;
    }

    @Override
    @Generated
    public String getAwsRegion() {
        return this.awsRegion;
    }

    @Override
    @Generated
    public String getAwsResourceId() {
        return this.awsResourceId;
    }

    @Override
    @Generated
    public String getAwsService() {
        return this.awsService;
    }

    @Override
    @Generated
    public List<AwsTag> getAwsTags() {
        return this.awsTags;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IS3Object> getObjects() {
        return this.objects;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public Boolean getS3BucketVersioningEnabled() {
        return this.s3BucketVersioningEnabled;
    }

    @Override
    @Generated
    public String getS3ETag() {
        return this.s3ETag;
    }

    @Override
    @Generated
    public String getS3Encryption() {
        return this.s3Encryption;
    }

    @Override
    @Generated
    public Long getS3ObjectCount() {
        return this.s3ObjectCount;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3Bucket)) {
            return false;
        }
        S3Bucket other = (S3Bucket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$s3BucketVersioningEnabled = this.getS3BucketVersioningEnabled();
        Boolean other$s3BucketVersioningEnabled = other.getS3BucketVersioningEnabled();
        if (this$s3BucketVersioningEnabled == null ? other$s3BucketVersioningEnabled != null : !((Object)this$s3BucketVersioningEnabled).equals(other$s3BucketVersioningEnabled)) {
            return false;
        }
        Long this$s3ObjectCount = this.getS3ObjectCount();
        Long other$s3ObjectCount = other.getS3ObjectCount();
        if (this$s3ObjectCount == null ? other$s3ObjectCount != null : !((Object)this$s3ObjectCount).equals(other$s3ObjectCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        String this$awsAccountId = this.getAwsAccountId();
        String other$awsAccountId = other.getAwsAccountId();
        if (this$awsAccountId == null ? other$awsAccountId != null : !this$awsAccountId.equals(other$awsAccountId)) {
            return false;
        }
        String this$awsArn = this.getAwsArn();
        String other$awsArn = other.getAwsArn();
        if (this$awsArn == null ? other$awsArn != null : !this$awsArn.equals(other$awsArn)) {
            return false;
        }
        String this$awsOwnerId = this.getAwsOwnerId();
        String other$awsOwnerId = other.getAwsOwnerId();
        if (this$awsOwnerId == null ? other$awsOwnerId != null : !this$awsOwnerId.equals(other$awsOwnerId)) {
            return false;
        }
        String this$awsOwnerName = this.getAwsOwnerName();
        String other$awsOwnerName = other.getAwsOwnerName();
        if (this$awsOwnerName == null ? other$awsOwnerName != null : !this$awsOwnerName.equals(other$awsOwnerName)) {
            return false;
        }
        String this$awsPartition = this.getAwsPartition();
        String other$awsPartition = other.getAwsPartition();
        if (this$awsPartition == null ? other$awsPartition != null : !this$awsPartition.equals(other$awsPartition)) {
            return false;
        }
        String this$awsRegion = this.getAwsRegion();
        String other$awsRegion = other.getAwsRegion();
        if (this$awsRegion == null ? other$awsRegion != null : !this$awsRegion.equals(other$awsRegion)) {
            return false;
        }
        String this$awsResourceId = this.getAwsResourceId();
        String other$awsResourceId = other.getAwsResourceId();
        if (this$awsResourceId == null ? other$awsResourceId != null : !this$awsResourceId.equals(other$awsResourceId)) {
            return false;
        }
        String this$awsService = this.getAwsService();
        String other$awsService = other.getAwsService();
        if (this$awsService == null ? other$awsService != null : !this$awsService.equals(other$awsService)) {
            return false;
        }
        List<AwsTag> this$awsTags = this.getAwsTags();
        List<AwsTag> other$awsTags = other.getAwsTags();
        if (this$awsTags == null ? other$awsTags != null : !((Object)this$awsTags).equals(other$awsTags)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IS3Object> this$objects = this.getObjects();
        SortedSet<IS3Object> other$objects = other.getObjects();
        if (this$objects == null ? other$objects != null : !this$objects.equals(other$objects)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$s3ETag = this.getS3ETag();
        String other$s3ETag = other.getS3ETag();
        if (this$s3ETag == null ? other$s3ETag != null : !this$s3ETag.equals(other$s3ETag)) {
            return false;
        }
        String this$s3Encryption = this.getS3Encryption();
        String other$s3Encryption = other.getS3Encryption();
        return !(this$s3Encryption == null ? other$s3Encryption != null : !this$s3Encryption.equals(other$s3Encryption));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof S3Bucket;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $s3BucketVersioningEnabled = this.getS3BucketVersioningEnabled();
        result = result * 59 + ($s3BucketVersioningEnabled == null ? 43 : ((Object)$s3BucketVersioningEnabled).hashCode());
        Long $s3ObjectCount = this.getS3ObjectCount();
        result = result * 59 + ($s3ObjectCount == null ? 43 : ((Object)$s3ObjectCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        String $awsAccountId = this.getAwsAccountId();
        result = result * 59 + ($awsAccountId == null ? 43 : $awsAccountId.hashCode());
        String $awsArn = this.getAwsArn();
        result = result * 59 + ($awsArn == null ? 43 : $awsArn.hashCode());
        String $awsOwnerId = this.getAwsOwnerId();
        result = result * 59 + ($awsOwnerId == null ? 43 : $awsOwnerId.hashCode());
        String $awsOwnerName = this.getAwsOwnerName();
        result = result * 59 + ($awsOwnerName == null ? 43 : $awsOwnerName.hashCode());
        String $awsPartition = this.getAwsPartition();
        result = result * 59 + ($awsPartition == null ? 43 : $awsPartition.hashCode());
        String $awsRegion = this.getAwsRegion();
        result = result * 59 + ($awsRegion == null ? 43 : $awsRegion.hashCode());
        String $awsResourceId = this.getAwsResourceId();
        result = result * 59 + ($awsResourceId == null ? 43 : $awsResourceId.hashCode());
        String $awsService = this.getAwsService();
        result = result * 59 + ($awsService == null ? 43 : $awsService.hashCode());
        List<AwsTag> $awsTags = this.getAwsTags();
        result = result * 59 + ($awsTags == null ? 43 : ((Object)$awsTags).hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IS3Object> $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : $objects.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $s3ETag = this.getS3ETag();
        result = result * 59 + ($s3ETag == null ? 43 : $s3ETag.hashCode());
        String $s3Encryption = this.getS3Encryption();
        result = result * 59 + ($s3Encryption == null ? 43 : $s3Encryption.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "S3Bucket(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", awsAccountId=" + this.getAwsAccountId() + ", awsArn=" + this.getAwsArn() + ", awsOwnerId=" + this.getAwsOwnerId() + ", awsOwnerName=" + this.getAwsOwnerName() + ", awsPartition=" + this.getAwsPartition() + ", awsRegion=" + this.getAwsRegion() + ", awsResourceId=" + this.getAwsResourceId() + ", awsService=" + this.getAwsService() + ", awsTags=" + this.getAwsTags() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", objects=" + this.getObjects() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", s3BucketVersioningEnabled=" + this.getS3BucketVersioningEnabled() + ", s3ETag=" + this.getS3ETag() + ", s3Encryption=" + this.getS3Encryption() + ", s3ObjectCount=" + this.getS3ObjectCount() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class S3BucketBuilder<C extends S3Bucket, B extends S3BucketBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private String awsAccountId;
        @Generated
        private String awsArn;
        @Generated
        private String awsOwnerId;
        @Generated
        private String awsOwnerName;
        @Generated
        private String awsPartition;
        @Generated
        private String awsRegion;
        @Generated
        private String awsResourceId;
        @Generated
        private String awsService;
        @Generated
        private ArrayList<AwsTag> awsTags;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IS3Object> objects;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private Boolean s3BucketVersioningEnabled;
        @Generated
        private String s3ETag;
        @Generated
        private String s3Encryption;
        @Generated
        private Long s3ObjectCount;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            S3BucketBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(S3Bucket instance, S3BucketBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.awsAccountId(instance.awsAccountId);
            b.awsArn(instance.awsArn);
            b.awsOwnerId(instance.awsOwnerId);
            b.awsOwnerName(instance.awsOwnerName);
            b.awsPartition(instance.awsPartition);
            b.awsRegion(instance.awsRegion);
            b.awsResourceId(instance.awsResourceId);
            b.awsService(instance.awsService);
            b.awsTags(instance.awsTags == null ? Collections.emptyList() : instance.awsTags);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.objects(instance.objects == null ? Collections.emptySortedSet() : instance.objects);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.s3BucketVersioningEnabled(instance.s3BucketVersioningEnabled);
            b.s3ETag(instance.s3ETag);
            b.s3Encryption(instance.s3Encryption);
            b.s3ObjectCount(instance.s3ObjectCount);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return (B)this.self();
        }

        @Generated
        public B awsArn(String awsArn) {
            this.awsArn = awsArn;
            return (B)this.self();
        }

        @Generated
        public B awsOwnerId(String awsOwnerId) {
            this.awsOwnerId = awsOwnerId;
            return (B)this.self();
        }

        @Generated
        public B awsOwnerName(String awsOwnerName) {
            this.awsOwnerName = awsOwnerName;
            return (B)this.self();
        }

        @Generated
        public B awsPartition(String awsPartition) {
            this.awsPartition = awsPartition;
            return (B)this.self();
        }

        @Generated
        public B awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return (B)this.self();
        }

        @Generated
        public B awsResourceId(String awsResourceId) {
            this.awsResourceId = awsResourceId;
            return (B)this.self();
        }

        @Generated
        public B awsService(String awsService) {
            this.awsService = awsService;
            return (B)this.self();
        }

        @Generated
        public B awsTag(AwsTag awsTag) {
            if (this.awsTags == null) {
                this.awsTags = new ArrayList();
            }
            this.awsTags.add(awsTag);
            return (B)this.self();
        }

        @Generated
        public B awsTags(Collection<? extends AwsTag> awsTags) {
            if (awsTags == null) {
                throw new NullPointerException("awsTags cannot be null");
            }
            if (this.awsTags == null) {
                this.awsTags = new ArrayList();
            }
            this.awsTags.addAll(awsTags);
            return (B)this.self();
        }

        @Generated
        public B clearAwsTags() {
            if (this.awsTags != null) {
                this.awsTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B object(IS3Object object) {
            if (this.objects == null) {
                this.objects = new ArrayList();
            }
            this.objects.add(object);
            return (B)this.self();
        }

        @Generated
        public B objects(Collection<? extends IS3Object> objects) {
            if (objects == null) {
                throw new NullPointerException("objects cannot be null");
            }
            if (this.objects == null) {
                this.objects = new ArrayList();
            }
            this.objects.addAll(objects);
            return (B)this.self();
        }

        @Generated
        public B clearObjects() {
            if (this.objects != null) {
                this.objects.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B s3BucketVersioningEnabled(Boolean s3BucketVersioningEnabled) {
            this.s3BucketVersioningEnabled = s3BucketVersioningEnabled;
            return (B)this.self();
        }

        @Generated
        public B s3ETag(String s3ETag) {
            this.s3ETag = s3ETag;
            return (B)this.self();
        }

        @Generated
        public B s3Encryption(String s3Encryption) {
            this.s3Encryption = s3Encryption;
            return (B)this.self();
        }

        @Generated
        public B s3ObjectCount(Long s3ObjectCount) {
            this.s3ObjectCount = s3ObjectCount;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "S3Bucket.S3BucketBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", awsAccountId=" + this.awsAccountId + ", awsArn=" + this.awsArn + ", awsOwnerId=" + this.awsOwnerId + ", awsOwnerName=" + this.awsOwnerName + ", awsPartition=" + this.awsPartition + ", awsRegion=" + this.awsRegion + ", awsResourceId=" + this.awsResourceId + ", awsService=" + this.awsService + ", awsTags=" + this.awsTags + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelImplementedEntities=" + this.modelImplementedEntities + ", objects=" + this.objects + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", s3BucketVersioningEnabled=" + this.s3BucketVersioningEnabled + ", s3ETag=" + this.s3ETag + ", s3Encryption=" + this.s3Encryption + ", s3ObjectCount=" + this.s3ObjectCount + ")";
        }
    }

    @Generated
    private static final class S3BucketBuilderImpl
    extends S3BucketBuilder<S3Bucket, S3BucketBuilderImpl> {
        @Generated
        private S3BucketBuilderImpl() {
        }

        @Override
        @Generated
        protected S3BucketBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public S3Bucket build() {
            return new S3Bucket(this);
        }
    }
}

