/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISigma;
import com.atlan.model.assets.ISigmaDataElement;
import com.atlan.model.assets.ISigmaDataElementField;
import com.atlan.model.assets.ISigmaPage;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigmaDataElement
extends Asset
implements ISigmaDataElement,
ISigma,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigmaDataElement.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SigmaDataElement";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    Long sigmaDataElementFieldCount;
    @Attribute
    SortedSet<ISigmaDataElementField> sigmaDataElementFields;
    @Attribute
    String sigmaDataElementName;
    @Attribute
    String sigmaDataElementQualifiedName;
    @Attribute
    String sigmaDataElementQuery;
    @Attribute
    String sigmaDataElementType;
    @Attribute
    ISigmaPage sigmaPage;
    @Attribute
    String sigmaPageName;
    @Attribute
    String sigmaPageQualifiedName;
    @Attribute
    String sigmaWorkbookName;
    @Attribute
    String sigmaWorkbookQualifiedName;

    @Override
    public SigmaDataElement trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SigmaDataElement.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SigmaDataElement.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SigmaDataElement.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SigmaDataElement.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SigmaDataElement.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SigmaDataElement.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SigmaDataElement refByGuid(String guid) {
        return SigmaDataElement.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SigmaDataElement refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SigmaDataElementBuilder)((SigmaDataElementBuilder)SigmaDataElement._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SigmaDataElement refByQualifiedName(String qualifiedName) {
        return SigmaDataElement.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SigmaDataElement refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SigmaDataElementBuilder)((SigmaDataElementBuilder)SigmaDataElement._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SigmaDataElement get(String id) throws AtlanException {
        return SigmaDataElement.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SigmaDataElement get(AtlanClient client, String id) throws AtlanException {
        return SigmaDataElement.get(client, id, true);
    }

    @JsonIgnore
    public static SigmaDataElement get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SigmaDataElement) {
                return (SigmaDataElement)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SigmaDataElement) {
            return (SigmaDataElement)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SigmaDataElement.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SigmaDataElementBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SigmaDataElementBuilder)((SigmaDataElementBuilder)((SigmaDataElementBuilder)SigmaDataElement._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SigmaDataElementBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        SigmaDataElement.validateRequired(TYPE_NAME, map);
        return SigmaDataElement.updater(this.getQualifiedName(), this.getName());
    }

    public static SigmaDataElement removeDescription(String qualifiedName, String name) throws AtlanException {
        return SigmaDataElement.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaDataElement removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaDataElement)Asset.removeDescription(client, SigmaDataElement.updater(qualifiedName, name));
    }

    public static SigmaDataElement removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SigmaDataElement.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaDataElement removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaDataElement)Asset.removeUserDescription(client, SigmaDataElement.updater(qualifiedName, name));
    }

    public static SigmaDataElement removeOwners(String qualifiedName, String name) throws AtlanException {
        return SigmaDataElement.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaDataElement removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaDataElement)Asset.removeOwners(client, SigmaDataElement.updater(qualifiedName, name));
    }

    public static SigmaDataElement updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SigmaDataElement.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SigmaDataElement updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SigmaDataElement)Asset.updateCertificate(client, SigmaDataElement._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SigmaDataElement removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SigmaDataElement.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaDataElement removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaDataElement)Asset.removeCertificate(client, SigmaDataElement.updater(qualifiedName, name));
    }

    public static SigmaDataElement updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SigmaDataElement.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SigmaDataElement updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SigmaDataElement)Asset.updateAnnouncement(client, SigmaDataElement._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SigmaDataElement removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SigmaDataElement.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaDataElement removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaDataElement)Asset.removeAnnouncement(client, SigmaDataElement.updater(qualifiedName, name));
    }

    public static SigmaDataElement replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SigmaDataElement.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SigmaDataElement replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaDataElement)Asset.replaceTerms(client, SigmaDataElement.updater(qualifiedName, name), terms);
    }

    public static SigmaDataElement appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SigmaDataElement.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SigmaDataElement appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaDataElement)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SigmaDataElement removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SigmaDataElement.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SigmaDataElement removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaDataElement)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SigmaDataElement appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SigmaDataElement.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SigmaDataElement appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SigmaDataElement)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SigmaDataElement appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SigmaDataElement.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SigmaDataElement appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SigmaDataElement)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SigmaDataElement.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SigmaDataElement(SigmaDataElementBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SigmaDataElement.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sigmaDataElementFieldCount = b.sigmaDataElementFieldCount;
        SortedSet<ISigmaDataElementField> sigmaDataElementFields = new TreeSet<ISigmaDataElementField>();
        if (b.sigmaDataElementFields != null) {
            sigmaDataElementFields.addAll(b.sigmaDataElementFields);
        }
        sigmaDataElementFields = Collections.unmodifiableSortedSet(sigmaDataElementFields);
        this.sigmaDataElementFields = sigmaDataElementFields;
        this.sigmaDataElementName = b.sigmaDataElementName;
        this.sigmaDataElementQualifiedName = b.sigmaDataElementQualifiedName;
        this.sigmaDataElementQuery = b.sigmaDataElementQuery;
        this.sigmaDataElementType = b.sigmaDataElementType;
        this.sigmaPage = b.sigmaPage;
        this.sigmaPageName = b.sigmaPageName;
        this.sigmaPageQualifiedName = b.sigmaPageQualifiedName;
        this.sigmaWorkbookName = b.sigmaWorkbookName;
        this.sigmaWorkbookQualifiedName = b.sigmaWorkbookQualifiedName;
    }

    @Generated
    public static SigmaDataElementBuilder<?, ?> _internal() {
        return new SigmaDataElementBuilderImpl();
    }

    @Generated
    public SigmaDataElementBuilder<?, ?> toBuilder() {
        return new SigmaDataElementBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public Long getSigmaDataElementFieldCount() {
        return this.sigmaDataElementFieldCount;
    }

    @Override
    @Generated
    public SortedSet<ISigmaDataElementField> getSigmaDataElementFields() {
        return this.sigmaDataElementFields;
    }

    @Override
    @Generated
    public String getSigmaDataElementName() {
        return this.sigmaDataElementName;
    }

    @Override
    @Generated
    public String getSigmaDataElementQualifiedName() {
        return this.sigmaDataElementQualifiedName;
    }

    @Override
    @Generated
    public String getSigmaDataElementQuery() {
        return this.sigmaDataElementQuery;
    }

    @Override
    @Generated
    public String getSigmaDataElementType() {
        return this.sigmaDataElementType;
    }

    @Override
    @Generated
    public ISigmaPage getSigmaPage() {
        return this.sigmaPage;
    }

    @Override
    @Generated
    public String getSigmaPageName() {
        return this.sigmaPageName;
    }

    @Override
    @Generated
    public String getSigmaPageQualifiedName() {
        return this.sigmaPageQualifiedName;
    }

    @Override
    @Generated
    public String getSigmaWorkbookName() {
        return this.sigmaWorkbookName;
    }

    @Override
    @Generated
    public String getSigmaWorkbookQualifiedName() {
        return this.sigmaWorkbookQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SigmaDataElement)) {
            return false;
        }
        SigmaDataElement other = (SigmaDataElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sigmaDataElementFieldCount = this.getSigmaDataElementFieldCount();
        Long other$sigmaDataElementFieldCount = other.getSigmaDataElementFieldCount();
        if (this$sigmaDataElementFieldCount == null ? other$sigmaDataElementFieldCount != null : !((Object)this$sigmaDataElementFieldCount).equals(other$sigmaDataElementFieldCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<ISigmaDataElementField> this$sigmaDataElementFields = this.getSigmaDataElementFields();
        SortedSet<ISigmaDataElementField> other$sigmaDataElementFields = other.getSigmaDataElementFields();
        if (this$sigmaDataElementFields == null ? other$sigmaDataElementFields != null : !this$sigmaDataElementFields.equals(other$sigmaDataElementFields)) {
            return false;
        }
        String this$sigmaDataElementName = this.getSigmaDataElementName();
        String other$sigmaDataElementName = other.getSigmaDataElementName();
        if (this$sigmaDataElementName == null ? other$sigmaDataElementName != null : !this$sigmaDataElementName.equals(other$sigmaDataElementName)) {
            return false;
        }
        String this$sigmaDataElementQualifiedName = this.getSigmaDataElementQualifiedName();
        String other$sigmaDataElementQualifiedName = other.getSigmaDataElementQualifiedName();
        if (this$sigmaDataElementQualifiedName == null ? other$sigmaDataElementQualifiedName != null : !this$sigmaDataElementQualifiedName.equals(other$sigmaDataElementQualifiedName)) {
            return false;
        }
        String this$sigmaDataElementQuery = this.getSigmaDataElementQuery();
        String other$sigmaDataElementQuery = other.getSigmaDataElementQuery();
        if (this$sigmaDataElementQuery == null ? other$sigmaDataElementQuery != null : !this$sigmaDataElementQuery.equals(other$sigmaDataElementQuery)) {
            return false;
        }
        String this$sigmaDataElementType = this.getSigmaDataElementType();
        String other$sigmaDataElementType = other.getSigmaDataElementType();
        if (this$sigmaDataElementType == null ? other$sigmaDataElementType != null : !this$sigmaDataElementType.equals(other$sigmaDataElementType)) {
            return false;
        }
        ISigmaPage this$sigmaPage = this.getSigmaPage();
        ISigmaPage other$sigmaPage = other.getSigmaPage();
        if (this$sigmaPage == null ? other$sigmaPage != null : !this$sigmaPage.equals(other$sigmaPage)) {
            return false;
        }
        String this$sigmaPageName = this.getSigmaPageName();
        String other$sigmaPageName = other.getSigmaPageName();
        if (this$sigmaPageName == null ? other$sigmaPageName != null : !this$sigmaPageName.equals(other$sigmaPageName)) {
            return false;
        }
        String this$sigmaPageQualifiedName = this.getSigmaPageQualifiedName();
        String other$sigmaPageQualifiedName = other.getSigmaPageQualifiedName();
        if (this$sigmaPageQualifiedName == null ? other$sigmaPageQualifiedName != null : !this$sigmaPageQualifiedName.equals(other$sigmaPageQualifiedName)) {
            return false;
        }
        String this$sigmaWorkbookName = this.getSigmaWorkbookName();
        String other$sigmaWorkbookName = other.getSigmaWorkbookName();
        if (this$sigmaWorkbookName == null ? other$sigmaWorkbookName != null : !this$sigmaWorkbookName.equals(other$sigmaWorkbookName)) {
            return false;
        }
        String this$sigmaWorkbookQualifiedName = this.getSigmaWorkbookQualifiedName();
        String other$sigmaWorkbookQualifiedName = other.getSigmaWorkbookQualifiedName();
        return !(this$sigmaWorkbookQualifiedName == null ? other$sigmaWorkbookQualifiedName != null : !this$sigmaWorkbookQualifiedName.equals(other$sigmaWorkbookQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SigmaDataElement;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sigmaDataElementFieldCount = this.getSigmaDataElementFieldCount();
        result = result * 59 + ($sigmaDataElementFieldCount == null ? 43 : ((Object)$sigmaDataElementFieldCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<ISigmaDataElementField> $sigmaDataElementFields = this.getSigmaDataElementFields();
        result = result * 59 + ($sigmaDataElementFields == null ? 43 : $sigmaDataElementFields.hashCode());
        String $sigmaDataElementName = this.getSigmaDataElementName();
        result = result * 59 + ($sigmaDataElementName == null ? 43 : $sigmaDataElementName.hashCode());
        String $sigmaDataElementQualifiedName = this.getSigmaDataElementQualifiedName();
        result = result * 59 + ($sigmaDataElementQualifiedName == null ? 43 : $sigmaDataElementQualifiedName.hashCode());
        String $sigmaDataElementQuery = this.getSigmaDataElementQuery();
        result = result * 59 + ($sigmaDataElementQuery == null ? 43 : $sigmaDataElementQuery.hashCode());
        String $sigmaDataElementType = this.getSigmaDataElementType();
        result = result * 59 + ($sigmaDataElementType == null ? 43 : $sigmaDataElementType.hashCode());
        ISigmaPage $sigmaPage = this.getSigmaPage();
        result = result * 59 + ($sigmaPage == null ? 43 : $sigmaPage.hashCode());
        String $sigmaPageName = this.getSigmaPageName();
        result = result * 59 + ($sigmaPageName == null ? 43 : $sigmaPageName.hashCode());
        String $sigmaPageQualifiedName = this.getSigmaPageQualifiedName();
        result = result * 59 + ($sigmaPageQualifiedName == null ? 43 : $sigmaPageQualifiedName.hashCode());
        String $sigmaWorkbookName = this.getSigmaWorkbookName();
        result = result * 59 + ($sigmaWorkbookName == null ? 43 : $sigmaWorkbookName.hashCode());
        String $sigmaWorkbookQualifiedName = this.getSigmaWorkbookQualifiedName();
        result = result * 59 + ($sigmaWorkbookQualifiedName == null ? 43 : $sigmaWorkbookQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SigmaDataElement(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sigmaDataElementFieldCount=" + this.getSigmaDataElementFieldCount() + ", sigmaDataElementFields=" + this.getSigmaDataElementFields() + ", sigmaDataElementName=" + this.getSigmaDataElementName() + ", sigmaDataElementQualifiedName=" + this.getSigmaDataElementQualifiedName() + ", sigmaDataElementQuery=" + this.getSigmaDataElementQuery() + ", sigmaDataElementType=" + this.getSigmaDataElementType() + ", sigmaPage=" + this.getSigmaPage() + ", sigmaPageName=" + this.getSigmaPageName() + ", sigmaPageQualifiedName=" + this.getSigmaPageQualifiedName() + ", sigmaWorkbookName=" + this.getSigmaWorkbookName() + ", sigmaWorkbookQualifiedName=" + this.getSigmaWorkbookQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class SigmaDataElementBuilder<C extends SigmaDataElement, B extends SigmaDataElementBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private Long sigmaDataElementFieldCount;
        @Generated
        private ArrayList<ISigmaDataElementField> sigmaDataElementFields;
        @Generated
        private String sigmaDataElementName;
        @Generated
        private String sigmaDataElementQualifiedName;
        @Generated
        private String sigmaDataElementQuery;
        @Generated
        private String sigmaDataElementType;
        @Generated
        private ISigmaPage sigmaPage;
        @Generated
        private String sigmaPageName;
        @Generated
        private String sigmaPageQualifiedName;
        @Generated
        private String sigmaWorkbookName;
        @Generated
        private String sigmaWorkbookQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SigmaDataElementBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SigmaDataElement instance, SigmaDataElementBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sigmaDataElementFieldCount(instance.sigmaDataElementFieldCount);
            b.sigmaDataElementFields(instance.sigmaDataElementFields == null ? Collections.emptySortedSet() : instance.sigmaDataElementFields);
            b.sigmaDataElementName(instance.sigmaDataElementName);
            b.sigmaDataElementQualifiedName(instance.sigmaDataElementQualifiedName);
            b.sigmaDataElementQuery(instance.sigmaDataElementQuery);
            b.sigmaDataElementType(instance.sigmaDataElementType);
            b.sigmaPage(instance.sigmaPage);
            b.sigmaPageName(instance.sigmaPageName);
            b.sigmaPageQualifiedName(instance.sigmaPageQualifiedName);
            b.sigmaWorkbookName(instance.sigmaWorkbookName);
            b.sigmaWorkbookQualifiedName(instance.sigmaWorkbookQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementFieldCount(Long sigmaDataElementFieldCount) {
            this.sigmaDataElementFieldCount = sigmaDataElementFieldCount;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementField(ISigmaDataElementField sigmaDataElementField) {
            if (this.sigmaDataElementFields == null) {
                this.sigmaDataElementFields = new ArrayList();
            }
            this.sigmaDataElementFields.add(sigmaDataElementField);
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementFields(Collection<? extends ISigmaDataElementField> sigmaDataElementFields) {
            if (sigmaDataElementFields == null) {
                throw new NullPointerException("sigmaDataElementFields cannot be null");
            }
            if (this.sigmaDataElementFields == null) {
                this.sigmaDataElementFields = new ArrayList();
            }
            this.sigmaDataElementFields.addAll(sigmaDataElementFields);
            return (B)this.self();
        }

        @Generated
        public B clearSigmaDataElementFields() {
            if (this.sigmaDataElementFields != null) {
                this.sigmaDataElementFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementName(String sigmaDataElementName) {
            this.sigmaDataElementName = sigmaDataElementName;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementQualifiedName(String sigmaDataElementQualifiedName) {
            this.sigmaDataElementQualifiedName = sigmaDataElementQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementQuery(String sigmaDataElementQuery) {
            this.sigmaDataElementQuery = sigmaDataElementQuery;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementType(String sigmaDataElementType) {
            this.sigmaDataElementType = sigmaDataElementType;
            return (B)this.self();
        }

        @Generated
        public B sigmaPage(ISigmaPage sigmaPage) {
            this.sigmaPage = sigmaPage;
            return (B)this.self();
        }

        @Generated
        public B sigmaPageName(String sigmaPageName) {
            this.sigmaPageName = sigmaPageName;
            return (B)this.self();
        }

        @Generated
        public B sigmaPageQualifiedName(String sigmaPageQualifiedName) {
            this.sigmaPageQualifiedName = sigmaPageQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sigmaWorkbookName(String sigmaWorkbookName) {
            this.sigmaWorkbookName = sigmaWorkbookName;
            return (B)this.self();
        }

        @Generated
        public B sigmaWorkbookQualifiedName(String sigmaWorkbookQualifiedName) {
            this.sigmaWorkbookQualifiedName = sigmaWorkbookQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SigmaDataElement.SigmaDataElementBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sigmaDataElementFieldCount=" + this.sigmaDataElementFieldCount + ", sigmaDataElementFields=" + this.sigmaDataElementFields + ", sigmaDataElementName=" + this.sigmaDataElementName + ", sigmaDataElementQualifiedName=" + this.sigmaDataElementQualifiedName + ", sigmaDataElementQuery=" + this.sigmaDataElementQuery + ", sigmaDataElementType=" + this.sigmaDataElementType + ", sigmaPage=" + this.sigmaPage + ", sigmaPageName=" + this.sigmaPageName + ", sigmaPageQualifiedName=" + this.sigmaPageQualifiedName + ", sigmaWorkbookName=" + this.sigmaWorkbookName + ", sigmaWorkbookQualifiedName=" + this.sigmaWorkbookQualifiedName + ")";
        }
    }

    @Generated
    private static final class SigmaDataElementBuilderImpl
    extends SigmaDataElementBuilder<SigmaDataElement, SigmaDataElementBuilderImpl> {
        @Generated
        private SigmaDataElementBuilderImpl() {
        }

        @Override
        @Generated
        protected SigmaDataElementBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SigmaDataElement build() {
            return new SigmaDataElement(this);
        }
    }
}

