/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISisense;
import com.atlan.model.assets.ISisenseDashboard;
import com.atlan.model.assets.ISisenseDatamodel;
import com.atlan.model.assets.ISisenseDatamodelTable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SisenseDatamodel
extends Asset
implements ISisenseDatamodel,
ISisense,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SisenseDatamodel.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SisenseDatamodel";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<ISisenseDashboard> sisenseDashboards;
    @Attribute
    @Date
    Long sisenseDatamodelLastBuildTime;
    @Attribute
    @Date
    Long sisenseDatamodelLastPublishTime;
    @Attribute
    @Date
    Long sisenseDatamodelLastSuccessfulBuildTime;
    @Attribute
    String sisenseDatamodelRelationType;
    @Attribute
    String sisenseDatamodelRevision;
    @Attribute
    String sisenseDatamodelServer;
    @Attribute
    Long sisenseDatamodelTableCount;
    @Attribute
    SortedSet<ISisenseDatamodelTable> sisenseDatamodelTables;
    @Attribute
    String sisenseDatamodelType;

    @Override
    public SisenseDatamodel trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SisenseDatamodel.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SisenseDatamodel.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SisenseDatamodel.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SisenseDatamodel.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SisenseDatamodel.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SisenseDatamodel.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SisenseDatamodel refByGuid(String guid) {
        return SisenseDatamodel.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SisenseDatamodel refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SisenseDatamodelBuilder)((SisenseDatamodelBuilder)SisenseDatamodel._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SisenseDatamodel refByQualifiedName(String qualifiedName) {
        return SisenseDatamodel.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SisenseDatamodel refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SisenseDatamodelBuilder)((SisenseDatamodelBuilder)SisenseDatamodel._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SisenseDatamodel get(String id) throws AtlanException {
        return SisenseDatamodel.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SisenseDatamodel get(AtlanClient client, String id) throws AtlanException {
        return SisenseDatamodel.get(client, id, true);
    }

    @JsonIgnore
    public static SisenseDatamodel get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SisenseDatamodel) {
                return (SisenseDatamodel)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SisenseDatamodel) {
            return (SisenseDatamodel)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SisenseDatamodel.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SisenseDatamodelBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SisenseDatamodelBuilder)((SisenseDatamodelBuilder)((SisenseDatamodelBuilder)SisenseDatamodel._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SisenseDatamodelBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        SisenseDatamodel.validateRequired(TYPE_NAME, map);
        return SisenseDatamodel.updater(this.getQualifiedName(), this.getName());
    }

    public static SisenseDatamodel removeDescription(String qualifiedName, String name) throws AtlanException {
        return SisenseDatamodel.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDatamodel removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodel)Asset.removeDescription(client, SisenseDatamodel.updater(qualifiedName, name));
    }

    public static SisenseDatamodel removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SisenseDatamodel.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDatamodel removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodel)Asset.removeUserDescription(client, SisenseDatamodel.updater(qualifiedName, name));
    }

    public static SisenseDatamodel removeOwners(String qualifiedName, String name) throws AtlanException {
        return SisenseDatamodel.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDatamodel removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodel)Asset.removeOwners(client, SisenseDatamodel.updater(qualifiedName, name));
    }

    public static SisenseDatamodel updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SisenseDatamodel.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SisenseDatamodel updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SisenseDatamodel)Asset.updateCertificate(client, SisenseDatamodel._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SisenseDatamodel removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SisenseDatamodel.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDatamodel removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodel)Asset.removeCertificate(client, SisenseDatamodel.updater(qualifiedName, name));
    }

    public static SisenseDatamodel updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SisenseDatamodel.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SisenseDatamodel updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SisenseDatamodel)Asset.updateAnnouncement(client, SisenseDatamodel._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SisenseDatamodel removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SisenseDatamodel.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDatamodel removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodel)Asset.removeAnnouncement(client, SisenseDatamodel.updater(qualifiedName, name));
    }

    public static SisenseDatamodel replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SisenseDatamodel.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SisenseDatamodel replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodel)Asset.replaceTerms(client, SisenseDatamodel.updater(qualifiedName, name), terms);
    }

    public static SisenseDatamodel appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SisenseDatamodel.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SisenseDatamodel appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodel)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SisenseDatamodel removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SisenseDatamodel.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SisenseDatamodel removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodel)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SisenseDatamodel appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SisenseDatamodel.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SisenseDatamodel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SisenseDatamodel)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SisenseDatamodel appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SisenseDatamodel.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SisenseDatamodel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SisenseDatamodel)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SisenseDatamodel.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SisenseDatamodel(SisenseDatamodelBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SisenseDatamodel.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<ISisenseDashboard> sisenseDashboards = new TreeSet<ISisenseDashboard>();
        if (b.sisenseDashboards != null) {
            sisenseDashboards.addAll(b.sisenseDashboards);
        }
        sisenseDashboards = Collections.unmodifiableSortedSet(sisenseDashboards);
        this.sisenseDashboards = sisenseDashboards;
        this.sisenseDatamodelLastBuildTime = b.sisenseDatamodelLastBuildTime;
        this.sisenseDatamodelLastPublishTime = b.sisenseDatamodelLastPublishTime;
        this.sisenseDatamodelLastSuccessfulBuildTime = b.sisenseDatamodelLastSuccessfulBuildTime;
        this.sisenseDatamodelRelationType = b.sisenseDatamodelRelationType;
        this.sisenseDatamodelRevision = b.sisenseDatamodelRevision;
        this.sisenseDatamodelServer = b.sisenseDatamodelServer;
        this.sisenseDatamodelTableCount = b.sisenseDatamodelTableCount;
        SortedSet<ISisenseDatamodelTable> sisenseDatamodelTables = new TreeSet<ISisenseDatamodelTable>();
        if (b.sisenseDatamodelTables != null) {
            sisenseDatamodelTables.addAll(b.sisenseDatamodelTables);
        }
        sisenseDatamodelTables = Collections.unmodifiableSortedSet(sisenseDatamodelTables);
        this.sisenseDatamodelTables = sisenseDatamodelTables;
        this.sisenseDatamodelType = b.sisenseDatamodelType;
    }

    @Generated
    public static SisenseDatamodelBuilder<?, ?> _internal() {
        return new SisenseDatamodelBuilderImpl();
    }

    @Generated
    public SisenseDatamodelBuilder<?, ?> toBuilder() {
        return new SisenseDatamodelBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ISisenseDashboard> getSisenseDashboards() {
        return this.sisenseDashboards;
    }

    @Override
    @Generated
    public Long getSisenseDatamodelLastBuildTime() {
        return this.sisenseDatamodelLastBuildTime;
    }

    @Override
    @Generated
    public Long getSisenseDatamodelLastPublishTime() {
        return this.sisenseDatamodelLastPublishTime;
    }

    @Override
    @Generated
    public Long getSisenseDatamodelLastSuccessfulBuildTime() {
        return this.sisenseDatamodelLastSuccessfulBuildTime;
    }

    @Override
    @Generated
    public String getSisenseDatamodelRelationType() {
        return this.sisenseDatamodelRelationType;
    }

    @Override
    @Generated
    public String getSisenseDatamodelRevision() {
        return this.sisenseDatamodelRevision;
    }

    @Override
    @Generated
    public String getSisenseDatamodelServer() {
        return this.sisenseDatamodelServer;
    }

    @Override
    @Generated
    public Long getSisenseDatamodelTableCount() {
        return this.sisenseDatamodelTableCount;
    }

    @Override
    @Generated
    public SortedSet<ISisenseDatamodelTable> getSisenseDatamodelTables() {
        return this.sisenseDatamodelTables;
    }

    @Override
    @Generated
    public String getSisenseDatamodelType() {
        return this.sisenseDatamodelType;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SisenseDatamodel)) {
            return false;
        }
        SisenseDatamodel other = (SisenseDatamodel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sisenseDatamodelLastBuildTime = this.getSisenseDatamodelLastBuildTime();
        Long other$sisenseDatamodelLastBuildTime = other.getSisenseDatamodelLastBuildTime();
        if (this$sisenseDatamodelLastBuildTime == null ? other$sisenseDatamodelLastBuildTime != null : !((Object)this$sisenseDatamodelLastBuildTime).equals(other$sisenseDatamodelLastBuildTime)) {
            return false;
        }
        Long this$sisenseDatamodelLastPublishTime = this.getSisenseDatamodelLastPublishTime();
        Long other$sisenseDatamodelLastPublishTime = other.getSisenseDatamodelLastPublishTime();
        if (this$sisenseDatamodelLastPublishTime == null ? other$sisenseDatamodelLastPublishTime != null : !((Object)this$sisenseDatamodelLastPublishTime).equals(other$sisenseDatamodelLastPublishTime)) {
            return false;
        }
        Long this$sisenseDatamodelLastSuccessfulBuildTime = this.getSisenseDatamodelLastSuccessfulBuildTime();
        Long other$sisenseDatamodelLastSuccessfulBuildTime = other.getSisenseDatamodelLastSuccessfulBuildTime();
        if (this$sisenseDatamodelLastSuccessfulBuildTime == null ? other$sisenseDatamodelLastSuccessfulBuildTime != null : !((Object)this$sisenseDatamodelLastSuccessfulBuildTime).equals(other$sisenseDatamodelLastSuccessfulBuildTime)) {
            return false;
        }
        Long this$sisenseDatamodelTableCount = this.getSisenseDatamodelTableCount();
        Long other$sisenseDatamodelTableCount = other.getSisenseDatamodelTableCount();
        if (this$sisenseDatamodelTableCount == null ? other$sisenseDatamodelTableCount != null : !((Object)this$sisenseDatamodelTableCount).equals(other$sisenseDatamodelTableCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<ISisenseDashboard> this$sisenseDashboards = this.getSisenseDashboards();
        SortedSet<ISisenseDashboard> other$sisenseDashboards = other.getSisenseDashboards();
        if (this$sisenseDashboards == null ? other$sisenseDashboards != null : !this$sisenseDashboards.equals(other$sisenseDashboards)) {
            return false;
        }
        String this$sisenseDatamodelRelationType = this.getSisenseDatamodelRelationType();
        String other$sisenseDatamodelRelationType = other.getSisenseDatamodelRelationType();
        if (this$sisenseDatamodelRelationType == null ? other$sisenseDatamodelRelationType != null : !this$sisenseDatamodelRelationType.equals(other$sisenseDatamodelRelationType)) {
            return false;
        }
        String this$sisenseDatamodelRevision = this.getSisenseDatamodelRevision();
        String other$sisenseDatamodelRevision = other.getSisenseDatamodelRevision();
        if (this$sisenseDatamodelRevision == null ? other$sisenseDatamodelRevision != null : !this$sisenseDatamodelRevision.equals(other$sisenseDatamodelRevision)) {
            return false;
        }
        String this$sisenseDatamodelServer = this.getSisenseDatamodelServer();
        String other$sisenseDatamodelServer = other.getSisenseDatamodelServer();
        if (this$sisenseDatamodelServer == null ? other$sisenseDatamodelServer != null : !this$sisenseDatamodelServer.equals(other$sisenseDatamodelServer)) {
            return false;
        }
        SortedSet<ISisenseDatamodelTable> this$sisenseDatamodelTables = this.getSisenseDatamodelTables();
        SortedSet<ISisenseDatamodelTable> other$sisenseDatamodelTables = other.getSisenseDatamodelTables();
        if (this$sisenseDatamodelTables == null ? other$sisenseDatamodelTables != null : !this$sisenseDatamodelTables.equals(other$sisenseDatamodelTables)) {
            return false;
        }
        String this$sisenseDatamodelType = this.getSisenseDatamodelType();
        String other$sisenseDatamodelType = other.getSisenseDatamodelType();
        return !(this$sisenseDatamodelType == null ? other$sisenseDatamodelType != null : !this$sisenseDatamodelType.equals(other$sisenseDatamodelType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SisenseDatamodel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sisenseDatamodelLastBuildTime = this.getSisenseDatamodelLastBuildTime();
        result = result * 59 + ($sisenseDatamodelLastBuildTime == null ? 43 : ((Object)$sisenseDatamodelLastBuildTime).hashCode());
        Long $sisenseDatamodelLastPublishTime = this.getSisenseDatamodelLastPublishTime();
        result = result * 59 + ($sisenseDatamodelLastPublishTime == null ? 43 : ((Object)$sisenseDatamodelLastPublishTime).hashCode());
        Long $sisenseDatamodelLastSuccessfulBuildTime = this.getSisenseDatamodelLastSuccessfulBuildTime();
        result = result * 59 + ($sisenseDatamodelLastSuccessfulBuildTime == null ? 43 : ((Object)$sisenseDatamodelLastSuccessfulBuildTime).hashCode());
        Long $sisenseDatamodelTableCount = this.getSisenseDatamodelTableCount();
        result = result * 59 + ($sisenseDatamodelTableCount == null ? 43 : ((Object)$sisenseDatamodelTableCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<ISisenseDashboard> $sisenseDashboards = this.getSisenseDashboards();
        result = result * 59 + ($sisenseDashboards == null ? 43 : $sisenseDashboards.hashCode());
        String $sisenseDatamodelRelationType = this.getSisenseDatamodelRelationType();
        result = result * 59 + ($sisenseDatamodelRelationType == null ? 43 : $sisenseDatamodelRelationType.hashCode());
        String $sisenseDatamodelRevision = this.getSisenseDatamodelRevision();
        result = result * 59 + ($sisenseDatamodelRevision == null ? 43 : $sisenseDatamodelRevision.hashCode());
        String $sisenseDatamodelServer = this.getSisenseDatamodelServer();
        result = result * 59 + ($sisenseDatamodelServer == null ? 43 : $sisenseDatamodelServer.hashCode());
        SortedSet<ISisenseDatamodelTable> $sisenseDatamodelTables = this.getSisenseDatamodelTables();
        result = result * 59 + ($sisenseDatamodelTables == null ? 43 : $sisenseDatamodelTables.hashCode());
        String $sisenseDatamodelType = this.getSisenseDatamodelType();
        result = result * 59 + ($sisenseDatamodelType == null ? 43 : $sisenseDatamodelType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SisenseDatamodel(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sisenseDashboards=" + this.getSisenseDashboards() + ", sisenseDatamodelLastBuildTime=" + this.getSisenseDatamodelLastBuildTime() + ", sisenseDatamodelLastPublishTime=" + this.getSisenseDatamodelLastPublishTime() + ", sisenseDatamodelLastSuccessfulBuildTime=" + this.getSisenseDatamodelLastSuccessfulBuildTime() + ", sisenseDatamodelRelationType=" + this.getSisenseDatamodelRelationType() + ", sisenseDatamodelRevision=" + this.getSisenseDatamodelRevision() + ", sisenseDatamodelServer=" + this.getSisenseDatamodelServer() + ", sisenseDatamodelTableCount=" + this.getSisenseDatamodelTableCount() + ", sisenseDatamodelTables=" + this.getSisenseDatamodelTables() + ", sisenseDatamodelType=" + this.getSisenseDatamodelType() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class SisenseDatamodelBuilder<C extends SisenseDatamodel, B extends SisenseDatamodelBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<ISisenseDashboard> sisenseDashboards;
        @Generated
        private Long sisenseDatamodelLastBuildTime;
        @Generated
        private Long sisenseDatamodelLastPublishTime;
        @Generated
        private Long sisenseDatamodelLastSuccessfulBuildTime;
        @Generated
        private String sisenseDatamodelRelationType;
        @Generated
        private String sisenseDatamodelRevision;
        @Generated
        private String sisenseDatamodelServer;
        @Generated
        private Long sisenseDatamodelTableCount;
        @Generated
        private ArrayList<ISisenseDatamodelTable> sisenseDatamodelTables;
        @Generated
        private String sisenseDatamodelType;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SisenseDatamodelBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SisenseDatamodel instance, SisenseDatamodelBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sisenseDashboards(instance.sisenseDashboards == null ? Collections.emptySortedSet() : instance.sisenseDashboards);
            b.sisenseDatamodelLastBuildTime(instance.sisenseDatamodelLastBuildTime);
            b.sisenseDatamodelLastPublishTime(instance.sisenseDatamodelLastPublishTime);
            b.sisenseDatamodelLastSuccessfulBuildTime(instance.sisenseDatamodelLastSuccessfulBuildTime);
            b.sisenseDatamodelRelationType(instance.sisenseDatamodelRelationType);
            b.sisenseDatamodelRevision(instance.sisenseDatamodelRevision);
            b.sisenseDatamodelServer(instance.sisenseDatamodelServer);
            b.sisenseDatamodelTableCount(instance.sisenseDatamodelTableCount);
            b.sisenseDatamodelTables(instance.sisenseDatamodelTables == null ? Collections.emptySortedSet() : instance.sisenseDatamodelTables);
            b.sisenseDatamodelType(instance.sisenseDatamodelType);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sisenseDashboard(ISisenseDashboard sisenseDashboard) {
            if (this.sisenseDashboards == null) {
                this.sisenseDashboards = new ArrayList();
            }
            this.sisenseDashboards.add(sisenseDashboard);
            return (B)this.self();
        }

        @Generated
        public B sisenseDashboards(Collection<? extends ISisenseDashboard> sisenseDashboards) {
            if (sisenseDashboards == null) {
                throw new NullPointerException("sisenseDashboards cannot be null");
            }
            if (this.sisenseDashboards == null) {
                this.sisenseDashboards = new ArrayList();
            }
            this.sisenseDashboards.addAll(sisenseDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearSisenseDashboards() {
            if (this.sisenseDashboards != null) {
                this.sisenseDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelLastBuildTime(Long sisenseDatamodelLastBuildTime) {
            this.sisenseDatamodelLastBuildTime = sisenseDatamodelLastBuildTime;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelLastPublishTime(Long sisenseDatamodelLastPublishTime) {
            this.sisenseDatamodelLastPublishTime = sisenseDatamodelLastPublishTime;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelLastSuccessfulBuildTime(Long sisenseDatamodelLastSuccessfulBuildTime) {
            this.sisenseDatamodelLastSuccessfulBuildTime = sisenseDatamodelLastSuccessfulBuildTime;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelRelationType(String sisenseDatamodelRelationType) {
            this.sisenseDatamodelRelationType = sisenseDatamodelRelationType;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelRevision(String sisenseDatamodelRevision) {
            this.sisenseDatamodelRevision = sisenseDatamodelRevision;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelServer(String sisenseDatamodelServer) {
            this.sisenseDatamodelServer = sisenseDatamodelServer;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTableCount(Long sisenseDatamodelTableCount) {
            this.sisenseDatamodelTableCount = sisenseDatamodelTableCount;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTable(ISisenseDatamodelTable sisenseDatamodelTable) {
            if (this.sisenseDatamodelTables == null) {
                this.sisenseDatamodelTables = new ArrayList();
            }
            this.sisenseDatamodelTables.add(sisenseDatamodelTable);
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTables(Collection<? extends ISisenseDatamodelTable> sisenseDatamodelTables) {
            if (sisenseDatamodelTables == null) {
                throw new NullPointerException("sisenseDatamodelTables cannot be null");
            }
            if (this.sisenseDatamodelTables == null) {
                this.sisenseDatamodelTables = new ArrayList();
            }
            this.sisenseDatamodelTables.addAll(sisenseDatamodelTables);
            return (B)this.self();
        }

        @Generated
        public B clearSisenseDatamodelTables() {
            if (this.sisenseDatamodelTables != null) {
                this.sisenseDatamodelTables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelType(String sisenseDatamodelType) {
            this.sisenseDatamodelType = sisenseDatamodelType;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SisenseDatamodel.SisenseDatamodelBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sisenseDashboards=" + this.sisenseDashboards + ", sisenseDatamodelLastBuildTime=" + this.sisenseDatamodelLastBuildTime + ", sisenseDatamodelLastPublishTime=" + this.sisenseDatamodelLastPublishTime + ", sisenseDatamodelLastSuccessfulBuildTime=" + this.sisenseDatamodelLastSuccessfulBuildTime + ", sisenseDatamodelRelationType=" + this.sisenseDatamodelRelationType + ", sisenseDatamodelRevision=" + this.sisenseDatamodelRevision + ", sisenseDatamodelServer=" + this.sisenseDatamodelServer + ", sisenseDatamodelTableCount=" + this.sisenseDatamodelTableCount + ", sisenseDatamodelTables=" + this.sisenseDatamodelTables + ", sisenseDatamodelType=" + this.sisenseDatamodelType + ")";
        }
    }

    @Generated
    private static final class SisenseDatamodelBuilderImpl
    extends SisenseDatamodelBuilder<SisenseDatamodel, SisenseDatamodelBuilderImpl> {
        @Generated
        private SisenseDatamodelBuilderImpl() {
        }

        @Override
        @Generated
        protected SisenseDatamodelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SisenseDatamodel build() {
            return new SisenseDatamodel(this);
        }
    }
}

