/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISisense;
import com.atlan.model.assets.ISisenseDatamodel;
import com.atlan.model.assets.ISisenseDatamodelTable;
import com.atlan.model.assets.ISisenseWidget;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SisenseDatamodelTable
extends Asset
implements ISisenseDatamodelTable,
ISisense,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SisenseDatamodelTable.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SisenseDatamodelTable";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    ISisenseDatamodel sisenseDatamodel;
    @Attribute
    String sisenseDatamodelQualifiedName;
    @Attribute
    Long sisenseDatamodelTableColumnCount;
    @Attribute
    String sisenseDatamodelTableExpression;
    @Attribute
    Boolean sisenseDatamodelTableIsHidden;
    @Attribute
    Boolean sisenseDatamodelTableIsMaterialized;
    @Attribute
    String sisenseDatamodelTableLiveQuerySettings;
    @Attribute
    String sisenseDatamodelTableSchedule;
    @Attribute
    String sisenseDatamodelTableType;
    @Attribute
    SortedSet<ISisenseWidget> sisenseWidgets;

    @Override
    public SisenseDatamodelTable trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SisenseDatamodelTable.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SisenseDatamodelTable.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SisenseDatamodelTable.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SisenseDatamodelTable.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SisenseDatamodelTable.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SisenseDatamodelTable.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SisenseDatamodelTable refByGuid(String guid) {
        return SisenseDatamodelTable.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SisenseDatamodelTable refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SisenseDatamodelTableBuilder)((SisenseDatamodelTableBuilder)SisenseDatamodelTable._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SisenseDatamodelTable refByQualifiedName(String qualifiedName) {
        return SisenseDatamodelTable.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SisenseDatamodelTable refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SisenseDatamodelTableBuilder)((SisenseDatamodelTableBuilder)SisenseDatamodelTable._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SisenseDatamodelTable get(String id) throws AtlanException {
        return SisenseDatamodelTable.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SisenseDatamodelTable get(AtlanClient client, String id) throws AtlanException {
        return SisenseDatamodelTable.get(client, id, true);
    }

    @JsonIgnore
    public static SisenseDatamodelTable get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SisenseDatamodelTable) {
                return (SisenseDatamodelTable)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SisenseDatamodelTable) {
            return (SisenseDatamodelTable)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SisenseDatamodelTable.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SisenseDatamodelTableBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SisenseDatamodelTableBuilder)((SisenseDatamodelTableBuilder)((SisenseDatamodelTableBuilder)SisenseDatamodelTable._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SisenseDatamodelTableBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        SisenseDatamodelTable.validateRequired(TYPE_NAME, map);
        return SisenseDatamodelTable.updater(this.getQualifiedName(), this.getName());
    }

    public static SisenseDatamodelTable removeDescription(String qualifiedName, String name) throws AtlanException {
        return SisenseDatamodelTable.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDatamodelTable removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodelTable)Asset.removeDescription(client, SisenseDatamodelTable.updater(qualifiedName, name));
    }

    public static SisenseDatamodelTable removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SisenseDatamodelTable.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDatamodelTable removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodelTable)Asset.removeUserDescription(client, SisenseDatamodelTable.updater(qualifiedName, name));
    }

    public static SisenseDatamodelTable removeOwners(String qualifiedName, String name) throws AtlanException {
        return SisenseDatamodelTable.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDatamodelTable removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodelTable)Asset.removeOwners(client, SisenseDatamodelTable.updater(qualifiedName, name));
    }

    public static SisenseDatamodelTable updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SisenseDatamodelTable.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SisenseDatamodelTable updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SisenseDatamodelTable)Asset.updateCertificate(client, SisenseDatamodelTable._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SisenseDatamodelTable removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SisenseDatamodelTable.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDatamodelTable removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodelTable)Asset.removeCertificate(client, SisenseDatamodelTable.updater(qualifiedName, name));
    }

    public static SisenseDatamodelTable updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SisenseDatamodelTable.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SisenseDatamodelTable updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SisenseDatamodelTable)Asset.updateAnnouncement(client, SisenseDatamodelTable._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SisenseDatamodelTable removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SisenseDatamodelTable.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDatamodelTable removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodelTable)Asset.removeAnnouncement(client, SisenseDatamodelTable.updater(qualifiedName, name));
    }

    public static SisenseDatamodelTable replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SisenseDatamodelTable.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SisenseDatamodelTable replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodelTable)Asset.replaceTerms(client, SisenseDatamodelTable.updater(qualifiedName, name), terms);
    }

    public static SisenseDatamodelTable appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SisenseDatamodelTable.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SisenseDatamodelTable appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodelTable)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SisenseDatamodelTable removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SisenseDatamodelTable.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SisenseDatamodelTable removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodelTable)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SisenseDatamodelTable appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SisenseDatamodelTable.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SisenseDatamodelTable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SisenseDatamodelTable)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SisenseDatamodelTable appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SisenseDatamodelTable.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SisenseDatamodelTable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SisenseDatamodelTable)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SisenseDatamodelTable.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SisenseDatamodelTable(SisenseDatamodelTableBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SisenseDatamodelTable.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sisenseDatamodel = b.sisenseDatamodel;
        this.sisenseDatamodelQualifiedName = b.sisenseDatamodelQualifiedName;
        this.sisenseDatamodelTableColumnCount = b.sisenseDatamodelTableColumnCount;
        this.sisenseDatamodelTableExpression = b.sisenseDatamodelTableExpression;
        this.sisenseDatamodelTableIsHidden = b.sisenseDatamodelTableIsHidden;
        this.sisenseDatamodelTableIsMaterialized = b.sisenseDatamodelTableIsMaterialized;
        this.sisenseDatamodelTableLiveQuerySettings = b.sisenseDatamodelTableLiveQuerySettings;
        this.sisenseDatamodelTableSchedule = b.sisenseDatamodelTableSchedule;
        this.sisenseDatamodelTableType = b.sisenseDatamodelTableType;
        SortedSet<ISisenseWidget> sisenseWidgets = new TreeSet<ISisenseWidget>();
        if (b.sisenseWidgets != null) {
            sisenseWidgets.addAll(b.sisenseWidgets);
        }
        sisenseWidgets = Collections.unmodifiableSortedSet(sisenseWidgets);
        this.sisenseWidgets = sisenseWidgets;
    }

    @Generated
    public static SisenseDatamodelTableBuilder<?, ?> _internal() {
        return new SisenseDatamodelTableBuilderImpl();
    }

    @Generated
    public SisenseDatamodelTableBuilder<?, ?> toBuilder() {
        return new SisenseDatamodelTableBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ISisenseDatamodel getSisenseDatamodel() {
        return this.sisenseDatamodel;
    }

    @Override
    @Generated
    public String getSisenseDatamodelQualifiedName() {
        return this.sisenseDatamodelQualifiedName;
    }

    @Override
    @Generated
    public Long getSisenseDatamodelTableColumnCount() {
        return this.sisenseDatamodelTableColumnCount;
    }

    @Override
    @Generated
    public String getSisenseDatamodelTableExpression() {
        return this.sisenseDatamodelTableExpression;
    }

    @Override
    @Generated
    public Boolean getSisenseDatamodelTableIsHidden() {
        return this.sisenseDatamodelTableIsHidden;
    }

    @Override
    @Generated
    public Boolean getSisenseDatamodelTableIsMaterialized() {
        return this.sisenseDatamodelTableIsMaterialized;
    }

    @Override
    @Generated
    public String getSisenseDatamodelTableLiveQuerySettings() {
        return this.sisenseDatamodelTableLiveQuerySettings;
    }

    @Override
    @Generated
    public String getSisenseDatamodelTableSchedule() {
        return this.sisenseDatamodelTableSchedule;
    }

    @Override
    @Generated
    public String getSisenseDatamodelTableType() {
        return this.sisenseDatamodelTableType;
    }

    @Override
    @Generated
    public SortedSet<ISisenseWidget> getSisenseWidgets() {
        return this.sisenseWidgets;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SisenseDatamodelTable)) {
            return false;
        }
        SisenseDatamodelTable other = (SisenseDatamodelTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sisenseDatamodelTableColumnCount = this.getSisenseDatamodelTableColumnCount();
        Long other$sisenseDatamodelTableColumnCount = other.getSisenseDatamodelTableColumnCount();
        if (this$sisenseDatamodelTableColumnCount == null ? other$sisenseDatamodelTableColumnCount != null : !((Object)this$sisenseDatamodelTableColumnCount).equals(other$sisenseDatamodelTableColumnCount)) {
            return false;
        }
        Boolean this$sisenseDatamodelTableIsHidden = this.getSisenseDatamodelTableIsHidden();
        Boolean other$sisenseDatamodelTableIsHidden = other.getSisenseDatamodelTableIsHidden();
        if (this$sisenseDatamodelTableIsHidden == null ? other$sisenseDatamodelTableIsHidden != null : !((Object)this$sisenseDatamodelTableIsHidden).equals(other$sisenseDatamodelTableIsHidden)) {
            return false;
        }
        Boolean this$sisenseDatamodelTableIsMaterialized = this.getSisenseDatamodelTableIsMaterialized();
        Boolean other$sisenseDatamodelTableIsMaterialized = other.getSisenseDatamodelTableIsMaterialized();
        if (this$sisenseDatamodelTableIsMaterialized == null ? other$sisenseDatamodelTableIsMaterialized != null : !((Object)this$sisenseDatamodelTableIsMaterialized).equals(other$sisenseDatamodelTableIsMaterialized)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ISisenseDatamodel this$sisenseDatamodel = this.getSisenseDatamodel();
        ISisenseDatamodel other$sisenseDatamodel = other.getSisenseDatamodel();
        if (this$sisenseDatamodel == null ? other$sisenseDatamodel != null : !this$sisenseDatamodel.equals(other$sisenseDatamodel)) {
            return false;
        }
        String this$sisenseDatamodelQualifiedName = this.getSisenseDatamodelQualifiedName();
        String other$sisenseDatamodelQualifiedName = other.getSisenseDatamodelQualifiedName();
        if (this$sisenseDatamodelQualifiedName == null ? other$sisenseDatamodelQualifiedName != null : !this$sisenseDatamodelQualifiedName.equals(other$sisenseDatamodelQualifiedName)) {
            return false;
        }
        String this$sisenseDatamodelTableExpression = this.getSisenseDatamodelTableExpression();
        String other$sisenseDatamodelTableExpression = other.getSisenseDatamodelTableExpression();
        if (this$sisenseDatamodelTableExpression == null ? other$sisenseDatamodelTableExpression != null : !this$sisenseDatamodelTableExpression.equals(other$sisenseDatamodelTableExpression)) {
            return false;
        }
        String this$sisenseDatamodelTableLiveQuerySettings = this.getSisenseDatamodelTableLiveQuerySettings();
        String other$sisenseDatamodelTableLiveQuerySettings = other.getSisenseDatamodelTableLiveQuerySettings();
        if (this$sisenseDatamodelTableLiveQuerySettings == null ? other$sisenseDatamodelTableLiveQuerySettings != null : !this$sisenseDatamodelTableLiveQuerySettings.equals(other$sisenseDatamodelTableLiveQuerySettings)) {
            return false;
        }
        String this$sisenseDatamodelTableSchedule = this.getSisenseDatamodelTableSchedule();
        String other$sisenseDatamodelTableSchedule = other.getSisenseDatamodelTableSchedule();
        if (this$sisenseDatamodelTableSchedule == null ? other$sisenseDatamodelTableSchedule != null : !this$sisenseDatamodelTableSchedule.equals(other$sisenseDatamodelTableSchedule)) {
            return false;
        }
        String this$sisenseDatamodelTableType = this.getSisenseDatamodelTableType();
        String other$sisenseDatamodelTableType = other.getSisenseDatamodelTableType();
        if (this$sisenseDatamodelTableType == null ? other$sisenseDatamodelTableType != null : !this$sisenseDatamodelTableType.equals(other$sisenseDatamodelTableType)) {
            return false;
        }
        SortedSet<ISisenseWidget> this$sisenseWidgets = this.getSisenseWidgets();
        SortedSet<ISisenseWidget> other$sisenseWidgets = other.getSisenseWidgets();
        return !(this$sisenseWidgets == null ? other$sisenseWidgets != null : !this$sisenseWidgets.equals(other$sisenseWidgets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SisenseDatamodelTable;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sisenseDatamodelTableColumnCount = this.getSisenseDatamodelTableColumnCount();
        result = result * 59 + ($sisenseDatamodelTableColumnCount == null ? 43 : ((Object)$sisenseDatamodelTableColumnCount).hashCode());
        Boolean $sisenseDatamodelTableIsHidden = this.getSisenseDatamodelTableIsHidden();
        result = result * 59 + ($sisenseDatamodelTableIsHidden == null ? 43 : ((Object)$sisenseDatamodelTableIsHidden).hashCode());
        Boolean $sisenseDatamodelTableIsMaterialized = this.getSisenseDatamodelTableIsMaterialized();
        result = result * 59 + ($sisenseDatamodelTableIsMaterialized == null ? 43 : ((Object)$sisenseDatamodelTableIsMaterialized).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ISisenseDatamodel $sisenseDatamodel = this.getSisenseDatamodel();
        result = result * 59 + ($sisenseDatamodel == null ? 43 : $sisenseDatamodel.hashCode());
        String $sisenseDatamodelQualifiedName = this.getSisenseDatamodelQualifiedName();
        result = result * 59 + ($sisenseDatamodelQualifiedName == null ? 43 : $sisenseDatamodelQualifiedName.hashCode());
        String $sisenseDatamodelTableExpression = this.getSisenseDatamodelTableExpression();
        result = result * 59 + ($sisenseDatamodelTableExpression == null ? 43 : $sisenseDatamodelTableExpression.hashCode());
        String $sisenseDatamodelTableLiveQuerySettings = this.getSisenseDatamodelTableLiveQuerySettings();
        result = result * 59 + ($sisenseDatamodelTableLiveQuerySettings == null ? 43 : $sisenseDatamodelTableLiveQuerySettings.hashCode());
        String $sisenseDatamodelTableSchedule = this.getSisenseDatamodelTableSchedule();
        result = result * 59 + ($sisenseDatamodelTableSchedule == null ? 43 : $sisenseDatamodelTableSchedule.hashCode());
        String $sisenseDatamodelTableType = this.getSisenseDatamodelTableType();
        result = result * 59 + ($sisenseDatamodelTableType == null ? 43 : $sisenseDatamodelTableType.hashCode());
        SortedSet<ISisenseWidget> $sisenseWidgets = this.getSisenseWidgets();
        result = result * 59 + ($sisenseWidgets == null ? 43 : $sisenseWidgets.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SisenseDatamodelTable(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sisenseDatamodel=" + this.getSisenseDatamodel() + ", sisenseDatamodelQualifiedName=" + this.getSisenseDatamodelQualifiedName() + ", sisenseDatamodelTableColumnCount=" + this.getSisenseDatamodelTableColumnCount() + ", sisenseDatamodelTableExpression=" + this.getSisenseDatamodelTableExpression() + ", sisenseDatamodelTableIsHidden=" + this.getSisenseDatamodelTableIsHidden() + ", sisenseDatamodelTableIsMaterialized=" + this.getSisenseDatamodelTableIsMaterialized() + ", sisenseDatamodelTableLiveQuerySettings=" + this.getSisenseDatamodelTableLiveQuerySettings() + ", sisenseDatamodelTableSchedule=" + this.getSisenseDatamodelTableSchedule() + ", sisenseDatamodelTableType=" + this.getSisenseDatamodelTableType() + ", sisenseWidgets=" + this.getSisenseWidgets() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class SisenseDatamodelTableBuilder<C extends SisenseDatamodelTable, B extends SisenseDatamodelTableBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ISisenseDatamodel sisenseDatamodel;
        @Generated
        private String sisenseDatamodelQualifiedName;
        @Generated
        private Long sisenseDatamodelTableColumnCount;
        @Generated
        private String sisenseDatamodelTableExpression;
        @Generated
        private Boolean sisenseDatamodelTableIsHidden;
        @Generated
        private Boolean sisenseDatamodelTableIsMaterialized;
        @Generated
        private String sisenseDatamodelTableLiveQuerySettings;
        @Generated
        private String sisenseDatamodelTableSchedule;
        @Generated
        private String sisenseDatamodelTableType;
        @Generated
        private ArrayList<ISisenseWidget> sisenseWidgets;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SisenseDatamodelTableBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SisenseDatamodelTable instance, SisenseDatamodelTableBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sisenseDatamodel(instance.sisenseDatamodel);
            b.sisenseDatamodelQualifiedName(instance.sisenseDatamodelQualifiedName);
            b.sisenseDatamodelTableColumnCount(instance.sisenseDatamodelTableColumnCount);
            b.sisenseDatamodelTableExpression(instance.sisenseDatamodelTableExpression);
            b.sisenseDatamodelTableIsHidden(instance.sisenseDatamodelTableIsHidden);
            b.sisenseDatamodelTableIsMaterialized(instance.sisenseDatamodelTableIsMaterialized);
            b.sisenseDatamodelTableLiveQuerySettings(instance.sisenseDatamodelTableLiveQuerySettings);
            b.sisenseDatamodelTableSchedule(instance.sisenseDatamodelTableSchedule);
            b.sisenseDatamodelTableType(instance.sisenseDatamodelTableType);
            b.sisenseWidgets(instance.sisenseWidgets == null ? Collections.emptySortedSet() : instance.sisenseWidgets);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodel(ISisenseDatamodel sisenseDatamodel) {
            this.sisenseDatamodel = sisenseDatamodel;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelQualifiedName(String sisenseDatamodelQualifiedName) {
            this.sisenseDatamodelQualifiedName = sisenseDatamodelQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTableColumnCount(Long sisenseDatamodelTableColumnCount) {
            this.sisenseDatamodelTableColumnCount = sisenseDatamodelTableColumnCount;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTableExpression(String sisenseDatamodelTableExpression) {
            this.sisenseDatamodelTableExpression = sisenseDatamodelTableExpression;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTableIsHidden(Boolean sisenseDatamodelTableIsHidden) {
            this.sisenseDatamodelTableIsHidden = sisenseDatamodelTableIsHidden;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTableIsMaterialized(Boolean sisenseDatamodelTableIsMaterialized) {
            this.sisenseDatamodelTableIsMaterialized = sisenseDatamodelTableIsMaterialized;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTableLiveQuerySettings(String sisenseDatamodelTableLiveQuerySettings) {
            this.sisenseDatamodelTableLiveQuerySettings = sisenseDatamodelTableLiveQuerySettings;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTableSchedule(String sisenseDatamodelTableSchedule) {
            this.sisenseDatamodelTableSchedule = sisenseDatamodelTableSchedule;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodelTableType(String sisenseDatamodelTableType) {
            this.sisenseDatamodelTableType = sisenseDatamodelTableType;
            return (B)this.self();
        }

        @Generated
        public B sisenseWidget(ISisenseWidget sisenseWidget) {
            if (this.sisenseWidgets == null) {
                this.sisenseWidgets = new ArrayList();
            }
            this.sisenseWidgets.add(sisenseWidget);
            return (B)this.self();
        }

        @Generated
        public B sisenseWidgets(Collection<? extends ISisenseWidget> sisenseWidgets) {
            if (sisenseWidgets == null) {
                throw new NullPointerException("sisenseWidgets cannot be null");
            }
            if (this.sisenseWidgets == null) {
                this.sisenseWidgets = new ArrayList();
            }
            this.sisenseWidgets.addAll(sisenseWidgets);
            return (B)this.self();
        }

        @Generated
        public B clearSisenseWidgets() {
            if (this.sisenseWidgets != null) {
                this.sisenseWidgets.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SisenseDatamodelTable.SisenseDatamodelTableBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sisenseDatamodel=" + this.sisenseDatamodel + ", sisenseDatamodelQualifiedName=" + this.sisenseDatamodelQualifiedName + ", sisenseDatamodelTableColumnCount=" + this.sisenseDatamodelTableColumnCount + ", sisenseDatamodelTableExpression=" + this.sisenseDatamodelTableExpression + ", sisenseDatamodelTableIsHidden=" + this.sisenseDatamodelTableIsHidden + ", sisenseDatamodelTableIsMaterialized=" + this.sisenseDatamodelTableIsMaterialized + ", sisenseDatamodelTableLiveQuerySettings=" + this.sisenseDatamodelTableLiveQuerySettings + ", sisenseDatamodelTableSchedule=" + this.sisenseDatamodelTableSchedule + ", sisenseDatamodelTableType=" + this.sisenseDatamodelTableType + ", sisenseWidgets=" + this.sisenseWidgets + ")";
        }
    }

    @Generated
    private static final class SisenseDatamodelTableBuilderImpl
    extends SisenseDatamodelTableBuilder<SisenseDatamodelTable, SisenseDatamodelTableBuilderImpl> {
        @Generated
        private SisenseDatamodelTableBuilderImpl() {
        }

        @Override
        @Generated
        protected SisenseDatamodelTableBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SisenseDatamodelTable build() {
            return new SisenseDatamodelTable(this);
        }
    }
}

