/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.ISuperset;
import com.atlan.model.assets.ISupersetChart;
import com.atlan.model.assets.ISupersetDashboard;
import com.atlan.model.assets.SupersetDashboard;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupersetChart
extends Asset
implements ISupersetChart,
ISuperset,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SupersetChart.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SupersetChart";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String supersetChartDescriptionMarkdown;
    @Attribute
    Map<String, String> supersetChartFormData;
    @Attribute
    ISupersetDashboard supersetDashboard;
    @Attribute
    Long supersetDashboardId;
    @Attribute
    String supersetDashboardQualifiedName;

    @Override
    public SupersetChart trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SupersetChart.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SupersetChart.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SupersetChart.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SupersetChart.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SupersetChart.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SupersetChart.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SupersetChart refByGuid(String guid) {
        return SupersetChart.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SupersetChart refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SupersetChartBuilder)((SupersetChartBuilder)SupersetChart._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SupersetChart refByQualifiedName(String qualifiedName) {
        return SupersetChart.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SupersetChart refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SupersetChartBuilder)((SupersetChartBuilder)SupersetChart._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SupersetChart get(String id) throws AtlanException {
        return SupersetChart.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SupersetChart get(AtlanClient client, String id) throws AtlanException {
        return SupersetChart.get(client, id, true);
    }

    @JsonIgnore
    public static SupersetChart get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SupersetChart) {
                return (SupersetChart)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SupersetChart) {
            return (SupersetChart)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SupersetChart.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SupersetChartBuilder<?, ?> creator(String name, SupersetDashboard dashboard) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", dashboard.getQualifiedName());
        map.put("connectionQualifiedName", dashboard.getConnectionQualifiedName());
        SupersetChart.validateRelationship("SupersetDashboard", map);
        return SupersetChart.creator(name, dashboard.getConnectionQualifiedName(), dashboard.getQualifiedName()).supersetDashboard(dashboard.trimToReference());
    }

    public static SupersetChartBuilder<?, ?> creator(String name, String dashboardQualifiedName) {
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(dashboardQualifiedName);
        return SupersetChart.creator(name, connectionQualifiedName, dashboardQualifiedName);
    }

    public static SupersetChartBuilder<?, ?> creator(String name, String connectionQualifiedName, String dashboardQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return (SupersetChartBuilder)((Asset.AssetBuilder)((SupersetChartBuilder)((SupersetChartBuilder)((SupersetChartBuilder)((SupersetChartBuilder)((SupersetChartBuilder)SupersetChart._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(dashboardQualifiedName + "/" + name)).connectorType(connectorType)).supersetDashboardQualifiedName(dashboardQualifiedName)).supersetDashboard(SupersetDashboard.refByQualifiedName(dashboardQualifiedName))).connectionQualifiedName(connectionQualifiedName);
    }

    public static SupersetChartBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SupersetChartBuilder)((SupersetChartBuilder)((SupersetChartBuilder)SupersetChart._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SupersetChartBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        SupersetChart.validateRequired(TYPE_NAME, map);
        return SupersetChart.updater(this.getQualifiedName(), this.getName());
    }

    public static SupersetChart removeDescription(String qualifiedName, String name) throws AtlanException {
        return SupersetChart.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SupersetChart removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetChart)Asset.removeDescription(client, SupersetChart.updater(qualifiedName, name));
    }

    public static SupersetChart removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SupersetChart.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SupersetChart removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetChart)Asset.removeUserDescription(client, SupersetChart.updater(qualifiedName, name));
    }

    public static SupersetChart removeOwners(String qualifiedName, String name) throws AtlanException {
        return SupersetChart.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SupersetChart removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetChart)Asset.removeOwners(client, SupersetChart.updater(qualifiedName, name));
    }

    public static SupersetChart updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SupersetChart.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SupersetChart updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SupersetChart)Asset.updateCertificate(client, SupersetChart._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SupersetChart removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SupersetChart.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SupersetChart removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetChart)Asset.removeCertificate(client, SupersetChart.updater(qualifiedName, name));
    }

    public static SupersetChart updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SupersetChart.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SupersetChart updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SupersetChart)Asset.updateAnnouncement(client, SupersetChart._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SupersetChart removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SupersetChart.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SupersetChart removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SupersetChart)Asset.removeAnnouncement(client, SupersetChart.updater(qualifiedName, name));
    }

    public static SupersetChart replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SupersetChart.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SupersetChart replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SupersetChart)Asset.replaceTerms(client, SupersetChart.updater(qualifiedName, name), terms);
    }

    public static SupersetChart appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SupersetChart.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SupersetChart appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SupersetChart)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SupersetChart removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SupersetChart.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SupersetChart removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SupersetChart)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SupersetChart appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SupersetChart.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SupersetChart appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SupersetChart)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SupersetChart appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SupersetChart.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SupersetChart appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SupersetChart)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SupersetChart.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SupersetChart(SupersetChartBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> supersetChartFormData;
        this.typeName = b.typeName$set ? b.typeName$value : SupersetChart.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.supersetChartDescriptionMarkdown = b.supersetChartDescriptionMarkdown;
        switch (b.supersetChartFormData$key == null ? 0 : b.supersetChartFormData$key.size()) {
            case 0: {
                supersetChartFormData = Collections.emptyMap();
                break;
            }
            case 1: {
                supersetChartFormData = Collections.singletonMap(b.supersetChartFormData$key.get(0), b.supersetChartFormData$value.get(0));
                break;
            }
            default: {
                supersetChartFormData = new LinkedHashMap(b.supersetChartFormData$key.size() < 0x40000000 ? 1 + b.supersetChartFormData$key.size() + (b.supersetChartFormData$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.supersetChartFormData$key.size(); ++$i) {
                    supersetChartFormData.put(b.supersetChartFormData$key.get($i), b.supersetChartFormData$value.get($i));
                }
                supersetChartFormData = Collections.unmodifiableMap(supersetChartFormData);
            }
        }
        this.supersetChartFormData = supersetChartFormData;
        this.supersetDashboard = b.supersetDashboard;
        this.supersetDashboardId = b.supersetDashboardId;
        this.supersetDashboardQualifiedName = b.supersetDashboardQualifiedName;
    }

    @Generated
    public static SupersetChartBuilder<?, ?> _internal() {
        return new SupersetChartBuilderImpl();
    }

    @Generated
    public SupersetChartBuilder<?, ?> toBuilder() {
        return new SupersetChartBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getSupersetChartDescriptionMarkdown() {
        return this.supersetChartDescriptionMarkdown;
    }

    @Override
    @Generated
    public Map<String, String> getSupersetChartFormData() {
        return this.supersetChartFormData;
    }

    @Override
    @Generated
    public ISupersetDashboard getSupersetDashboard() {
        return this.supersetDashboard;
    }

    @Override
    @Generated
    public Long getSupersetDashboardId() {
        return this.supersetDashboardId;
    }

    @Override
    @Generated
    public String getSupersetDashboardQualifiedName() {
        return this.supersetDashboardQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SupersetChart)) {
            return false;
        }
        SupersetChart other = (SupersetChart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$supersetDashboardId = this.getSupersetDashboardId();
        Long other$supersetDashboardId = other.getSupersetDashboardId();
        if (this$supersetDashboardId == null ? other$supersetDashboardId != null : !((Object)this$supersetDashboardId).equals(other$supersetDashboardId)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$supersetChartDescriptionMarkdown = this.getSupersetChartDescriptionMarkdown();
        String other$supersetChartDescriptionMarkdown = other.getSupersetChartDescriptionMarkdown();
        if (this$supersetChartDescriptionMarkdown == null ? other$supersetChartDescriptionMarkdown != null : !this$supersetChartDescriptionMarkdown.equals(other$supersetChartDescriptionMarkdown)) {
            return false;
        }
        Map<String, String> this$supersetChartFormData = this.getSupersetChartFormData();
        Map<String, String> other$supersetChartFormData = other.getSupersetChartFormData();
        if (this$supersetChartFormData == null ? other$supersetChartFormData != null : !((Object)this$supersetChartFormData).equals(other$supersetChartFormData)) {
            return false;
        }
        ISupersetDashboard this$supersetDashboard = this.getSupersetDashboard();
        ISupersetDashboard other$supersetDashboard = other.getSupersetDashboard();
        if (this$supersetDashboard == null ? other$supersetDashboard != null : !this$supersetDashboard.equals(other$supersetDashboard)) {
            return false;
        }
        String this$supersetDashboardQualifiedName = this.getSupersetDashboardQualifiedName();
        String other$supersetDashboardQualifiedName = other.getSupersetDashboardQualifiedName();
        return !(this$supersetDashboardQualifiedName == null ? other$supersetDashboardQualifiedName != null : !this$supersetDashboardQualifiedName.equals(other$supersetDashboardQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SupersetChart;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $supersetDashboardId = this.getSupersetDashboardId();
        result = result * 59 + ($supersetDashboardId == null ? 43 : ((Object)$supersetDashboardId).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $supersetChartDescriptionMarkdown = this.getSupersetChartDescriptionMarkdown();
        result = result * 59 + ($supersetChartDescriptionMarkdown == null ? 43 : $supersetChartDescriptionMarkdown.hashCode());
        Map<String, String> $supersetChartFormData = this.getSupersetChartFormData();
        result = result * 59 + ($supersetChartFormData == null ? 43 : ((Object)$supersetChartFormData).hashCode());
        ISupersetDashboard $supersetDashboard = this.getSupersetDashboard();
        result = result * 59 + ($supersetDashboard == null ? 43 : $supersetDashboard.hashCode());
        String $supersetDashboardQualifiedName = this.getSupersetDashboardQualifiedName();
        result = result * 59 + ($supersetDashboardQualifiedName == null ? 43 : $supersetDashboardQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SupersetChart(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", supersetChartDescriptionMarkdown=" + this.getSupersetChartDescriptionMarkdown() + ", supersetChartFormData=" + this.getSupersetChartFormData() + ", supersetDashboard=" + this.getSupersetDashboard() + ", supersetDashboardId=" + this.getSupersetDashboardId() + ", supersetDashboardQualifiedName=" + this.getSupersetDashboardQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class SupersetChartBuilder<C extends SupersetChart, B extends SupersetChartBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String supersetChartDescriptionMarkdown;
        @Generated
        private ArrayList<String> supersetChartFormData$key;
        @Generated
        private ArrayList<String> supersetChartFormData$value;
        @Generated
        private ISupersetDashboard supersetDashboard;
        @Generated
        private Long supersetDashboardId;
        @Generated
        private String supersetDashboardQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SupersetChartBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SupersetChart instance, SupersetChartBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.supersetChartDescriptionMarkdown(instance.supersetChartDescriptionMarkdown);
            b.supersetChartFormData(instance.supersetChartFormData == null ? Collections.emptyMap() : instance.supersetChartFormData);
            b.supersetDashboard(instance.supersetDashboard);
            b.supersetDashboardId(instance.supersetDashboardId);
            b.supersetDashboardQualifiedName(instance.supersetDashboardQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B supersetChartDescriptionMarkdown(String supersetChartDescriptionMarkdown) {
            this.supersetChartDescriptionMarkdown = supersetChartDescriptionMarkdown;
            return (B)this.self();
        }

        @Generated
        public B putSupersetChartFormData(String putSupersetChartFormDataKey, String putSupersetChartFormDataValue) {
            if (this.supersetChartFormData$key == null) {
                this.supersetChartFormData$key = new ArrayList();
                this.supersetChartFormData$value = new ArrayList();
            }
            this.supersetChartFormData$key.add(putSupersetChartFormDataKey);
            this.supersetChartFormData$value.add(putSupersetChartFormDataValue);
            return (B)this.self();
        }

        @Generated
        public B supersetChartFormData(Map<? extends String, ? extends String> supersetChartFormData) {
            if (supersetChartFormData == null) {
                throw new NullPointerException("supersetChartFormData cannot be null");
            }
            if (this.supersetChartFormData$key == null) {
                this.supersetChartFormData$key = new ArrayList();
                this.supersetChartFormData$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : supersetChartFormData.entrySet()) {
                this.supersetChartFormData$key.add($lombokEntry.getKey());
                this.supersetChartFormData$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearSupersetChartFormData() {
            if (this.supersetChartFormData$key != null) {
                this.supersetChartFormData$key.clear();
                this.supersetChartFormData$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B supersetDashboard(ISupersetDashboard supersetDashboard) {
            this.supersetDashboard = supersetDashboard;
            return (B)this.self();
        }

        @Generated
        public B supersetDashboardId(Long supersetDashboardId) {
            this.supersetDashboardId = supersetDashboardId;
            return (B)this.self();
        }

        @Generated
        public B supersetDashboardQualifiedName(String supersetDashboardQualifiedName) {
            this.supersetDashboardQualifiedName = supersetDashboardQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SupersetChart.SupersetChartBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", supersetChartDescriptionMarkdown=" + this.supersetChartDescriptionMarkdown + ", supersetChartFormData$key=" + this.supersetChartFormData$key + ", supersetChartFormData$value=" + this.supersetChartFormData$value + ", supersetDashboard=" + this.supersetDashboard + ", supersetDashboardId=" + this.supersetDashboardId + ", supersetDashboardQualifiedName=" + this.supersetDashboardQualifiedName + ")";
        }
    }

    @Generated
    private static final class SupersetChartBuilderImpl
    extends SupersetChartBuilder<SupersetChart, SupersetChartBuilderImpl> {
        @Generated
        private SupersetChartBuilderImpl() {
        }

        @Override
        @Generated
        protected SupersetChartBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SupersetChart build() {
            return new SupersetChart(this);
        }
    }
}

