/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IApplicationContainer;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.ITableau;
import com.atlan.model.assets.ITableauDatasource;
import com.atlan.model.assets.ITableauFlow;
import com.atlan.model.assets.ITableauProject;
import com.atlan.model.assets.ITableauSite;
import com.atlan.model.assets.ITableauWorkbook;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableauProject
extends Asset
implements ITableauProject,
ITableau,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableauProject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauProject";
    String typeName;
    @Attribute
    IApplicationContainer applicationContainer;
    @Attribute
    String assetApplicationQualifiedName;
    @Attribute
    SortedSet<ITableauProject> childProjects;
    @Attribute
    SortedSet<ITableauDatasource> datasources;
    @Attribute
    SortedSet<ITableauFlow> flows;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Boolean isTopLevelProject;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    ITableauProject parentProject;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    ITableauSite site;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    SortedSet<ITableauWorkbook> workbooks;

    @Override
    public TableauProject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return TableauProject.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return TableauProject.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return TableauProject.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return TableauProject.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return TableauProject.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return TableauProject.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static TableauProject refByGuid(String guid) {
        return TableauProject.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static TableauProject refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((TableauProjectBuilder)((TableauProjectBuilder)TableauProject._internal().guid(guid)).semantic(semantic)).build();
    }

    public static TableauProject refByQualifiedName(String qualifiedName) {
        return TableauProject.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static TableauProject refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((TableauProjectBuilder)((TableauProjectBuilder)TableauProject._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static TableauProject get(String id) throws AtlanException {
        return TableauProject.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static TableauProject get(AtlanClient client, String id) throws AtlanException {
        return TableauProject.get(client, id, true);
    }

    @JsonIgnore
    public static TableauProject get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof TableauProject) {
                return (TableauProject)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof TableauProject) {
            return (TableauProject)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return TableauProject.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static TableauProjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauProjectBuilder)((TableauProjectBuilder)((TableauProjectBuilder)TableauProject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public TableauProjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        TableauProject.validateRequired(TYPE_NAME, map);
        return TableauProject.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauProject removeDescription(String qualifiedName, String name) throws AtlanException {
        return TableauProject.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauProject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauProject)Asset.removeDescription(client, TableauProject.updater(qualifiedName, name));
    }

    public static TableauProject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return TableauProject.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauProject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauProject)Asset.removeUserDescription(client, TableauProject.updater(qualifiedName, name));
    }

    public static TableauProject removeOwners(String qualifiedName, String name) throws AtlanException {
        return TableauProject.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauProject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauProject)Asset.removeOwners(client, TableauProject.updater(qualifiedName, name));
    }

    public static TableauProject updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return TableauProject.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static TableauProject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TableauProject)Asset.updateCertificate(client, TableauProject._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauProject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return TableauProject.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauProject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauProject)Asset.removeCertificate(client, TableauProject.updater(qualifiedName, name));
    }

    public static TableauProject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return TableauProject.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static TableauProject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauProject)Asset.updateAnnouncement(client, TableauProject._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauProject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return TableauProject.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TableauProject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauProject)Asset.removeAnnouncement(client, TableauProject.updater(qualifiedName, name));
    }

    public static TableauProject replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return TableauProject.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static TableauProject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauProject)Asset.replaceTerms(client, TableauProject.updater(qualifiedName, name), terms);
    }

    public static TableauProject appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return TableauProject.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static TableauProject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauProject)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static TableauProject removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return TableauProject.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static TableauProject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauProject)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static TableauProject appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return TableauProject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static TableauProject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TableauProject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static TableauProject appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return TableauProject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static TableauProject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TableauProject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        TableauProject.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauProject(TableauProjectBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : TableauProject.$default$typeName();
        this.applicationContainer = b.applicationContainer;
        this.assetApplicationQualifiedName = b.assetApplicationQualifiedName;
        SortedSet<ITableauProject> childProjects = new TreeSet<ITableauProject>();
        if (b.childProjects != null) {
            childProjects.addAll(b.childProjects);
        }
        childProjects = Collections.unmodifiableSortedSet(childProjects);
        this.childProjects = childProjects;
        SortedSet<ITableauDatasource> datasources = new TreeSet<ITableauDatasource>();
        if (b.datasources != null) {
            datasources.addAll(b.datasources);
        }
        datasources = Collections.unmodifiableSortedSet(datasources);
        this.datasources = datasources;
        SortedSet<ITableauFlow> flows = new TreeSet<ITableauFlow>();
        if (b.flows != null) {
            flows.addAll(b.flows);
        }
        flows = Collections.unmodifiableSortedSet(flows);
        this.flows = flows;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isTopLevelProject = b.isTopLevelProject;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.parentProject = b.parentProject;
        this.projectHierarchy = switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.projectHierarchy.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
        };
        this.site = b.site;
        this.siteQualifiedName = b.siteQualifiedName;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        SortedSet<ITableauWorkbook> workbooks = new TreeSet<ITableauWorkbook>();
        if (b.workbooks != null) {
            workbooks.addAll(b.workbooks);
        }
        workbooks = Collections.unmodifiableSortedSet(workbooks);
        this.workbooks = workbooks;
    }

    @Generated
    public static TableauProjectBuilder<?, ?> _internal() {
        return new TableauProjectBuilderImpl();
    }

    @Generated
    public TableauProjectBuilder<?, ?> toBuilder() {
        return new TableauProjectBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IApplicationContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    @Override
    @Generated
    public String getAssetApplicationQualifiedName() {
        return this.assetApplicationQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ITableauProject> getChildProjects() {
        return this.childProjects;
    }

    @Override
    @Generated
    public SortedSet<ITableauDatasource> getDatasources() {
        return this.datasources;
    }

    @Override
    @Generated
    public SortedSet<ITableauFlow> getFlows() {
        return this.flows;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Boolean getIsTopLevelProject() {
        return this.isTopLevelProject;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ITableauProject getParentProject() {
        return this.parentProject;
    }

    @Override
    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Override
    @Generated
    public ITableauSite getSite() {
        return this.site;
    }

    @Override
    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Override
    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ITableauWorkbook> getWorkbooks() {
        return this.workbooks;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauProject)) {
            return false;
        }
        TableauProject other = (TableauProject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isTopLevelProject = this.getIsTopLevelProject();
        Boolean other$isTopLevelProject = other.getIsTopLevelProject();
        if (this$isTopLevelProject == null ? other$isTopLevelProject != null : !((Object)this$isTopLevelProject).equals(other$isTopLevelProject)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IApplicationContainer this$applicationContainer = this.getApplicationContainer();
        IApplicationContainer other$applicationContainer = other.getApplicationContainer();
        if (this$applicationContainer == null ? other$applicationContainer != null : !this$applicationContainer.equals(other$applicationContainer)) {
            return false;
        }
        String this$assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        String other$assetApplicationQualifiedName = other.getAssetApplicationQualifiedName();
        if (this$assetApplicationQualifiedName == null ? other$assetApplicationQualifiedName != null : !this$assetApplicationQualifiedName.equals(other$assetApplicationQualifiedName)) {
            return false;
        }
        SortedSet<ITableauProject> this$childProjects = this.getChildProjects();
        SortedSet<ITableauProject> other$childProjects = other.getChildProjects();
        if (this$childProjects == null ? other$childProjects != null : !this$childProjects.equals(other$childProjects)) {
            return false;
        }
        SortedSet<ITableauDatasource> this$datasources = this.getDatasources();
        SortedSet<ITableauDatasource> other$datasources = other.getDatasources();
        if (this$datasources == null ? other$datasources != null : !this$datasources.equals(other$datasources)) {
            return false;
        }
        SortedSet<ITableauFlow> this$flows = this.getFlows();
        SortedSet<ITableauFlow> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !this$flows.equals(other$flows)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ITableauProject this$parentProject = this.getParentProject();
        ITableauProject other$parentProject = other.getParentProject();
        if (this$parentProject == null ? other$parentProject != null : !this$parentProject.equals(other$parentProject)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        ITableauSite this$site = this.getSite();
        ITableauSite other$site = other.getSite();
        if (this$site == null ? other$site != null : !this$site.equals(other$site)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        SortedSet<ITableauWorkbook> this$workbooks = this.getWorkbooks();
        SortedSet<ITableauWorkbook> other$workbooks = other.getWorkbooks();
        return !(this$workbooks == null ? other$workbooks != null : !this$workbooks.equals(other$workbooks));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauProject;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isTopLevelProject = this.getIsTopLevelProject();
        result = result * 59 + ($isTopLevelProject == null ? 43 : ((Object)$isTopLevelProject).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IApplicationContainer $applicationContainer = this.getApplicationContainer();
        result = result * 59 + ($applicationContainer == null ? 43 : $applicationContainer.hashCode());
        String $assetApplicationQualifiedName = this.getAssetApplicationQualifiedName();
        result = result * 59 + ($assetApplicationQualifiedName == null ? 43 : $assetApplicationQualifiedName.hashCode());
        SortedSet<ITableauProject> $childProjects = this.getChildProjects();
        result = result * 59 + ($childProjects == null ? 43 : $childProjects.hashCode());
        SortedSet<ITableauDatasource> $datasources = this.getDatasources();
        result = result * 59 + ($datasources == null ? 43 : $datasources.hashCode());
        SortedSet<ITableauFlow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : $flows.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ITableauProject $parentProject = this.getParentProject();
        result = result * 59 + ($parentProject == null ? 43 : $parentProject.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        ITableauSite $site = this.getSite();
        result = result * 59 + ($site == null ? 43 : $site.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        SortedSet<ITableauWorkbook> $workbooks = this.getWorkbooks();
        result = result * 59 + ($workbooks == null ? 43 : $workbooks.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TableauProject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", applicationContainer=" + this.getApplicationContainer() + ", assetApplicationQualifiedName=" + this.getAssetApplicationQualifiedName() + ", childProjects=" + this.getChildProjects() + ", datasources=" + this.getDatasources() + ", flows=" + this.getFlows() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isTopLevelProject=" + this.getIsTopLevelProject() + ", modelImplementedEntities=" + this.getModelImplementedEntities() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", parentProject=" + this.getParentProject() + ", projectHierarchy=" + this.getProjectHierarchy() + ", site=" + this.getSite() + ", siteQualifiedName=" + this.getSiteQualifiedName() + ", topLevelProjectQualifiedName=" + this.getTopLevelProjectQualifiedName() + ", workbooks=" + this.getWorkbooks() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class TableauProjectBuilder<C extends TableauProject, B extends TableauProjectBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IApplicationContainer applicationContainer;
        @Generated
        private String assetApplicationQualifiedName;
        @Generated
        private ArrayList<ITableauProject> childProjects;
        @Generated
        private ArrayList<ITableauDatasource> datasources;
        @Generated
        private ArrayList<ITableauFlow> flows;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Boolean isTopLevelProject;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ITableauProject parentProject;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private ITableauSite site;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private ArrayList<ITableauWorkbook> workbooks;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauProjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauProject instance, TableauProjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.applicationContainer(instance.applicationContainer);
            b.assetApplicationQualifiedName(instance.assetApplicationQualifiedName);
            b.childProjects(instance.childProjects == null ? Collections.emptySortedSet() : instance.childProjects);
            b.datasources(instance.datasources == null ? Collections.emptySortedSet() : instance.datasources);
            b.flows(instance.flows == null ? Collections.emptySortedSet() : instance.flows);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.isTopLevelProject(instance.isTopLevelProject);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.parentProject(instance.parentProject);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.site(instance.site);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.workbooks(instance.workbooks == null ? Collections.emptySortedSet() : instance.workbooks);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B applicationContainer(IApplicationContainer applicationContainer) {
            this.applicationContainer = applicationContainer;
            return (B)this.self();
        }

        @Generated
        public B assetApplicationQualifiedName(String assetApplicationQualifiedName) {
            this.assetApplicationQualifiedName = assetApplicationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B childProject(ITableauProject childProject) {
            if (this.childProjects == null) {
                this.childProjects = new ArrayList();
            }
            this.childProjects.add(childProject);
            return (B)this.self();
        }

        @Generated
        public B childProjects(Collection<? extends ITableauProject> childProjects) {
            if (childProjects == null) {
                throw new NullPointerException("childProjects cannot be null");
            }
            if (this.childProjects == null) {
                this.childProjects = new ArrayList();
            }
            this.childProjects.addAll(childProjects);
            return (B)this.self();
        }

        @Generated
        public B clearChildProjects() {
            if (this.childProjects != null) {
                this.childProjects.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B datasource(ITableauDatasource datasource) {
            if (this.datasources == null) {
                this.datasources = new ArrayList();
            }
            this.datasources.add(datasource);
            return (B)this.self();
        }

        @Generated
        public B datasources(Collection<? extends ITableauDatasource> datasources) {
            if (datasources == null) {
                throw new NullPointerException("datasources cannot be null");
            }
            if (this.datasources == null) {
                this.datasources = new ArrayList();
            }
            this.datasources.addAll(datasources);
            return (B)this.self();
        }

        @Generated
        public B clearDatasources() {
            if (this.datasources != null) {
                this.datasources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B flow(ITableauFlow flow) {
            if (this.flows == null) {
                this.flows = new ArrayList();
            }
            this.flows.add(flow);
            return (B)this.self();
        }

        @Generated
        public B flows(Collection<? extends ITableauFlow> flows) {
            if (flows == null) {
                throw new NullPointerException("flows cannot be null");
            }
            if (this.flows == null) {
                this.flows = new ArrayList();
            }
            this.flows.addAll(flows);
            return (B)this.self();
        }

        @Generated
        public B clearFlows() {
            if (this.flows != null) {
                this.flows.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isTopLevelProject(Boolean isTopLevelProject) {
            this.isTopLevelProject = isTopLevelProject;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B parentProject(ITableauProject parentProject) {
            this.parentProject = parentProject;
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B site(ITableauSite site) {
            this.site = site;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B workbook(ITableauWorkbook workbook) {
            if (this.workbooks == null) {
                this.workbooks = new ArrayList();
            }
            this.workbooks.add(workbook);
            return (B)this.self();
        }

        @Generated
        public B workbooks(Collection<? extends ITableauWorkbook> workbooks) {
            if (workbooks == null) {
                throw new NullPointerException("workbooks cannot be null");
            }
            if (this.workbooks == null) {
                this.workbooks = new ArrayList();
            }
            this.workbooks.addAll(workbooks);
            return (B)this.self();
        }

        @Generated
        public B clearWorkbooks() {
            if (this.workbooks != null) {
                this.workbooks.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TableauProject.TableauProjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", applicationContainer=" + this.applicationContainer + ", assetApplicationQualifiedName=" + this.assetApplicationQualifiedName + ", childProjects=" + this.childProjects + ", datasources=" + this.datasources + ", flows=" + this.flows + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isTopLevelProject=" + this.isTopLevelProject + ", modelImplementedEntities=" + this.modelImplementedEntities + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", parentProject=" + this.parentProject + ", projectHierarchy=" + this.projectHierarchy + ", site=" + this.site + ", siteQualifiedName=" + this.siteQualifiedName + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", workbooks=" + this.workbooks + ")";
        }
    }

    @Generated
    private static final class TableauProjectBuilderImpl
    extends TableauProjectBuilder<TableauProject, TableauProjectBuilderImpl> {
        @Generated
        private TableauProjectBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauProjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauProject build() {
            return new TableauProject(this);
        }
    }
}

