/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ITagAttachment;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagAttachment
extends Asset
implements ITagAttachment,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TagAttachment.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TagAttachment";
    String typeName;
    @Attribute
    String tagAttachmentStringValue;
    @Attribute
    String tagQualifiedName;

    @Override
    public TagAttachment trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return TagAttachment.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return TagAttachment.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return TagAttachment.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return TagAttachment.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return TagAttachment.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return TagAttachment.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static TagAttachment refByGuid(String guid) {
        return TagAttachment.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static TagAttachment refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((TagAttachmentBuilder)((TagAttachmentBuilder)TagAttachment._internal().guid(guid)).semantic(semantic)).build();
    }

    public static TagAttachment refByQualifiedName(String qualifiedName) {
        return TagAttachment.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static TagAttachment refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((TagAttachmentBuilder)((TagAttachmentBuilder)TagAttachment._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static TagAttachment get(String id) throws AtlanException {
        return TagAttachment.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static TagAttachment get(AtlanClient client, String id) throws AtlanException {
        return TagAttachment.get(client, id, true);
    }

    @JsonIgnore
    public static TagAttachment get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof TagAttachment) {
                return (TagAttachment)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof TagAttachment) {
            return (TagAttachment)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return TagAttachment.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static TagAttachmentBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TagAttachmentBuilder)((TagAttachmentBuilder)((TagAttachmentBuilder)TagAttachment._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public TagAttachmentBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        TagAttachment.validateRequired(TYPE_NAME, map);
        return TagAttachment.updater(this.getQualifiedName(), this.getName());
    }

    public static TagAttachment removeDescription(String qualifiedName, String name) throws AtlanException {
        return TagAttachment.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TagAttachment removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TagAttachment)Asset.removeDescription(client, TagAttachment.updater(qualifiedName, name));
    }

    public static TagAttachment removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return TagAttachment.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TagAttachment removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TagAttachment)Asset.removeUserDescription(client, TagAttachment.updater(qualifiedName, name));
    }

    public static TagAttachment removeOwners(String qualifiedName, String name) throws AtlanException {
        return TagAttachment.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TagAttachment removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TagAttachment)Asset.removeOwners(client, TagAttachment.updater(qualifiedName, name));
    }

    public static TagAttachment updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return TagAttachment.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static TagAttachment updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TagAttachment)Asset.updateCertificate(client, TagAttachment._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TagAttachment removeCertificate(String qualifiedName, String name) throws AtlanException {
        return TagAttachment.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TagAttachment removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TagAttachment)Asset.removeCertificate(client, TagAttachment.updater(qualifiedName, name));
    }

    public static TagAttachment updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return TagAttachment.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static TagAttachment updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TagAttachment)Asset.updateAnnouncement(client, TagAttachment._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TagAttachment removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return TagAttachment.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static TagAttachment removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TagAttachment)Asset.removeAnnouncement(client, TagAttachment.updater(qualifiedName, name));
    }

    public static TagAttachment replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return TagAttachment.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static TagAttachment replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TagAttachment)Asset.replaceTerms(client, TagAttachment.updater(qualifiedName, name), terms);
    }

    public static TagAttachment appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return TagAttachment.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static TagAttachment appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TagAttachment)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static TagAttachment removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return TagAttachment.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static TagAttachment removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TagAttachment)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static TagAttachment appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return TagAttachment.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static TagAttachment appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TagAttachment)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static TagAttachment appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return TagAttachment.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static TagAttachment appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TagAttachment)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        TagAttachment.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TagAttachment(TagAttachmentBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : TagAttachment.$default$typeName();
        this.tagAttachmentStringValue = b.tagAttachmentStringValue;
        this.tagQualifiedName = b.tagQualifiedName;
    }

    @Generated
    public static TagAttachmentBuilder<?, ?> _internal() {
        return new TagAttachmentBuilderImpl();
    }

    @Generated
    public TagAttachmentBuilder<?, ?> toBuilder() {
        return new TagAttachmentBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getTagAttachmentStringValue() {
        return this.tagAttachmentStringValue;
    }

    @Override
    @Generated
    public String getTagQualifiedName() {
        return this.tagQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagAttachment)) {
            return false;
        }
        TagAttachment other = (TagAttachment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$tagAttachmentStringValue = this.getTagAttachmentStringValue();
        String other$tagAttachmentStringValue = other.getTagAttachmentStringValue();
        if (this$tagAttachmentStringValue == null ? other$tagAttachmentStringValue != null : !this$tagAttachmentStringValue.equals(other$tagAttachmentStringValue)) {
            return false;
        }
        String this$tagQualifiedName = this.getTagQualifiedName();
        String other$tagQualifiedName = other.getTagQualifiedName();
        return !(this$tagQualifiedName == null ? other$tagQualifiedName != null : !this$tagQualifiedName.equals(other$tagQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TagAttachment;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $tagAttachmentStringValue = this.getTagAttachmentStringValue();
        result = result * 59 + ($tagAttachmentStringValue == null ? 43 : $tagAttachmentStringValue.hashCode());
        String $tagQualifiedName = this.getTagQualifiedName();
        result = result * 59 + ($tagQualifiedName == null ? 43 : $tagQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TagAttachment(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", tagAttachmentStringValue=" + this.getTagAttachmentStringValue() + ", tagQualifiedName=" + this.getTagQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class TagAttachmentBuilder<C extends TagAttachment, B extends TagAttachmentBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String tagAttachmentStringValue;
        @Generated
        private String tagQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TagAttachmentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TagAttachment instance, TagAttachmentBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.tagAttachmentStringValue(instance.tagAttachmentStringValue);
            b.tagQualifiedName(instance.tagQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B tagAttachmentStringValue(String tagAttachmentStringValue) {
            this.tagAttachmentStringValue = tagAttachmentStringValue;
            return (B)this.self();
        }

        @Generated
        public B tagQualifiedName(String tagQualifiedName) {
            this.tagQualifiedName = tagQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TagAttachment.TagAttachmentBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", tagAttachmentStringValue=" + this.tagAttachmentStringValue + ", tagQualifiedName=" + this.tagQualifiedName + ")";
        }
    }

    @Generated
    private static final class TagAttachmentBuilderImpl
    extends TagAttachmentBuilder<TagAttachment, TagAttachmentBuilderImpl> {
        @Generated
        private TagAttachmentBuilderImpl() {
        }

        @Override
        @Generated
        protected TagAttachmentBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TagAttachment build() {
            return new TagAttachment(this);
        }
    }
}

