/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.discovery;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.ITag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TagFilter.class);
    String name;
    String displayName;
    List<TagValue> tagValues;

    public static TagFilter of(AtlanClient client, String tagName) {
        try {
            String clsId = client.getAtlanTagCache().getSidForName(tagName);
            return ((TagFilterBuilder)((TagFilterBuilder)TagFilter._internal().displayName(tagName)).name(clsId)).build();
        }
        catch (AtlanException e) {
            log.error("Unable to translate tag -- skipping: {}", (Object)tagName, (Object)e);
            return null;
        }
    }

    public static TagFilter of(AtlanClient client, String tagName, String value) {
        TagFilter starter = TagFilter.of(client, tagName);
        if (starter != null && value != null && !value.isEmpty()) {
            try {
                List<ITag> sourceTags = client.getSourceTagCache().getByMappedAtlanTag(starter.getName());
                List<String> qualifiedNames = sourceTags.stream().map(ITag::getQualifiedName).toList();
                return ((TagFilterBuilder)starter.toBuilder().tagValue((TagValue)((TagValue.TagValueBuilder)((TagValue.TagValueBuilder)TagValue.builder().tagQFNames(qualifiedNames)).consolidatedValue(value)).build())).build();
            }
            catch (AtlanException e) {
                log.error("Unable to find any source tags mapped to tag -- skipping: {}", (Object)tagName, (Object)e);
            }
        }
        return starter;
    }

    @Generated
    protected TagFilter(TagFilterBuilder<?, ?> b) {
        this.name = b.name;
        this.displayName = b.displayName;
        this.tagValues = switch (b.tagValues == null ? 0 : b.tagValues.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.tagValues.get(0));
            default -> Collections.unmodifiableList(new ArrayList<TagValue>(b.tagValues));
        };
    }

    @Generated
    public static TagFilterBuilder<?, ?> _internal() {
        return new TagFilterBuilderImpl();
    }

    @Generated
    public TagFilterBuilder<?, ?> toBuilder() {
        return new TagFilterBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public List<TagValue> getTagValues() {
        return this.tagValues;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagFilter)) {
            return false;
        }
        TagFilter other = (TagFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        List<TagValue> this$tagValues = this.getTagValues();
        List<TagValue> other$tagValues = other.getTagValues();
        return !(this$tagValues == null ? other$tagValues != null : !((Object)this$tagValues).equals(other$tagValues));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TagFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        List<TagValue> $tagValues = this.getTagValues();
        result = result * 59 + ($tagValues == null ? 43 : ((Object)$tagValues).hashCode());
        return result;
    }

    @Generated
    public static abstract class TagFilterBuilder<C extends TagFilter, B extends TagFilterBuilder<C, B>> {
        @Generated
        private String name;
        @Generated
        private String displayName;
        @Generated
        private ArrayList<TagValue> tagValues;

        @Generated
        protected B $fillValuesFrom(C instance) {
            TagFilterBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TagFilter instance, TagFilterBuilder<?, ?> b) {
            b.name(instance.name);
            b.displayName(instance.displayName);
            b.tagValues(instance.tagValues == null ? Collections.emptyList() : instance.tagValues);
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B displayName(String displayName) {
            this.displayName = displayName;
            return this.self();
        }

        @Generated
        public B tagValue(TagValue tagValue) {
            if (this.tagValues == null) {
                this.tagValues = new ArrayList();
            }
            this.tagValues.add(tagValue);
            return this.self();
        }

        @Generated
        public B tagValues(Collection<? extends TagValue> tagValues) {
            if (tagValues == null) {
                throw new NullPointerException("tagValues cannot be null");
            }
            if (this.tagValues == null) {
                this.tagValues = new ArrayList();
            }
            this.tagValues.addAll(tagValues);
            return this.self();
        }

        @Generated
        public B clearTagValues() {
            if (this.tagValues != null) {
                this.tagValues.clear();
            }
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TagFilter.TagFilterBuilder(name=" + this.name + ", displayName=" + this.displayName + ", tagValues=" + this.tagValues + ")";
        }
    }

    public static final class TagValue {
        String consolidatedValue;
        List<String> tagQFNames;

        @Generated
        protected TagValue(TagValueBuilder<?, ?> b) {
            this.consolidatedValue = b.consolidatedValue;
            this.tagQFNames = switch (b.tagQFNames == null ? 0 : b.tagQFNames.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(b.tagQFNames.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(b.tagQFNames));
            };
        }

        @Generated
        public static TagValueBuilder<?, ?> builder() {
            return new TagValueBuilderImpl();
        }

        @Generated
        public TagValueBuilder<?, ?> toBuilder() {
            return new TagValueBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getConsolidatedValue() {
            return this.consolidatedValue;
        }

        @Generated
        public List<String> getTagQFNames() {
            return this.tagQFNames;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TagValue)) {
                return false;
            }
            TagValue other = (TagValue)o;
            String this$consolidatedValue = this.getConsolidatedValue();
            String other$consolidatedValue = other.getConsolidatedValue();
            if (this$consolidatedValue == null ? other$consolidatedValue != null : !this$consolidatedValue.equals(other$consolidatedValue)) {
                return false;
            }
            List<String> this$tagQFNames = this.getTagQFNames();
            List<String> other$tagQFNames = other.getTagQFNames();
            return !(this$tagQFNames == null ? other$tagQFNames != null : !((Object)this$tagQFNames).equals(other$tagQFNames));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $consolidatedValue = this.getConsolidatedValue();
            result = result * 59 + ($consolidatedValue == null ? 43 : $consolidatedValue.hashCode());
            List<String> $tagQFNames = this.getTagQFNames();
            result = result * 59 + ($tagQFNames == null ? 43 : ((Object)$tagQFNames).hashCode());
            return result;
        }

        @Generated
        public static abstract class TagValueBuilder<C extends TagValue, B extends TagValueBuilder<C, B>> {
            @Generated
            private String consolidatedValue;
            @Generated
            private ArrayList<String> tagQFNames;

            @Generated
            protected B $fillValuesFrom(C instance) {
                TagValueBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(TagValue instance, TagValueBuilder<?, ?> b) {
                b.consolidatedValue(instance.consolidatedValue);
                b.tagQFNames(instance.tagQFNames == null ? Collections.emptyList() : instance.tagQFNames);
            }

            @Generated
            public B consolidatedValue(String consolidatedValue) {
                this.consolidatedValue = consolidatedValue;
                return this.self();
            }

            @Generated
            public B tagQFName(String tagQFName) {
                if (this.tagQFNames == null) {
                    this.tagQFNames = new ArrayList();
                }
                this.tagQFNames.add(tagQFName);
                return this.self();
            }

            @Generated
            public B tagQFNames(Collection<? extends String> tagQFNames) {
                if (tagQFNames == null) {
                    throw new NullPointerException("tagQFNames cannot be null");
                }
                if (this.tagQFNames == null) {
                    this.tagQFNames = new ArrayList();
                }
                this.tagQFNames.addAll(tagQFNames);
                return this.self();
            }

            @Generated
            public B clearTagQFNames() {
                if (this.tagQFNames != null) {
                    this.tagQFNames.clear();
                }
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "TagFilter.TagValue.TagValueBuilder(consolidatedValue=" + this.consolidatedValue + ", tagQFNames=" + this.tagQFNames + ")";
            }
        }

        @Generated
        private static final class TagValueBuilderImpl
        extends TagValueBuilder<TagValue, TagValueBuilderImpl> {
            @Generated
            private TagValueBuilderImpl() {
            }

            @Override
            @Generated
            protected TagValueBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public TagValue build() {
                return new TagValue(this);
            }
        }
    }

    @Generated
    private static final class TagFilterBuilderImpl
    extends TagFilterBuilder<TagFilter, TagFilterBuilderImpl> {
        @Generated
        private TagFilterBuilderImpl() {
        }

        @Override
        @Generated
        protected TagFilterBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TagFilter build() {
            return new TagFilter(this);
        }
    }
}

