/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.Credential;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PowerBICrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.POWERBI.getValue();

    public static PowerBICrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return PowerBICrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null);
    }

    public static PowerBICrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws AtlanException {
        return ((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)PowerBICrawler._internal().setup(PREFIX, "@atlan/tableau", client, PowerBICrawler.getConnection(client, connectionName, AtlanConnectorType.POWERBI, adminRoles, adminGroups, adminUsers, false, false, 0L, "https://powerbi.microsoft.com/pictures/application-logos/svg/powerbi.svg"))).include((List<String>)null)).exclude((List<String>)null)).directEndorsements(true);
    }

    @Generated
    protected PowerBICrawler(PowerBICrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static PowerBICrawlerBuilder<?, ?> _internal() {
        return new PowerBICrawlerBuilderImpl();
    }

    @Generated
    public PowerBICrawlerBuilder<?, ?> toBuilder() {
        return new PowerBICrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBICrawler)) {
            return false;
        }
        PowerBICrawler other = (PowerBICrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBICrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PowerBICrawler(super=" + super.toString() + ")";
    }

    public static abstract class PowerBICrawlerBuilder<C extends PowerBICrawler, B extends PowerBICrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B direct() {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-powerbi-" + this.epoch + "-0")).host("api.powerbi.com")).port(443)).connectorConfigName("atlan-connectors-powerbi");
            return (B)((PowerBICrawlerBuilder)this._credential(this.localCreds));
        }

        public B delegatedUser(String username, String password, String tenantId, String clientId, String clientSecret) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("basic")).username(username)).password(password)).extra("tenantId", tenantId)).extra("clientId", clientId)).extra("clientSecret", clientSecret);
            return (B)((PowerBICrawlerBuilder)this._credential(this.localCreds));
        }

        public B servicePrincipal(String tenantId, String clientId, String clientSecret) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("service_principal")).connectorType("rest")).extra("tenantId", tenantId)).extra("clientId", clientId)).extra("clientSecret", clientSecret);
            return (B)((PowerBICrawlerBuilder)this._credential(this.localCreds));
        }

        public B include(List<String> workspaces) throws InvalidRequestException {
            Map<String, Map<String, String>> toInclude = AbstractCrawler.buildFlatFilter(workspaces);
            try {
                return (B)((PowerBICrawlerBuilder)this._parameter("include-filter", Serde.allInclusiveMapper.writeValueAsString(toInclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(List<String> workspaces) throws InvalidRequestException {
            Map<String, Map<String, String>> toExclude = AbstractCrawler.buildFlatFilter(workspaces);
            try {
                return (B)((PowerBICrawlerBuilder)this._parameter("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(toExclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B include(String regex) {
            return (B)((PowerBICrawlerBuilder)this._parameter("dashboard_report_include_regex", regex));
        }

        public B exclude(String regex) {
            return (B)((PowerBICrawlerBuilder)this._parameter("dashboard_report_exclude_regex", regex));
        }

        public B directEndorsements(boolean enabled) {
            return (B)((PowerBICrawlerBuilder)this._parameter("endorsement-attach-mode", enabled ? "metastore" : "requests"));
        }

        @Override
        protected B metadata() {
            return (B)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)((PowerBICrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "powerbi"))._label("orchestration.atlan.com/sourceCategory", "bi"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hpowerbi"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-powerbi-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/categories", "powerbi,crawler"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6332245668881"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://powerbi.microsoft.com/pictures/application-logos/svg/powerbi.svg"))._annotation("orchestration.atlan.com/logo", "https://powerbi.microsoft.com/pictures/application-logos/svg/powerbi.svg"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/powerbi"))._annotation("orchestration.atlan.com/name", "Power BI Assets"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to crawl Power BI assets and publish to Atlan for discovery"))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/powerbi"))._annotation("package.argoproj.io/keywords", "[\"powerbi\",\"bi\",\"connector\",\"crawler\"]"))._annotation("package.argoproj.io/name", "@atlan/powerbi"))._annotation("package.argoproj.io/parent", "."))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-powerbi-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("connection", this.connection.toJson(this.client)), Map.entry("atlas-auth-type", "internal"), Map.entry("publish-mode", "production"))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBICrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBICrawler instance, PowerBICrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PowerBICrawler.PowerBICrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class PowerBICrawlerBuilderImpl
    extends PowerBICrawlerBuilder<PowerBICrawler, PowerBICrawlerBuilderImpl> {
        @Generated
        private PowerBICrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBICrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBICrawler build() {
            return new PowerBICrawler(this);
        }
    }
}

