/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.Credential;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SnowflakeCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.SNOWFLAKE.getValue();

    public static SnowflakeCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return SnowflakeCrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null, true, true, 10000L);
    }

    public static SnowflakeCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, boolean allowQuery, boolean allowSamples, long rowLimit) throws AtlanException {
        return ((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)SnowflakeCrawler._internal().setup(PREFIX, "@atlan/snowflake", client, SnowflakeCrawler.getConnection(client, connectionName, AtlanConnectorType.SNOWFLAKE, adminRoles, adminGroups, adminUsers, allowQuery, allowSamples, rowLimit, "https://docs.snowflake.com/en/_images/logo-snowflake-sans-text.png"))).tags(false)).include(null)).exclude((Map<String, List<String>>)null);
    }

    @Generated
    protected SnowflakeCrawler(SnowflakeCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static SnowflakeCrawlerBuilder<?, ?> _internal() {
        return new SnowflakeCrawlerBuilderImpl();
    }

    @Generated
    public SnowflakeCrawlerBuilder<?, ?> toBuilder() {
        return new SnowflakeCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnowflakeCrawler)) {
            return false;
        }
        SnowflakeCrawler other = (SnowflakeCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnowflakeCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SnowflakeCrawler(super=" + super.toString() + ")";
    }

    public static abstract class SnowflakeCrawlerBuilder<C extends SnowflakeCrawler, B extends SnowflakeCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B basicAuth(String username, String password, String role, String warehouse) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.port(443)).authType("basic")).username(username)).password(password)).extra("role", role)).extra("warehouse", warehouse);
            return (B)((SnowflakeCrawlerBuilder)this._credential(this.localCreds));
        }

        public B keypairAuth(String username, String privateKey, String privateKeyPassword, String role, String warehouse) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.port(443)).authType("keypair")).username(username)).password(privateKey)).extra("role", role)).extra("warehouse", warehouse)).extra("private_key_password", privateKeyPassword);
            return (B)((SnowflakeCrawlerBuilder)this._credential(this.localCreds));
        }

        public B informationSchema(String hostname) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.host(hostname)).name("default-snowflake-" + this.epoch + "-0")).connectorConfigName("atlan-connectors-snowflake");
            return (B)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)this._parameter("extract-strategy", "information-schema"))._credential(this.localCreds));
        }

        public B accountUsage(String hostname, String databaseName, String schemaName) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.host(hostname)).name("default-snowflake-" + this.epoch + "-0")).connectorConfigName("atlan-connectors-snowflake");
            return (B)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)this._parameter("extract-strategy", "account-usage"))._parameter("account-usage-database-name", databaseName))._parameter("account-usage-schema-name", schemaName))._credential(this.localCreds));
        }

        public B lineage(boolean include) {
            return (B)((SnowflakeCrawlerBuilder)this._parameter("enable-lineage", "" + include));
        }

        public B tags(boolean include) {
            return (B)((SnowflakeCrawlerBuilder)this._parameter("enable-snowflake-tags", "" + include));
        }

        public B include(Map<String, List<String>> assets) throws InvalidRequestException {
            Map<String, List<String>> toInclude = AbstractCrawler.buildHierarchicalFilter(assets);
            try {
                return (B)((SnowflakeCrawlerBuilder)this._parameter("include-filter", Serde.allInclusiveMapper.writeValueAsString(toInclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(Map<String, List<String>> assets) throws InvalidRequestException {
            Map<String, List<String>> toExclude = AbstractCrawler.buildHierarchicalFilter(assets);
            try {
                return (B)((SnowflakeCrawlerBuilder)this._parameter("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(toExclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(String regex) {
            return (B)((SnowflakeCrawlerBuilder)this._parameter("temp-table-regex", regex));
        }

        @Override
        protected B metadata() {
            return (B)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)((SnowflakeCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "snowflake"))._label("orchestration.atlan.com/sourceCategory", "warehouse"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hsnowflake"))._label("package.argoproj.io/parent", ""))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-snowflake-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/categories", "warehouse,crawler"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6037440864145"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://docs.snowflake.com/en/_images/logo-snowflake-sans-text.png"))._annotation("orchestration.atlan.com/logo", "https://1amiydhcmj36tz3733v94f15-wpengine.netdna-ssl.com/wp-content/themes/snowflake/assets/img/logo-blue.svg"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/snowflake"))._annotation("orchestration.atlan.com/name", "Snowflake Assets"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to crawl snowflake assets and publish to Atlan for discovery"))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/snowflake"))._annotation("package.argoproj.io/keywords", "[\"snowflake\",\"warehouse\",\"connector\",\"crawler\"]"))._annotation("package.argoproj.io/name", "@atlan/snowflake"))._annotation("package.argoproj.io/parent", "."))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-snowflake-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("control-config-strategy", "default"), Map.entry("connection", this.connection.toJson(this.client)))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SnowflakeCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SnowflakeCrawler instance, SnowflakeCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SnowflakeCrawler.SnowflakeCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class SnowflakeCrawlerBuilderImpl
    extends SnowflakeCrawlerBuilder<SnowflakeCrawler, SnowflakeCrawlerBuilderImpl> {
        @Generated
        private SnowflakeCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected SnowflakeCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SnowflakeCrawler build() {
            return new SnowflakeCrawler(this);
        }
    }
}

