/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.workflow;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.enums.AtlanWorkflowPhase;
import com.atlan.model.workflow.WorkflowMetadata;
import com.atlan.model.workflow.WorkflowRunResponse;
import com.atlan.model.workflow.WorkflowSearchRequest;
import com.atlan.model.workflow.WorkflowSearchResult;
import com.atlan.model.workflow.WorkflowSpec;
import com.atlan.net.ApiResource;
import com.atlan.net.HttpClient;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class WorkflowResponse
extends ApiResource {
    private static final long serialVersionUID = 2L;
    @JsonIgnore
    AtlanClient client;
    WorkflowMetadata metadata;
    WorkflowSpec spec;
    List<Object> payload;

    public AtlanWorkflowPhase monitorStatus() throws AtlanException, InterruptedException {
        return this.monitorStatus(null);
    }

    public AtlanWorkflowPhase monitorStatus(Logger log) throws AtlanException, InterruptedException {
        return this.monitorStatus(log, Level.INFO);
    }

    public AtlanWorkflowPhase monitorStatus(Logger log, Level level) throws AtlanException, InterruptedException {
        return this.monitorStatus(log, level, Long.MAX_VALUE);
    }

    public AtlanWorkflowPhase monitorStatus(Logger log, Level level, long maxWaitTime) throws AtlanException, InterruptedException {
        long start = System.currentTimeMillis();
        if (this.getMetadata() != null && this.getMetadata().getName() != null) {
            long elapsed;
            String name = this.getMetadata().getName();
            AtlanWorkflowPhase status = null;
            do {
                Thread.sleep(HttpClient.waitTime(5).toMillis());
                WorkflowSearchResult runDetails = this.getRunDetails(name);
                if (runDetails != null) {
                    status = runDetails.getStatus();
                }
                if (log != null) {
                    log.atLevel(level).log("Workflow {}: {}", (Object)name, (Object)status);
                }
                elapsed = (System.currentTimeMillis() - start) / 1000L;
            } while (status != AtlanWorkflowPhase.SUCCESS && status != AtlanWorkflowPhase.ERROR && status != AtlanWorkflowPhase.FAILED && elapsed <= maxWaitTime);
            if (log != null) {
                log.atLevel(level).log("Workflow {}: {}", (Object)name, (Object)status);
            }
            return status;
        }
        if (log != null) {
            log.atLevel(level).log("Skipping workflow monitoring \u2014 nothing to monitor.");
        }
        return null;
    }

    public WorkflowRunResponse stop() throws AtlanException {
        WorkflowSearchResult latest = this.getRunDetails(this.getMetadata().getName());
        if (latest != null && latest.get_id() != null) {
            return this.client.workflows.stop(latest.get_id(), null);
        }
        return null;
    }

    protected WorkflowSearchResult getRunDetails(String name) throws AtlanException {
        return WorkflowSearchRequest.findLatestRun(this.client, name);
    }

    @Generated
    public AtlanClient getClient() {
        return this.client;
    }

    @Generated
    public WorkflowMetadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public WorkflowSpec getSpec() {
        return this.spec;
    }

    @Generated
    public List<Object> getPayload() {
        return this.payload;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowResponse)) {
            return false;
        }
        WorkflowResponse other = (WorkflowResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AtlanClient this$client = this.getClient();
        AtlanClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        WorkflowMetadata this$metadata = this.getMetadata();
        WorkflowMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        WorkflowSpec this$spec = this.getSpec();
        WorkflowSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
            return false;
        }
        List<Object> this$payload = this.getPayload();
        List<Object> other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtlanClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        WorkflowMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        WorkflowSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        List<Object> $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "WorkflowResponse(super=" + super.toString() + ", client=" + this.getClient() + ", metadata=" + this.getMetadata() + ", spec=" + this.getSpec() + ", payload=" + this.getPayload() + ")";
    }

    @JsonIgnore
    @Generated
    public void setClient(AtlanClient client) {
        this.client = client;
    }
}

