/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.admin.AtlanRequest;
import com.atlan.model.admin.AtlanTagPayload;
import com.atlan.model.admin.AtlanTagRequest;
import com.atlan.model.admin.AttributeRequest;
import com.atlan.model.admin.CustomMetadataPayload;
import com.atlan.model.admin.CustomMetadataRequest;
import com.atlan.model.admin.TermLinkRequest;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanRequestStatus;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Collection;

public class AtlanRequestDeserializer
extends StdDeserializer<AtlanRequest> {
    private static final long serialVersionUID = 2L;
    private final AtlanClient client;

    public AtlanRequestDeserializer(AtlanClient client) {
        this(AtlanRequest.class, client);
    }

    public AtlanRequestDeserializer(Class<?> t, AtlanClient client) {
        super(t);
        this.client = client;
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser, context);
    }

    public AtlanRequest deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode root = (JsonNode)parser.getCodec().readTree(parser);
        JsonNode requestType = root.get("requestType");
        if (root.has("requestType") && (requestType == null || requestType.isNull())) {
            return null;
        }
        if (requestType != null && requestType.isTextual()) {
            AtlanRequest.AtlanRequestBuilder builder = null;
            String type = JacksonUtils.deserializeString(root, "requestType");
            JsonNode jsonPayload = root.get("payload");
            JsonNode jsonDestAttribute = root.get("destinationAttribute");
            String destinationAttribute = null;
            if (jsonDestAttribute != null && !jsonDestAttribute.isNull() && jsonDestAttribute.isTextual()) {
                destinationAttribute = jsonDestAttribute.asText();
            }
            if (type != null) {
                switch (type) {
                    case "attach_classification": {
                        String humanReadableAtlanTag;
                        String typeName = JacksonUtils.deserializeString(jsonPayload, "typeName");
                        Boolean propagate = JacksonUtils.deserializeBoolean(jsonPayload, "propagate");
                        Boolean removeOnDelete = JacksonUtils.deserializeBoolean(jsonPayload, "removePropagationsOnEntityDelete");
                        try {
                            humanReadableAtlanTag = this.client.getAtlanTagCache().getNameForSid(typeName);
                        }
                        catch (NotFoundException e) {
                            humanReadableAtlanTag = "(DELETED)";
                        }
                        catch (AtlanException e) {
                            throw new IOException("Unable to translate Atlan tag with the ID: " + typeName, e);
                        }
                        if (humanReadableAtlanTag == null) {
                            humanReadableAtlanTag = "(DELETED)";
                        }
                        AtlanTagPayload.AtlanTagPayloadBuilder payloadBuilder = AtlanTagPayload.builder().typeName(humanReadableAtlanTag);
                        if (propagate != null) {
                            payloadBuilder = payloadBuilder.propagate(propagate);
                        }
                        if (removeOnDelete != null) {
                            payloadBuilder = payloadBuilder.removePropagationsOnEntityDelete(removeOnDelete);
                        }
                        builder = AtlanTagRequest.builder().payload(payloadBuilder.build());
                        break;
                    }
                    case "bm_attribute": {
                        AtlanObject cma;
                        String cmId = destinationAttribute;
                        try {
                            destinationAttribute = this.client.getCustomMetadataCache().getNameForId(cmId);
                            cma = this.client.getCustomMetadataCache().getCustomMetadataAttributes(cmId, jsonPayload);
                        }
                        catch (NotFoundException e) {
                            destinationAttribute = "(DELETED)";
                            cma = CustomMetadataAttributes.builder().build();
                        }
                        catch (AtlanException e) {
                            throw new IOException("Unable to translate custom metadata attributes for " + cmId + ": " + jsonPayload, e);
                        }
                        builder = CustomMetadataRequest.builder().payload(CustomMetadataPayload.builder().attributes((CustomMetadataAttributes)cma).build());
                        break;
                    }
                    case "attribute": {
                        builder = AttributeRequest.builder();
                        break;
                    }
                    case "term_link": {
                        builder = TermLinkRequest.builder();
                        break;
                    }
                    default: {
                        throw new IOException("Unknown request type " + type + ": " + jsonPayload);
                    }
                }
            }
            if (builder != null) {
                JsonNode destinationEntity = root.get("destinationEntity");
                JsonNode entityType = root.get("entityType");
                if (destinationEntity != null && !destinationEntity.isNull() && entityType != null && !entityType.isNull()) {
                    ((ObjectNode)destinationEntity).set("typeName", entityType);
                    builder.destinationEntity(this.client.convertValue(destinationEntity, new TypeReference<Asset>(){}));
                }
                AtlanObject request = ((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)((AtlanRequest.AtlanRequestBuilder)builder.id(JacksonUtils.deserializeString(root, "id"))).version(JacksonUtils.deserializeString(root, "version"))).isActive(JacksonUtils.deserializeBoolean(root, "isActive"))).createdAt(JacksonUtils.deserializeLong(root, "createdAt"))).updatedAt(JacksonUtils.deserializeLong(root, "updatedAt"))).createdBy(JacksonUtils.deserializeString(root, "createdBy"))).tenantId(JacksonUtils.deserializeString(root, "tenantId"))).sourceType(JacksonUtils.deserializeString(root, "sourceType"))).sourceGuid(JacksonUtils.deserializeString(root, "sourceGuid"))).sourceQualifiedName(JacksonUtils.deserializeString(root, "sourceQualifiedName"))).sourceAttribute(JacksonUtils.deserializeString(root, "sourceAttribute"))).destinationGuid(JacksonUtils.deserializeString(root, "destinationGuid"))).destinationQualifiedName(JacksonUtils.deserializeString(root, "destinationQualifiedName"))).destinationAttribute(destinationAttribute)).destinationValue(JacksonUtils.deserializeString(root, "destinationValue"))).destinationValueType(JacksonUtils.deserializeString(root, "destinationValueType"))).entityType(JacksonUtils.deserializeString(root, "entityType"))).requestType(JacksonUtils.deserializeString(root, "requestType"))).approvedBy(JacksonUtils.deserializeString(root, "approvedBy"))).rejectedBy(JacksonUtils.deserializeString(root, "rejectedBy"))).status(JacksonUtils.deserializeObject(this.client, root, "status", new TypeReference<AtlanRequestStatus>(){}))).message(JacksonUtils.deserializeString(root, "message"))).approvalType(JacksonUtils.deserializeString(root, "approvalType"))).hash(JacksonUtils.deserializeLong(root, "hash"))).isDuplicate(JacksonUtils.deserializeBoolean(root, "isDuplicate"))).destinationValueAction(JacksonUtils.deserializeString(root, "destinationValueAction"))).requestApproverUsers(JacksonUtils.deserializeObject(this.client, root, "requestApproverUsers", new TypeReference<Collection<? extends String>>(){}))).requestApproverGroups(JacksonUtils.deserializeObject(this.client, root, "requestApproverGroups", new TypeReference<Collection<? extends String>>(){}))).requestApproverRoles(JacksonUtils.deserializeObject(this.client, root, "requestApproverRoles", new TypeReference<Collection<? extends String>>(){}))).requestDenyUsers(JacksonUtils.deserializeObject(this.client, root, "requestDenyUsers", new TypeReference<Collection<? extends String>>(){}))).requestDenyGroups(JacksonUtils.deserializeObject(this.client, root, "requestDenyGroups", new TypeReference<Collection<? extends String>>(){}))).requestDenyRoles(JacksonUtils.deserializeObject(this.client, root, "requestDenyRoles", new TypeReference<Collection<? extends String>>(){}))).build();
                request.setRawJsonObject(root);
                return request;
            }
        } else {
            throw new IOException("Request type currently not handled: " + root);
        }
        return null;
    }
}

