/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

public class TypeUtils {
    public static boolean isComparable(String attrType, ComparisonCategory to) {
        String baseType;
        switch (baseType = TypeUtils.getBaseType(attrType)) {
            case "boolean": {
                return to == ComparisonCategory.BOOLEAN;
            }
            case "int": 
            case "long": 
            case "date": 
            case "float": {
                return to == ComparisonCategory.NUMBER;
            }
        }
        return to == ComparisonCategory.STRING;
    }

    public static String getBaseType(String attrType) {
        String baseType = attrType;
        if (attrType.contains("<")) {
            if (attrType.startsWith("array<")) {
                baseType = attrType.startsWith("array<map<") ? TypeUtils.getEmbeddedType(attrType.substring("array<".length(), attrType.length() - 1)) : TypeUtils.getEmbeddedType(attrType);
            } else if (attrType.startsWith("map<")) {
                baseType = TypeUtils.getEmbeddedType(attrType);
            }
        }
        return baseType;
    }

    private static String getEmbeddedType(String attrType) {
        return attrType.substring(attrType.indexOf("<") + 1, attrType.indexOf(">"));
    }

    public static enum ComparisonCategory {
        STRING,
        NUMBER,
        BOOLEAN;

    }
}

