/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.ChronosEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.lineage.OpenLineageEvent;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;

public class OpenLineageEndpoint
extends ChronosEndpoint {
    private static final String endpoint = "api/v1/lineage";

    public OpenLineageEndpoint(AtlanClient client) {
        super(client);
    }

    public void send(OpenLineageEvent request, AtlanConnectorType connectorType) throws AtlanException {
        this.send(request, connectorType, null);
    }

    public void send(OpenLineageEvent request, AtlanConnectorType connectorType, RequestOptions options) throws AtlanException {
        String url = String.format("%s/%s/%s", this.getBaseUrl(), connectorType.getValue(), endpoint);
        try {
            ApiResource.requestPlainText(this.client, ApiResource.RequestMethod.POST, url, request, options);
        }
        catch (AuthenticationException e) {
            if (e.getAtlanError() != null && e.getAtlanError().getErrorMessage() != null && e.getAtlanError().getErrorMessage().startsWith("Unauthorized: url path not configured to receive data, urlPath:")) {
                throw new InvalidRequestException(ErrorCode.OPENLINEAGE_NOT_CONFIGURED, (Throwable)e, connectorType.getValue());
            }
            throw e;
        }
    }
}

