/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import com.atlan.AtlanClient;
import com.atlan.api.AtlasEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.SearchLogEntry;
import com.atlan.model.search.SearchLogRequest;
import com.atlan.model.search.SearchLogResponse;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchLogEndpoint
extends AtlasEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchLogEndpoint.class);
    private static final String search_endpoint = "/search/searchlog";

    public SearchLogEndpoint(AtlanClient client) {
        super(client);
    }

    public SearchLogResponse search(SearchLogRequest request) throws AtlanException {
        return this.search(request, null);
    }

    public SearchLogResponse search(SearchLogRequest request, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), search_endpoint);
        boolean missingSort = request.getDsl().getSort() == null || request.getDsl().getSort().isEmpty();
        boolean missingTimeSort = true;
        if (!missingSort) {
            for (SortOptions option : request.getDsl().getSort()) {
                if (!option.isField()) continue;
                String fieldName = option.field().field();
                if (!SearchLogEntry.SEARCHED_AT.getNumericFieldName().equals(fieldName)) continue;
                missingTimeSort = false;
                break;
            }
        }
        if (missingTimeSort) {
            request = ((SearchLogRequest.SearchLogRequestBuilder)request.toBuilder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)request.getDsl().toBuilder().sortOption(SearchLogEntry.SEARCHED_AT.order(SortOrder.Asc))).build())).build();
        }
        SearchLogResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, request, SearchLogResponse.class, options);
        response.setClient(this.client);
        return response;
    }
}

