/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.api.TypeDefsEndpoint;
import com.atlan.cache.AbstractMassCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.AtlanTagDef;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.TypeDefResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlanTagCache
extends AbstractMassCache<AtlanTagDef> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtlanTagCache.class);
    private volatile Map<String, String> mapSidToSourceTagsAttrSid = new ConcurrentHashMap<String, String>();
    private volatile Set<String> deletedSids = ConcurrentHashMap.newKeySet();
    private volatile Set<String> deletedNames = ConcurrentHashMap.newKeySet();
    private final TypeDefsEndpoint typeDefsEndpoint;

    public AtlanTagCache(AtlanClient client) {
        super(client, "tag");
        this.typeDefsEndpoint = client.typeDefs;
    }

    @Override
    protected void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of Atlan tags...");
        TypeDefResponse response = this.typeDefsEndpoint.list(List.of(AtlanTypeCategory.ATLAN_TAG, AtlanTypeCategory.STRUCT));
        if (response == null || response.getStructDefs() == null || response.getStructDefs().isEmpty()) {
            throw new AuthenticationException(ErrorCode.EXPIRED_API_TOKEN);
        }
        List<AtlanTagDef> tags = response.getAtlanTagDefs();
        this.mapSidToSourceTagsAttrSid.clear();
        this.deletedSids.clear();
        this.deletedNames.clear();
        for (AtlanTagDef clsDef : tags) {
            String typeId = clsDef.getName();
            this.cache(clsDef.getGuid(), typeId, clsDef.getDisplayName(), clsDef);
            List<AttributeDef> attrs = clsDef.getAttributeDefs();
            String sourceTagsId = "";
            if (attrs != null && !attrs.isEmpty()) {
                for (AttributeDef attr : attrs) {
                    if (!"sourceTagAttachment".equals(attr.getDisplayName())) continue;
                    sourceTagsId = attr.getName();
                }
            }
            this.mapSidToSourceTagsAttrSid.put(typeId, sourceTagsId);
        }
    }

    @Override
    protected void lookupByName(String name) {
    }

    @Override
    protected void lookupById(String id) {
    }

    private String getSourceTagsAttrIdFromId(String id) {
        this.lock.readLock().lock();
        try {
            String string = this.mapSidToSourceTagsAttrSid.get(id);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean isDeletedName(String name) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.deletedNames.contains(name);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void addDeletedName(String name) {
        this.lock.writeLock().lock();
        try {
            this.deletedNames.add(name);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean isDeletedId(String id) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.deletedSids.contains(id);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void addDeletedId(String id) {
        this.lock.writeLock().lock();
        try {
            this.deletedSids.add(id);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String getIdForName(String name, long minimumTime) throws AtlanException {
        if (name != null && this.isDeletedName(name)) {
            return null;
        }
        try {
            return super.getIdForName(name, minimumTime);
        }
        catch (NotFoundException e) {
            this.addDeletedName(name);
            throw e;
        }
    }

    @Override
    public String getNameForId(String id, long minimumTime) throws AtlanException {
        if (id != null && this.isDeletedId(id)) {
            return null;
        }
        try {
            return super.getNameForId(id, minimumTime);
        }
        catch (NotFoundException e) {
            this.addDeletedId(id);
            throw e;
        }
    }

    @Override
    public String getSidForName(String name, long minimumTime) throws AtlanException {
        if (name != null && this.isDeletedName(name)) {
            return null;
        }
        try {
            return super.getSidForName(name, minimumTime);
        }
        catch (NotFoundException e) {
            this.addDeletedName(name);
            throw e;
        }
    }

    @Override
    public String getNameForSid(String id, long minimumTime) throws AtlanException {
        if (id != null && this.isDeletedId(id)) {
            return null;
        }
        try {
            return super.getNameForSid(id, minimumTime);
        }
        catch (NotFoundException e) {
            this.addDeletedId(id);
            throw e;
        }
    }

    public String getSourceTagsAttrId(String id) throws AtlanException {
        return this.getSourceTagsAttrId(id, true);
    }

    public String getSourceTagsAttrId(String id, boolean allowRefresh) throws AtlanException {
        return this.getSourceTagsAttrId(id, allowRefresh ? Long.MAX_VALUE : Long.MIN_VALUE);
    }

    public String getSourceTagsAttrId(String id, long minimumTime) throws AtlanException {
        if (id == null || id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_ATLAN_TAG_ID);
        }
        String attrId = this.getSourceTagsAttrIdFromId(id);
        if (attrId == null && !this.isDeletedId(id)) {
            this.refresh(minimumTime);
            attrId = this.getSourceTagsAttrIdFromId(id);
            if (attrId == null) {
                this.addDeletedId(id);
                throw new NotFoundException(ErrorCode.ATLAN_TAG_NOT_FOUND_BY_ID, id);
            }
        }
        return attrId;
    }
}

