/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.api.GroupsEndpoint;
import com.atlan.cache.AbstractMassCache;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanGroup;
import com.atlan.model.admin.GroupResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCache
extends AbstractMassCache<AtlanGroup> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupCache.class);
    private final GroupsEndpoint groupsEndpoint;

    public GroupCache(AtlanClient client) {
        super(client, "group");
        this.groupsEndpoint = client.groups;
    }

    @Override
    protected void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of groups...");
        List<AtlanGroup> groups = this.groupsEndpoint.list();
        for (AtlanGroup group : groups) {
            String groupId = group.getId();
            String groupName = group.getName();
            this.cache(groupId, group.getAlias(), groupName, group);
        }
    }

    public String getIdForAlias(String alias) throws AtlanException {
        return this.getIdForAlias(alias, true);
    }

    public String getIdForAlias(String alias, boolean allowRefresh) throws AtlanException {
        return this.getIdForSid(alias, allowRefresh);
    }

    public String getNameForAlias(String alias) throws AtlanException {
        return this.getNameForAlias(alias, true);
    }

    public String getNameForAlias(String alias, boolean allowRefresh) throws AtlanException {
        return this.getNameForSid(alias, allowRefresh);
    }

    @Override
    protected void lookupByName(String name) throws AtlanException {
        GroupResponse response = this.groupsEndpoint.list("{\"name\":\"" + name + "\"}");
        this.cacheResponse(response);
    }

    @Override
    protected void lookupById(String id) throws AtlanException {
        GroupResponse response = this.groupsEndpoint.list("{\"id\":\"" + id + "\"}");
        this.cacheResponse(response);
    }

    @Override
    protected void lookupBySid(String alias) throws AtlanException {
        GroupResponse response = this.groupsEndpoint.list("{\"alias\":\"" + alias + "\"}");
        this.cacheResponse(response);
    }

    private void cacheResponse(GroupResponse response) {
        if (response != null && response.getRecords() != null) {
            List<AtlanGroup> groups = response.getRecords();
            for (AtlanGroup group : groups) {
                String groupId = group.getId();
                this.cache(groupId, group.getAlias(), group.getName(), group);
            }
        }
    }
}

