/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.cache.AbstractOffHeapCache;
import com.atlan.model.core.AtlanObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OffHeapObjectCache<T extends AtlanObject>
extends AbstractOffHeapCache<String, T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OffHeapObjectCache.class);
    private final AtlanClient client;

    public OffHeapObjectCache(AtlanClient client, String name) {
        super(name);
        this.client = client;
    }

    @Override
    protected byte[] serializeKey(String key) {
        return key.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    protected String deserializeKey(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    protected byte[] serializeValue(T value) {
        byte[] typeName = value.getClass().getCanonicalName().getBytes(StandardCharsets.UTF_8);
        int typeNameLength = typeName.length;
        try {
            byte[] json = this.client.writeValueAsBytes(value);
            ByteBuffer buffer = ByteBuffer.allocate(typeNameLength + 4 + json.length);
            buffer.putInt(typeNameLength);
            buffer.put(typeName);
            buffer.put(json);
            if (buffer.hasArray()) {
                return buffer.array();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize value.", e);
        }
    }

    @Override
    protected T deserializeValue(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int typeNameLength = buffer.getInt();
        byte[] typeNameBytes = new byte[typeNameLength];
        buffer.get(typeNameBytes);
        String typeName = new String(typeNameBytes, StandardCharsets.UTF_8);
        try {
            Class<?> type = Class.forName(typeName);
            byte[] json = new byte[buffer.remaining()];
            buffer.get(json);
            return (T)((AtlanObject)this.client.readValue(json, type));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to find type: " + typeName + ".", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize value.", e);
        }
    }
}

