/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.AtlanClient;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.SearchableAttribute;
import com.atlan.generators.TypeGenerator;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.EntityDef;
import com.atlan.model.typedefs.RelationshipAttributeDef;
import freemarker.template.TemplateNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetGenerator
extends TypeGenerator
implements Comparable<AssetGenerator> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetGenerator.class);
    public static final String DIRECTORY = "assets";
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<AssetGenerator> assetComparator = Comparator.comparing(TypeGenerator::getOriginalName, stringComparator);
    private final EntityDef entityDef;
    private String parentClassName;
    private SortedSet<SearchableAttribute<?>> interfaceAttributes;
    private SortedSet<SearchableAttribute<?>> classAttributes;
    private SortedSet<SearchableAttribute<?>> nonInheritedAttributes;
    private List<AssetGenerator> originalSuperTypes = null;
    private List<AssetGenerator> fullSubTypes = null;
    private List<String> originalSubTypes = null;
    private List<String> subTypes = null;
    private List<String> mapContainers = null;
    private final Set<String> superTypes;

    public AssetGenerator(AtlanClient client, EntityDef entityDef, GeneratorConfig cfg) {
        super(client, entityDef, cfg);
        this.entityDef = entityDef;
        this.resolveClassName();
        this.description = this.cache.getTypeDescription(this.originalName);
        this.superTypes = this.cache.getAllSuperTypesForType(this.getOriginalName());
    }

    @Override
    protected void resolveClassName() {
        this.className = this.cfg.resolveClassName(this.originalName);
    }

    public String resolveSuperTypeName(String name) {
        if (name.equals("Referenceable")) {
            return name;
        }
        return this.cfg.resolveClassName(name);
    }

    public void resolveDetails() {
        this.resolveParentClassName();
        this.resolveSubTypes();
        this.resolveAttributes();
        this.resolveRelationships();
    }

    public String getInterfaceTemplateFile() {
        try {
            return this.cfg.getFreemarkerConfig().getTemplate("I" + this.className + ".ftl").getSourceName();
        }
        catch (TemplateNotFoundException templateNotFoundException) {
        }
        catch (IOException e) {
            log.error("Error reading template: I{}.ftl", (Object)this.className, (Object)e);
        }
        return null;
    }

    public boolean isAbstract() {
        return this.originalSubTypes != null && !this.originalSubTypes.isEmpty() && !this.cfg.forceNonAbstract(this.getOriginalName());
    }

    public void resolveParentClassName() {
        this.parentClassName = this.getOriginalName().equals("Asset") ? "Reference" : "Asset";
    }

    public SortedSet<String> getAllSubTypes(String originalTypeName) {
        TreeSet<String> localSubTypes = new TreeSet<String>();
        AssetGenerator assetGen = this.cache.getCachedAssetType(originalTypeName);
        if (assetGen != null) {
            List<String> subTypes;
            assetGen.resolveSubTypes();
            if (!assetGen.isAbstract()) {
                log.info("Adding concrete subtype {} to: {}", (Object)assetGen.getClassName(), (Object)originalTypeName);
                localSubTypes.add(assetGen.getClassName());
            }
            if ((subTypes = assetGen.getOriginalSubTypes()) != null && !subTypes.isEmpty()) {
                for (String subType : subTypes) {
                    SortedSet<String> further = this.getAllSubTypes(subType);
                    localSubTypes.addAll(further);
                }
            }
        }
        return localSubTypes;
    }

    private void resolveSubTypes() {
        List<String> superTypes;
        this.originalSubTypes = this.entityDef.getSubTypes();
        if (this.originalSubTypes != null && !this.originalSubTypes.isEmpty()) {
            this.subTypes = new ArrayList<String>();
            this.fullSubTypes = new ArrayList<AssetGenerator>();
            for (String originalSubType : this.originalSubTypes) {
                AssetGenerator sub = this.cache.getCachedAssetType(originalSubType);
                if (sub != null) {
                    this.fullSubTypes.add(sub);
                }
                if (!this.cfg.includeTypedef(sub.getEntityDef())) continue;
                TypeGenerator.MappedType subType = this.cache.getCachedType(originalSubType);
                if (subType != null) {
                    this.subTypes.add(subType.getName());
                    continue;
                }
                log.warn("Mapped subType was not found: {}", (Object)originalSubType);
            }
        }
        if ((superTypes = this.entityDef.getSuperTypes()) != null && !superTypes.isEmpty()) {
            this.originalSuperTypes = new ArrayList<AssetGenerator>();
            for (String superType : superTypes) {
                AssetGenerator parent = this.cache.getCachedAssetType(superType);
                if (parent == null) continue;
                this.originalSuperTypes.add(parent);
            }
        }
    }

    private void resolveAttributes() {
        SearchableAttribute attribute;
        SortedSet<AttributeDef> allAttributes = this.getOriginalName().equals("Asset") ? this.cache.getAllAttributesForType(this.getOriginalName()) : this.cache.getAllNonAssetAttributesForType(this.getOriginalName());
        this.nonInheritedAttributes = new TreeSet();
        for (AttributeDef attributeDef : this.cache.getEntityDefCache().get(this.getOriginalName()).getAttributeDefs()) {
            attribute = new SearchableAttribute(this.client, this.className, attributeDef, this.cfg);
            if (attribute.getType().getName().equals("Internal")) continue;
            this.nonInheritedAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
        this.classAttributes = new TreeSet();
        for (AttributeDef attributeDef : allAttributes) {
            attribute = new SearchableAttribute(this.client, this.className, attributeDef, this.cfg);
            if (attribute.getType().getName().equals("Internal")) continue;
            this.classAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
        this.interfaceAttributes = new TreeSet();
        for (AttributeDef attributeDef : this.cache.getAllAttributesForType(this.getOriginalName())) {
            attribute = new SearchableAttribute(this.client, this.className, attributeDef, this.cfg);
            if (attribute.getType().getName().equals("Internal")) continue;
            this.interfaceAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
    }

    private void resolveRelationships() {
        SearchableAttribute attribute;
        SortedSet<RelationshipAttributeDef> allRelationships = this.getOriginalName().equals("Asset") ? this.cache.getAllRelationshipsForType(this.getOriginalName()) : this.cache.getAllNonAssetRelationshipsForType(this.getOriginalName());
        Set<String> uniqueRelationships = this.cache.getUniqueRelationshipsForType(this.getOriginalName());
        for (RelationshipAttributeDef relationshipAttributeDef : this.cache.getEntityDefCache().get(this.getOriginalName()).getRelationshipAttributeDefs()) {
            if (!uniqueRelationships.contains(relationshipAttributeDef.getName()) || (attribute = new SearchableAttribute(this.client, this.className, relationshipAttributeDef, this.cfg)).getType().getName().equals("Internal")) continue;
            this.nonInheritedAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
        for (RelationshipAttributeDef relationshipAttributeDef : allRelationships) {
            attribute = new SearchableAttribute(this.client, this.className, relationshipAttributeDef, this.cfg);
            if (attribute.getType().getName().equals("Internal")) continue;
            this.classAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
        for (RelationshipAttributeDef relationshipAttributeDef : this.cache.getAllRelationshipsForType(this.getOriginalName())) {
            attribute = new SearchableAttribute(this.client, this.className, relationshipAttributeDef, this.cfg);
            if (attribute.getType().getName().equals("Internal")) continue;
            this.interfaceAttributes.add(attribute);
            this.checkAndAddMapContainer(attribute);
        }
    }

    private void checkAndAddMapContainer(SearchableAttribute<?> attribute) {
        if (attribute.getType().getContainer() != null && attribute.getType().getContainer().contains("Map")) {
            if (this.mapContainers == null) {
                this.mapContainers = new ArrayList<String>();
            }
            this.mapContainers.add(attribute.getRenamed());
        }
    }

    @Override
    public int compareTo(AssetGenerator o) {
        return assetComparator.compare(this, o);
    }

    @Generated
    public EntityDef getEntityDef() {
        return this.entityDef;
    }

    @Generated
    public String getParentClassName() {
        return this.parentClassName;
    }

    @Generated
    public SortedSet<SearchableAttribute<?>> getInterfaceAttributes() {
        return this.interfaceAttributes;
    }

    @Generated
    public SortedSet<SearchableAttribute<?>> getClassAttributes() {
        return this.classAttributes;
    }

    @Generated
    public SortedSet<SearchableAttribute<?>> getNonInheritedAttributes() {
        return this.nonInheritedAttributes;
    }

    @Generated
    public List<AssetGenerator> getOriginalSuperTypes() {
        return this.originalSuperTypes;
    }

    @Generated
    public List<AssetGenerator> getFullSubTypes() {
        return this.fullSubTypes;
    }

    @Generated
    public List<String> getOriginalSubTypes() {
        return this.originalSubTypes;
    }

    @Generated
    public List<String> getSubTypes() {
        return this.subTypes;
    }

    @Generated
    public List<String> getMapContainers() {
        return this.mapContainers;
    }

    @Generated
    public Set<String> getSuperTypes() {
        return this.superTypes;
    }
}

