/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.generators.AssetGenerator;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.SearchableAttribute;
import com.atlan.generators.TypeGenerator;
import com.atlan.generators.lombok.Singulars;
import com.atlan.model.enums.AtlanEnum;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetTestGenerator
extends AssetGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetTestGenerator.class);
    public static final String DIRECTORY = "assets";
    private static final String ASSET_GUID = "705d96f4-bdb6-4792-8dfe-8dc4ca3d2c23";
    private static final String ASSET_QN = "default/snowflake/1234567890/test/qualifiedName";
    protected final AssetGenerator asset;
    protected final List<TestAttribute> testAttributes;

    public AssetTestGenerator(AssetGenerator asset, GeneratorConfig cfg) {
        super(asset.getClient(), asset.getEntityDef(), cfg);
        this.asset = asset;
        this.testAttributes = new ArrayList<TestAttribute>();
    }

    @Override
    public void resolveDetails() {
        super.resolveDetails();
        this.addTestAttributes(this.asset);
    }

    private void addTestAttributes(AssetGenerator assetGenerator) {
        Set<String> superTypes = assetGenerator.getSuperTypes();
        if (superTypes != null && !superTypes.isEmpty()) {
            for (String superType : superTypes) {
                if (superType == null || superType.equals("Referenceable")) continue;
                this.addTestAttributes(this.cache.getCachedAssetType(superType), true);
            }
        }
        this.addTestAttributes(assetGenerator, false);
    }

    private void addTestAttributes(AssetGenerator assetGenerator, boolean fromSuperType) {
        SortedSet<SearchableAttribute<?>> attributes = assetGenerator.getNonInheritedAttributes();
        if (attributes != null) {
            block6: for (SearchableAttribute searchableAttribute : attributes) {
                boolean multiValued;
                TestAttribute.TestAttributeBuilder builder = TestAttribute.builder().details(searchableAttribute);
                TypeGenerator.MappedType type = searchableAttribute.getType();
                boolean bl = multiValued = searchableAttribute.getSingular() != null;
                String renamedAttr = searchableAttribute.getRenamed();
                if (renamedAttr.equals("serialVersionUID")) continue;
                String builderMethod = renamedAttr;
                if (multiValued) {
                    builderMethod = searchableAttribute.getSingular().isEmpty() ? Singulars.autoSingularize(renamedAttr) : searchableAttribute.getSingular();
                }
                builder.builderMethod(builderMethod).inherited(fromSuperType);
                switch (type.getType()) {
                    case PRIMITIVE: {
                        this.addPrimitive(builder, multiValued, type.getName(), type.getContainer());
                        continue block6;
                    }
                    case ENUM: {
                        this.addEnum(builder, multiValued, type.getName());
                        continue block6;
                    }
                    case ASSET: {
                        builder.relatedTypeOriginal(type.getOriginalBase());
                        if (!searchableAttribute.getRetyped()) {
                            this.addAssetRef(builder, multiValued, type.getName());
                            continue block6;
                        }
                        this.addAssetRef(builder, multiValued, type.getOriginalBase());
                        continue block6;
                    }
                    case STRUCT: {
                        this.addStructRef(builder, multiValued, type.getName());
                        continue block6;
                    }
                }
                log.warn("Unhandled testing type {} - skipping.", (Object)type.getType());
            }
        } else if (!assetGenerator.getOriginalName().equals("Referenceable")) {
            log.warn("No attributes found for {}, skipping any test inclusion.", (Object)assetGenerator.getOriginalName());
        }
    }

    private void addPrimitive(TestAttribute.TestAttributeBuilder builder, boolean multiValued, String typeName, String containerName) {
        builder.relationship(false);
        if (!multiValued) {
            this.testAttributes.add(builder.values(List.of(this.getPrimitiveValue(containerName, typeName, 0))).rawValues(List.of(this.getRawPrimitiveValue(containerName, typeName, 0))).build());
        } else {
            this.testAttributes.add(builder.values(List.of(this.getPrimitiveValue(containerName, typeName, 0), this.getPrimitiveValue(containerName, typeName, 1))).rawValues(List.of(this.getRawPrimitiveValue(containerName, typeName, 0), this.getRawPrimitiveValue(containerName, typeName, 1))).build());
        }
    }

    private String getPrimitiveValue(String containerName, String typeName, int count) {
        Object value = null;
        switch (typeName) {
            case "String": {
                value = "\"" + typeName + count + "\"";
                break;
            }
            case "Boolean": {
                if (Math.floorMod(count, 2) == 0) {
                    value = "true";
                    break;
                }
                value = "false";
                break;
            }
            case "Integer": {
                if (Math.floorMod(count, 2) == 0) {
                    value = "123";
                    break;
                }
                value = "456";
                break;
            }
            case "Long": {
                if (Math.floorMod(count, 2) == 0) {
                    value = "123456789L";
                    break;
                }
                value = "987654321L";
                break;
            }
            case "Double": {
                if (Math.floorMod(count, 2) == 0) {
                    value = "123.456";
                    break;
                }
                value = "654.321";
                break;
            }
            case "String, String": {
                if (containerName.equals("List<Map<")) {
                    if (Math.floorMod(count, 2) == 0) {
                        value = "Map.of(\"key1\", \"value1\")";
                        break;
                    }
                    value = "Map.of(\"key2\", \"value2\")";
                    break;
                }
                if (Math.floorMod(count, 2) == 0) {
                    value = "\"key1\", \"value1\"";
                    break;
                }
                value = "\"key2\", \"value2\"";
                break;
            }
            case "String, Long": {
                if (containerName.equals("List<Map<")) {
                    if (Math.floorMod(count, 2) == 0) {
                        value = "Map.of(\"key1\", 123456L)";
                        break;
                    }
                    value = "Map.of(\"key2\", 654321L)";
                    break;
                }
                if (Math.floorMod(count, 2) == 0) {
                    value = "\"key1\", 123456L";
                    break;
                }
                value = "\"key2\", 654321L";
                break;
            }
            default: {
                log.warn("Unknown primitive type for test attribute {} - skipping.", (Object)typeName);
            }
        }
        return value;
    }

    private String getRawPrimitiveValue(String containerName, String typeName, int count) {
        String value = null;
        switch (typeName) {
            case "String": 
            case "Boolean": 
            case "Integer": 
            case "Double": {
                value = this.getPrimitiveValue(containerName, typeName, count);
                break;
            }
            case "Long": {
                if (Math.floorMod(count, 2) == 0) {
                    value = "123456789";
                    break;
                }
                value = "987654321";
                break;
            }
            case "String, String": {
                if (Math.floorMod(count, 2) == 0) {
                    value = "{\"key1\", \"value1\"}";
                    break;
                }
                value = "{\"key2\", \"value2\"}";
                break;
            }
            case "String, Long": {
                if (Math.floorMod(count, 2) == 0) {
                    value = "{\"key1\", 123456}";
                    break;
                }
                value = "{\"key2\", 654321}";
                break;
            }
            default: {
                log.warn("Unknown primitive type for test attribute {} - skipping.", (Object)typeName);
            }
        }
        return value;
    }

    private void addEnum(TestAttribute.TestAttributeBuilder builder, boolean multiValued, String typeName) {
        builder.relationship(false);
        if (typeName.equals("AtlanPolicyAction")) {
            typeName = "PersonaMetadataAction";
        }
        if (!multiValued) {
            this.testAttributes.add(builder.values(List.of(this.getEnumValue(typeName, 0))).rawValues(List.of(this.getRawEnumValue(typeName, 0))).build());
        } else {
            this.testAttributes.add(builder.values(List.of(this.getEnumValue(typeName, 0), this.getEnumValue(typeName, 1))).rawValues(List.of(this.getRawEnumValue(typeName, 0), this.getRawEnumValue(typeName, 1))).build());
        }
    }

    private String getEnumValue(String typeName, int count) {
        Enum<?>[] values = this.getEnumValues(typeName);
        if (values != null) {
            if (values.length > count) {
                return typeName + "." + values[count].name();
            }
            return typeName + "." + values[0].name();
        }
        return null;
    }

    private String getRawEnumValue(String typeName, int count) {
        AtlanEnum[] values = (AtlanEnum[])this.getEnumValues(typeName);
        if (values != null) {
            if (values.length > count) {
                return "\"" + values[count].getValue() + "\"";
            }
            return "\"" + values[0].getValue() + "\"";
        }
        return null;
    }

    private Enum<?>[] getEnumValues(String typeName) {
        Enum[] values = null;
        try {
            Class<?> clazz = Class.forName(this.getPackageRoot() + ".enums." + typeName);
            Field f = clazz.getDeclaredField("$VALUES");
            f.setAccessible(true);
            Object o = f.get(null);
            values = (Enum[])o;
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to reflectively introspect enumeration: {}", (Object)typeName, (Object)e);
        }
        catch (NoSuchFieldException e) {
            log.error("Unable to find any values in enumeration: {}", (Object)typeName, (Object)e);
        }
        catch (IllegalAccessException e) {
            log.error("Unable to access values in enumeration: {}", (Object)typeName, (Object)e);
        }
        return values;
    }

    private void addAssetRef(TestAttribute.TestAttributeBuilder builder, boolean multiValued, String typeName) {
        builder.relationship(true);
        if (!multiValued) {
            this.testAttributes.add(builder.values(List.of(this.getAssetValue(typeName, 0))).rawValues(List.of(this.getRawAssetValue(typeName, 0))).build());
        } else {
            this.testAttributes.add(builder.values(List.of(this.getAssetValue(typeName, 0), this.getAssetValue(typeName, 1))).rawValues(List.of(this.getRawAssetValue(typeName, 0), this.getRawAssetValue(typeName, 1))).build());
        }
    }

    private String getAssetValue(String typeName, int count) {
        String concreteType = this.traverseToConcreteType(typeName);
        if (Math.floorMod(count, 2) == 0) {
            return concreteType + ".refByGuid(\"705d96f4-bdb6-4792-8dfe-8dc4ca3d2c23\")";
        }
        return concreteType + ".refByQualifiedName(\"default/snowflake/1234567890/test/qualifiedName\")";
    }

    private String getRawAssetValue(String typeName, int count) {
        String concreteType = this.traverseToConcreteType(typeName);
        if (Math.floorMod(count, 2) == 0) {
            return "{ \"typeName\": \"" + concreteType + "\", \"guid\": \"705d96f4-bdb6-4792-8dfe-8dc4ca3d2c23\" }";
        }
        return "{ \"typeName\": \"" + concreteType + "\", \"uniqueAttributes\": { \"qualifiedName\": \"default/snowflake/1234567890/test/qualifiedName\" }}";
    }

    private String traverseToConcreteType(String typeName) {
        AssetGenerator assetGen = this.cache.getCachedAssetType(typeName);
        if (assetGen != null) {
            if (!assetGen.isAbstract()) {
                return typeName;
            }
            List<String> subTypes = assetGen.getSubTypes();
            if (subTypes != null && !subTypes.isEmpty()) {
                for (String subType : subTypes) {
                    String candidate = this.traverseToConcreteType(subType);
                    AssetGenerator candidateGen = this.cache.getCachedAssetType(candidate);
                    if (candidateGen == null || candidateGen.isAbstract()) continue;
                    return candidate;
                }
            }
        }
        return typeName;
    }

    private void addStructRef(TestAttribute.TestAttributeBuilder builder, boolean multiValued, String typeName) {
        if (!multiValued) {
            this.testAttributes.add(builder.values(List.of(this.getStructValue(typeName, 0))).rawValues(List.of(this.getRawStructValue(typeName, 0))).build());
        } else {
            this.testAttributes.add(builder.values(List.of(this.getStructValue(typeName, 0), this.getStructValue(typeName, 1))).rawValues(List.of(this.getRawStructValue(typeName, 0), this.getRawStructValue(typeName, 1))).build());
        }
    }

    private String getStructValue(String typeName, int count) {
        Field[] fields = this.getFieldsForStruct(typeName);
        if (fields != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(typeName).append(".builder()");
            for (Field field : fields) {
                Class<?> fieldType = field.getType();
                String fieldName = field.getName();
                if (fieldName.equals("TYPE_NAME") || fieldName.equals("typeName") || fieldName.equals("serialVersionUID")) continue;
                sb.append(".").append(fieldName).append("(");
                if (this.isPrimitive(fieldType)) {
                    sb.append(this.getPrimitiveValue(null, fieldType.getSimpleName(), count));
                } else if (fieldType == List.class) {
                    generic = field.getGenericType();
                    if (generic instanceof ParameterizedType) {
                        pt = (ParameterizedType)generic;
                        Type type = pt.getActualTypeArguments()[0];
                        try {
                            Class<?> embedded = Class.forName(type.getTypeName());
                            String simpleClassName = embedded.getSimpleName();
                            sb.append("List.of(").append(this.getPrimitiveValue("List<", simpleClassName, 0)).append(", ").append(this.getPrimitiveValue("List<", simpleClassName, 1)).append(")");
                        }
                        catch (ClassNotFoundException e) {
                            log.error("Unable to find embedded struct class: {}", (Object)type.getTypeName(), (Object)e);
                        }
                    } else {
                        log.warn("Unable to reflectively identify list-wrapped type: {}", (Object)generic.getTypeName());
                    }
                } else if (fieldType == Map.class) {
                    generic = field.getGenericType();
                    if (generic instanceof ParameterizedType) {
                        pt = (ParameterizedType)generic;
                        Type typeKey = pt.getActualTypeArguments()[0];
                        Type typeVal = pt.getActualTypeArguments()[1];
                        try {
                            Class<?> embeddedKey = Class.forName(typeKey.getTypeName());
                            String simpleClassNameKey = embeddedKey.getSimpleName();
                            Class<?> embeddedVal = Class.forName(typeVal.getTypeName());
                            String simpleClassNameVal = embeddedVal.getSimpleName();
                            sb.append("Map.of(").append(this.getPrimitiveValue("Map<", simpleClassNameKey + ", " + simpleClassNameVal, 0)).append(", ").append(this.getPrimitiveValue("Map<", simpleClassNameKey + ", " + simpleClassNameVal, 1)).append(")");
                        }
                        catch (ClassNotFoundException e) {
                            log.error("Unable to find embedded struct class: {}", (Object)pt.getActualTypeArguments(), (Object)e);
                        }
                    } else {
                        log.warn("Unable to reflectively identify map-wrapped type: {}", (Object)generic.getTypeName());
                    }
                } else if (fieldType.getCanonicalName().startsWith("com.atlan.model.enums.")) {
                    sb.append(this.getEnumValue(fieldType.getSimpleName(), count));
                } else {
                    log.error("Type not yet handled for (SDK) structs: {}", (Object)fieldType.getCanonicalName());
                }
                sb.append(")");
            }
            sb.append(".build()");
            return sb.toString();
        }
        return "";
    }

    private String getRawStructValue(String typeName, int count) {
        Field[] fields = this.getFieldsForStruct(typeName);
        if (fields != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Field field : fields) {
                Class<?> fieldType = field.getType();
                String fieldName = field.getName();
                if (fieldName.equals("TYPE_NAME") || fieldName.equals("typeName") || fieldName.equals("serialVersionUID")) continue;
                sb.append("\"").append(fieldName).append("\": ");
                if (this.isPrimitive(fieldType)) {
                    sb.append(this.getRawPrimitiveValue(null, fieldType.getSimpleName(), count));
                } else if (fieldType == List.class) {
                    Type generic = field.getGenericType();
                    if (generic instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)generic;
                        Type type = pt.getActualTypeArguments()[0];
                        try {
                            Class<?> embedded = Class.forName(type.getTypeName());
                            String simpleClassName = embedded.getSimpleName();
                            sb.append("[").append(this.getRawPrimitiveValue("List<", simpleClassName, 0)).append(", ").append(this.getRawPrimitiveValue("List<", simpleClassName, 1)).append("]");
                        }
                        catch (ClassNotFoundException e) {
                            log.error("Unable to find embedded struct class: {}", (Object)type.getTypeName(), (Object)e);
                        }
                    } else {
                        log.warn("Unable to reflectively identify list-wrapped type: {}", (Object)generic.getTypeName());
                    }
                } else if (fieldType.getCanonicalName().startsWith("com.atlan.model.enums.")) {
                    sb.append(this.getRawEnumValue(fieldType.getSimpleName(), count));
                } else {
                    log.error("Type not yet handled for (raw API) structs: {}", (Object)fieldType.getCanonicalName());
                }
                sb.append(", ");
            }
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 2);
            }
            sb.append("}");
            return sb.toString();
        }
        return "";
    }

    private Field[] getFieldsForStruct(String typeName) {
        try {
            Class<?> clazz = Class.forName(this.getPackageRoot() + ".structs." + typeName);
            return clazz.getDeclaredFields();
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to reflectively introspect struct: {}", (Object)typeName, (Object)e);
            return null;
        }
    }

    private boolean isPrimitive(Class<?> clazz) {
        return clazz == String.class || clazz == Boolean.class || clazz == Integer.class || clazz == Long.class || clazz == Double.class;
    }

    @Generated
    public AssetGenerator getAsset() {
        return this.asset;
    }

    @Generated
    public List<TestAttribute> getTestAttributes() {
        return this.testAttributes;
    }

    public static final class TestAttribute {
        private SearchableAttribute<?> details;
        private String builderMethod;
        private List<String> values;
        private List<String> rawValues;
        private boolean inherited;
        private boolean relationship;
        private String relatedTypeOriginal;

        @Generated
        TestAttribute(SearchableAttribute<?> details, String builderMethod, List<String> values, List<String> rawValues, boolean inherited, boolean relationship, String relatedTypeOriginal) {
            this.details = details;
            this.builderMethod = builderMethod;
            this.values = values;
            this.rawValues = rawValues;
            this.inherited = inherited;
            this.relationship = relationship;
            this.relatedTypeOriginal = relatedTypeOriginal;
        }

        @Generated
        public static TestAttributeBuilder builder() {
            return new TestAttributeBuilder();
        }

        @Generated
        public SearchableAttribute<?> getDetails() {
            return this.details;
        }

        @Generated
        public String getBuilderMethod() {
            return this.builderMethod;
        }

        @Generated
        public List<String> getValues() {
            return this.values;
        }

        @Generated
        public List<String> getRawValues() {
            return this.rawValues;
        }

        @Generated
        public boolean getInherited() {
            return this.inherited;
        }

        @Generated
        public boolean getRelationship() {
            return this.relationship;
        }

        @Generated
        public String getRelatedTypeOriginal() {
            return this.relatedTypeOriginal;
        }

        @Generated
        public static class TestAttributeBuilder {
            @Generated
            private SearchableAttribute<?> details;
            @Generated
            private String builderMethod;
            @Generated
            private List<String> values;
            @Generated
            private List<String> rawValues;
            @Generated
            private boolean inherited;
            @Generated
            private boolean relationship;
            @Generated
            private String relatedTypeOriginal;

            @Generated
            TestAttributeBuilder() {
            }

            @Generated
            public TestAttributeBuilder details(SearchableAttribute<?> details) {
                this.details = details;
                return this;
            }

            @Generated
            public TestAttributeBuilder builderMethod(String builderMethod) {
                this.builderMethod = builderMethod;
                return this;
            }

            @Generated
            public TestAttributeBuilder values(List<String> values) {
                this.values = values;
                return this;
            }

            @Generated
            public TestAttributeBuilder rawValues(List<String> rawValues) {
                this.rawValues = rawValues;
                return this;
            }

            @Generated
            public TestAttributeBuilder inherited(boolean inherited) {
                this.inherited = inherited;
                return this;
            }

            @Generated
            public TestAttributeBuilder relationship(boolean relationship) {
                this.relationship = relationship;
                return this;
            }

            @Generated
            public TestAttributeBuilder relatedTypeOriginal(String relatedTypeOriginal) {
                this.relatedTypeOriginal = relatedTypeOriginal;
                return this;
            }

            @Generated
            public TestAttribute build() {
                return new TestAttribute(this.details, this.builderMethod, this.values, this.rawValues, this.inherited, this.relationship, this.relatedTypeOriginal);
            }

            @Generated
            public String toString() {
                return "AssetTestGenerator.TestAttribute.TestAttributeBuilder(details=" + String.valueOf(this.details) + ", builderMethod=" + this.builderMethod + ", values=" + String.valueOf(this.values) + ", rawValues=" + String.valueOf(this.rawValues) + ", inherited=" + this.inherited + ", relationship=" + this.relationship + ", relatedTypeOriginal=" + this.relatedTypeOriginal + ")";
            }
        }
    }
}

