/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.AtlanClient;
import com.atlan.generators.AttributeGenerator;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.TypeGenerator;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.RelationshipAttributeDef;
import com.atlan.util.StringUtils;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchableAttribute<T extends SearchableAttribute<?>>
extends AttributeGenerator
implements Comparable<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchableAttribute.class);
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<SearchableAttribute<?>> attributeComparator = Comparator.comparing(AttributeGenerator::getRenamed, stringComparator);
    private String searchType;
    private String searchTypeArgs;

    protected SearchableAttribute(AtlanClient client, GeneratorConfig cfg) {
        super(client, cfg);
    }

    public SearchableAttribute(AtlanClient client, String className, AttributeDef attributeDef, GeneratorConfig cfg) {
        super(client, className, attributeDef, cfg);
    }

    @Override
    protected void resolveName() {
        super.resolveName();
        this.setRenamed(this.cfg.resolveAttributeName(this.getOriginalName()));
        this.setSnakeCaseRenamed(StringUtils.getLowerSnakeCase(this.getRenamed()));
    }

    @Override
    protected void resolveType(AttributeDef attributeDef) {
        Map<IndexType, String> searchMap;
        Set<IndexType> indices;
        String assetTypeOverride;
        super.resolveType(attributeDef);
        String enumName = this.cfg.resolveAttributeToEnumeration(this.getOriginalName());
        if (enumName != null) {
            this.setType(this.getType().toBuilder().name(enumName).type(TypeGenerator.MappedType.Type.ENUM).build());
        }
        if ((assetTypeOverride = this.cfg.resolveAttributeToTypeOverride(this.className, this.getOriginalName())) != null) {
            this.setType(this.getType().toBuilder().name(assetTypeOverride).type(TypeGenerator.MappedType.Type.ASSET).build());
            this.setRetyped(true);
        }
        if (!(indices = (searchMap = this.getIndexesForAttribute(attributeDef)).keySet()).isEmpty()) {
            if (indices.equals(Set.of(IndexType.RELATION))) {
                this.searchType = "RelationField";
                this.searchTypeArgs = null;
            } else if (indices.equals(Set.of(IndexType.S_RELATION))) {
                this.searchType = "SearchableRelationship";
                this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.S_RELATION) + "\"";
            } else if (indices.equals(Set.of(IndexType.KEYWORD))) {
                this.searchType = "KeywordField";
                this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.KEYWORD) + "\"";
            } else if (indices.equals(Set.of(IndexType.TEXT))) {
                this.searchType = "TextField";
                this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.TEXT) + "\"";
            } else if (indices.equals(Set.of(IndexType.NUMERIC))) {
                this.searchType = "NumericField";
                this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.NUMERIC) + "\"";
            } else if (indices.equals(Set.of(IndexType.BOOLEAN))) {
                this.searchType = "BooleanField";
                this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.BOOLEAN) + "\"";
            } else if (indices.equals(Set.of(IndexType.NUMERIC, IndexType.RANK_FEATURE))) {
                this.searchType = "NumericRankField";
                this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.NUMERIC) + "\", \"" + searchMap.get((Object)IndexType.RANK_FEATURE) + "\"";
            } else if (indices.equals(Set.of(IndexType.KEYWORD, IndexType.TEXT))) {
                this.searchType = "KeywordTextField";
                this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.KEYWORD) + "\", \"" + searchMap.get((Object)IndexType.TEXT) + "\"";
            } else if (indices.equals(Set.of(IndexType.KEYWORD, IndexType.TEXT, IndexType.STEMMED))) {
                this.searchType = "KeywordTextStemmedField";
                this.searchTypeArgs = "\"" + searchMap.get((Object)IndexType.KEYWORD) + "\", \"" + searchMap.get((Object)IndexType.TEXT) + "\", \"" + searchMap.get((Object)IndexType.STEMMED) + "\"";
            } else {
                log.warn("Found index combination for {} that is not handled: {}", (Object)this.getOriginalName(), indices);
            }
        }
    }

    public boolean isDate() {
        return this.getType().getOriginalBase().toLowerCase(Locale.ROOT).equals("date");
    }

    private Map<IndexType, String> getIndexesForAttribute(AttributeDef attributeDef) {
        LinkedHashMap<IndexType, String> searchable = new LinkedHashMap<IndexType, String>();
        Map<String, String> config = attributeDef.getIndexTypeESConfig();
        String attrName = attributeDef.getName();
        if (attributeDef instanceof RelationshipAttributeDef) {
            String mappedRelationship = this.cfg.getSearchableRelationship(attributeDef.getName());
            String relationshipType = ((RelationshipAttributeDef)attributeDef).getRelationshipTypeName();
            if (mappedRelationship != null && mappedRelationship.equals(relationshipType)) {
                searchable.put(IndexType.S_RELATION, relationshipType);
            } else {
                searchable.put(IndexType.RELATION, attrName);
            }
        } else {
            if (config != null && config.containsKey("analyzer")) {
                String analyzer = config.get("analyzer");
                if (analyzer.equals("atlan_text_analyzer")) {
                    if (attrName.endsWith(".stemmed")) {
                        searchable.put(IndexType.STEMMED, attrName);
                    } else {
                        searchable.put(IndexType.TEXT, attrName);
                    }
                } else {
                    log.warn("Unknown analyzer on attribute {}: {}", (Object)attrName, (Object)analyzer);
                }
            } else if (attributeDef.getIndexType() != null && attributeDef.getIndexType().toLowerCase(Locale.ROOT).equals("string")) {
                searchable.put(IndexType.KEYWORD, attrName);
            } else {
                IndexType defIndex = SearchableAttribute.getDefaultIndexForType(this.getType());
                searchable.put(defIndex, attrName);
            }
            boolean duplicate = false;
            Map<String, Map<String, String>> fields = attributeDef.getIndexTypeESFields();
            if (fields != null) {
                for (Map.Entry<String, Map<String, String>> entry : fields.entrySet()) {
                    String fieldName = attrName + "." + entry.getKey();
                    Map<String, String> indexDetails = entry.getValue();
                    if (indexDetails != null && indexDetails.containsKey("type")) {
                        String indexType;
                        switch (indexType = indexDetails.get("type")) {
                            case "keyword": {
                                duplicate = searchable.put(IndexType.KEYWORD, fieldName) != null;
                                break;
                            }
                            case "text": {
                                if (fieldName.endsWith(".stemmed")) {
                                    duplicate = searchable.put(IndexType.STEMMED, fieldName) != null;
                                    break;
                                }
                                duplicate = searchable.put(IndexType.TEXT, fieldName) != null;
                                break;
                            }
                            case "rank_feature": {
                                duplicate = searchable.put(IndexType.RANK_FEATURE, fieldName) != null;
                                break;
                            }
                            default: {
                                log.warn("Unknown index type on attribute {}, field {}: {}", new Object[]{attributeDef.getName(), fieldName, indexType});
                                break;
                            }
                        }
                        continue;
                    }
                    IndexType defIndex = SearchableAttribute.getDefaultIndexForType(this.getType());
                    duplicate = searchable.put(defIndex, fieldName) != null;
                }
            }
            if (duplicate) {
                log.info("Same attribute had multiple (identical) index references: {}", (Object)attrName);
            }
        }
        return searchable;
    }

    private static IndexType getDefaultIndexForType(TypeGenerator.MappedType type) {
        String baseType;
        return switch (baseType = type.getOriginalBase()) {
            case "date", "float", "double", "int", "long" -> IndexType.NUMERIC;
            case "boolean" -> IndexType.BOOLEAN;
            case "string" -> IndexType.TEXT;
            default -> IndexType.KEYWORD;
        };
    }

    public String getEnumForAttr() {
        return StringUtils.getUpperSnakeCase(this.getRenamed());
    }

    @Override
    public int compareTo(SearchableAttribute o) {
        return attributeComparator.compare(this, o);
    }

    @Generated
    public String getSearchType() {
        return this.searchType;
    }

    @Generated
    public String getSearchTypeArgs() {
        return this.searchTypeArgs;
    }

    static enum IndexType {
        KEYWORD,
        TEXT,
        RANK_FEATURE,
        BOOLEAN,
        NUMERIC,
        STEMMED,
        RELATION,
        S_RELATION;

    }
}

